/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.ApiregistrationV1ServiceReference;
import io.kubernetes.client.openapi.models.ApiregistrationV1ServiceReferenceBuilder;
import io.kubernetes.client.openapi.models.ApiregistrationV1ServiceReferenceFluent;
import io.kubernetes.client.openapi.models.V1APIServiceSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class V1APIServiceSpecFluent<A extends V1APIServiceSpecFluent<A>>
extends BaseFluent<A> {
    private List<Byte> caBundle;
    private String group;
    private Integer groupPriorityMinimum;
    private Boolean insecureSkipTLSVerify;
    private ApiregistrationV1ServiceReferenceBuilder service;
    private String version;
    private Integer versionPriority;

    public V1APIServiceSpecFluent() {
    }

    public V1APIServiceSpecFluent(V1APIServiceSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1APIServiceSpec instance) {
        V1APIServiceSpec v1APIServiceSpec = instance = instance != null ? instance : new V1APIServiceSpec();
        if (instance != null) {
            this.withCaBundle(instance.getCaBundle());
            this.withGroup(instance.getGroup());
            this.withGroupPriorityMinimum(instance.getGroupPriorityMinimum());
            this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
            this.withService(instance.getService());
            this.withVersion(instance.getVersion());
            this.withVersionPriority(instance.getVersionPriority());
        }
    }

    public A withCaBundle(byte ... caBundle) {
        if (this.caBundle != null) {
            this.caBundle.clear();
            this._visitables.remove("caBundle");
        }
        if (caBundle != null) {
            for (byte item : caBundle) {
                this.addToCaBundle(item);
            }
        }
        return (A)this;
    }

    public byte[] getCaBundle() {
        int size = this.caBundle != null ? this.caBundle.size() : 0;
        byte[] result = new byte[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (byte item : this.caBundle) {
            result[index++] = item;
        }
        return result;
    }

    public A addToCaBundle(int index, Byte item) {
        if (this.caBundle == null) {
            this.caBundle = new ArrayList<Byte>();
        }
        this.caBundle.add(index, item);
        return (A)this;
    }

    public A setToCaBundle(int index, Byte item) {
        if (this.caBundle == null) {
            this.caBundle = new ArrayList<Byte>();
        }
        this.caBundle.set(index, item);
        return (A)this;
    }

    public A addToCaBundle(Byte ... items) {
        if (this.caBundle == null) {
            this.caBundle = new ArrayList<Byte>();
        }
        for (Byte item : items) {
            this.caBundle.add(item);
        }
        return (A)this;
    }

    public A addAllToCaBundle(Collection<Byte> items) {
        if (this.caBundle == null) {
            this.caBundle = new ArrayList<Byte>();
        }
        for (Byte item : items) {
            this.caBundle.add(item);
        }
        return (A)this;
    }

    public A removeFromCaBundle(Byte ... items) {
        if (this.caBundle == null) {
            return (A)this;
        }
        for (Byte item : items) {
            this.caBundle.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromCaBundle(Collection<Byte> items) {
        if (this.caBundle == null) {
            return (A)this;
        }
        for (Byte item : items) {
            this.caBundle.remove(item);
        }
        return (A)this;
    }

    public boolean hasCaBundle() {
        return this.caBundle != null && !this.caBundle.isEmpty();
    }

    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public Integer getGroupPriorityMinimum() {
        return this.groupPriorityMinimum;
    }

    public A withGroupPriorityMinimum(Integer groupPriorityMinimum) {
        this.groupPriorityMinimum = groupPriorityMinimum;
        return (A)this;
    }

    public boolean hasGroupPriorityMinimum() {
        return this.groupPriorityMinimum != null;
    }

    public Boolean getInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify;
    }

    public A withInsecureSkipTLSVerify(Boolean insecureSkipTLSVerify) {
        this.insecureSkipTLSVerify = insecureSkipTLSVerify;
        return (A)this;
    }

    public boolean hasInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify != null;
    }

    public ApiregistrationV1ServiceReference buildService() {
        return this.service != null ? this.service.build() : null;
    }

    public A withService(ApiregistrationV1ServiceReference service) {
        this._visitables.remove("service");
        if (service != null) {
            this.service = new ApiregistrationV1ServiceReferenceBuilder(service);
            this._visitables.get("service").add(this.service);
        } else {
            this.service = null;
            this._visitables.get("service").remove(this.service);
        }
        return (A)this;
    }

    public boolean hasService() {
        return this.service != null;
    }

    public ServiceNested<A> withNewService() {
        return new ServiceNested(null);
    }

    public ServiceNested<A> withNewServiceLike(ApiregistrationV1ServiceReference item) {
        return new ServiceNested(item);
    }

    public ServiceNested<A> editService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(null));
    }

    public ServiceNested<A> editOrNewService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(new ApiregistrationV1ServiceReferenceBuilder().build()));
    }

    public ServiceNested<A> editOrNewServiceLike(ApiregistrationV1ServiceReference item) {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(item));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public Integer getVersionPriority() {
        return this.versionPriority;
    }

    public A withVersionPriority(Integer versionPriority) {
        this.versionPriority = versionPriority;
        return (A)this;
    }

    public boolean hasVersionPriority() {
        return this.versionPriority != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1APIServiceSpecFluent that = (V1APIServiceSpecFluent)o;
        if (!Objects.equals(this.caBundle, that.caBundle)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals(this.groupPriorityMinimum, that.groupPriorityMinimum)) {
            return false;
        }
        if (!Objects.equals(this.insecureSkipTLSVerify, that.insecureSkipTLSVerify)) {
            return false;
        }
        if (!Objects.equals(this.service, that.service)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals(this.versionPriority, that.versionPriority);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.caBundle, this.group, this.groupPriorityMinimum, this.insecureSkipTLSVerify, this.service, this.version, this.versionPriority, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caBundle != null && !this.caBundle.isEmpty()) {
            sb.append("caBundle:");
            sb.append(String.valueOf(this.caBundle) + ",");
        }
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group + ",");
        }
        if (this.groupPriorityMinimum != null) {
            sb.append("groupPriorityMinimum:");
            sb.append(this.groupPriorityMinimum + ",");
        }
        if (this.insecureSkipTLSVerify != null) {
            sb.append("insecureSkipTLSVerify:");
            sb.append(this.insecureSkipTLSVerify + ",");
        }
        if (this.service != null) {
            sb.append("service:");
            sb.append(String.valueOf(this.service) + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.versionPriority != null) {
            sb.append("versionPriority:");
            sb.append(this.versionPriority);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withInsecureSkipTLSVerify() {
        return this.withInsecureSkipTLSVerify(true);
    }

    public class ServiceNested<N>
    extends ApiregistrationV1ServiceReferenceFluent<ServiceNested<N>>
    implements Nested<N> {
        ApiregistrationV1ServiceReferenceBuilder builder;

        ServiceNested(ApiregistrationV1ServiceReference item) {
            this.builder = new ApiregistrationV1ServiceReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1APIServiceSpecFluent.this.withService(this.builder.build());
        }

        public N endService() {
            return this.and();
        }
    }
}

