/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1APIResource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="APIResourceList is a list of APIResource, it is used to expose the name of the resources supported in a specific group and version, and if the resource is namespaced.")
public class V1APIResourceList {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    @Nullable
    private String apiVersion;
    public static final String SERIALIZED_NAME_GROUP_VERSION = "groupVersion";
    @SerializedName(value="groupVersion")
    @Nonnull
    private String groupVersion;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    @Nullable
    private String kind;
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    @Nonnull
    private List<V1APIResource> resources = new ArrayList<V1APIResource>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1APIResourceList apiVersion(@Nullable String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(@Nullable String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1APIResourceList groupVersion(@Nonnull String groupVersion) {
        this.groupVersion = groupVersion;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="groupVersion is the group and version this APIResourceList is for.")
    public String getGroupVersion() {
        return this.groupVersion;
    }

    public void setGroupVersion(@Nonnull String groupVersion) {
        this.groupVersion = groupVersion;
    }

    public V1APIResourceList kind(@Nullable String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(@Nullable String kind) {
        this.kind = kind;
    }

    public V1APIResourceList resources(@Nonnull List<V1APIResource> resources) {
        this.resources = resources;
        return this;
    }

    public V1APIResourceList addResourcesItem(V1APIResource resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<V1APIResource>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="resources contains the name of the resources and if they are namespaced.")
    public List<V1APIResource> getResources() {
        return this.resources;
    }

    public void setResources(@Nonnull List<V1APIResource> resources) {
        this.resources = resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIResourceList v1APIResourceList = (V1APIResourceList)o;
        return Objects.equals(this.apiVersion, v1APIResourceList.apiVersion) && Objects.equals(this.groupVersion, v1APIResourceList.groupVersion) && Objects.equals(this.kind, v1APIResourceList.kind) && Objects.equals(this.resources, v1APIResourceList.resources);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.groupVersion, this.kind, this.resources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1APIResourceList {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    groupVersion: ").append(this.toIndentedString(this.groupVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1APIResourceList is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1APIResourceList` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_GROUP_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `groupVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUP_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_RESOURCES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `resources` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCES).toString()));
        }
        JsonArray jsonArrayresources = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESOURCES);
        for (int i = 0; i < jsonArrayresources.size(); ++i) {
            V1APIResource.validateJsonElement(jsonArrayresources.get(i));
        }
    }

    public static V1APIResourceList fromJson(String jsonString) throws IOException {
        return (V1APIResourceList)JSON.getGson().fromJson(jsonString, V1APIResourceList.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_GROUP_VERSION);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_RESOURCES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_GROUP_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_RESOURCES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1APIResourceList.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1APIResourceList.class));
            return new TypeAdapter<V1APIResourceList>(){

                public void write(JsonWriter out, V1APIResourceList value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1APIResourceList read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1APIResourceList.validateJsonElement(jsonElement);
                    return (V1APIResourceList)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

