/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.CryptoKt;
import io.ktor.util.KtorExperimentalAPI;
import io.ktor.util.NonceManager;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KtorExperimentalAPI
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B3\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\nB1\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u0018\u001a\u00020\u0005H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u0019\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lio/ktor/util/StatelessHmacNonceManager;", "Lio/ktor/util/NonceManager;", "key", "", "algorithm", "", "timeoutMillis", "", "nonceGenerator", "Lkotlin/Function0;", "([BLjava/lang/String;JLkotlin/jvm/functions/Function0;)V", "keySpec", "Ljavax/crypto/spec/SecretKeySpec;", "(Ljavax/crypto/spec/SecretKeySpec;Ljava/lang/String;JLkotlin/jvm/functions/Function0;)V", "getAlgorithm", "()Ljava/lang/String;", "getKeySpec", "()Ljavax/crypto/spec/SecretKeySpec;", "macLength", "", "getNonceGenerator", "()Lkotlin/jvm/functions/Function0;", "getTimeoutMillis", "()J", "newNonce", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "verifyNonce", "", "nonce", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ktor-utils"})
public final class StatelessHmacNonceManager
implements NonceManager {
    private final int macLength;
    @NotNull
    private final SecretKeySpec keySpec;
    @NotNull
    private final String algorithm;
    private final long timeoutMillis;
    @NotNull
    private final Function0<String> nonceGenerator;

    @Override
    @Nullable
    public Object newNonce(@NotNull Continuation<? super String> continuation2) {
        Mac mac;
        String random = (String)this.nonceGenerator.invoke();
        long l = System.nanoTime();
        int n = 16;
        String string = Long.toString(l, CharsKt.checkRadix((int)n));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.Long.toString(this, checkRadix(radix))");
        String time = StringsKt.padStart((String)string, (int)16, (char)'0');
        Mac $receiver = mac = Mac.getInstance(this.algorithm);
        boolean bl = false;
        $receiver.init(this.keySpec);
        String string2 = random + ':' + time;
        Charset charset = Charsets.ISO_8859_1;
        Mac mac2 = $receiver;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        mac2.update(byArray2);
        byte[] byArray3 = mac.doFinal();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"Mac.getInstance(algorith\u20269_1))\n        }.doFinal()");
        String mac3 = CryptoKt.hex(byArray3);
        return random + '+' + time + '+' + mac3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object verifyNonce(@NotNull String nonce, @NotNull Continuation<? super Boolean> continuation2) {
        Mac mac;
        void time;
        void random;
        List list;
        List parts = StringsKt.split$default((CharSequence)nonce, (char[])new char[]{'+'}, (boolean)false, (int)0, (int)6, null);
        if (parts.size() != 3) {
            return Boxing.boxBoolean((boolean)false);
        }
        List list2 = list = parts;
        String string = (String)list2.get(0);
        list2 = list;
        String string2 = (String)list2.get(1);
        list2 = list;
        String mac2 = (String)list2.get(2);
        if (random.length() < 8) {
            return Boxing.boxBoolean((boolean)false);
        }
        if (mac2.length() != this.macLength * 2) {
            return Boxing.boxBoolean((boolean)false);
        }
        if (time.length() != 16) {
            return Boxing.boxBoolean((boolean)false);
        }
        void var9_10 = time;
        int n = 16;
        long nanoTime = Long.parseLong((String)var9_10, CharsKt.checkRadix((int)n));
        if (nanoTime + TimeUnit.MILLISECONDS.toNanos(this.timeoutMillis) < System.nanoTime()) {
            return Boxing.boxBoolean((boolean)false);
        }
        Mac $receiver22 = mac = Mac.getInstance(this.algorithm);
        boolean bl = false;
        $receiver22.init(this.keySpec);
        String string3 = (String)random + ':' + (String)time;
        Charset charset = Charsets.ISO_8859_1;
        Mac mac3 = $receiver22;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string4.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        mac3.update(byArray2);
        byte[] byArray3 = mac.doFinal();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"Mac.getInstance(algorith\u20269_1))\n        }.doFinal()");
        String computedMac = CryptoKt.hex(byArray3);
        int validCount = 0;
        int $receiver22 = 0;
        int n2 = computedMac.length();
        int n3 = mac2.length();
        int n4 = Math.min(n2, n3);
        while ($receiver22 < n4) {
            void i;
            if (computedMac.charAt((int)i) == mac2.charAt((int)i)) {
                ++validCount;
            }
            ++i;
        }
        return Boxing.boxBoolean((validCount == this.macLength * 2 ? 1 : 0) != 0);
    }

    @NotNull
    public final SecretKeySpec getKeySpec() {
        return this.keySpec;
    }

    @NotNull
    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    @NotNull
    public final Function0<String> getNonceGenerator() {
        return this.nonceGenerator;
    }

    public StatelessHmacNonceManager(@NotNull SecretKeySpec keySpec, @NotNull String algorithm, long timeoutMillis, @NotNull Function0<String> nonceGenerator) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)keySpec, (String)"keySpec");
        Intrinsics.checkParameterIsNotNull((Object)algorithm, (String)"algorithm");
        Intrinsics.checkParameterIsNotNull(nonceGenerator, (String)"nonceGenerator");
        this.keySpec = keySpec;
        this.algorithm = algorithm;
        this.timeoutMillis = timeoutMillis;
        this.nonceGenerator = nonceGenerator;
        Mac mac = Mac.getInstance(this.algorithm);
        StatelessHmacNonceManager statelessHmacNonceManager = this;
        Mac mac2 = mac;
        boolean bl = false;
        mac2.init(this.keySpec);
        Mac mac3 = mac2;
        Intrinsics.checkExpressionValueIsNotNull((Object)mac3, (String)"mac");
        statelessHmacNonceManager.macLength = n = mac3.getMacLength();
    }

    public /* synthetic */ StatelessHmacNonceManager(SecretKeySpec secretKeySpec, String string, long l, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "HmacSHA256";
        }
        if ((n & 4) != 0) {
            l = 60000L;
        }
        if ((n & 8) != 0) {
            function0 = 1.INSTANCE;
        }
        this(secretKeySpec, string, l, (Function0<String>)function0);
    }

    public StatelessHmacNonceManager(@NotNull byte[] key, @NotNull String algorithm, long timeoutMillis, @NotNull Function0<String> nonceGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)algorithm, (String)"algorithm");
        Intrinsics.checkParameterIsNotNull(nonceGenerator, (String)"nonceGenerator");
        this(new SecretKeySpec(key, algorithm), algorithm, timeoutMillis, nonceGenerator);
    }

    public /* synthetic */ StatelessHmacNonceManager(byte[] byArray, String string, long l, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "HmacSHA256";
        }
        if ((n & 4) != 0) {
            l = 60000L;
        }
        if ((n & 8) != 0) {
            function0 = 2.INSTANCE;
        }
        this(byArray, string, l, (Function0<String>)function0);
    }
}

