/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.sessions;

import io.ktor.sessions.CacheStorage;
import io.ktor.sessions.DirectoryStorage;
import io.ktor.sessions.SessionStorage;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0082\u0010\u001a\f\u0010\t\u001a\u00020\u0007*\u00020\u0003H\u0002\u00a8\u0006\n"}, d2={"directorySessionStorage", "Lio/ktor/sessions/SessionStorage;", "rootDir", "Ljava/io/File;", "cached", "", "deleteParentsWhileEmpty", "", "mostTop", "mkdirsOrFail", "ktor-server-sessions"})
public final class DirectoryStorageKt {
    @NotNull
    public static final SessionStorage directorySessionStorage(@NotNull File rootDir, boolean cached) {
        SessionStorage sessionStorage;
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        boolean bl = cached;
        if (bl) {
            sessionStorage = new CacheStorage(new DirectoryStorage(rootDir), 60000L);
        } else if (!bl) {
            sessionStorage = new DirectoryStorage(rootDir);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sessionStorage;
    }

    public static /* synthetic */ SessionStorage directorySessionStorage$default(File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return DirectoryStorageKt.directorySessionStorage(file, bl);
    }

    private static final void mkdirsOrFail(File $this$mkdirsOrFail) {
        if (!$this$mkdirsOrFail.mkdirs() && !$this$mkdirsOrFail.exists()) {
            throw new IOException(Intrinsics.stringPlus((String)"Couldn't create directory ", (Object)$this$mkdirsOrFail));
        }
        if (!$this$mkdirsOrFail.isDirectory()) {
            throw new IOException(Intrinsics.stringPlus((String)"Path is not a directory: ", (Object)$this$mkdirsOrFail));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void deleteParentsWhileEmpty(File $this$deleteParentsWhileEmpty, File mostTop) {
        File file;
        void var2_3;
        void var4_6;
        Object object = $this$deleteParentsWhileEmpty;
        File file2 = mostTop;
        while (!Intrinsics.areEqual((Object)(var4_6 = var2_3), (Object)(file = file2))) {
            if (!var4_6.isDirectory()) return;
            if (!var4_6.exists()) return;
            String[] stringArray = var4_6.list();
            boolean bl = false;
            boolean bl2 = false;
            if (stringArray != null) {
                String[] stringArray2 = stringArray;
                boolean bl3 = false;
                if (stringArray2.length != 0) return;
                boolean bl4 = true;
                if (!bl4) return;
            }
            boolean bl5 = true;
            if (!bl5) return;
            if (!var4_6.delete() && var4_6.exists()) {
                throw new IOException(Intrinsics.stringPlus((String)"Failed to delete dir ", (Object)var4_6));
            }
            File file3 = var4_6.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"parentFile");
            File file4 = file3;
            file2 = file;
        }
    }

    public static final /* synthetic */ void access$mkdirsOrFail(File $receiver) {
        DirectoryStorageKt.mkdirsOrFail($receiver);
    }

    public static final /* synthetic */ void access$deleteParentsWhileEmpty(File $receiver, File mostTop) {
        DirectoryStorageKt.deleteParentsWhileEmpty($receiver, mostTop);
    }
}

