/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.sessions;

import io.ktor.sessions.CacheStorage;
import io.ktor.sessions.DirectoryStorage;
import io.ktor.sessions.SessionStorage;
import io.ktor.sessions.StringWindowIterator;
import io.ktor.util.KtorExperimentalAPI;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0082\u0010\u001a\u001f\u0010\t\u001a\u00020\u0005\"\u0004\b\u0000\u0010\n*\n\u0012\u0004\u0012\u0002H\n\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\f\u001a\f\u0010\r\u001a\u00020\u0007*\u00020\u0003H\u0002\u001a.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0005H\u0002\u00a8\u0006\u0015"}, d2={"directorySessionStorage", "Lio/ktor/sessions/SessionStorage;", "rootDir", "Ljava/io/File;", "cached", "", "deleteParentsWhileEmpty", "", "mostTop", "isNullOrEmpty", "T", "", "([Ljava/lang/Object;)Z", "mkdirsOrFail", "window", "Lkotlin/sequences/Sequence;", "", "size", "", "step", "dropTrailing", "ktor-server-sessions"})
public final class DirectoryStorageKt {
    @KtorExperimentalAPI
    @NotNull
    public static final SessionStorage directorySessionStorage(@NotNull File rootDir, boolean cached) {
        SessionStorage sessionStorage;
        Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
        boolean bl = cached;
        if (bl) {
            sessionStorage = new CacheStorage(new DirectoryStorage(rootDir), 60000L);
        } else if (!bl) {
            sessionStorage = new DirectoryStorage(rootDir);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sessionStorage;
    }

    @KtorExperimentalAPI
    @NotNull
    public static /* synthetic */ SessionStorage directorySessionStorage$default(File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return DirectoryStorageKt.directorySessionStorage(file, bl);
    }

    private static final void mkdirsOrFail(@NotNull File $this$mkdirsOrFail) {
        if (!$this$mkdirsOrFail.mkdirs() && !$this$mkdirsOrFail.exists()) {
            throw (Throwable)new IOException("Couldn't create directory " + $this$mkdirsOrFail);
        }
        if (!$this$mkdirsOrFail.isDirectory()) {
            throw (Throwable)new IOException("Path is not a directory: " + $this$mkdirsOrFail);
        }
    }

    private static final void deleteParentsWhileEmpty(@NotNull File $this$deleteParentsWhileEmpty, File mostTop) {
        while (Intrinsics.areEqual((Object)$this$deleteParentsWhileEmpty, (Object)mostTop) ^ true && $this$deleteParentsWhileEmpty.isDirectory() && $this$deleteParentsWhileEmpty.exists() && DirectoryStorageKt.isNullOrEmpty($this$deleteParentsWhileEmpty.list())) {
            if (!$this$deleteParentsWhileEmpty.delete() && $this$deleteParentsWhileEmpty.exists()) {
                throw (Throwable)new IOException("Failed to delete dir " + $this$deleteParentsWhileEmpty);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)$this$deleteParentsWhileEmpty.getParentFile(), (String)"parentFile");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final <T> boolean isNullOrEmpty(@Nullable T[] $this$isNullOrEmpty) {
        if ($this$isNullOrEmpty == null) return true;
        T[] TArray = $this$isNullOrEmpty;
        boolean bl = false;
        if (TArray.length != 0) return false;
        return true;
    }

    private static final Sequence<String> window(@NotNull String $this$window, int size, int step, boolean dropTrailing) {
        CharSequence charSequence = $this$window;
        boolean bl = false;
        return charSequence.length() == 0 || size > $this$window.length() && dropTrailing ? SequencesKt.emptySequence() : (Sequence)new Sequence<String>($this$window, size, step, dropTrailing){
            final /* synthetic */ String $this_window;
            final /* synthetic */ int $size;
            final /* synthetic */ int $step;
            final /* synthetic */ boolean $dropTrailing;

            @NotNull
            public Iterator<String> iterator() {
                return (Iterator)((Object)new StringWindowIterator(this.$this_window, this.$size, this.$step, this.$dropTrailing));
            }
            {
                this.$this_window = $receiver;
                this.$size = $captured_local_variable$1;
                this.$step = $captured_local_variable$2;
                this.$dropTrailing = $captured_local_variable$3;
            }
        };
    }

    static /* synthetic */ Sequence window$default(String string, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        return DirectoryStorageKt.window(string, n, n2, bl);
    }

    public static final /* synthetic */ void access$mkdirsOrFail(File $this$access_u24mkdirsOrFail) {
        DirectoryStorageKt.mkdirsOrFail($this$access_u24mkdirsOrFail);
    }

    public static final /* synthetic */ void access$deleteParentsWhileEmpty(File $this$access_u24deleteParentsWhileEmpty, File mostTop) {
        DirectoryStorageKt.deleteParentsWhileEmpty($this$access_u24deleteParentsWhileEmpty, mostTop);
    }
}

