/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.servlet;

import io.ktor.application.Application;
import io.ktor.application.ApplicationKt;
import io.ktor.server.engine.DefaultUncaughtExceptionHandler;
import io.ktor.server.engine.EngineAPI;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.servlet.AsyncDispatchers;
import io.ktor.server.servlet.AsyncServletApplicationCall;
import io.ktor.server.servlet.BlockingServletApplicationCall;
import io.ktor.server.servlet.KtorServlet;
import io.ktor.server.servlet.KtorServletKt;
import io.ktor.server.servlet.ServletUpgrade;
import io.ktor.util.AttributeKey;
import io.ktor.util.Attributes;
import io.ktor.util.cio.ChannelIOException;
import io.ktor.util.pipeline.Pipeline;
import javax.servlet.AsyncContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EngineAPI
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020\u001cH\u0016J\b\u0010#\u001a\u00020\u001cH\u0016J\u0018\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0018X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lio/ktor/server/servlet/KtorServlet;", "Ljavax/servlet/http/HttpServlet;", "Lkotlinx/coroutines/CoroutineScope;", "()V", "application", "Lio/ktor/application/Application;", "getApplication", "()Lio/ktor/application/Application;", "asyncDispatchers", "Lkotlin/Lazy;", "Lio/ktor/server/servlet/AsyncDispatchers;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "enginePipeline", "Lio/ktor/server/engine/EnginePipeline;", "getEnginePipeline", "()Lio/ktor/server/engine/EnginePipeline;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "upgrade", "Lio/ktor/server/servlet/ServletUpgrade;", "getUpgrade", "()Lio/ktor/server/servlet/ServletUpgrade;", "asyncService", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "blockingService", "destroy", "init", "service", "ktor-server-servlet"})
public abstract class KtorServlet
extends HttpServlet
implements CoroutineScope {
    private final Lazy<AsyncDispatchers> asyncDispatchers = LazyKt.lazy((Function0)asyncDispatchers.1.INSTANCE);
    @NotNull
    private final CoroutineContext coroutineContext = Dispatchers.getUnconfined().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)).plus((CoroutineContext)new CoroutineName("servlet")).plus((CoroutineContext)new DefaultUncaughtExceptionHandler((Function0)new Function0<Logger>(this){
        final /* synthetic */ KtorServlet this$0;

        @NotNull
        public final Logger invoke() {
            return this.this$0.getLogger();
        }
        {
            this.this$0 = ktorServlet;
            super(0);
        }
    }));

    @NotNull
    protected abstract Application getApplication();

    @NotNull
    protected abstract EnginePipeline getEnginePipeline();

    @NotNull
    protected Logger getLogger() {
        Logger logger = LoggerFactory.getLogger((String)this.getServletName());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(servletName)");
        return logger;
    }

    @NotNull
    protected abstract ServletUpgrade getUpgrade();

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public void init() {
        super.init();
        Attributes attributes = this.getApplication().getAttributes();
        AttributeKey<ServletContext> attributeKey = KtorServletKt.getServletContextAttribute();
        ServletContext servletContext = this.getServletContext();
        if (servletContext == null) {
            Intrinsics.throwNpe();
        }
        attributes.put(attributeKey, (Object)servletContext);
    }

    public void destroy() {
        JobKt.cancel$default((CoroutineContext)this.getCoroutineContext(), null, (int)1, null);
        if (this.asyncDispatchers.isInitialized()) {
            ((AsyncDispatchers)this.asyncDispatchers.getValue()).destroy();
        }
    }

    protected void service(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response2) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
        if (response2.isCommitted()) {
            return;
        }
        try {
            if (request.isAsyncSupported()) {
                this.asyncService(request, response2);
            } else {
                this.blockingService(request, response2);
            }
        }
        catch (ChannelIOException ioError) {
            ApplicationKt.getLog((Application)this.getApplication()).debug("I/O error", (Throwable)ioError);
        }
        catch (Throwable ex) {
            ApplicationKt.getLog((Application)this.getApplication()).error("ServletApplicationEngine cannot service the request", ex);
            response2.sendError(500, ex.getMessage());
        }
    }

    private final void asyncService(HttpServletRequest request, HttpServletResponse response2) {
        AsyncContext asyncContext = request.startAsync();
        if (asyncContext == null) {
            Intrinsics.throwNpe();
        }
        AsyncContext asyncContext2 = asyncContext;
        boolean bl = false;
        boolean bl2 = false;
        AsyncContext $this$apply = asyncContext2;
        boolean bl3 = false;
        $this$apply.setTimeout(0L);
        AsyncContext asyncContext3 = asyncContext2;
        AsyncDispatchers asyncDispatchers2 = (AsyncDispatchers)this.asyncDispatchers.getValue();
        BuildersKt.launch$default((CoroutineScope)this, (CoroutineContext)((CoroutineContext)asyncDispatchers2.getDispatcher()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, response2, asyncDispatchers2, asyncContext3, null){
            private CoroutineScope p$;
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ KtorServlet this$0;
            final /* synthetic */ HttpServletRequest $request;
            final /* synthetic */ HttpServletResponse $response;
            final /* synthetic */ AsyncDispatchers $asyncDispatchers;
            final /* synthetic */ AsyncContext $asyncContext;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Pipeline $this$execute$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$launch = this.p$;
                        AsyncServletApplicationCall call = new AsyncServletApplicationCall(this.this$0.getApplication(), this.$request, this.$response, (CoroutineContext)this.$asyncDispatchers.getEngineDispatcher(), (CoroutineContext)this.$asyncDispatchers.getDispatcher(), this.this$0.getUpgrade(), $this$launch.getCoroutineContext());
                        Pipeline pipeline = (Pipeline)this.this$0.getEnginePipeline();
                        asyncService.1 var5_10 = this;
                        boolean $i$f$execute = false;
                        this.L$0 = $this$launch;
                        this.L$1 = call;
                        this.L$2 = $this$execute$iv;
                        this.label = 1;
                        Object object2 = $this$execute$iv.execute((Object)((Object)call), (Object)Unit.INSTANCE, (Continuation)var5_10);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Object object2;
                        Pipeline $this$execute$iv = (Pipeline)this.L$2;
                        AsyncServletApplicationCall call = (AsyncServletApplicationCall)((Object)this.L$1);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                this.$asyncContext.complete();
                            }
                            catch (IllegalStateException alreadyCompleted) {
                                ApplicationKt.getLog((Application)this.this$0.getApplication()).debug("AsyncContext is already completed due to previous I/O error", (Throwable)alreadyCompleted);
                            }
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = ktorServlet;
                this.$request = httpServletRequest;
                this.$response = httpServletResponse;
                this.$asyncDispatchers = asyncDispatchers2;
                this.$asyncContext = asyncContext;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void blockingService(HttpServletRequest request, HttpServletResponse response2) {
        BuildersKt.runBlocking((CoroutineContext)this.getCoroutineContext(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, response2, null){
            private CoroutineScope p$;
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ KtorServlet this$0;
            final /* synthetic */ HttpServletRequest $request;
            final /* synthetic */ HttpServletResponse $response;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$execute$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$runBlocking = this.p$;
                        BlockingServletApplicationCall call = new BlockingServletApplicationCall(this.this$0.getApplication(), this.$request, this.$response, $this$runBlocking.getCoroutineContext());
                        Pipeline pipeline = (Pipeline)this.this$0.getEnginePipeline();
                        blockingService.1 var5_9 = this;
                        boolean $i$f$execute = false;
                        this.L$0 = $this$runBlocking;
                        this.L$1 = call;
                        this.L$2 = $this$execute$iv;
                        this.label = 1;
                        Object object2 = $this$execute$iv.execute((Object)((Object)call), (Object)Unit.INSTANCE, (Continuation)var5_9);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Pipeline $this$execute$iv = (Pipeline)this.L$2;
                        BlockingServletApplicationCall call = (BlockingServletApplicationCall)((Object)this.L$1);
                        CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = ktorServlet;
                this.$request = httpServletRequest;
                this.$response = httpServletResponse;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }
}

