/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.application.ApplicationCall;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.content.OutgoingContent;
import io.ktor.server.engine.BaseApplicationResponse;
import io.ktor.server.netty.NettyApplicationCall;
import io.ktor.server.netty.NettyApplicationResponse;
import io.ktor.util.InternalAPI;
import io.ktor.utils.io.ByteChannel;
import io.ktor.utils.io.ByteChannelCtorKt;
import io.ktor.utils.io.ByteChannelKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteWriteChannel;
import io.ktor.utils.io.ByteWriteChannelKt;
import io.ktor.utils.io.ClosedWriteChannelException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalAPI
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u0000 82\u00020\u0001:\u00018B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010 \u001a\u00020!J\r\u0010\"\u001a\u00020!H\u0000\u00a2\u0006\u0002\b#J\r\u0010$\u001a\u00020!H\u0000\u00a2\u0006\u0002\b%J\u0019\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)J\u0019\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020,H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0019\u0010.\u001a\u00020!2\u0006\u0010+\u001a\u00020/H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J\u0011\u0010\u000e\u001a\u000201H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J\u0018\u0010\u0014\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u001a2\u0006\u00104\u001a\u00020\u001aH$J\u0018\u0010\u0014\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u001a2\u0006\u00105\u001a\u00020(H\u0014J\u001f\u00106\u001a\u00020!2\b\b\u0002\u00103\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b7R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\b\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00069"}, d2={"Lio/ktor/server/netty/NettyApplicationResponse;", "Lio/ktor/server/engine/BaseApplicationResponse;", "call", "Lio/ktor/server/netty/NettyApplicationCall;", "context", "Lio/netty/channel/ChannelHandlerContext;", "engineContext", "Lkotlin/coroutines/CoroutineContext;", "userContext", "(Lio/ktor/server/netty/NettyApplicationCall;Lio/netty/channel/ChannelHandlerContext;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;)V", "getContext", "()Lio/netty/channel/ChannelHandlerContext;", "getEngineContext", "()Lkotlin/coroutines/CoroutineContext;", "responseChannel", "Lio/ktor/utils/io/ByteReadChannel;", "getResponseChannel$ktor_server_netty", "()Lio/ktor/utils/io/ByteReadChannel;", "setResponseChannel$ktor_server_netty", "(Lio/ktor/utils/io/ByteReadChannel;)V", "responseMessage", "Lkotlinx/coroutines/CompletableDeferred;", "", "getResponseMessage", "()Lkotlinx/coroutines/CompletableDeferred;", "responseMessageSent", "", "getResponseMessageSent", "()Z", "setResponseMessageSent", "(Z)V", "getUserContext", "cancel", "", "close", "close$ktor_server_netty", "ensureResponseSent", "ensureResponseSent$ktor_server_netty", "respondFromBytes", "bytes", "", "([BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondNoContent", "content", "Lio/ktor/http/content/OutgoingContent$NoContent;", "(Lio/ktor/http/content/OutgoingContent$NoContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondOutgoingContent", "Lio/ktor/http/content/OutgoingContent;", "(Lio/ktor/http/content/OutgoingContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lio/ktor/utils/io/ByteWriteChannel;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "chunked", "last", "data", "sendResponse", "sendResponse$ktor_server_netty", "Companion", "ktor-server-netty"})
public abstract class NettyApplicationResponse
extends BaseApplicationResponse {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ChannelHandlerContext context;
    @NotNull
    private final CoroutineContext engineContext;
    @NotNull
    private final CoroutineContext userContext;
    @NotNull
    private final CompletableDeferred<Object> responseMessage;
    private volatile boolean responseMessageSent;
    @NotNull
    private ByteReadChannel responseChannel;
    @NotNull
    private static final byte[] EmptyByteArray;
    @NotNull
    private static final HttpResponseStatus[] responseStatusCache;

    public NettyApplicationResponse(@NotNull NettyApplicationCall call, @NotNull ChannelHandlerContext context, @NotNull CoroutineContext engineContext, @NotNull CoroutineContext userContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)call), (String)"call");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)engineContext, (String)"engineContext");
        Intrinsics.checkNotNullParameter((Object)userContext, (String)"userContext");
        super((ApplicationCall)call);
        this.context = context;
        this.engineContext = engineContext;
        this.userContext = userContext;
        this.responseMessage = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.responseChannel = ByteReadChannel.Companion.getEmpty();
    }

    @NotNull
    protected final ChannelHandlerContext getContext() {
        return this.context;
    }

    @NotNull
    protected final CoroutineContext getEngineContext() {
        return this.engineContext;
    }

    @NotNull
    protected final CoroutineContext getUserContext() {
        return this.userContext;
    }

    @NotNull
    public final CompletableDeferred<Object> getResponseMessage() {
        return this.responseMessage;
    }

    protected final boolean getResponseMessageSent() {
        return this.responseMessageSent;
    }

    protected final void setResponseMessageSent(boolean bl) {
        this.responseMessageSent = bl;
    }

    @NotNull
    public final ByteReadChannel getResponseChannel$ktor_server_netty() {
        return this.responseChannel;
    }

    public final void setResponseChannel$ktor_server_netty(@NotNull ByteReadChannel byteReadChannel) {
        Intrinsics.checkNotNullParameter((Object)byteReadChannel, (String)"<set-?>");
        this.responseChannel = byteReadChannel;
    }

    @Nullable
    protected Object respondOutgoingContent(@NotNull OutgoingContent content, @NotNull Continuation<? super Unit> $completion) {
        return NettyApplicationResponse.respondOutgoingContent$suspendImpl(this, content, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static /* synthetic */ Object respondOutgoingContent$suspendImpl(NettyApplicationResponse var0, OutgoingContent var1_1, Continuation var2_2) {
        if (!(var2_2 instanceof respondOutgoingContent.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, (Continuation<? super respondOutgoingContent.1>)var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ NettyApplicationResponse this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return NettyApplicationResponse.respondOutgoingContent$suspendImpl(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = super.respondOutgoingContent((OutgoingContent)content, (Continuation)$continuation);
                ** if (v0 != var8_5) goto lbl19
lbl18:
                // 1 sources

                return var8_5;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                this = (NettyApplicationResponse)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Throwable t) {
                    try {
                        var5_12 = this.getResponseChannel$ktor_server_netty();
                        out = var5_12 instanceof ByteWriteChannel != false ? (ByteWriteChannel)var5_12 : null;
                        var5_12 = out;
                        if (var5_12 != null) {
                            Boxing.boxBoolean((boolean)var5_12.close(t));
                        }
                        throw t;
                    }
                    catch (Throwable var3_11) {
                        var5_13 = this.getResponseChannel$ktor_server_netty();
                        out = var5_13 instanceof ByteWriteChannel != false ? (ByteWriteChannel)var5_13 : null;
                        var5_13 = out;
                        if (var5_13 != null) {
                            Boxing.boxBoolean((boolean)ByteWriteChannelKt.close((ByteWriteChannel)var5_13));
                        }
                        throw var3_11;
                    }
                }
lbl26:
                // 2 sources

                if ((var4_6 = (out = (var4_6 = this.getResponseChannel$ktor_server_netty()) instanceof ByteWriteChannel != false ? (ByteWriteChannel)var4_6 : null)) != null) {
                    Boxing.boxBoolean((boolean)ByteWriteChannelKt.close((ByteWriteChannel)var4_6));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    protected Object respondFromBytes(@NotNull byte[] bytes, @NotNull Continuation<? super Unit> $completion) {
        return NettyApplicationResponse.respondFromBytes$suspendImpl(this, bytes, $completion);
    }

    static /* synthetic */ Object respondFromBytes$suspendImpl(NettyApplicationResponse this_, byte[] bytes, Continuation $completion) {
        boolean chunked = Intrinsics.areEqual((Object)this_.getHeaders().get(HttpHeaders.INSTANCE.getTransferEncoding()), (Object)"chunked");
        if (!this_.getResponseMessageSent()) {
            Object message = this_.responseMessage(chunked, bytes);
            Object object = message;
            this_.setResponseChannel$ktor_server_netty(object instanceof LastHttpContent ? ByteReadChannel.Companion.getEmpty() : ByteChannelCtorKt.ByteReadChannel((byte[])bytes));
            this_.getResponseMessage().complete(message);
            this_.setResponseMessageSent(true);
        }
        return Unit.INSTANCE;
    }

    @Nullable
    protected Object responseChannel(@NotNull Continuation<? super ByteWriteChannel> $completion) {
        return NettyApplicationResponse.responseChannel$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object responseChannel$suspendImpl(NettyApplicationResponse this_, Continuation $completion) {
        ByteChannel channel = ByteChannelKt.ByteChannel$default((boolean)false, (int)1, null);
        boolean chunked = Intrinsics.areEqual((Object)this_.getHeaders().get(HttpHeaders.INSTANCE.getTransferEncoding()), (Object)"chunked");
        this_.sendResponse$ktor_server_netty(chunked, (ByteReadChannel)channel);
        return channel;
    }

    @Nullable
    protected Object respondNoContent(@NotNull OutgoingContent.NoContent content, @NotNull Continuation<? super Unit> $completion) {
        return NettyApplicationResponse.respondNoContent$suspendImpl(this, content, $completion);
    }

    static /* synthetic */ Object respondNoContent$suspendImpl(NettyApplicationResponse this_, OutgoingContent.NoContent content, Continuation $completion) {
        Object object = this_.respondFromBytes(EmptyByteArray, (Continuation<? super Unit>)$completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    protected abstract Object responseMessage(boolean var1, boolean var2);

    @NotNull
    protected Object responseMessage(boolean chunked, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.responseMessage(chunked, true);
    }

    public final void sendResponse$ktor_server_netty(boolean chunked, @NotNull ByteReadChannel content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (!this.responseMessageSent) {
            this.responseChannel = content;
            this.responseMessage.complete(content.isClosedForRead() ? this.responseMessage(false, EmptyByteArray) : this.responseMessage(chunked, false));
            this.responseMessageSent = true;
        }
    }

    public static /* synthetic */ void sendResponse$ktor_server_netty$default(NettyApplicationResponse nettyApplicationResponse, boolean bl, ByteReadChannel byteReadChannel, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendResponse");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        nettyApplicationResponse.sendResponse$ktor_server_netty(bl, byteReadChannel);
    }

    public final void ensureResponseSent$ktor_server_netty() {
        NettyApplicationResponse.sendResponse$ktor_server_netty$default(this, false, ByteReadChannel.Companion.getEmpty(), 1, null);
    }

    public final void close$ktor_server_netty() {
        ByteReadChannel existingChannel = this.responseChannel;
        if (existingChannel instanceof ByteWriteChannel) {
            ((ByteWriteChannel)existingChannel).close((Throwable)new ClosedWriteChannelException("Application response has been closed"));
            this.responseChannel = ByteReadChannel.Companion.getEmpty();
        }
        this.ensureResponseSent$ktor_server_netty();
    }

    public final void cancel() {
        if (!this.responseMessageSent) {
            this.responseChannel = ByteReadChannel.Companion.getEmpty();
            Job.DefaultImpls.cancel$default((Job)((Job)this.responseMessage), null, (int)1, null);
            this.responseMessageSent = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        EmptyByteArray = new byte[0];
        Iterable $this$associateBy$iv = HttpStatusCode.Companion.getAllStatusCodes();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            HttpStatusCode httpStatusCode = (HttpStatusCode)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Integer n = it.getValue();
            map.put(n, element$iv$iv);
        }
        Map map = destination$iv$iv;
        boolean bl = false;
        boolean bl2 = false;
        Map codes = map;
        boolean bl3 = false;
        HttpResponseStatus[] httpResponseStatusArray = new HttpResponseStatus[1000];
        for (int i = 0; i < 1000; ++i) {
            HttpResponseStatus httpResponseStatus;
            int n = i;
            if (codes.keySet().contains(n)) {
                Object v = codes.get(n);
                Intrinsics.checkNotNull(v);
                httpResponseStatus = new HttpResponseStatus(n, ((HttpStatusCode)v).getDescription());
            } else {
                httpResponseStatus = null;
            }
            httpResponseStatusArray[n] = httpResponseStatus;
        }
        responseStatusCache = httpResponseStatusArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lio/ktor/server/netty/NettyApplicationResponse$Companion;", "", "()V", "EmptyByteArray", "", "responseStatusCache", "", "Lio/netty/handler/codec/http/HttpResponseStatus;", "getResponseStatusCache", "()[Lio/netty/handler/codec/http/HttpResponseStatus;", "[Lio/netty/handler/codec/http/HttpResponseStatus;", "ktor-server-netty"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpResponseStatus[] getResponseStatusCache() {
            return responseStatusCache;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

