/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.application.ApplicationCall;
import io.ktor.http.Parameters;
import io.ktor.request.ApplicationRequest;
import io.ktor.request.ApplicationRequestPropertiesKt;
import io.ktor.request.RequestCookies;
import io.ktor.server.engine.BaseApplicationRequest;
import io.ktor.server.netty.NettyApplicationRequestCookies;
import io.ktor.server.netty.NettyMultiPartData;
import io.ktor.util.InternalAPI;
import io.ktor.utils.io.ByteReadChannel;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalAPI
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020&H$J\b\u0010'\u001a\u00020\nH\u0016R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006("}, d2={"Lio/ktor/server/netty/NettyApplicationRequest;", "Lio/ktor/server/engine/BaseApplicationRequest;", "Lkotlinx/coroutines/CoroutineScope;", "call", "Lio/ktor/application/ApplicationCall;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "context", "Lio/netty/channel/ChannelHandlerContext;", "requestBodyChannel", "Lio/ktor/utils/io/ByteReadChannel;", "uri", "", "keepAlive", "", "(Lio/ktor/application/ApplicationCall;Lkotlin/coroutines/CoroutineContext;Lio/netty/channel/ChannelHandlerContext;Lio/ktor/utils/io/ByteReadChannel;Ljava/lang/String;Z)V", "contentMultipart", "Lkotlin/Lazy;", "Lio/ktor/server/netty/NettyMultiPartData;", "getContext", "()Lio/netty/channel/ChannelHandlerContext;", "cookies", "Lio/ktor/request/RequestCookies;", "getCookies", "()Lio/ktor/request/RequestCookies;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "getKeepAlive$ktor_server_netty", "()Z", "queryParameters", "Lio/ktor/http/Parameters;", "getQueryParameters", "()Lio/ktor/http/Parameters;", "getUri", "()Ljava/lang/String;", "close", "", "newDecoder", "Lio/netty/handler/codec/http/multipart/HttpPostMultipartRequestDecoder;", "receiveChannel", "ktor-server-netty"})
public abstract class NettyApplicationRequest
extends BaseApplicationRequest
implements CoroutineScope {
    @NotNull
    private final Parameters queryParameters;
    @NotNull
    private final RequestCookies cookies;
    private final Lazy<NettyMultiPartData> contentMultipart;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final ChannelHandlerContext context;
    private final ByteReadChannel requestBodyChannel;
    @NotNull
    private final String uri;
    private final boolean keepAlive;

    @NotNull
    public final Parameters getQueryParameters() {
        return this.queryParameters;
    }

    @NotNull
    public RequestCookies getCookies() {
        return this.cookies;
    }

    @NotNull
    public ByteReadChannel receiveChannel() {
        return this.requestBodyChannel;
    }

    @NotNull
    protected abstract HttpPostMultipartRequestDecoder newDecoder();

    public final void close() {
        if (this.contentMultipart.isInitialized()) {
            ((NettyMultiPartData)this.contentMultipart.getValue()).destroy$ktor_server_netty();
        }
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @NotNull
    public final ChannelHandlerContext getContext() {
        return this.context;
    }

    @NotNull
    protected final String getUri() {
        return this.uri;
    }

    public final boolean getKeepAlive$ktor_server_netty() {
        return this.keepAlive;
    }

    public NettyApplicationRequest(@NotNull ApplicationCall call, @NotNull CoroutineContext coroutineContext, @NotNull ChannelHandlerContext context, @NotNull ByteReadChannel requestBodyChannel, @NotNull String uri, boolean keepAlive) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)coroutineContext, (String)"coroutineContext");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)requestBodyChannel, (String)"requestBodyChannel");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        super(call);
        this.coroutineContext = coroutineContext;
        this.context = context;
        this.requestBodyChannel = requestBodyChannel;
        this.uri = uri;
        this.keepAlive = keepAlive;
        this.queryParameters = new Parameters(this){
            private final QueryStringDecoder decoder;
            final /* synthetic */ NettyApplicationRequest this$0;

            public boolean getCaseInsensitiveName() {
                return true;
            }

            @Nullable
            public List<String> getAll(@NotNull String name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return (List)this.decoder.parameters().get(name);
            }

            @NotNull
            public Set<String> names() {
                return this.decoder.parameters().keySet();
            }

            @NotNull
            public Set<Map.Entry<String, List<String>>> entries() {
                return this.decoder.parameters().entrySet();
            }

            public boolean isEmpty() {
                return this.decoder.parameters().isEmpty();
            }
            {
                this.this$0 = $outer;
                this.decoder = new QueryStringDecoder($outer.getUri());
            }

            public boolean contains(@NotNull String name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return Parameters.DefaultImpls.contains((Parameters)this, (String)name);
            }

            public boolean contains(@NotNull String name, @NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return Parameters.DefaultImpls.contains((Parameters)this, (String)name, (String)value);
            }

            public void forEach(@NotNull Function2<? super String, ? super List<String>, Unit> body) {
                Intrinsics.checkParameterIsNotNull(body, (String)"body");
                Parameters.DefaultImpls.forEach((Parameters)this, body);
            }

            @Nullable
            public String get(@NotNull String name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return Parameters.DefaultImpls.get((Parameters)this, (String)name);
            }
        };
        this.cookies = new NettyApplicationRequestCookies((ApplicationRequest)this);
        this.contentMultipart = LazyKt.lazy((Function0)((Function0)new Function0<NettyMultiPartData>(this){
            final /* synthetic */ NettyApplicationRequest this$0;

            @NotNull
            public final NettyMultiPartData invoke() {
                if (!ApplicationRequestPropertiesKt.isMultipart((ApplicationRequest)this.this$0)) {
                    throw (Throwable)new IOException("The request content is not multipart encoded");
                }
                HttpPostMultipartRequestDecoder decoder = this.this$0.newDecoder();
                ByteBufAllocator byteBufAllocator = this.this$0.getContext().alloc();
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBufAllocator, (String)"context.alloc()");
                return new NettyMultiPartData(decoder, byteBufAllocator, NettyApplicationRequest.access$getRequestBodyChannel$p(this.this$0));
            }
            {
                this.this$0 = nettyApplicationRequest;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ ByteReadChannel access$getRequestBodyChannel$p(NettyApplicationRequest $this) {
        return $this.requestBodyChannel;
    }
}

