/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http1;

import io.ktor.application.Application;
import io.ktor.application.ApplicationKt;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.netty.NettyApplicationCallHandler;
import io.ktor.server.netty.cio.NettyRequestQueue;
import io.ktor.server.netty.cio.NettyResponsePipeline;
import io.ktor.server.netty.cio.RequestBodyHandler;
import io.ktor.server.netty.cio.WriterEncapsulation;
import io.ktor.server.netty.http1.NettyHttp1ApplicationCall;
import io.ktor.util.cio.ChannelIOException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.io.ByteReadChannel;
import org.jetbrains.annotations.NotNull;

@ChannelHandler.Sharable
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lio/ktor/server/netty/http1/NettyHttp1Handler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "Lkotlinx/coroutines/CoroutineScope;", "enginePipeline", "Lio/ktor/server/engine/EnginePipeline;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "callEventGroup", "Lio/netty/util/concurrent/EventExecutorGroup;", "engineContext", "Lkotlin/coroutines/CoroutineContext;", "userContext", "requestQueue", "Lio/ktor/server/netty/cio/NettyRequestQueue;", "(Lio/ktor/server/engine/EnginePipeline;Lio/ktor/server/engine/ApplicationEngineEnvironment;Lio/netty/util/concurrent/EventExecutorGroup;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;Lio/ktor/server/netty/cio/NettyRequestQueue;)V", "configured", "", "coroutineContext", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "handlerJob", "Lkotlinx/coroutines/CompletableDeferred;", "", "skipEmpty", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelInactive", "channelRead", "msg", "", "content", "Lkotlinx/coroutines/io/ByteReadChannel;", "context", "message", "Lio/netty/handler/codec/http/HttpRequest;", "exceptionCaught", "cause", "", "handleRequest", "ktor-server-netty"})
public final class NettyHttp1Handler
extends ChannelInboundHandlerAdapter
implements CoroutineScope {
    private final CompletableDeferred handlerJob;
    private boolean configured;
    private boolean skipEmpty;
    private final EnginePipeline enginePipeline;
    private final ApplicationEngineEnvironment environment;
    private final EventExecutorGroup callEventGroup;
    private final CoroutineContext engineContext;
    private final CoroutineContext userContext;
    private final NettyRequestQueue requestQueue;

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return (CoroutineContext)this.handlerJob;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        if (msg instanceof HttpRequest) {
            this.handleRequest(ctx, (HttpRequest)msg);
            return;
        }
        if (msg instanceof LastHttpContent) {
            ByteBuf byteBuf = ((LastHttpContent)msg).content();
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"msg.content()");
            if (!byteBuf.isReadable() && this.skipEmpty) {
                this.skipEmpty = false;
                ((LastHttpContent)msg).release();
                return;
            }
        }
        ctx.fireChannelRead(msg);
    }

    /*
     * Unable to fully structure code
     */
    private final void handleRequest(ChannelHandlerContext context, HttpRequest message) {
        v0 = context.channel().config();
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"context.channel().config()");
        v0.setAutoRead(false);
        if (!(message instanceof LastHttpContent)) ** GOTO lbl-1000
        v1 = ((LastHttpContent)message).content();
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"message.content()");
        if (!v1.isReadable()) {
            v2 = ByteReadChannel.Companion.getEmpty();
        } else if (message.method() == HttpMethod.GET) {
            this.skipEmpty = true;
            v2 = ByteReadChannel.Companion.getEmpty();
        } else {
            v2 = this.content(context, message);
        }
        requestBodyChannel = v2;
        call = new NettyHttp1ApplicationCall(this.environment.getApplication(), context, message, requestBodyChannel, this.engineContext, this.userContext);
        this.requestQueue.schedule(call);
    }

    private final ByteReadChannel content(ChannelHandlerContext context, HttpRequest message) {
        ByteReadChannel byteReadChannel;
        HttpRequest httpRequest = message;
        if (httpRequest instanceof HttpContent) {
            ByteReadChannel byteReadChannel2;
            RequestBodyHandler bodyHandler = (RequestBodyHandler)context.pipeline().get(RequestBodyHandler.class);
            ByteReadChannel it = byteReadChannel2 = bodyHandler.newChannel();
            bodyHandler.channelRead(context, message);
            byteReadChannel = byteReadChannel2;
        } else {
            RequestBodyHandler bodyHandler = (RequestBodyHandler)context.pipeline().get(RequestBodyHandler.class);
            byteReadChannel = bodyHandler.newChannel();
        }
        return byteReadChannel;
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        if (!this.configured) {
            ChannelPipeline channelPipeline;
            this.configured = true;
            RequestBodyHandler requestBodyHandler = new RequestBodyHandler(ctx, this.requestQueue);
            NettyResponsePipeline responseWriter = new NettyResponsePipeline(ctx, WriterEncapsulation.Http1.INSTANCE, this.requestQueue, this.getCoroutineContext());
            ChannelPipeline $receiver = channelPipeline = ctx.pipeline();
            $receiver.addLast(new ChannelHandler[]{(ChannelHandler)requestBodyHandler});
            $receiver.addLast(this.callEventGroup, new ChannelHandler[]{(ChannelHandler)new NettyApplicationCallHandler(this.userContext, this.enginePipeline)});
            responseWriter.ensureRunning();
        }
        super.channelActive(ctx);
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        if (this.configured) {
            ChannelPipeline channelPipeline;
            this.configured = false;
            ChannelPipeline $receiver = channelPipeline = ctx.pipeline();
            $receiver.remove(NettyApplicationCallHandler.class);
            this.requestQueue.cancel();
        }
        super.channelInactive(ctx);
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        if (cause instanceof IOException || cause instanceof ChannelIOException) {
            ApplicationKt.getLog((Application)this.environment.getApplication()).debug("I/O operation failed", cause);
            this.handlerJob.cancel();
        } else {
            this.handlerJob.completeExceptionally(cause);
        }
        this.requestQueue.cancel();
        ctx.close();
    }

    public NettyHttp1Handler(@NotNull EnginePipeline enginePipeline, @NotNull ApplicationEngineEnvironment environment, @NotNull EventExecutorGroup callEventGroup, @NotNull CoroutineContext engineContext, @NotNull CoroutineContext userContext, @NotNull NettyRequestQueue requestQueue) {
        Intrinsics.checkParameterIsNotNull((Object)enginePipeline, (String)"enginePipeline");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)callEventGroup, (String)"callEventGroup");
        Intrinsics.checkParameterIsNotNull((Object)engineContext, (String)"engineContext");
        Intrinsics.checkParameterIsNotNull((Object)userContext, (String)"userContext");
        Intrinsics.checkParameterIsNotNull((Object)requestQueue, (String)"requestQueue");
        this.enginePipeline = enginePipeline;
        this.environment = environment;
        this.callEventGroup = callEventGroup;
        this.engineContext = engineContext;
        this.userContext = userContext;
        this.requestQueue = requestQueue;
        this.handlerJob = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
    }
}

