/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.cio;

import io.ktor.server.netty.NettyApplicationCall;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.internal.LockFreeLinkedListNode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lio/ktor/server/netty/cio/NettyRequestQueue;", "", "readLimit", "", "runningLimit", "(II)V", "elements", "Lkotlinx/coroutines/channels/ReceiveChannel;", "Lio/ktor/server/netty/cio/NettyRequestQueue$CallElement;", "getElements", "()Lkotlinx/coroutines/channels/ReceiveChannel;", "incomingQueue", "Lkotlinx/coroutines/channels/Channel;", "getReadLimit$ktor_server_netty", "()I", "getRunningLimit$ktor_server_netty", "canRequestMoreEvents", "", "cancel", "", "close", "schedule", "call", "Lio/ktor/server/netty/NettyApplicationCall;", "CallElement", "ktor-server-netty"})
public final class NettyRequestQueue {
    private final Channel<CallElement> incomingQueue;
    @NotNull
    private final ReceiveChannel<CallElement> elements;
    private final int readLimit;
    private final int runningLimit;

    @NotNull
    public final ReceiveChannel<CallElement> getElements() {
        return this.elements;
    }

    public final void schedule(@NotNull NettyApplicationCall call) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)call), (String)"call");
        CallElement element = new CallElement(call);
        try {
            this.incomingQueue.offer((Object)element);
        }
        catch (Throwable t) {
            element.tryDispose();
        }
    }

    public final void close() {
        SendChannel.DefaultImpls.close$default(this.incomingQueue, null, (int)1, null);
    }

    public final void cancel() {
        SendChannel.DefaultImpls.close$default(this.incomingQueue, null, (int)1, null);
        while (true) {
            CallElement callElement = (CallElement)((Object)this.incomingQueue.poll());
            if (callElement == null) break;
            callElement.tryDispose();
        }
    }

    public final boolean canRequestMoreEvents() {
        return this.incomingQueue.isEmpty();
    }

    public final int getReadLimit$ktor_server_netty() {
        return this.readLimit;
    }

    public final int getRunningLimit$ktor_server_netty() {
        return this.runningLimit;
    }

    public NettyRequestQueue(int readLimit, int runningLimit) {
        boolean bl;
        this.readLimit = readLimit;
        this.runningLimit = runningLimit;
        boolean bl2 = bl = this.readLimit > 0;
        if (!bl) {
            String string = "readLimit should be positive: " + this.readLimit;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl3 = bl = this.runningLimit > 0;
        if (!bl) {
            String string = "executeLimit should be positive: " + this.runningLimit;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.incomingQueue = ChannelKt.Channel((int)Integer.MAX_VALUE);
        this.elements = (ReceiveChannel)this.incomingQueue;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/ktor/server/netty/cio/NettyRequestQueue$CallElement;", "Lkotlinx/coroutines/internal/LockFreeLinkedListNode;", "call", "Lio/ktor/server/netty/NettyApplicationCall;", "(Lio/ktor/server/netty/NettyApplicationCall;)V", "getCall", "()Lio/ktor/server/netty/NettyApplicationCall;", "scheduled", "", "ensureRunning", "", "tryDispose", "", "Companion", "ktor-server-netty"})
    public static final class CallElement
    extends LockFreeLinkedListNode {
        private volatile int scheduled;
        @NotNull
        private final NettyApplicationCall call;
        private static final AtomicIntegerFieldUpdater<CallElement> Scheduled;
        public static final Companion Companion;

        public final boolean ensureRunning() {
            if (Scheduled.compareAndSet(this, 0, 1)) {
                this.call.getContext().fireChannelRead((Object)this.call);
                return true;
            }
            return this.scheduled == 1;
        }

        public final void tryDispose() {
            if (Scheduled.compareAndSet(this, 0, 2)) {
                this.call.dispose$ktor_server_netty();
            }
        }

        @NotNull
        public final NettyApplicationCall getCall() {
            return this.call;
        }

        public CallElement(@NotNull NettyApplicationCall call) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)call), (String)"call");
            this.call = call;
        }

        static {
            Companion = new Companion(null);
            AtomicIntegerFieldUpdater<CallElement> atomicIntegerFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(CallElement.class, "scheduled");
            if (atomicIntegerFieldUpdater == null) {
                Intrinsics.throwNpe();
            }
            Scheduled = atomicIntegerFieldUpdater;
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/ktor/server/netty/cio/NettyRequestQueue$CallElement$Companion;", "", "()V", "Scheduled", "Ljava/util/concurrent/atomic/AtomicIntegerFieldUpdater;", "Lio/ktor/server/netty/cio/NettyRequestQueue$CallElement;", "kotlin.jvm.PlatformType", "ktor-server-netty"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

