/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.jetty;

import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ConnectorType;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineSSLConnectorConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"initializeServer", "", "Lorg/eclipse/jetty/server/Server;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "ktor-server-jetty"})
public final class ServerInitializerKt {
    /*
     * WARNING - void declaration
     */
    public static final void initializeServer(@NotNull Server $this$initializeServer, @NotNull ApplicationEngineEnvironment environment) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$initializeServer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Iterable $this$map$iv = environment.getConnectors();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object[] objectArray;
            Object[] objectArray2;
            boolean bl;
            HttpConfiguration $this$initializeServer_u24lambda_u2d4_u24lambda_u2d1;
            boolean bl2;
            void ktorConnector;
            EngineConnectorConfig engineConnectorConfig = (EngineConnectorConfig)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            HttpConfiguration httpConfiguration = new HttpConfiguration();
            boolean bl4 = false;
            boolean bl5 = false;
            HttpConfiguration $this$initializeServer_u24lambda_u2d4_u24lambda_u2d0 = httpConfiguration;
            boolean bl6 = false;
            $this$initializeServer_u24lambda_u2d4_u24lambda_u2d0.setSendServerVersion(false);
            $this$initializeServer_u24lambda_u2d4_u24lambda_u2d0.setSendDateHeader(false);
            if (Intrinsics.areEqual((Object)ktorConnector.getType(), (Object)ConnectorType.Companion.getHTTPS())) {
                $this$initializeServer_u24lambda_u2d4_u24lambda_u2d0.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            }
            HttpConfiguration httpConfig = httpConfiguration;
            boolean alpnAvailable = false;
            HttpConfiguration alpnConnectionFactory = null;
            HTTP2ServerConnectionFactory http2ConnectionFactory = null;
            try {
                $this$initializeServer_u24lambda_u2d4_u24lambda_u2d0 = new ALPNServerConnectionFactory(new String[0]);
                boolean bl7 = false;
                bl2 = false;
                $this$initializeServer_u24lambda_u2d4_u24lambda_u2d1 = $this$initializeServer_u24lambda_u2d4_u24lambda_u2d0;
                bl = false;
                $this$initializeServer_u24lambda_u2d4_u24lambda_u2d1.setDefaultProtocol(HttpVersion.HTTP_1_1.asString());
                alpnConnectionFactory = $this$initializeServer_u24lambda_u2d4_u24lambda_u2d0;
                http2ConnectionFactory = new HTTP2ServerConnectionFactory(httpConfig);
                alpnAvailable = true;
            }
            catch (Throwable t) {
                alpnConnectionFactory = null;
                http2ConnectionFactory = null;
            }
            ConnectorType connectorType = ktorConnector.getType();
            if (Intrinsics.areEqual((Object)connectorType, (Object)ConnectorType.Companion.getHTTP())) {
                objectArray2 = new AbstractConnectionFactory[]{(AbstractConnectionFactory)new HttpConnectionFactory(httpConfig), (AbstractConnectionFactory)new HTTP2CServerConnectionFactory(httpConfig)};
                objectArray = objectArray2;
            } else if (Intrinsics.areEqual((Object)connectorType, (Object)ConnectorType.Companion.getHTTPS())) {
                void $this$initializeServer_u24lambda_u2d4_u24lambda_u2d2;
                objectArray2 = new AbstractConnectionFactory[4];
                $this$initializeServer_u24lambda_u2d4_u24lambda_u2d1 = new SslContextFactory.Server();
                bl = false;
                boolean bl8 = false;
                HttpConfiguration httpConfiguration2 = $this$initializeServer_u24lambda_u2d4_u24lambda_u2d1;
                int n = 0;
                Object[] objectArray3 = objectArray2;
                boolean bl9 = false;
                if (alpnAvailable) {
                    $this$initializeServer_u24lambda_u2d4_u24lambda_u2d2.setCipherComparator(HTTP2Cipher.COMPARATOR);
                    $this$initializeServer_u24lambda_u2d4_u24lambda_u2d2.setUseCipherSuitesOrder(true);
                }
                $this$initializeServer_u24lambda_u2d4_u24lambda_u2d2.setKeyStore(((EngineSSLConnectorConfig)ktorConnector).getKeyStore());
                Object[] objectArray4 = (char[])((EngineSSLConnectorConfig)ktorConnector).getPrivateKeyPassword().invoke();
                boolean bl10 = false;
                $this$initializeServer_u24lambda_u2d4_u24lambda_u2d2.setKeyManagerPassword(new String((char[])objectArray4));
                objectArray4 = (char[])((EngineSSLConnectorConfig)ktorConnector).getKeyStorePassword().invoke();
                bl10 = false;
                $this$initializeServer_u24lambda_u2d4_u24lambda_u2d2.setKeyStorePassword(new String((char[])objectArray4));
                objectArray4 = new String[7];
                objectArray4[0] = (char)"SSL_RSA_WITH_DES_CBC_SHA";
                objectArray4[1] = (char)"SSL_DHE_RSA_WITH_DES_CBC_SHA";
                objectArray4[2] = (char)"SSL_DHE_DSS_WITH_DES_CBC_SHA";
                objectArray4[3] = (char)"SSL_RSA_EXPORT_WITH_RC4_40_MD5";
                objectArray4[4] = (char)"SSL_RSA_EXPORT_WITH_DES40_CBC_SHA";
                objectArray4[5] = (char)"SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA";
                objectArray4[6] = (char)"SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA";
                $this$initializeServer_u24lambda_u2d4_u24lambda_u2d2.addExcludeCipherSuites((String[])objectArray4);
                Unit unit = Unit.INSTANCE;
                String string = alpnAvailable ? "alpn" : HttpVersion.HTTP_1_1.asString();
                SslContextFactory sslContextFactory = (SslContextFactory)$this$initializeServer_u24lambda_u2d4_u24lambda_u2d1;
                objectArray3[n] = (AbstractConnectionFactory)new SslConnectionFactory(sslContextFactory, string);
                objectArray2[1] = (AbstractConnectionFactory)alpnConnectionFactory;
                $this$initializeServer_u24lambda_u2d4_u24lambda_u2d1 = http2ConnectionFactory;
                objectArray2[2] = (AbstractConnectionFactory)($this$initializeServer_u24lambda_u2d4_u24lambda_u2d1 == null ? (HTTP2ServerConnectionFactory)new HTTP2CServerConnectionFactory(httpConfig) : $this$initializeServer_u24lambda_u2d4_u24lambda_u2d1);
                objectArray2[3] = (AbstractConnectionFactory)new HttpConnectionFactory(httpConfig);
                Collection $this$toTypedArray$iv = ArraysKt.filterNotNull((Object[])objectArray2);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                AbstractConnectionFactory[] abstractConnectionFactoryArray = thisCollection$iv.toArray(new AbstractConnectionFactory[0]);
                if (abstractConnectionFactoryArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                objectArray = abstractConnectionFactoryArray;
            } else {
                throw new IllegalArgumentException("Connector type " + ktorConnector.getType() + " is not supported by Jetty engine implementation");
            }
            Object[] connectionFactories = objectArray;
            connectorType = new ServerConnector($this$initializeServer, (ConnectionFactory[])Arrays.copyOf(connectionFactories, connectionFactories.length));
            bl2 = false;
            boolean bl11 = false;
            ConnectorType $this$initializeServer_u24lambda_u2d4_u24lambda_u2d3 = connectorType;
            boolean bl12 = false;
            $this$initializeServer_u24lambda_u2d4_u24lambda_u2d3.setHost(ktorConnector.getHost());
            $this$initializeServer_u24lambda_u2d4_u24lambda_u2d3.setPort(ktorConnector.getPort());
            ConnectorType connectorType2 = connectorType;
            collection.add(connectorType2);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerConnector it = (ServerConnector)element$iv;
            boolean bl = false;
            $this$initializeServer.addConnector((Connector)it);
        }
    }
}

