/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.jetty;

import io.ktor.application.DefaultApplicationEventsKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.EngineContextCancellationHelperKt;
import io.ktor.server.jetty.JettyApplicationEngineBase;
import io.ktor.server.jetty.ServerInitializerKt;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import org.eclipse.jetty.server.Server;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001cB&\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lio/ktor/server/jetty/JettyApplicationEngineBase;", "Lio/ktor/server/engine/BaseApplicationEngine;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "configure", "Lkotlin/Function1;", "Lio/ktor/server/jetty/JettyApplicationEngineBase$Configuration;", "", "Lkotlin/ExtensionFunctionType;", "(Lio/ktor/server/engine/ApplicationEngineEnvironment;Lkotlin/jvm/functions/Function1;)V", "cancellationDeferred", "Lkotlinx/coroutines/CompletableDeferred;", "configuration", "server", "Lorg/eclipse/jetty/server/Server;", "getServer", "()Lorg/eclipse/jetty/server/Server;", "start", "wait", "", "stop", "gracePeriod", "", "timeout", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "toString", "", "Configuration", "ktor-server-jetty"})
public class JettyApplicationEngineBase
extends BaseApplicationEngine {
    private final Configuration configuration;
    private CompletableDeferred<Unit> cancellationDeferred;
    @NotNull
    private final Server server;

    @NotNull
    protected final Server getServer() {
        return this.server;
    }

    @NotNull
    public JettyApplicationEngineBase start(boolean wait) {
        this.getEnvironment().start();
        this.server.start();
        this.cancellationDeferred = EngineContextCancellationHelperKt.stopServerOnCancellation((ApplicationEngine)this);
        if (wait) {
            this.server.join();
            this.stop(1L, 5L, TimeUnit.SECONDS);
        }
        return this;
    }

    public void stop(long gracePeriod, long timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        CompletableDeferred<Unit> completableDeferred = this.cancellationDeferred;
        if (completableDeferred != null) {
            completableDeferred.complete((Object)Unit.INSTANCE);
        }
        this.getEnvironment().getMonitor().raise(DefaultApplicationEventsKt.getApplicationStopPreparing(), (Object)this.getEnvironment());
        this.server.setStopTimeout(timeUnit.toMillis(timeout));
        this.server.stop();
        this.server.destroy();
        this.getEnvironment().stop();
    }

    @NotNull
    public String toString() {
        return "Jetty(" + this.getEnvironment() + ')';
    }

    public JettyApplicationEngineBase(@NotNull ApplicationEngineEnvironment environment, @NotNull Function1<? super Configuration, Unit> configure) {
        Configuration configuration;
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull(configure, (String)"configure");
        super(environment, null, 2, null);
        Configuration configuration2 = new Configuration();
        JettyApplicationEngineBase jettyApplicationEngineBase = this;
        configure.invoke((Object)configuration2);
        jettyApplicationEngineBase.configuration = configuration = configuration2;
        configuration2 = new Server();
        jettyApplicationEngineBase = this;
        Configuration $receiver = configuration2;
        this.configuration.getConfigureServer().invoke((Object)$receiver);
        ServerInitializerKt.initializeServer((Server)$receiver, environment);
        configuration = configuration2;
        jettyApplicationEngineBase.server = configuration;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R+\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/ktor/server/jetty/JettyApplicationEngineBase$Configuration;", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "()V", "configureServer", "Lkotlin/Function1;", "Lorg/eclipse/jetty/server/Server;", "", "Lkotlin/ExtensionFunctionType;", "getConfigureServer", "()Lkotlin/jvm/functions/Function1;", "setConfigureServer", "(Lkotlin/jvm/functions/Function1;)V", "ktor-server-jetty"})
    public static final class Configuration
    extends BaseApplicationEngine.Configuration {
        @NotNull
        private Function1<? super Server, Unit> configureServer = configureServer.1.INSTANCE;

        @NotNull
        public final Function1<Server, Unit> getConfigureServer() {
            return this.configureServer;
        }

        public final void setConfigureServer(@NotNull Function1<? super Server, Unit> function1) {
            Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
            this.configureServer = function1;
        }
    }
}

