/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import io.ktor.application.ApplicationEnvironment;
import io.ktor.config.ApplicationConfig;
import io.ktor.config.ApplicationConfigValue;
import io.ktor.config.HoconApplicationConfig;
import io.ktor.config.HoconApplicationConfigKt;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ApplicationEngineEnvironmentBuilder;
import io.ktor.server.engine.ApplicationEngineEnvironmentKt;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.EngineConnectorBuilder;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineSSLConnectorBuilder;
import io.ktor.util.PlatformUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\f*\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"commandLineEnvironment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "args", "", "", "([Ljava/lang/String;)Lio/ktor/server/engine/ApplicationEngineEnvironment;", "loadCommonConfiguration", "", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "deploymentConfig", "Lio/ktor/config/ApplicationConfig;", "splitPair", "Lkotlin/Pair;", "ch", "", "ktor-server-host-common"})
public final class CommandLineKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ApplicationEngineEnvironment commandLineEnvironment(@NotNull String[] args) {
        String string;
        String string2;
        Config config;
        Config $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Object it;
        File file;
        URL uRL;
        Object object;
        String $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String[] $this$mapNotNull$iv = args;
        boolean $i$f$mapNotNull22 = false;
        String[] stringArray = $this$mapNotNull$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var9_15 = $this$forEach$iv$iv$iv;
        int n = ((void)var9_15).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var9_15[i];
            boolean bl7 = false;
            void it2 = element$iv$iv;
            boolean bl2 = false;
            if (CommandLineKt.splitPair((String)it2, '=') == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Pair<String, String> it$iv$iv = object;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Map argsMap = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        String $i$f$mapNotNull22 = (String)argsMap.get("-jar");
        if ($i$f$mapNotNull22 == null) {
            uRL = null;
        } else {
            $this$mapNotNullTo$iv$iv = $i$f$mapNotNull22;
            boolean destination$iv$iv2 = false;
            $i$f$mapNotNullTo = false;
            String it3 = $this$mapNotNullTo$iv$iv;
            boolean bl = false;
            uRL = StringsKt.startsWith$default((String)it3, (String)"file:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it3, (String)"jrt:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it3, (String)"jar:", (boolean)false, (int)2, null) ? new URI(it3).toURL() : new File(it3).toURI().toURL();
        }
        URL jar = uRL;
        $this$mapNotNullTo$iv$iv = (String)argsMap.get("-config");
        if ($this$mapNotNullTo$iv$iv == null) {
            file = null;
        } else {
            destination$iv$iv2 = $this$mapNotNullTo$iv$iv;
            $i$f$mapNotNullTo = false;
            boolean it3 = false;
            Object it4 = destination$iv$iv2;
            boolean bl = false;
            file = new File((String)it4);
        }
        File configFile = file;
        Map $this$filterKeys$iv = argsMap;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Map it4 = $this$filterKeys$iv;
        boolean bl = false;
        for (Map.Entry entry$iv : it4.entrySet()) {
            it = (String)entry$iv.getKey();
            boolean bl6 = false;
            if (!StringsKt.startsWith$default((String)it, (String)"-P:", (boolean)false, (int)2, null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterKeys$iv = result$iv;
        boolean $i$f$mapKeys = false;
        result$iv = $this$mapKeys$iv;
        Object destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo2 = false;
        Iterable $this$associateByTo$iv$iv$iv2 = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            void it$iv$iv;
            Object it5;
            Map.Entry bl7 = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv3;
            boolean bl8 = false;
            String string3 = StringsKt.removePrefix((String)((String)it5.getKey()), (CharSequence)"-P:");
            Map.Entry bl2 = (Map.Entry)element$iv$iv$iv;
            object = string3;
            Map map2 = map;
            boolean bl9 = false;
            it5 = it$iv$iv.getValue();
            map2.put(object, it5);
        }
        Map commandLineMap = destination$iv$iv3;
        Config environmentConfig = ConfigFactory.systemProperties().withOnlyPath("ktor");
        destination$iv$iv3 = configFile;
        if (destination$iv$iv3 == null) {
            config = null;
        } else {
            Object $i$f$mapKeysTo2 = destination$iv$iv3;
            boolean $this$associateByTo$iv$iv$iv2 = false;
            $i$f$associateByTo = false;
            it = $i$f$mapKeysTo2;
            boolean bl10 = false;
            config = ConfigFactory.parseFile((File)it);
        }
        $this$mapKeysTo$iv$iv = config;
        Config fileConfig = $this$mapKeysTo$iv$iv == null ? ConfigFactory.load() : $this$mapKeysTo$iv$iv;
        Config argConfig = ConfigFactory.parseMap((Map)commandLineMap, (String)"Command-line options");
        Config combinedConfig = argConfig.withFallback((ConfigMergeable)fileConfig).withFallback((ConfigMergeable)environmentConfig).resolve();
        String applicationIdPath = "ktor.application.id";
        String hostConfigPath = "ktor.deployment.host";
        String hostPortPath = "ktor.deployment.port";
        String hostWatchPaths = "ktor.deployment.watch";
        String rootPathPath = "ktor.deployment.rootPath";
        String hostSslPortPath = "ktor.deployment.sslPort";
        String hostSslKeyStore = "ktor.security.ssl.keyStore";
        String hostSslKeyAlias = "ktor.security.ssl.keyAlias";
        String hostSslKeyStorePassword = "ktor.security.ssl.keyStorePassword";
        String hostSslPrivateKeyPassword = "ktor.security.ssl.privateKeyPassword";
        String developmentModeKey = "ktor.development";
        Intrinsics.checkNotNullExpressionValue((Object)combinedConfig, (String)"combinedConfig");
        String bl5 = HoconApplicationConfigKt.tryGetString((Config)combinedConfig, (String)applicationIdPath);
        String applicationId = bl5 == null ? "Application" : bl5;
        Logger appLog = LoggerFactory.getLogger((String)applicationId);
        if (configFile != null && !configFile.exists()) {
            appLog.error("Configuration file '" + configFile + "' specified as command line argument was not found");
            appLog.warn("Will attempt to start without loading configuration\u2026");
        }
        String rootPath = (string2 = (String)argsMap.get("-path")) == null ? ((string = HoconApplicationConfigKt.tryGetString((Config)combinedConfig, (String)rootPathPath)) == null ? "" : string) : string2;
        ApplicationEngineEnvironment environment2 = ApplicationEngineEnvironmentKt.applicationEngineEnvironment((Function1<? super ApplicationEngineEnvironmentBuilder, Unit>)((Function1)new Function1<ApplicationEngineEnvironmentBuilder, Unit>(appLog, jar, combinedConfig, rootPath, (Map<String, String>)argsMap, hostConfigPath, hostPortPath, hostSslPortPath, hostSslKeyStore, hostSslKeyStorePassword, hostSslPrivateKeyPassword, hostSslKeyAlias, developmentModeKey, hostWatchPaths){
            final /* synthetic */ Logger $appLog;
            final /* synthetic */ URL $jar;
            final /* synthetic */ Config $combinedConfig;
            final /* synthetic */ String $rootPath;
            final /* synthetic */ Map<String, String> $argsMap;
            final /* synthetic */ String $hostConfigPath;
            final /* synthetic */ String $hostPortPath;
            final /* synthetic */ String $hostSslPortPath;
            final /* synthetic */ String $hostSslKeyStore;
            final /* synthetic */ String $hostSslKeyStorePassword;
            final /* synthetic */ String $hostSslPrivateKeyPassword;
            final /* synthetic */ String $hostSslKeyAlias;
            final /* synthetic */ String $developmentModeKey;
            final /* synthetic */ String $hostWatchPaths;
            {
                this.$appLog = $appLog;
                this.$jar = $jar;
                this.$combinedConfig = $combinedConfig;
                this.$rootPath = $rootPath;
                this.$argsMap = $argsMap;
                this.$hostConfigPath = $hostConfigPath;
                this.$hostPortPath = $hostPortPath;
                this.$hostSslPortPath = $hostSslPortPath;
                this.$hostSslKeyStore = $hostSslKeyStore;
                this.$hostSslKeyStorePassword = $hostSslKeyStorePassword;
                this.$hostSslPrivateKeyPassword = $hostSslPrivateKeyPassword;
                this.$hostSslKeyAlias = $hostSslKeyAlias;
                this.$developmentModeKey = $developmentModeKey;
                this.$hostWatchPaths = $hostWatchPaths;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ApplicationEngineEnvironmentBuilder $this$applicationEngineEnvironment) {
                Object object;
                Object object2;
                Object object3;
                boolean bl;
                Object object4;
                Object it;
                boolean bl2;
                boolean bl3;
                Object object5;
                String string;
                String string2;
                String string3;
                Object it2;
                String string4;
                Object object6;
                Object object7;
                Object object8;
                Object object9;
                Object object10;
                List<EngineConnectorConfig> list;
                Object object11;
                Object object12;
                URLClassLoader uRLClassLoader;
                Intrinsics.checkNotNullParameter((Object)$this$applicationEngineEnvironment, (String)"$this$applicationEngineEnvironment");
                Logger logger = this.$appLog;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"appLog");
                $this$applicationEngineEnvironment.setLog(logger);
                ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder = $this$applicationEngineEnvironment;
                Object object13 = this.$jar;
                if (object13 == null) {
                    uRLClassLoader = null;
                } else {
                    object12 = object13;
                    object11 = this.$jar;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    URL uRL = object12;
                    list = applicationEngineEnvironmentBuilder;
                    boolean bl6 = false;
                    object10 = new URL[]{object11};
                    object9 = new URLClassLoader((URL[])object10, ApplicationEnvironment.class.getClassLoader());
                    applicationEngineEnvironmentBuilder = list;
                    uRLClassLoader = object9;
                }
                logger = uRLClassLoader;
                if (logger == null) {
                    object13 = ApplicationEnvironment.class.getClassLoader();
                    Intrinsics.checkNotNullExpressionValue((Object)object13, (String)"ApplicationEnvironment::class.java.classLoader");
                    object8 = object13;
                } else {
                    object8 = (ClassLoader)logger;
                }
                applicationEngineEnvironmentBuilder.setClassLoader((ClassLoader)object8);
                logger = this.$combinedConfig;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"combinedConfig");
                $this$applicationEngineEnvironment.setConfig((ApplicationConfig)new HoconApplicationConfig((Config)logger));
                $this$applicationEngineEnvironment.setRootPath(this.$rootPath);
                ConfigValue contentHiddenValue = ConfigValueFactory.fromAnyRef((Object)"***", (String)"Content hidden");
                if (this.$combinedConfig.hasPath("ktor")) {
                    $this$applicationEngineEnvironment.getLog().trace(this.$combinedConfig.getObject("ktor").withoutKey("security").withValue("security", contentHiddenValue).render());
                } else {
                    $this$applicationEngineEnvironment.getLog().trace("No configuration provided: neither application.conf nor system properties nor command line options (-config or -P:ktor...=) provided");
                }
                object12 = this.$argsMap.get("-host");
                if (object12 == null) {
                    Config config = this.$combinedConfig;
                    Intrinsics.checkNotNullExpressionValue((Object)config, (String)"combinedConfig");
                    object11 = HoconApplicationConfigKt.tryGetString((Config)config, (String)this.$hostConfigPath);
                    object7 = object11 == null ? "0.0.0.0" : object11;
                } else {
                    object7 = object12;
                }
                Object host = object7;
                object11 = this.$argsMap.get("-port");
                if (object11 == null) {
                    Config config = this.$combinedConfig;
                    Intrinsics.checkNotNullExpressionValue((Object)config, (String)"combinedConfig");
                    object6 = HoconApplicationConfigKt.tryGetString((Config)config, (String)this.$hostPortPath);
                } else {
                    object6 = object11;
                }
                Object port = object6;
                String string5 = this.$argsMap.get("-sslPort");
                if (string5 == null) {
                    Config config = this.$combinedConfig;
                    Intrinsics.checkNotNullExpressionValue((Object)config, (String)"combinedConfig");
                    string4 = HoconApplicationConfigKt.tryGetString((Config)config, (String)this.$hostSslPortPath);
                } else {
                    string4 = string5;
                }
                String sslPort = string4;
                String string6 = this.$argsMap.get("-sslKeyStore");
                if (string6 == null) {
                    it2 = this.$combinedConfig;
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"combinedConfig");
                    string3 = HoconApplicationConfigKt.tryGetString((Config)it2, (String)this.$hostSslKeyStore);
                } else {
                    string3 = string6;
                }
                String sslKeyStorePath = string3;
                Object bl6 = this.$combinedConfig;
                Intrinsics.checkNotNullExpressionValue((Object)bl6, (String)"combinedConfig");
                it2 = HoconApplicationConfigKt.tryGetString((Config)bl6, (String)this.$hostSslKeyStorePassword);
                if (it2 == null) {
                    string2 = null;
                } else {
                    bl6 = it2;
                    boolean bl7 = false;
                    string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)bl6))).toString();
                }
                String sslKeyStorePassword = string2;
                object10 = this.$combinedConfig;
                Intrinsics.checkNotNullExpressionValue((Object)object10, (String)"combinedConfig");
                bl6 = HoconApplicationConfigKt.tryGetString((Config)object10, (String)this.$hostSslPrivateKeyPassword);
                if (bl6 == null) {
                    string = null;
                } else {
                    object10 = bl6;
                    boolean bl8 = false;
                    string = ((Object)StringsKt.trim((CharSequence)((CharSequence)object10))).toString();
                }
                String sslPrivateKeyPassword = string;
                Object object14 = this.$combinedConfig;
                Intrinsics.checkNotNullExpressionValue((Object)object14, (String)"combinedConfig");
                object10 = HoconApplicationConfigKt.tryGetString((Config)object14, (String)this.$hostSslKeyAlias);
                String sslKeyAlias = object10 == null ? "mykey" : object10;
                ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder2 = $this$applicationEngineEnvironment;
                Object object15 = this.$combinedConfig;
                Intrinsics.checkNotNullExpressionValue((Object)object15, (String)"combinedConfig");
                object14 = HoconApplicationConfigKt.tryGetString((Config)object15, (String)this.$developmentModeKey);
                if (object14 == null) {
                    object5 = null;
                } else {
                    object15 = object14;
                    bl3 = false;
                    bl2 = false;
                    Config config = object15;
                    list = applicationEngineEnvironmentBuilder2;
                    boolean bl9 = false;
                    object4 = it;
                    bl = false;
                    object9 = Boolean.parseBoolean((String)object4);
                    applicationEngineEnvironmentBuilder2 = list;
                    object5 = object9;
                }
                object10 = object5;
                applicationEngineEnvironmentBuilder2.setDevelopmentMode(object10 == null ? PlatformUtils.INSTANCE.getIS_DEVELOPMENT_MODE() : ((Boolean)object10).booleanValue());
                if (port != null) {
                    void $this$invoke_u24lambda_u2d2;
                    ApplicationEngineEnvironmentBuilder $this$connector$iv = $this$applicationEngineEnvironment;
                    boolean $i$f$connector = false;
                    object15 = new EngineConnectorBuilder(null, 1, null);
                    bl3 = false;
                    bl2 = false;
                    it = object15;
                    list = $this$connector$iv.getConnectors();
                    boolean bl10 = false;
                    $this$invoke_u24lambda_u2d2.setHost((String)host);
                    object4 = port;
                    bl = false;
                    $this$invoke_u24lambda_u2d2.setPort(Integer.parseInt((String)object4));
                    object9 = Unit.INSTANCE;
                    list.add((EngineConnectorConfig)object15);
                }
                if (sslPort != null) {
                    void $this$invoke_u24lambda_u2d7;
                    void $this$sslConnector$iv;
                    void privateKeyPassword$iv;
                    void keyStorePassword$iv;
                    void keyStore$iv;
                    boolean bl11;
                    String string7;
                    if (sslKeyStorePath == null) {
                        throw new IllegalArgumentException("SSL requires keystore: use -sslKeyStore=path or " + this.$hostSslKeyStore + " config");
                    }
                    if (sslKeyStorePassword == null) {
                        throw new IllegalArgumentException("SSL requires keystore password: use " + this.$hostSslKeyStorePassword + " config");
                    }
                    if (sslPrivateKeyPassword == null) {
                        throw new IllegalArgumentException("SSL requires certificate password: use " + this.$hostSslPrivateKeyPassword + " config");
                    }
                    File $i$f$connector = new File(sslKeyStorePath);
                    boolean bl12 = false;
                    bl3 = false;
                    File file322 = $i$f$connector;
                    boolean bl13 = false;
                    File keyStoreFile = file322.exists() || file322.isAbsolute() ? file322 : new File(".", sslKeyStorePath).getAbsoluteFile();
                    object15 = KeyStore.getInstance("JKS");
                    bl3 = false;
                    boolean file322 = false;
                    Object $this$invoke_u24lambda_u2d6 = object15;
                    boolean bl14 = false;
                    object4 = new FileInputStream(keyStoreFile);
                    bl = false;
                    boolean bl15 = false;
                    Throwable throwable = null;
                    try {
                        FileInputStream it3 = (FileInputStream)object4;
                        boolean bl16 = false;
                        InputStream inputStream = it3;
                        string7 = sslKeyStorePassword;
                        bl11 = false;
                        char[] cArray = string7.toCharArray();
                        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                        ((KeyStore)$this$invoke_u24lambda_u2d6).load(inputStream, cArray);
                        it3 = Unit.INSTANCE;
                    }
                    catch (Throwable it3) {
                        throwable = it3;
                        throw it3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object4, (Throwable)throwable);
                    }
                    object4 = sslPrivateKeyPassword;
                    bl = false;
                    char[] cArray = ((String)object4).toCharArray();
                    Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                    object4 = ((KeyStore)$this$invoke_u24lambda_u2d6).getKey(sslKeyAlias, cArray);
                    bl = false;
                    boolean bl17 = false;
                    if (object4 == null) {
                        boolean bl18 = false;
                        String string8 = "The specified key " + sslKeyAlias + " doesn't exist in the key store " + sslKeyStorePath;
                        throw (Throwable)new IllegalArgumentException(string8.toString());
                    }
                    Object keyStore = object15;
                    object15 = $this$applicationEngineEnvironment;
                    Intrinsics.checkNotNullExpressionValue((Object)keyStore, (String)"keyStore");
                    Object object16 = keyStore;
                    Function0 file322 = (Function0)new Function0<char[]>(sslKeyStorePassword){
                        final /* synthetic */ String $sslKeyStorePassword;
                        {
                            this.$sslKeyStorePassword = $sslKeyStorePassword;
                            super(0);
                        }

                        @NotNull
                        public final char[] invoke() {
                            String string = this.$sslKeyStorePassword;
                            boolean bl = false;
                            String string2 = string;
                            if (string2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            char[] cArray = string2.toCharArray();
                            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                            return cArray;
                        }
                    };
                    $this$invoke_u24lambda_u2d6 = (Function0)new Function0<char[]>(sslPrivateKeyPassword){
                        final /* synthetic */ String $sslPrivateKeyPassword;
                        {
                            this.$sslPrivateKeyPassword = $sslPrivateKeyPassword;
                            super(0);
                        }

                        @NotNull
                        public final char[] invoke() {
                            String string = this.$sslPrivateKeyPassword;
                            boolean bl = false;
                            String string2 = string;
                            if (string2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            char[] cArray = string2.toCharArray();
                            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                            return cArray;
                        }
                    };
                    boolean $i$f$sslConnector = false;
                    object4 = new EngineSSLConnectorBuilder((KeyStore)keyStore$iv, sslKeyAlias, (Function0<char[]>)keyStorePassword$iv, (Function0<char[]>)privateKeyPassword$iv);
                    bl = false;
                    bl17 = false;
                    Object bl18 = object4;
                    list = $this$sslConnector$iv.getConnectors();
                    boolean bl19 = false;
                    $this$invoke_u24lambda_u2d7.setHost((String)host);
                    string7 = sslPort;
                    bl11 = false;
                    $this$invoke_u24lambda_u2d7.setPort(Integer.parseInt(string7));
                    $this$invoke_u24lambda_u2d7.setKeyStorePath(keyStoreFile);
                    object9 = Unit.INSTANCE;
                    list.add((EngineConnectorConfig)object4);
                }
                if (port == null && sslPort == null) {
                    throw new IllegalArgumentException("Neither port nor sslPort specified. Use command line options -port/-sslPort or configure connectors in application.conf");
                }
                object15 = this.$argsMap.get("-watch");
                if (object15 == null) {
                    object3 = null;
                } else {
                    String[] stringArray = new String[]{","};
                    object3 = object2 = StringsKt.split$default((CharSequence)((CharSequence)object15), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                }
                if (object2 == null) {
                    object15 = this.$combinedConfig;
                    Intrinsics.checkNotNullExpressionValue((Object)object15, (String)"combinedConfig");
                    object = HoconApplicationConfigKt.tryGetStringList((Config)object15, (String)this.$hostWatchPaths);
                } else {
                    object = object10 = object2;
                }
                if (object10 != null) {
                    object2 = object10;
                    boolean bl20 = false;
                    boolean bl21 = false;
                    Object it4 = object2;
                    boolean bl22 = false;
                    $this$applicationEngineEnvironment.setWatchPaths((List<String>)it4);
                }
            }
        }));
        return environment2;
    }

    private static final Pair<String, String> splitPair(String $this$splitPair, char ch) {
        int n = StringsKt.indexOf$default((CharSequence)$this$splitPair, (char)ch, (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        boolean bl2 = false;
        int idx = n;
        boolean bl3 = false;
        int n2 = idx;
        return n2 == -1 ? null : new Pair((Object)StringsKt.take((String)$this$splitPair, (int)idx), (Object)StringsKt.drop((String)$this$splitPair, (int)(idx + 1)));
    }

    public static final void loadCommonConfiguration(@NotNull BaseApplicationEngine.Configuration $this$loadCommonConfiguration, @NotNull ApplicationConfig deploymentConfig) {
        int it;
        boolean bl;
        int n;
        boolean bl2;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$loadCommonConfiguration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)deploymentConfig, (String)"deploymentConfig");
        ApplicationConfigValue applicationConfigValue = deploymentConfig.propertyOrNull("callGroupSize");
        String string2 = string = applicationConfigValue == null ? null : applicationConfigValue.getString();
        if (string != null) {
            int n2;
            String string3 = string;
            bl2 = false;
            n = n2 = Integer.parseInt(string3);
            bl2 = false;
            bl = false;
            it = n;
            boolean bl3 = false;
            $this$loadCommonConfiguration.setCallGroupSize(it);
        }
        applicationConfigValue = deploymentConfig.propertyOrNull("connectionGroupSize");
        String string4 = string = applicationConfigValue == null ? null : applicationConfigValue.getString();
        if (string != null) {
            int n3;
            String string5 = string;
            bl2 = false;
            n = n3 = Integer.parseInt(string5);
            bl2 = false;
            bl = false;
            it = n;
            boolean bl4 = false;
            $this$loadCommonConfiguration.setConnectionGroupSize(it);
        }
        ApplicationConfigValue applicationConfigValue2 = deploymentConfig.propertyOrNull("workerGroupSize");
        String string6 = string = applicationConfigValue2 == null ? null : applicationConfigValue2.getString();
        if (string != null) {
            int n4;
            String string7 = string;
            bl2 = false;
            int n5 = n4 = Integer.parseInt(string7);
            bl2 = false;
            bl = false;
            it = n5;
            boolean bl5 = false;
            $this$loadCommonConfiguration.setWorkerGroupSize(it);
        }
    }
}

