/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.application.ApplicationCall;
import io.ktor.features.OriginConnectionPointKt;
import io.ktor.http.ContentType;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.LinkHeaderKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.request.ApplicationRequest;
import io.ktor.response.ApplicationResponse;
import io.ktor.response.ApplicationResponsePropertiesKt;
import io.ktor.response.ApplicationSendPipeline;
import io.ktor.response.ResponseCookies;
import io.ktor.response.ResponseHeaders;
import io.ktor.response.ResponsePushBuilder;
import io.ktor.server.engine.BaseApplicationResponse;
import io.ktor.server.engine.EngineAPI;
import io.ktor.server.engine.LongKt;
import io.ktor.util.AttributeKey;
import io.ktor.util.cio.ByteBufferPoolKt;
import io.ktor.util.cio.ChannelWriteException;
import io.ktor.util.pipeline.Pipeline;
import io.ktor.util.pipeline.PipelineContext;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.io.ByteReadChannel;
import kotlinx.coroutines.io.ByteReadChannelJVMKt;
import kotlinx.coroutines.io.ByteWriteChannel;
import kotlinx.coroutines.io.ByteWriteChannelKt;
import kotlinx.coroutines.io.ClosedWriteChannelException;
import kotlinx.io.pool.ObjectPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000 B2\u00020\u0001:\u0005@ABCDB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0004J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0016J\u0019\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J\u0019\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\u0019\u0010-\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020.H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J\u0019\u00100\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101J\u0019\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u000204H\u00a4@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J\u0019\u00106\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u000207H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108J\u0011\u00109\u001a\u00020:H\u00a4@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J\u0010\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u0006H$J\n\u0010>\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010>\u001a\u00020\u001b2\u0006\u0010?\u001a\u00020\u0006H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006E"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse;", "Lio/ktor/response/ApplicationResponse;", "call", "Lio/ktor/application/ApplicationCall;", "(Lio/ktor/application/ApplicationCall;)V", "_status", "Lio/ktor/http/HttpStatusCode;", "bufferPool", "Lkotlinx/io/pool/ObjectPool;", "Ljava/nio/ByteBuffer;", "getBufferPool", "()Lkotlinx/io/pool/ObjectPool;", "getCall", "()Lio/ktor/application/ApplicationCall;", "cookies", "Lio/ktor/response/ResponseCookies;", "getCookies", "()Lio/ktor/response/ResponseCookies;", "cookies$delegate", "Lkotlin/Lazy;", "pipeline", "Lio/ktor/response/ApplicationSendPipeline;", "getPipeline", "()Lio/ktor/response/ApplicationSendPipeline;", "responded", "", "commitHeaders", "", "content", "Lio/ktor/http/content/OutgoingContent;", "ensureLength", "expected", "", "actual", "push", "builder", "Lio/ktor/response/ResponsePushBuilder;", "respondFromBytes", "bytes", "", "([BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondFromChannel", "readChannel", "Lkotlinx/coroutines/io/ByteReadChannel;", "(Lkotlinx/coroutines/io/ByteReadChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondNoContent", "Lio/ktor/http/content/OutgoingContent$NoContent;", "(Lio/ktor/http/content/OutgoingContent$NoContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondOutgoingContent", "(Lio/ktor/http/content/OutgoingContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondUpgrade", "upgrade", "Lio/ktor/http/content/OutgoingContent$ProtocolUpgrade;", "(Lio/ktor/http/content/OutgoingContent$ProtocolUpgrade;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondWriteChannelContent", "Lio/ktor/http/content/OutgoingContent$WriteChannelContent;", "(Lio/ktor/http/content/OutgoingContent$WriteChannelContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "responseChannel", "Lkotlinx/coroutines/io/ByteWriteChannel;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setStatus", "statusCode", "status", "value", "BodyLengthIsTooLong", "BodyLengthIsTooSmall", "Companion", "InvalidHeaderForContent", "ResponseAlreadySentException", "ktor-server-host-common"})
public abstract class BaseApplicationResponse
implements ApplicationResponse {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private HttpStatusCode _status;
    @NotNull
    private final Lazy cookies$delegate;
    private boolean responded;
    @NotNull
    private final ApplicationSendPipeline pipeline;
    @NotNull
    private final ApplicationCall call;
    @NotNull
    private static final AttributeKey<BaseApplicationResponse> EngineResponseAtributeKey;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BaseApplicationResponse.class), "cookies", "getCookies()Lio/ktor/response/ResponseCookies;"))};
        Companion = new Companion(null);
        EngineResponseAtributeKey = new AttributeKey("EngineResponse");
    }

    @NotNull
    public ResponseCookies getCookies() {
        Lazy lazy = this.cookies$delegate;
        BaseApplicationResponse baseApplicationResponse = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (ResponseCookies)lazy.getValue();
    }

    @Nullable
    public HttpStatusCode status() {
        return this._status;
    }

    public void status(@NotNull HttpStatusCode value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this._status = value;
        this.setStatus(value);
    }

    @NotNull
    public final ApplicationSendPipeline getPipeline() {
        return this.pipeline;
    }

    /*
     * WARNING - void declaration
     */
    protected final void commitHeaders(@NotNull OutgoingContent content) {
        OutgoingContent outgoingContent;
        void transferEncodingSet;
        HttpStatusCode httpStatusCode;
        HttpStatusCode httpStatusCode2;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        if (this.responded) {
            throw (Throwable)new ResponseAlreadySentException();
        }
        this.responded = true;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        HttpStatusCode httpStatusCode3 = content.getStatus();
        if (httpStatusCode3 != null) {
            HttpStatusCode httpStatusCode4 = httpStatusCode3;
            boolean bl2 = false;
            bl = false;
            HttpStatusCode it = httpStatusCode4;
            boolean bl3 = false;
            this.status(it);
            httpStatusCode2 = Unit.INSTANCE;
        } else {
            httpStatusCode2 = httpStatusCode = this.status();
        }
        if (httpStatusCode2 == null) {
            this.status(HttpStatusCode.Companion.getOK());
            httpStatusCode = Unit.INSTANCE;
        }
        content.getHeaders().forEach((Function2)new Function2<String, List<? extends String>, Unit>(this, (Ref.BooleanRef)transferEncodingSet, content){
            final /* synthetic */ BaseApplicationResponse this$0;
            final /* synthetic */ Ref.BooleanRef $transferEncodingSet;
            final /* synthetic */ OutgoingContent $content;

            public final void invoke(@NotNull String name, @NotNull List<String> values) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull(values, (String)"values");
                String string = name;
                if (Intrinsics.areEqual((Object)string, (Object)HttpHeaders.INSTANCE.getTransferEncoding())) {
                    this.$transferEncodingSet.element = true;
                } else if (Intrinsics.areEqual((Object)string, (Object)HttpHeaders.INSTANCE.getUpgrade())) {
                    if (!(this.$content instanceof OutgoingContent.ProtocolUpgrade)) {
                        throw (Throwable)new InvalidHeaderForContent(HttpHeaders.INSTANCE.getUpgrade(), "non-upgrading response");
                    }
                    for (String value : values) {
                        this.this$0.getHeaders().append(name, value, false);
                    }
                    return;
                }
                for (String value : values) {
                    ResponseHeaders.append$default((ResponseHeaders)this.this$0.getHeaders(), (String)name, (String)value, (boolean)false, (int)4, null);
                }
            }
            {
                this.this$0 = baseApplicationResponse;
                this.$transferEncodingSet = booleanRef;
                this.$content = outgoingContent;
                super(2);
            }
        });
        Long contentLength = content.getContentLength();
        if (contentLength != null) {
            this.getHeaders().append(HttpHeaders.INSTANCE.getContentLength(), LongKt.toStringFast(contentLength), false);
        } else if (!transferEncodingSet.element && !((outgoingContent = content) instanceof OutgoingContent.ProtocolUpgrade)) {
            if (outgoingContent instanceof OutgoingContent.NoContent) {
                this.getHeaders().append(HttpHeaders.INSTANCE.getContentLength(), "0", false);
            } else {
                this.getHeaders().append(HttpHeaders.INSTANCE.getTransferEncoding(), "chunked", false);
            }
        }
        ContentType contentType = content.getContentType();
        if (contentType != null) {
            ContentType contentType2 = contentType;
            bl = false;
            boolean bl4 = false;
            ContentType it = contentType2;
            boolean bl5 = false;
            this.getHeaders().append(HttpHeaders.INSTANCE.getContentType(), it.toString(), false);
        }
        String connection = this.getCall().getRequest().getHeaders().get(HttpHeaders.INSTANCE.getConnection());
        if (connection != null) {
            if (StringsKt.equals((String)connection, (String)"close", (boolean)true)) {
                ApplicationResponsePropertiesKt.header((ApplicationResponse)this, (String)"Connection", (String)"close");
            } else if (StringsKt.equals((String)connection, (String)"keep-alive", (boolean)true)) {
                ApplicationResponsePropertiesKt.header((ApplicationResponse)this, (String)"Connection", (String)"keep-alive");
            }
        }
    }

    @Nullable
    protected Object respondOutgoingContent(@NotNull OutgoingContent outgoingContent, @NotNull Continuation<? super Unit> $completion) {
        return BaseApplicationResponse.respondOutgoingContent$suspendImpl(this, outgoingContent, $completion);
    }

    static /* synthetic */ Object respondOutgoingContent$suspendImpl(BaseApplicationResponse this_, OutgoingContent content, Continuation $completion) {
        OutgoingContent outgoingContent = content;
        if (outgoingContent instanceof OutgoingContent.ProtocolUpgrade) {
            this_.commitHeaders(content);
            return this_.respondUpgrade((OutgoingContent.ProtocolUpgrade)content, (Continuation<? super Unit>)$completion);
        }
        if (outgoingContent instanceof OutgoingContent.ByteArrayContent) {
            byte[] bytes = ((OutgoingContent.ByteArrayContent)content).bytes();
            this_.commitHeaders(content);
            return this_.respondFromBytes(bytes, (Continuation<? super Unit>)$completion);
        }
        if (outgoingContent instanceof OutgoingContent.WriteChannelContent) {
            this_.commitHeaders(content);
            return this_.respondWriteChannelContent((OutgoingContent.WriteChannelContent)content, (Continuation<? super Unit>)$completion);
        }
        if (outgoingContent instanceof OutgoingContent.ReadChannelContent) {
            ByteReadChannel readChannel = ((OutgoingContent.ReadChannelContent)content).readFrom();
            this_.commitHeaders(content);
            return this_.respondFromChannel(readChannel, (Continuation<? super Unit>)$completion);
        }
        if (outgoingContent instanceof OutgoingContent.NoContent) {
            this_.commitHeaders(content);
            return this_.respondNoContent((OutgoingContent.NoContent)content, (Continuation<? super Unit>)$completion);
        }
        throw new NoWhenBranchMatchedException();
    }

    @Nullable
    protected Object respondNoContent(@NotNull OutgoingContent.NoContent noContent, @NotNull Continuation<? super Unit> $completion) {
        return BaseApplicationResponse.respondNoContent$suspendImpl(this, noContent, $completion);
    }

    static /* synthetic */ Object respondNoContent$suspendImpl(BaseApplicationResponse this_, OutgoingContent.NoContent content, Continuation $completion) {
        return Unit.INSTANCE;
    }

    @Nullable
    protected Object respondWriteChannelContent(@NotNull OutgoingContent.WriteChannelContent writeChannelContent, @NotNull Continuation<? super Unit> $completion) {
        return BaseApplicationResponse.respondWriteChannelContent$suspendImpl(this, writeChannelContent, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static /* synthetic */ Object respondWriteChannelContent$suspendImpl(BaseApplicationResponse this, OutgoingContent.WriteChannelContent content, Continuation $completion) {
        if (!($completion instanceof respondWriteChannelContent.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ BaseApplicationResponse this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseApplicationResponse.respondWriteChannelContent$suspendImpl(this.this$0, null, (Continuation)this);
                }
                {
                    this.this$0 = baseApplicationResponse;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = content;
                $continuation.label = 1;
                v0 = this.responseChannel((Continuation<? super ByteWriteChannel>)$continuation);
                if (v0 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                content = (OutgoingContent.WriteChannelContent)$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                $this$use$iv = (ByteWriteChannel)v0;
                $i$f$use = false;
                $this$use = $this$use$iv;
                $i$a$-use-BaseApplicationResponse$respondWriteChannelContent$2 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = content;
                $continuation.L$2 = $this$use$iv;
                $continuation.L$3 = $this$use;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$use, null, (Continuation)$continuation, content){
                    private CoroutineScope p$;
                    Object L$0;
                    int label;
                    final /* synthetic */ ByteWriteChannel $this_use;
                    final /* synthetic */ Continuation $continuation$inlined;
                    final /* synthetic */ OutgoingContent.WriteChannelContent $content$inlined;
                    {
                        this.$this_use = byteWriteChannel;
                        this.$continuation$inlined = continuation2;
                        this.$content$inlined = writeChannelContent;
                        super(2, continuation);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                CoroutineScope $this$withContext = this.p$;
                                this.L$0 = $this$withContext;
                                this.label = 1;
                                Object object2 = this.$content$inlined.writeTo(this.$this_use, (Continuation)this);
                                Object object3 = object2;
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                        function2.p$ = (CoroutineScope)value;
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
                        return function22;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var11_5) goto lbl40
lbl39:
                // 1 sources

                return var11_5;
lbl40:
                // 1 sources

                ** GOTO lbl63
            }
            case 2: {
                $this$use = (ByteWriteChannel)$continuation.L$3;
                $this$use$iv = (ByteWriteChannel)$continuation.L$2;
                content = (OutgoingContent.WriteChannelContent)$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                    ** GOTO lbl63
                    {
                        catch (ClosedWriteChannelException closed) {
                            throw (Throwable)new ChannelWriteException(null, (Throwable)closed, 1, null);
                        }
                    }
                }
                catch (Throwable cause$iv) {
                    $this$use$iv.close(cause$iv);
                    throw cause$iv;
                }
            }
            catch (Throwable var8_13) {
                throw var8_13;
            }
            {
                finally {
                    ByteWriteChannelKt.close((ByteWriteChannel)$this$use$iv);
                }
lbl63:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    protected Object respondFromBytes(@NotNull byte[] byArray, @NotNull Continuation<? super Unit> $completion) {
        return BaseApplicationResponse.respondFromBytes$suspendImpl(this, byArray, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static /* synthetic */ Object respondFromBytes$suspendImpl(BaseApplicationResponse this, byte[] bytes, Continuation $completion) {
        if (!($completion instanceof respondFromBytes.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ BaseApplicationResponse this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseApplicationResponse.respondFromBytes$suspendImpl(this.this$0, null, (Continuation)this);
                }
                {
                    this.this$0 = baseApplicationResponse;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
                if (v0 != null) {
                    var3_6 = v0;
                    var4_7 = false;
                    v0 = Boxing.boxLong((long)Long.parseLong((String)var3_6));
                    if (v0 != null) {
                        var3_6 = v0;
                        var4_7 = false;
                        var5_8 = false;
                        length = ((Number)var3_6).longValue();
                        $i$a$-let-BaseApplicationResponse$respondFromBytes$2 = false;
                        this.ensureLength(length, bytes.length);
                    }
                }
                $continuation.L$0 = this;
                $continuation.L$1 = bytes;
                $continuation.label = 1;
                v1 = this.responseChannel((Continuation<? super ByteWriteChannel>)$continuation);
                if (v1 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl37
            }
            case 1: {
                bytes = (byte[])$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl37:
                // 2 sources

                $this$use$iv = (ByteWriteChannel)v1;
                $i$f$use = false;
                $this$use = $this$use$iv;
                $i$a$-use-BaseApplicationResponse$respondFromBytes$3 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = bytes;
                $continuation.L$2 = $this$use$iv;
                $continuation.L$3 = $this$use;
                $continuation.label = 2;
                v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getUnconfined()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$use, null, (Continuation)$continuation, bytes){
                    private CoroutineScope p$;
                    Object L$0;
                    int label;
                    final /* synthetic */ ByteWriteChannel $this_use;
                    final /* synthetic */ Continuation $continuation$inlined;
                    final /* synthetic */ byte[] $bytes$inlined;
                    {
                        this.$this_use = byteWriteChannel;
                        this.$continuation$inlined = continuation2;
                        this.$bytes$inlined = byArray;
                        super(2, continuation);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                CoroutineScope $this$withContext = this.p$;
                                this.L$0 = $this$withContext;
                                this.label = 1;
                                Object object2 = ByteWriteChannelKt.writeFully((ByteWriteChannel)this.$this_use, (byte[])this.$bytes$inlined, (Continuation)this);
                                Object object3 = object2;
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                        function2.p$ = (CoroutineScope)value;
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
                        return function22;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v2 != var11_5) goto lbl51
lbl50:
                // 1 sources

                return var11_5;
lbl51:
                // 1 sources

                ** GOTO lbl71
            }
            case 2: {
                $this$use = (ByteWriteChannel)$continuation.L$3;
                $this$use$iv = (ByteWriteChannel)$continuation.L$2;
                bytes = (byte[])$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                    ** GOTO lbl71
                }
                catch (Throwable cause$iv) {
                    $this$use$iv.close(cause$iv);
                    throw cause$iv;
                }
            }
            catch (Throwable var7_15) {
                throw var7_15;
            }
            {
                finally {
                    ByteWriteChannelKt.close((ByteWriteChannel)$this$use$iv);
                }
lbl71:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    protected Object respondFromChannel(@NotNull ByteReadChannel byteReadChannel, @NotNull Continuation<? super Unit> $completion) {
        return BaseApplicationResponse.respondFromChannel$suspendImpl(this, byteReadChannel, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static /* synthetic */ Object respondFromChannel$suspendImpl(BaseApplicationResponse this, ByteReadChannel readChannel, Continuation $completion) {
        if (!($completion instanceof respondFromChannel.1)) ** GOTO lbl-1000
        var16_3 = $completion;
        if ((var16_3.label & -2147483648) != 0) {
            var16_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ BaseApplicationResponse this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                long J$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseApplicationResponse.respondFromChannel$suspendImpl(this.this$0, null, (Continuation)this);
                }
                {
                    this.this$0 = baseApplicationResponse;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var17_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = readChannel;
                $continuation.label = 1;
                v0 = this.responseChannel((Continuation<? super ByteWriteChannel>)$continuation);
                if (v0 == var17_5) {
                    return var17_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                readChannel = (ByteReadChannel)$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                $this$use$iv = (ByteWriteChannel)v0;
                $i$f$use = false;
                $this$use = $this$use$iv;
                $i$a$-use-BaseApplicationResponse$respondFromChannel$2 = false;
                v1 = this.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
                if (v1 != null) {
                    var7_11 = v1;
                    var8_12 = false;
                    v2 = Boxing.boxLong((long)Long.parseLong(var7_11));
                } else {
                    v2 = null;
                }
                length = v2;
                $continuation.L$0 = this;
                $continuation.L$1 = readChannel;
                $continuation.L$2 = $this$use$iv;
                $continuation.L$3 = $this$use;
                $continuation.L$4 = length;
                $continuation.label = 2;
                v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getUnconfined()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>($this$use, length, null, this, (Continuation)$continuation, readChannel){
                    private CoroutineScope p$;
                    Object L$0;
                    int label;
                    final /* synthetic */ ByteWriteChannel $this_use;
                    final /* synthetic */ Long $length;
                    final /* synthetic */ BaseApplicationResponse this$0;
                    final /* synthetic */ Continuation $continuation$inlined;
                    final /* synthetic */ ByteReadChannel $readChannel$inlined;
                    {
                        this.$this_use = byteWriteChannel;
                        this.$length = l;
                        this.this$0 = baseApplicationResponse;
                        this.$continuation$inlined = continuation2;
                        this.$readChannel$inlined = byteReadChannel;
                        super(2, continuation);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                CoroutineScope $this$withContext = this.p$;
                                Long l = this.$length;
                                this.L$0 = $this$withContext;
                                this.label = 1;
                                Object object2 = ByteReadChannelJVMKt.copyTo((ByteReadChannel)this.$readChannel$inlined, (ByteWriteChannel)this.$this_use, (long)(l != null ? l : Long.MAX_VALUE), (Continuation)this);
                                Object object3 = object2;
                                if (object2 != object) return object3;
                                return object;
                            }
                            case 1: {
                                CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Long>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                        function2.p$ = (CoroutineScope)value;
                        Function2<CoroutineScope, Continuation<? super Long>, Object> function22 = function2;
                        return function22;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v3 != var17_5) goto lbl47
lbl46:
                // 1 sources

                return var17_5;
lbl47:
                // 1 sources

                ** GOTO lbl57
            }
            case 2: {
                length = (Long)$continuation.L$4;
                $this$use = (ByteWriteChannel)$continuation.L$3;
                $this$use$iv = (ByteWriteChannel)$continuation.L$2;
                readChannel = (ByteReadChannel)$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl57:
                // 2 sources

                copied = ((Number)v3).longValue();
                v4 = length;
                if (v4 != null) ** GOTO lbl61
                ** GOTO lbl98
lbl61:
                // 1 sources

                v4.longValue();
                $continuation.L$0 = this;
                $continuation.L$1 = readChannel;
                $continuation.L$2 = $this$use$iv;
                $continuation.L$3 = $this$use;
                $continuation.L$4 = length;
                $continuation.J$0 = copied;
                $continuation.label = 3;
                v5 = readChannel.discard(1L, (Continuation)$continuation);
                ** if (v5 != var17_5) goto lbl72
lbl71:
                // 1 sources

                return var17_5;
lbl72:
                // 1 sources

                ** GOTO lbl83
            }
            case 3: {
                copied = $continuation.J$0;
                length = (Long)$continuation.L$4;
                $this$use = (ByteWriteChannel)$continuation.L$3;
                $this$use$iv = (ByteWriteChannel)$continuation.L$2;
                readChannel = (ByteReadChannel)$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl83:
                    // 2 sources

                    discarded = ((Number)v5).longValue();
                    this.ensureLength(length, copied + discarded);
                    ** GOTO lbl98
                }
                catch (Throwable cause$iv) {
                    $this$use$iv.close(cause$iv);
                    throw cause$iv;
                }
            }
            catch (Throwable var14_17) {
                throw var14_17;
            }
            {
                finally {
                    ByteWriteChannelKt.close((ByteWriteChannel)$this$use$iv);
                }
lbl98:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void ensureLength(long expected, long actual) {
        if (expected < actual) {
            throw (Throwable)new BodyLengthIsTooLong(expected);
        }
        if (expected > actual) {
            throw (Throwable)new BodyLengthIsTooSmall(expected, actual);
        }
    }

    @Nullable
    protected abstract Object respondUpgrade(@NotNull OutgoingContent.ProtocolUpgrade var1, @NotNull Continuation<? super Unit> var2);

    @Nullable
    protected abstract Object responseChannel(@NotNull Continuation<? super ByteWriteChannel> var1);

    @NotNull
    protected ObjectPool<ByteBuffer> getBufferPool() {
        return ByteBufferPoolKt.getKtorDefaultPool();
    }

    protected abstract void setStatus(@NotNull HttpStatusCode var1);

    public void push(@NotNull ResponsePushBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        LinkHeaderKt.link((ApplicationResponse)this, (String)builder.getUrl().buildString(), (String[])new String[]{"prefetch"});
    }

    @NotNull
    public ApplicationCall getCall() {
        return this.call;
    }

    public BaseApplicationResponse(@NotNull ApplicationCall call) {
        ApplicationSendPipeline applicationSendPipeline;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        this.call = call;
        this.cookies$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ResponseCookies>(this){
            final /* synthetic */ BaseApplicationResponse this$0;

            @NotNull
            public final ResponseCookies invoke() {
                return new ResponseCookies((ApplicationResponse)this.this$0, Intrinsics.areEqual((Object)OriginConnectionPointKt.getOrigin((ApplicationRequest)this.this$0.getCall().getRequest()).getScheme(), (Object)"https"));
            }
            {
                this.this$0 = baseApplicationResponse;
                super(0);
            }
        }));
        ApplicationSendPipeline applicationSendPipeline2 = new ApplicationSendPipeline();
        BaseApplicationResponse baseApplicationResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        ApplicationSendPipeline $this$apply = applicationSendPipeline2;
        boolean bl3 = false;
        $this$apply.merge((Pipeline)this.getCall().getApplication().getSendPipeline());
        baseApplicationResponse.pipeline = applicationSendPipeline = applicationSendPipeline2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$ResponseAlreadySentException;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "()V", "ktor-server-host-common"})
    public static final class ResponseAlreadySentException
    extends IllegalStateException {
        public ResponseAlreadySentException() {
            super("Response has already been sent");
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$InvalidHeaderForContent;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "name", "", "content", "(Ljava/lang/String;Ljava/lang/String;)V", "ktor-server-host-common"})
    public static final class InvalidHeaderForContent
    extends IllegalStateException {
        public InvalidHeaderForContent(@NotNull String name, @NotNull String content) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            super("Header " + name + " is not allowed for " + content);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$BodyLengthIsTooSmall;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "expected", "", "actual", "(JJ)V", "ktor-server-host-common"})
    public static final class BodyLengthIsTooSmall
    extends IllegalStateException {
        public BodyLengthIsTooSmall(long expected, long actual) {
            super("Body.size is too small. Body: " + actual + ", Content-Length: " + expected);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$BodyLengthIsTooLong;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "expected", "", "(J)V", "ktor-server-host-common"})
    public static final class BodyLengthIsTooLong
    extends IllegalStateException {
        public BodyLengthIsTooLong(long expected) {
            super("Body.size is too long. Expected " + expected);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$Companion;", "", "()V", "EngineResponseAtributeKey", "Lio/ktor/util/AttributeKey;", "Lio/ktor/server/engine/BaseApplicationResponse;", "EngineResponseAtributeKey$annotations", "getEngineResponseAtributeKey", "()Lio/ktor/util/AttributeKey;", "setupSendPipeline", "", "sendPipeline", "Lio/ktor/response/ApplicationSendPipeline;", "ktor-server-host-common"})
    public static final class Companion {
        @EngineAPI
        public static /* synthetic */ void EngineResponseAtributeKey$annotations() {
        }

        @NotNull
        public final AttributeKey<BaseApplicationResponse> getEngineResponseAtributeKey() {
            return EngineResponseAtributeKey;
        }

        @EngineAPI
        public final void setupSendPipeline(@NotNull ApplicationSendPipeline sendPipeline) {
            Intrinsics.checkParameterIsNotNull((Object)sendPipeline, (String)"sendPipeline");
            sendPipeline.intercept(ApplicationSendPipeline.Phases.getEngine(), (Function3)new Function3<PipelineContext<Object, ApplicationCall>, Object, Continuation<? super Unit>, Object>(null){
                private PipelineContext p$;
                private Object p$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int label;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            BaseApplicationResponse baseApplicationResponse;
                            ResultKt.throwOnFailure((Object)$result);
                            PipelineContext $this$intercept = this.p$;
                            Object response = this.p$0;
                            if (!(response instanceof OutgoingContent)) {
                                throw (Throwable)new IllegalArgumentException("Response pipeline couldn't transform '" + response.getClass() + "' to the OutgoingContent");
                            }
                            PipelineContext $this$call$iv = $this$intercept;
                            boolean $i$f$getCall = false;
                            ApplicationCall call = (ApplicationCall)$this$call$iv.getContext();
                            ApplicationResponse applicationResponse = call.getResponse();
                            if (!(applicationResponse instanceof BaseApplicationResponse)) {
                                applicationResponse = null;
                            }
                            if ((baseApplicationResponse = (BaseApplicationResponse)applicationResponse) == null) {
                                baseApplicationResponse = (BaseApplicationResponse)call.getAttributes().get(BaseApplicationResponse.Companion.getEngineResponseAtributeKey());
                            }
                            BaseApplicationResponse callResponse = baseApplicationResponse;
                            this.L$0 = $this$intercept;
                            this.L$1 = response;
                            this.L$2 = call;
                            this.L$3 = callResponse;
                            this.label = 1;
                            Object object2 = callResponse.respondOutgoingContent((OutgoingContent)response, (Continuation<? super Unit>)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            BaseApplicationResponse callResponse = (BaseApplicationResponse)this.L$3;
                            ApplicationCall call = (ApplicationCall)this.L$2;
                            Object response = this.L$1;
                            PipelineContext $this$intercept = (PipelineContext)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@NotNull PipelineContext<Object, ApplicationCall> $this$create, @NotNull Object response, @NotNull Continuation<? super Unit> continuation) {
                    Intrinsics.checkParameterIsNotNull($this$create, (String)"$this$create");
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                    Function3<PipelineContext<Object, ApplicationCall>, Object, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    PipelineContext<Object, ApplicationCall> pipelineContext = function3.p$ = $this$create;
                    Object object = function3.p$0 = response;
                    return function3;
                }

                public final Object invoke(Object object, Object object2, Object object3) {
                    return (this.create((PipelineContext<Object, ApplicationCall>)((PipelineContext)object), object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

