/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.cio;

import io.ktor.http.Headers;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.http.Parameters;
import io.ktor.http.QueryKt;
import io.ktor.http.RequestConnectionPoint;
import io.ktor.http.cio.CIOHeaders;
import io.ktor.http.cio.Request;
import io.ktor.server.application.PipelineCall;
import io.ktor.server.cio.CIOApplicationRequestKt;
import io.ktor.server.cio.CIOConnectionPoint;
import io.ktor.server.engine.BaseApplicationRequest;
import io.ktor.server.request.ApplicationRequest;
import io.ktor.server.request.PipelineRequestKt;
import io.ktor.server.request.RequestCookies;
import io.ktor.utils.io.ByteReadChannel;
import java.net.SocketAddress;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\u0010\u0006\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u0012\u000e\u0010\u0007\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u0011\u001a\u00020\u000eH\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0012R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0013R\u001b\u0010\u0019\u001a\u00020\u00148VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\u00020\b8\u0014X\u0094\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0012\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u001e\u001a\u00020\u001d8\u0014@\u0014X\u0094\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001b\u0010(\u001a\u00020$8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0016\u001a\u0004\b&\u0010'R\u001b\u0010+\u001a\u00020$8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u0016\u001a\u0004\b*\u0010'R\u001a\u0010-\u001a\u00020,8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100\u00a8\u00061"}, d2={"Lio/ktor/server/cio/CIOApplicationRequest;", "Lio/ktor/server/engine/BaseApplicationRequest;", "Lio/ktor/server/application/PipelineCall;", "call", "Ljava/net/SocketAddress;", "Lio/ktor/util/network/NetworkAddress;", "remoteAddress", "localAddress", "Lio/ktor/utils/io/ByteReadChannel;", "input", "Lio/ktor/http/cio/Request;", "request", "<init>", "(Lio/ktor/server/application/PipelineCall;Ljava/net/SocketAddress;Ljava/net/SocketAddress;Lio/ktor/utils/io/ByteReadChannel;Lio/ktor/http/cio/Request;)V", "", "release$ktor_server_cio", "()V", "release", "Lio/ktor/utils/io/ByteReadChannel;", "Lio/ktor/http/cio/Request;", "Lio/ktor/server/request/RequestCookies;", "cookies$delegate", "Lkotlin/Lazy;", "getCookies", "()Lio/ktor/server/request/RequestCookies;", "cookies", "engineReceiveChannel", "getEngineReceiveChannel", "()Lio/ktor/utils/io/ByteReadChannel;", "Lio/ktor/http/Headers;", "engineHeaders", "Lio/ktor/http/Headers;", "getEngineHeaders", "()Lio/ktor/http/Headers;", "setEngineHeaders", "(Lio/ktor/http/Headers;)V", "Lio/ktor/http/Parameters;", "queryParameters$delegate", "getQueryParameters", "()Lio/ktor/http/Parameters;", "queryParameters", "rawQueryParameters$delegate", "getRawQueryParameters", "rawQueryParameters", "Lio/ktor/http/RequestConnectionPoint;", "local", "Lio/ktor/http/RequestConnectionPoint;", "getLocal", "()Lio/ktor/http/RequestConnectionPoint;", "ktor-server-cio"})
@SourceDebugExtension(value={"SMAP\nCIOApplicationRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CIOApplicationRequest.kt\nio/ktor/server/cio/CIOApplicationRequest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
public final class CIOApplicationRequest
extends BaseApplicationRequest {
    @NotNull
    private final ByteReadChannel input;
    @NotNull
    private final Request request;
    @NotNull
    private final Lazy cookies$delegate;
    @NotNull
    private final ByteReadChannel engineReceiveChannel;
    @NotNull
    private Headers engineHeaders;
    @NotNull
    private final Lazy queryParameters$delegate;
    @NotNull
    private final Lazy rawQueryParameters$delegate;
    @NotNull
    private final RequestConnectionPoint local;

    public CIOApplicationRequest(@NotNull PipelineCall call, @Nullable SocketAddress remoteAddress, @Nullable SocketAddress localAddress, @NotNull ByteReadChannel input, @NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super(call);
        this.input = input;
        this.request = request;
        this.cookies$delegate = LazyKt.lazy(() -> CIOApplicationRequest.cookies_delegate$lambda$0(this));
        this.engineReceiveChannel = this.input;
        this.engineHeaders = (Headers)new CIOHeaders(this.request.getHeaders());
        this.queryParameters$delegate = LazyKt.lazy(() -> CIOApplicationRequest.queryParameters_delegate$lambda$1(this));
        this.rawQueryParameters$delegate = LazyKt.lazy(() -> CIOApplicationRequest.rawQueryParameters_delegate$lambda$3(this));
        CharSequence charSequence = this.request.getHeaders().get(HttpHeaders.INSTANCE.getHost());
        this.local = new CIOConnectionPoint(remoteAddress, localAddress, ((Object)this.request.getVersion()).toString(), ((Object)this.request.getUri()).toString(), charSequence != null ? ((Object)charSequence).toString() : null, HttpMethod.Companion.parse(this.request.getMethod().getValue()));
    }

    @NotNull
    public RequestCookies getCookies() {
        Lazy lazy = this.cookies$delegate;
        return (RequestCookies)lazy.getValue();
    }

    @NotNull
    protected ByteReadChannel getEngineReceiveChannel() {
        return this.engineReceiveChannel;
    }

    @NotNull
    protected Headers getEngineHeaders() {
        return this.engineHeaders;
    }

    protected void setEngineHeaders(@NotNull Headers headers2) {
        Intrinsics.checkNotNullParameter((Object)headers2, (String)"<set-?>");
        this.engineHeaders = headers2;
    }

    @NotNull
    public Parameters getQueryParameters() {
        Lazy lazy = this.queryParameters$delegate;
        return (Parameters)lazy.getValue();
    }

    @NotNull
    public Parameters getRawQueryParameters() {
        Lazy lazy = this.rawQueryParameters$delegate;
        return (Parameters)lazy.getValue();
    }

    @NotNull
    public RequestConnectionPoint getLocal() {
        return this.local;
    }

    public final void release$ktor_server_cio() {
        this.request.release();
    }

    private static final RequestCookies cookies_delegate$lambda$0(CIOApplicationRequest this$0) {
        return new RequestCookies((ApplicationRequest)this$0);
    }

    private static final Parameters queryParameters_delegate$lambda$1(CIOApplicationRequest this$0) {
        return CIOApplicationRequestKt.access$toQueryParameters(PipelineRequestKt.encodeParameters((ApplicationRequest)((ApplicationRequest)this$0), (Parameters)this$0.getRawQueryParameters()));
    }

    private static final Parameters rawQueryParameters_delegate$lambda$3(CIOApplicationRequest this$0) {
        String uri = ((Object)this$0.request.getUri()).toString();
        Integer n = StringsKt.indexOf$default((CharSequence)uri, (char)'?', (int)0, (boolean)false, (int)6, null);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it != -1 ? n : null;
        if (n2 == null) {
            return Parameters.Companion.getEmpty();
        }
        int queryStartIndex = n2;
        return QueryKt.parseQueryString$default((String)uri, (int)(queryStartIndex + 1), (int)0, (boolean)false, (int)4, null);
    }
}

