/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.selector;

import io.ktor.network.selector.ClosedChannelCancellationException;
import io.ktor.network.selector.InterestSuspensionsMap;
import io.ktor.network.selector.SelectInterest;
import io.ktor.network.selector.Selectable;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicInt;
import kotlinx.coroutines.CancellableContinuation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lio/ktor/network/selector/SelectableBase;", "Lio/ktor/network/selector/Selectable;", "channel", "Ljava/nio/channels/SelectableChannel;", "(Ljava/nio/channels/SelectableChannel;)V", "_interestedOps", "Lkotlinx/atomicfu/AtomicInt;", "_isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getChannel", "()Ljava/nio/channels/SelectableChannel;", "interestedOps", "", "getInterestedOps", "()I", "isClosed", "", "()Z", "suspensions", "Lio/ktor/network/selector/InterestSuspensionsMap;", "getSuspensions", "()Lio/ktor/network/selector/InterestSuspensionsMap;", "close", "", "dispose", "interestOp", "interest", "Lio/ktor/network/selector/SelectInterest;", "state", "ktor-network"})
public class SelectableBase
implements Selectable {
    @NotNull
    private final SelectableChannel channel;
    @NotNull
    private final AtomicBoolean _isClosed;
    @NotNull
    private final InterestSuspensionsMap suspensions;
    @NotNull
    private final AtomicInt _interestedOps;

    public SelectableBase(@NotNull SelectableChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.channel = channel;
        this._isClosed = new AtomicBoolean(false);
        this.suspensions = new InterestSuspensionsMap();
        this._interestedOps = AtomicFU.atomic((int)0);
    }

    @Override
    @NotNull
    public SelectableChannel getChannel() {
        return this.channel;
    }

    @Override
    @NotNull
    public InterestSuspensionsMap getSuspensions() {
        return this.suspensions;
    }

    @Override
    public boolean isClosed() {
        return this._isClosed.get();
    }

    @Override
    public int getInterestedOps() {
        return this._interestedOps.getValue();
    }

    @Override
    public void interestOp(@NotNull SelectInterest interest, boolean state) {
        int after;
        int before;
        Intrinsics.checkNotNullParameter((Object)((Object)interest), (String)"interest");
        int flag = interest.getFlag();
        while (!this._interestedOps.compareAndSet(before = this._interestedOps.getValue(), after = state ? before | flag : before & ~flag)) {
        }
    }

    @Override
    public void close() {
        if (!this._isClosed.compareAndSet(false, true)) {
            return;
        }
        this._interestedOps.setValue(0);
        InterestSuspensionsMap this_$iv = this.getSuspensions();
        boolean $i$f$invokeForEachPresent = false;
        for (SelectInterest interest$iv : SelectInterest.Companion.getAllInterests()) {
            CancellableContinuation<Unit> $this$invokeForEachPresent_u24lambda_u240$iv;
            if (this_$iv.removeSuspension(interest$iv) == null) continue;
            boolean bl = false;
            SelectInterest selectInterest = interest$iv;
            CancellableContinuation<Unit> $this$close_u24lambda_u240 = $this$invokeForEachPresent_u24lambda_u240$iv;
            boolean bl2 = false;
            ((Continuation)$this$close_u24lambda_u240).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new ClosedChannelCancellationException())));
        }
    }

    public void dispose() {
        this.close();
    }
}

