/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.features.auth.providers;

import io.ktor.client.features.auth.AuthProvider;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.http.HttpHeaders;
import io.ktor.http.auth.HttpAuthHeader;
import io.ktor.util.Base64JvmKt;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lio/ktor/client/features/auth/providers/BasicAuthProvider;", "Lio/ktor/client/features/auth/AuthProvider;", "username", "", "password", "realm", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "addRequestHeaders", "", "request", "Lio/ktor/client/request/HttpRequestBuilder;", "(Lio/ktor/client/request/HttpRequestBuilder;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "constructBasicAuthValue", "isApplicable", "", "auth", "Lio/ktor/http/auth/HttpAuthHeader;", "ktor-client-auth"})
public final class BasicAuthProvider
implements AuthProvider {
    private final String username;
    private final String password;
    private final String realm;

    @Override
    public boolean isApplicable(@NotNull HttpAuthHeader auth) {
        Intrinsics.checkParameterIsNotNull((Object)auth, (String)"auth");
        if (Intrinsics.areEqual((Object)auth.getAuthScheme(), (Object)"Basic") ^ true) {
            return false;
        }
        if (this.realm != null) {
            if (!(auth instanceof HttpAuthHeader.Parameterized)) {
                return false;
            }
            return Intrinsics.areEqual((Object)((HttpAuthHeader.Parameterized)auth).parameter("realm"), (Object)this.realm);
        }
        return true;
    }

    @Override
    @Nullable
    public Object addRequestHeaders(@NotNull HttpRequestBuilder request, @NotNull Continuation<? super Unit> continuation) {
        request.getHeaders().set(HttpHeaders.INSTANCE.getAuthorization(), this.constructBasicAuthValue(this.username, this.password));
        return Unit.INSTANCE;
    }

    private final String constructBasicAuthValue(String username, String password) {
        String authString;
        String string = authString = username + ':' + password;
        Charset charset = Charsets.ISO_8859_1;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String authBuf = Base64JvmKt.encodeBase64((byte[])byArray);
        return "Basic " + authBuf;
    }

    public BasicAuthProvider(@NotNull String username, @NotNull String password, @Nullable String realm) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        this.username = username;
        this.password = password;
        this.realm = realm;
    }
}

