/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.auth;

import io.ktor.auth.HeadersKt;
import io.ktor.auth.HttpAuthHeader;
import io.ktor.request.ApplicationRequest;
import io.ktor.request.ApplicationRequestPropertiesKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0006\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\n\u001a\u0014\u0010\u000b\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\f\u0010\u000e\u001a\u00020\u0006*\u00020\u0006H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"authSchemePattern", "Lkotlin/text/Regex;", "escapeRegex", "parameterPattern", "token68Pattern", "valuePatternPart", "", "parseAuthorizationHeader", "Lio/ktor/auth/HttpAuthHeader;", "headerValue", "Lio/ktor/request/ApplicationRequest;", "substringAfterMatch", "mr", "Lkotlin/text/MatchResult;", "unescapeIfQuoted", "ktor-auth"})
public final class HeadersKt {
    private static final Regex token68Pattern;
    private static final Regex authSchemePattern;
    private static final String valuePatternPart = "(\"((\\\\.)|[^\\\\\"])*\")|[^\\s,]*";
    private static final Regex parameterPattern;
    private static final Regex escapeRegex;

    @Nullable
    public static final HttpAuthHeader parseAuthorizationHeader(@NotNull ApplicationRequest $receiver) {
        HttpAuthHeader httpAuthHeader;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = ApplicationRequestPropertiesKt.authorization((ApplicationRequest)$receiver);
        if (string != null) {
            String string2;
            String it = string2 = string;
            httpAuthHeader = HeadersKt.parseAuthorizationHeader(it);
        } else {
            httpAuthHeader = null;
        }
        return httpAuthHeader;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final HttpAuthHeader parseAuthorizationHeader(@NotNull String headerValue) {
        void $receiver$iv$iv;
        void $receiver$iv;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)headerValue, (String)"headerValue");
        MatchResult matchResult = Regex.find$default((Regex)authSchemePattern, (CharSequence)headerValue, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult schemeRegion = matchResult;
        String authScheme = schemeRegion.getValue();
        String string2 = string = HeadersKt.substringAfterMatch(headerValue, schemeRegion);
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String remaining = ((Object)StringsKt.trimStart((CharSequence)string2)).toString();
        MatchResult token68 = Regex.find$default((Regex)token68Pattern, (CharSequence)remaining, (int)0, (int)2, null);
        if (token68 != null && StringsKt.isBlank((CharSequence)HeadersKt.substringAfterMatch(remaining, token68))) {
            return new HttpAuthHeader.Single(authScheme, token68.getValue());
        }
        Sequence sequence = Regex.findAll$default((Regex)parameterPattern, (CharSequence)remaining, (int)0, (int)2, null);
        void var7_6 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            MatchResult it;
            MatchResult matchResult2 = (MatchResult)element$iv$iv;
            Map map = destination$iv$iv;
            MatchGroup matchGroup = it.getGroups().get(1);
            if (matchGroup == null) {
                Intrinsics.throwNpe();
            }
            String string3 = matchGroup.getValue();
            it = (MatchResult)element$iv$iv;
            MatchGroup matchGroup2 = it.getGroups().get(2);
            if (matchGroup2 == null) {
                Intrinsics.throwNpe();
            }
            String string4 = HeadersKt.unescapeIfQuoted(matchGroup2.getValue());
            map.put(string3, string4);
        }
        Map parameters = destination$iv$iv;
        return new HttpAuthHeader.Parameterized(authScheme, parameters, null, 4, null);
    }

    private static final String substringAfterMatch(@NotNull String $receiver, MatchResult mr) {
        return StringsKt.drop((String)$receiver, (int)(mr.getRange().getEndInclusive() + (mr.getRange().isEmpty() ? 0 : 1)));
    }

    private static final String unescapeIfQuoted(@NotNull String $receiver) {
        String string;
        if (StringsKt.startsWith$default((CharSequence)$receiver, (char)'\"', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)$receiver, (char)'\"', (boolean)false, (int)2, null)) {
            CharSequence charSequence = StringsKt.removeSurrounding((String)$receiver, (CharSequence)"\"");
            Regex regex = escapeRegex;
            Function1 function1 = unescapeIfQuoted.1.INSTANCE;
            string = regex.replace(charSequence, function1);
        } else {
            string = $receiver;
        }
        return string;
    }

    static {
        String string = "[a-zA-Z0-9\\-._~+/]+=*";
        token68Pattern = new Regex(string);
        string = "\\S+";
        authSchemePattern = new Regex(string);
        valuePatternPart = valuePatternPart;
        string = "\\s*,?\\s*(" + token68Pattern + ")\\s*=\\s*(" + valuePatternPart + ")\\s*,?\\s*";
        parameterPattern = new Regex(string);
        string = "\\\\.";
        escapeRegex = new Regex(string);
    }

    @NotNull
    public static final /* synthetic */ Regex access$getToken68Pattern$p() {
        return token68Pattern;
    }
}

