/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.auth;

import io.ktor.auth.AuthScheme;
import io.ktor.auth.HeaderValueEncoding;
import io.ktor.auth.HeadersKt;
import io.ktor.auth.HttpAuthHeader$Parameterized$WhenMappings;
import io.ktor.http.CodecsKt;
import io.ktor.http.HeaderValueParam;
import io.ktor.http.HeaderValueWithParametersKt;
import io.ktor.util.CryptoKt;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000b2\u00020\u0001:\u0004\u000b\f\r\u000eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lio/ktor/auth/HttpAuthHeader;", "", "authScheme", "", "(Ljava/lang/String;)V", "getAuthScheme", "()Ljava/lang/String;", "render", "encoding", "Lio/ktor/auth/HeaderValueEncoding;", "toString", "Companion", "Parameterized", "Parameters", "Single", "Lio/ktor/auth/HttpAuthHeader$Single;", "Lio/ktor/auth/HttpAuthHeader$Parameterized;", "ktor-auth"})
public abstract class HttpAuthHeader {
    @NotNull
    private final String authScheme;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract String render(@NotNull HeaderValueEncoding var1);

    @NotNull
    public abstract String render();

    @NotNull
    public String toString() {
        return this.render();
    }

    @NotNull
    public final String getAuthScheme() {
        return this.authScheme;
    }

    private HttpAuthHeader(String authScheme) {
        this.authScheme = authScheme;
        CharSequence charSequence = this.authScheme;
        Regex regex = HeadersKt.access$getToken68Pattern$p();
        boolean bl = regex.matches(charSequence);
        if (!bl) {
            String string = "invalid authScheme value: it should be token";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ HttpAuthHeader(@NotNull String authScheme, DefaultConstructorMarker $constructor_marker) {
        this(authScheme);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lio/ktor/auth/HttpAuthHeader$Single;", "Lio/ktor/auth/HttpAuthHeader;", "authScheme", "", "blob", "(Ljava/lang/String;Ljava/lang/String;)V", "getBlob", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "render", "encoding", "Lio/ktor/auth/HeaderValueEncoding;", "ktor-auth"})
    public static final class Single
    extends HttpAuthHeader {
        @NotNull
        private final String blob;

        @Override
        @NotNull
        public String render() {
            return this.getAuthScheme() + ' ' + this.blob;
        }

        @Override
        @NotNull
        public String render(@NotNull HeaderValueEncoding encoding) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)encoding), (String)"encoding");
            return this.render();
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof Single)) {
                return false;
            }
            return StringsKt.equals((String)((Single)other).getAuthScheme(), (String)this.getAuthScheme(), (boolean)true) && StringsKt.equals((String)((Single)other).blob, (String)this.blob, (boolean)true);
        }

        public int hashCode() {
            Object[] objectArray;
            String string = this.getAuthScheme();
            int n = 0;
            Object[] objectArray2 = objectArray = new Object[2];
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String string4 = string3;
            objectArray[n] = string4;
            string = this.blob;
            n = 1;
            objectArray = objectArray2;
            String string5 = string;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
            string4 = string6;
            objectArray[n] = string4;
            return Objects.hash(objectArray2);
        }

        @NotNull
        public final String getBlob() {
            return this.blob;
        }

        public Single(@NotNull String authScheme, @NotNull String blob) {
            Intrinsics.checkParameterIsNotNull((Object)authScheme, (String)"authScheme");
            Intrinsics.checkParameterIsNotNull((Object)blob, (String)"blob");
            super(authScheme, null);
            this.blob = blob;
            CharSequence charSequence = this.blob;
            Regex regex = HeadersKt.access$getToken68Pattern$p();
            boolean bl = regex.matches(charSequence);
            if (!bl) {
                String string = "invalid blob value: it should be token68 but it is " + this.blob;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u0003J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003J\u0014\u0010\u001b\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lio/ktor/auth/HttpAuthHeader$Parameterized;", "Lio/ktor/auth/HttpAuthHeader;", "authScheme", "", "parameters", "", "encoding", "Lio/ktor/auth/HeaderValueEncoding;", "(Ljava/lang/String;Ljava/util/Map;Lio/ktor/auth/HeaderValueEncoding;)V", "", "Lio/ktor/http/HeaderValueParam;", "(Ljava/lang/String;Ljava/util/List;Lio/ktor/auth/HeaderValueEncoding;)V", "getEncoding", "()Lio/ktor/auth/HeaderValueEncoding;", "getParameters", "()Ljava/util/List;", "equals", "", "other", "", "hashCode", "", "parameter", "name", "render", "withParameter", "value", "encode", "ktor-auth"})
    public static final class Parameterized
    extends HttpAuthHeader {
        @NotNull
        private final List<HeaderValueParam> parameters;
        @NotNull
        private final HeaderValueEncoding encoding;

        @NotNull
        public final Parameterized withParameter(@NotNull String name, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return new Parameterized(this.getAuthScheme(), CollectionsKt.plus((Collection)this.parameters, (Object)new HeaderValueParam(name, value)), this.encoding);
        }

        @Override
        @NotNull
        public String render(@NotNull HeaderValueEncoding encoding) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)encoding), (String)"encoding");
            return CollectionsKt.joinToString$default((Iterable)this.parameters, (CharSequence)", ", (CharSequence)(this.getAuthScheme() + ' '), null, (int)0, null, (Function1)((Function1)new Function1<HeaderValueParam, String>(this, encoding){
                final /* synthetic */ Parameterized this$0;
                final /* synthetic */ HeaderValueEncoding $encoding;

                @NotNull
                public final String invoke(@NotNull HeaderValueParam it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return it.getName() + '=' + Parameterized.access$encode(this.this$0, it.getValue(), this.$encoding);
                }
                {
                    this.this$0 = parameterized;
                    this.$encoding = headerValueEncoding;
                    super(1);
                }
            }), (int)28, null);
        }

        @Nullable
        public final String parameter(@NotNull String name) {
            Object v0;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Iterable $receiver$iv = this.parameters;
                for (Object element$iv : $receiver$iv) {
                    HeaderValueParam it = (HeaderValueParam)element$iv;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            HeaderValueParam headerValueParam = v0;
            return headerValueParam != null ? headerValueParam.getValue() : null;
        }

        private final String encode(@NotNull String $receiver, HeaderValueEncoding encoding) {
            String string;
            switch (HttpAuthHeader$Parameterized$WhenMappings.$EnumSwitchMapping$0[encoding.ordinal()]) {
                case 1: {
                    string = HeaderValueWithParametersKt.escapeIfNeeded((String)$receiver);
                    break;
                }
                case 2: {
                    string = HeaderValueWithParametersKt.quote((String)$receiver);
                    break;
                }
                case 3: {
                    string = CodecsKt.encodeURLParameter$default((String)$receiver, (boolean)false, (int)1, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        @Override
        @NotNull
        public String render() {
            return this.render(this.encoding);
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof Parameterized)) {
                return false;
            }
            return StringsKt.equals((String)((Parameterized)other).getAuthScheme(), (String)this.getAuthScheme(), (boolean)true) && Intrinsics.areEqual(((Parameterized)other).parameters, this.parameters);
        }

        public int hashCode() {
            Object[] objectArray;
            String string = this.getAuthScheme();
            int n = 0;
            Object[] objectArray2 = objectArray = new Object[2];
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String string4 = string3;
            objectArray[n] = string4;
            objectArray2[1] = this.parameters;
            return Objects.hash(objectArray2);
        }

        @NotNull
        public final List<HeaderValueParam> getParameters() {
            return this.parameters;
        }

        @NotNull
        public final HeaderValueEncoding getEncoding() {
            return this.encoding;
        }

        public Parameterized(@NotNull String authScheme, @NotNull List<HeaderValueParam> parameters, @NotNull HeaderValueEncoding encoding) {
            Intrinsics.checkParameterIsNotNull((Object)authScheme, (String)"authScheme");
            Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
            Intrinsics.checkParameterIsNotNull((Object)((Object)encoding), (String)"encoding");
            super(authScheme, null);
            this.parameters = parameters;
            this.encoding = encoding;
            Iterable $receiver$iv = this.parameters;
            for (Object element$iv : $receiver$iv) {
                HeaderValueParam it = (HeaderValueParam)element$iv;
                CharSequence charSequence = it.getName();
                Regex regex = HeadersKt.access$getToken68Pattern$p();
                boolean bl = regex.matches(charSequence);
                if (bl) continue;
                String string = "parameter name should be a token but it is " + it.getName();
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ Parameterized(String string, List list, HeaderValueEncoding headerValueEncoding, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                headerValueEncoding = HeaderValueEncoding.QUOTED_WHEN_REQUIRED;
            }
            this(string, list, headerValueEncoding);
        }

        /*
         * WARNING - void declaration
         */
        public Parameterized(@NotNull String authScheme, @NotNull Map<String, String> parameters, @NotNull HeaderValueEncoding encoding) {
            Collection<HeaderValueParam> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)authScheme, (String)"authScheme");
            Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
            Intrinsics.checkParameterIsNotNull((Object)((Object)encoding), (String)"encoding");
            Iterable iterable = parameters.entrySet();
            String string = authScheme;
            Parameterized parameterized = this;
            void var5_7 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Map.Entry entry = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                HeaderValueParam headerValueParam = new HeaderValueParam((String)it.getKey(), (String)it.getValue());
                collection.add(headerValueParam);
            }
            collection = (List)destination$iv$iv;
            parameterized(string, (List<HeaderValueParam>)collection, encoding);
        }

        public /* synthetic */ Parameterized(String string, Map map, HeaderValueEncoding headerValueEncoding, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                headerValueEncoding = HeaderValueEncoding.QUOTED_WHEN_REQUIRED;
            }
            this(string, map, headerValueEncoding);
        }

        @NotNull
        public static final /* synthetic */ String access$encode(Parameterized $this, @NotNull String $receiver, @NotNull HeaderValueEncoding encoding) {
            return $this.encode($receiver, encoding);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0014\u0010\u001b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0014\u0010\u001d\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lio/ktor/auth/HttpAuthHeader$Parameters;", "", "()V", "Charset", "", "getCharset", "()Ljava/lang/String;", "OAuthCallback", "getOAuthCallback", "OAuthCallbackConfirmed", "getOAuthCallbackConfirmed", "OAuthConsumerKey", "getOAuthConsumerKey", "OAuthNonce", "getOAuthNonce", "OAuthSignature", "getOAuthSignature", "OAuthSignatureMethod", "getOAuthSignatureMethod", "OAuthTimestamp", "getOAuthTimestamp", "OAuthToken", "getOAuthToken", "OAuthTokenSecret", "getOAuthTokenSecret", "OAuthVerifier", "getOAuthVerifier", "OAuthVersion", "getOAuthVersion", "Realm", "getRealm", "ktor-auth"})
    public static final class Parameters {
        @NotNull
        private static final String Realm = "realm";
        @NotNull
        private static final String Charset = "charset";
        @NotNull
        private static final String OAuthCallback = "oauth_callback";
        @NotNull
        private static final String OAuthConsumerKey = "oauth_consumer_key";
        @NotNull
        private static final String OAuthNonce = "oauth_nonce";
        @NotNull
        private static final String OAuthToken = "oauth_token";
        @NotNull
        private static final String OAuthTokenSecret = "oauth_token_secret";
        @NotNull
        private static final String OAuthVerifier = "oauth_verifier";
        @NotNull
        private static final String OAuthSignatureMethod = "oauth_signature_method";
        @NotNull
        private static final String OAuthTimestamp = "oauth_timestamp";
        @NotNull
        private static final String OAuthVersion = "oauth_version";
        @NotNull
        private static final String OAuthSignature = "oauth_signature";
        @NotNull
        private static final String OAuthCallbackConfirmed = "oauth_callback_confirmed";
        public static final Parameters INSTANCE;

        @NotNull
        public final String getRealm() {
            return Realm;
        }

        @NotNull
        public final String getCharset() {
            return Charset;
        }

        @NotNull
        public final String getOAuthCallback() {
            return OAuthCallback;
        }

        @NotNull
        public final String getOAuthConsumerKey() {
            return OAuthConsumerKey;
        }

        @NotNull
        public final String getOAuthNonce() {
            return OAuthNonce;
        }

        @NotNull
        public final String getOAuthToken() {
            return OAuthToken;
        }

        @NotNull
        public final String getOAuthTokenSecret() {
            return OAuthTokenSecret;
        }

        @NotNull
        public final String getOAuthVerifier() {
            return OAuthVerifier;
        }

        @NotNull
        public final String getOAuthSignatureMethod() {
            return OAuthSignatureMethod;
        }

        @NotNull
        public final String getOAuthTimestamp() {
            return OAuthTimestamp;
        }

        @NotNull
        public final String getOAuthVersion() {
            return OAuthVersion;
        }

        @NotNull
        public final String getOAuthSignature() {
            return OAuthSignature;
        }

        @NotNull
        public final String getOAuthCallbackConfirmed() {
            return OAuthCallbackConfirmed;
        }

        private Parameters() {
        }

        static {
            Parameters parameters;
            INSTANCE = parameters = new Parameters();
            Realm = Realm;
            Charset = Charset;
            OAuthCallback = OAuthCallback;
            OAuthConsumerKey = OAuthConsumerKey;
            OAuthNonce = OAuthNonce;
            OAuthToken = OAuthToken;
            OAuthTokenSecret = OAuthTokenSecret;
            OAuthVerifier = OAuthVerifier;
            OAuthSignatureMethod = OAuthSignatureMethod;
            OAuthTimestamp = OAuthTimestamp;
            OAuthVersion = OAuthVersion;
            OAuthSignature = OAuthSignature;
            OAuthCallbackConfirmed = OAuthCallbackConfirmed;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJO\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u00062\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lio/ktor/auth/HttpAuthHeader$Companion;", "", "()V", "basicAuthChallenge", "Lio/ktor/auth/HttpAuthHeader$Parameterized;", "realm", "", "charset", "Ljava/nio/charset/Charset;", "digestAuthChallenge", "nonce", "domain", "", "opaque", "stale", "", "algorithm", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;)Lio/ktor/auth/HttpAuthHeader$Parameterized;", "ktor-auth"})
    public static final class Companion {
        @NotNull
        public final Parameterized basicAuthChallenge(@NotNull String realm, @Nullable Charset charset) {
            Intrinsics.checkParameterIsNotNull((Object)realm, (String)"realm");
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            String string = AuthScheme.INSTANCE.getBasic();
            LinkedHashMap<String, String> $receiver = linkedHashMap;
            $receiver.put(Parameters.INSTANCE.getRealm(), realm);
            if (charset != null) {
                $receiver.put(Parameters.INSTANCE.getCharset(), charset.name());
            }
            LinkedHashMap<String, String> linkedHashMap2 = linkedHashMap;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 4;
            HeaderValueEncoding headerValueEncoding = null;
            Map map = linkedHashMap2;
            String string2 = string;
            return new Parameterized(string2, map, headerValueEncoding, n, defaultConstructorMarker);
        }

        @NotNull
        public final Parameterized digestAuthChallenge(@NotNull String realm, @NotNull String nonce, @NotNull List<String> domain, @Nullable String opaque, @Nullable Boolean stale, @NotNull String algorithm) {
            LinkedHashMap<String, String> linkedHashMap;
            LinkedHashMap<String, String> linkedHashMap2;
            Intrinsics.checkParameterIsNotNull((Object)realm, (String)"realm");
            Intrinsics.checkParameterIsNotNull((Object)nonce, (String)"nonce");
            Intrinsics.checkParameterIsNotNull(domain, (String)"domain");
            Intrinsics.checkParameterIsNotNull((Object)algorithm, (String)"algorithm");
            String string = AuthScheme.INSTANCE.getDigest();
            LinkedHashMap<String, String> $receiver = linkedHashMap2 = (linkedHashMap = new LinkedHashMap<String, String>());
            $receiver.put("realm", realm);
            $receiver.put("nonce", nonce);
            Collection collection = domain;
            if (!collection.isEmpty()) {
                $receiver.put("domain", CollectionsKt.joinToString$default((Iterable)domain, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            }
            if (opaque != null) {
                $receiver.put("opaque", opaque);
            }
            if (stale != null) {
                $receiver.put("stale", String.valueOf(stale));
            }
            $receiver.put("algorithm", algorithm);
            linkedHashMap = linkedHashMap2;
            HeaderValueEncoding headerValueEncoding = HeaderValueEncoding.QUOTED_ALWAYS;
            Map map = linkedHashMap;
            String string2 = string;
            return new Parameterized(string2, map, headerValueEncoding);
        }

        @NotNull
        public static /* synthetic */ Parameterized digestAuthChallenge$default(Companion companion, String string, String string2, List list, String string3, Boolean bl, String string4, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = CryptoKt.generateNonce();
            }
            if ((n & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                bl = null;
            }
            if ((n & 0x20) != 0) {
                string4 = "MD5";
            }
            return companion.digestAuthChallenge(string, string2, list, string3, bl, string4);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

