/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.auth.jwt;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.impl.JWTParser;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Payload;
import io.ktor.application.ApplicationCall;
import io.ktor.auth.Authentication;
import io.ktor.auth.AuthenticationContext;
import io.ktor.auth.AuthenticationFailedCause;
import io.ktor.auth.AuthenticationPipeline;
import io.ktor.auth.AuthenticationProcedureChallenge;
import io.ktor.auth.AuthenticationProvider;
import io.ktor.auth.HeadersKt;
import io.ktor.auth.HttpAuthHeader;
import io.ktor.auth.Principal;
import io.ktor.auth.UnauthorizedResponse;
import io.ktor.auth.jwt.JWTAuthKt;
import io.ktor.auth.jwt.JWTAuthSchemes;
import io.ktor.auth.jwt.JWTAuthenticationProvider;
import io.ktor.auth.jwt.JWTCredential;
import io.ktor.request.ApplicationRequest;
import io.ktor.util.pipeline.PipelineContext;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u009e\u0001\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a,\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001af\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2/\u0010\u0014\u001a+\b\u0001\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0015\u00a2\u0006\u0002\b\u0018H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019\u001a\u001c\u0010\u001a\u001a\u00020\t*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a$\u0010\u001d\u001a\u00020\u001e*\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0016\u0010\"\u001a\u0004\u0018\u00010\r*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a/\u0010#\u001a\u00020\u001e*\u00020$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\r2\u0017\u0010&\u001a\u0013\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u001e0'\u00a2\u0006\u0002\b\u0018\u001aR\u0010)\u001a\u00020\u001e*\u00020$2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2$\u0010\u0014\u001a \b\u0001\u0012\u0004\u0012\u00020\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00010*H\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+\u001aJ\u0010)\u001a\u00020\u001e*\u00020$2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\r2$\u0010\u0014\u001a \b\u0001\u0012\u0004\u0012\u00020\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00010*H\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,\u001a\f\u0010-\u001a\u00020.*\u00020/H\u0000\u001a\u000e\u00100\u001a\u0004\u0018\u00010\t*\u000201H\u0002\u001a\f\u00102\u001a\u000203*\u000204H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00065"}, d2={"JWTAuthKey", "", "JWTLogger", "Lorg/slf4j/Logger;", "getVerifier", "Lcom/auth0/jwt/JWTVerifier;", "jwkProvider", "Lcom/auth0/jwk/JwkProvider;", "token", "Lio/ktor/auth/HttpAuthHeader;", "schemes", "Lio/ktor/auth/jwt/JWTAuthSchemes;", "issuer", "", "getVerifierNullableIssuer", "verifyAndValidate", "Lio/ktor/auth/Principal;", "call", "Lio/ktor/application/ApplicationCall;", "jwtVerifier", "validate", "Lkotlin/Function3;", "Lio/ktor/auth/jwt/JWTCredential;", "Lkotlin/coroutines/Continuation;", "Lkotlin/ExtensionFunctionType;", "(Lio/ktor/application/ApplicationCall;Lcom/auth0/jwt/JWTVerifier;Lio/ktor/auth/HttpAuthHeader;Lio/ktor/auth/jwt/JWTAuthSchemes;Lkotlin/jvm/functions/Function3;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "bearerAuthChallenge", "Lio/ktor/auth/HttpAuthHeader$Companion;", "realm", "bearerChallenge", "", "Lio/ktor/auth/AuthenticationContext;", "cause", "Lio/ktor/auth/AuthenticationFailedCause;", "getBlob", "jwt", "Lio/ktor/auth/Authentication$Configuration;", "name", "configure", "Lkotlin/Function1;", "Lio/ktor/auth/jwt/JWTAuthenticationProvider;", "jwtAuthentication", "Lkotlin/Function2;", "(Lio/ktor/auth/Authentication$Configuration;Lcom/auth0/jwk/JwkProvider;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "(Lio/ktor/auth/Authentication$Configuration;Lcom/auth0/jwt/JWTVerifier;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "makeAlgorithm", "Lcom/auth0/jwt/algorithms/Algorithm;", "Lcom/auth0/jwk/Jwk;", "parseAuthorizationHeaderOrNull", "Lio/ktor/request/ApplicationRequest;", "parsePayload", "Lcom/auth0/jwt/interfaces/Payload;", "Lcom/auth0/jwt/interfaces/DecodedJWT;", "ktor-auth-jwt"})
public final class JWTAuthKt {
    private static final Object JWTAuthKey = "JWTAuth";
    private static final Logger JWTLogger;

    public static final void jwt(@NotNull Authentication.Configuration $receiver, @Nullable String name, @NotNull Function1<? super JWTAuthenticationProvider, Unit> configure) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(configure, (String)"configure");
        JWTAuthenticationProvider jWTAuthenticationProvider = new JWTAuthenticationProvider(name);
        configure.invoke((Object)jWTAuthenticationProvider);
        JWTAuthenticationProvider provider = jWTAuthenticationProvider;
        String realm = provider.getRealm();
        Function3<ApplicationCall, JWTCredential, Continuation<? super Principal>, Object> authenticate = provider.getAuthenticationFunction$ktor_auth_jwt();
        Function1<HttpAuthHeader, JWTVerifier> verifier2 = provider.getVerifier$ktor_auth_jwt();
        JWTAuthSchemes schemes = provider.getSchemes$ktor_auth_jwt();
        provider.getPipeline().intercept(AuthenticationPipeline.Companion.getRequestAuthentication(), (Function3)new Function3<PipelineContext<AuthenticationContext, ApplicationCall>, AuthenticationContext, Continuation<? super Unit>, Object>(realm, schemes, verifier2, authenticate, null){
            private PipelineContext p$;
            private AuthenticationContext p$0;
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ String $realm;
            final /* synthetic */ JWTAuthSchemes $schemes;
            final /* synthetic */ Function1 $verifier;
            final /* synthetic */ Function3 $authenticate;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object result) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        v0 = result;
                        if (v0 instanceof Result.Failure) {
                            throw ((Result.Failure)v0).exception;
                        }
                        var2_3 = this.p$;
                        var3_4 = this.p$0;
                        $receiver$iv = var2_3;
                        token = JWTAuthKt.access$parseAuthorizationHeaderOrNull(((ApplicationCall)$receiver$iv.getContext()).getRequest());
                        if (token == null) {
                            JWTAuthKt.access$bearerChallenge(var3_4, (AuthenticationFailedCause)AuthenticationFailedCause.NoCredentials.INSTANCE, this.$realm, this.$schemes);
                            return Unit.INSTANCE;
                        }
                        $receiver$iv = var2_3;
                        this.L$0 = var3_4;
                        this.L$1 = token;
                        this.label = 1;
                        v1 = JWTAuthKt.verifyAndValidate((ApplicationCall)$receiver$iv.getContext(), (JWTVerifier)this.$verifier.invoke((Object)token), token, this.$schemes, (Function3<? super ApplicationCall, ? super JWTCredential, ? super Continuation<? super Principal>, ? extends Object>)this.$authenticate, (Continuation<? super Principal>)this);
                        ** if (v1 != var8_2) goto lbl23
lbl22:
                        // 1 sources

                        return var8_2;
lbl23:
                        // 1 sources

                        ** GOTO lbl32
                    }
                    case 1: {
                        token = (HttpAuthHeader)this.L$1;
                        var3_4 = (AuthenticationContext)this.L$0;
                        try {
                            v2 = result;
                            if (v2 instanceof Result.Failure) {
                                throw ((Result.Failure)v2).exception;
                            }
                            v1 = result;
lbl32:
                            // 2 sources

                            if ((principal = (Principal)v1) != null) {
                                var3_4.principal(principal);
                            } else {
                                JWTAuthKt.access$bearerChallenge(var3_4, (AuthenticationFailedCause)AuthenticationFailedCause.InvalidCredentials.INSTANCE, this.$realm, this.$schemes);
                            }
                        }
                        catch (Throwable cause) {
                            v3 = cause.getMessage();
                            if (v3 == null) {
                                v3 = cause.getClass().getSimpleName();
                            }
                            message = v3;
                            JWTAuthKt.access$getJWTLogger$p().trace("JWT verification failed: {}", (Object)message);
                            v4 = JWTAuthKt.access$getJWTAuthKey$p();
                            v5 = message;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"message");
                            var3_4.error(v4, (AuthenticationFailedCause)new AuthenticationFailedCause.Error(v5));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$realm = string;
                this.$schemes = jWTAuthSchemes;
                this.$verifier = function1;
                this.$authenticate = function3;
                super(3, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull PipelineContext<AuthenticationContext, ApplicationCall> $receiver, @NotNull AuthenticationContext context, @NotNull Continuation<? super Unit> continuation) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                Function3<PipelineContext<AuthenticationContext, ApplicationCall>, AuthenticationContext, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                PipelineContext<AuthenticationContext, ApplicationCall> pipelineContext = function3.p$ = $receiver;
                AuthenticationContext authenticationContext = function3.p$0 = context;
                return function3;
            }

            public final Object invoke(Object object, Object object2, Object object3) {
                return (this.create((PipelineContext<AuthenticationContext, ApplicationCall>)((PipelineContext)object), (AuthenticationContext)object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
            }
        });
        $receiver.register((AuthenticationProvider)provider);
    }

    public static /* synthetic */ void jwt$default(Authentication.Configuration configuration, String string, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        JWTAuthKt.jwt(configuration, string, (Function1<? super JWTAuthenticationProvider, Unit>)function1);
    }

    private static final void bearerChallenge(@NotNull AuthenticationContext $receiver, AuthenticationFailedCause cause, String realm, JWTAuthSchemes schemes) {
        $receiver.challenge(JWTAuthKey, cause, (Function3)new Function3<PipelineContext<AuthenticationProcedureChallenge, ApplicationCall>, AuthenticationProcedureChallenge, Continuation<? super Unit>, Object>(realm, schemes, null){
            private PipelineContext p$;
            private AuthenticationProcedureChallenge p$0;
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ String $realm;
            final /* synthetic */ JWTAuthSchemes $schemes;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object result) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        v0 = result;
                        if (v0 instanceof Result.Failure) {
                            throw ((Result.Failure)v0).exception;
                        }
                        var2_3 = this.p$;
                        var3_4 = this.p$0;
                        $receiver$iv = var2_3;
                        $receiver$iv = (ApplicationCall)$receiver$iv.getContext();
                        $i$f$getCall = new UnauthorizedResponse(new HttpAuthHeader[]{JWTAuthKt.access$bearerAuthChallenge(HttpAuthHeader.Companion, this.$realm, this.$schemes)});
                        var6_9 = this;
                        this.L$0 = var3_4;
                        this.L$1 = $receiver$iv;
                        this.L$2 = message$iv;
                        this.label = 1;
                        v1 = $receiver$iv.getResponse().getPipeline().execute((Object)$receiver$iv, (Object)message$iv, (Continuation)var6_9);
                        if (v1 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl29
                    }
                    case 1: {
                        message$iv = (UnauthorizedResponse)this.L$2;
                        $receiver$iv = (ApplicationCall)this.L$1;
                        var3_4 = (AuthenticationProcedureChallenge)this.L$0;
                        v2 = result;
                        if (v2 instanceof Result.Failure) {
                            throw ((Result.Failure)v2).exception;
                        }
                        v1 = result;
lbl29:
                        // 2 sources

                        var3_4.complete();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$realm = string;
                this.$schemes = jWTAuthSchemes;
                super(3, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull PipelineContext<AuthenticationProcedureChallenge, ApplicationCall> $receiver, @NotNull AuthenticationProcedureChallenge it, @NotNull Continuation<? super Unit> continuation) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                Function3<PipelineContext<AuthenticationProcedureChallenge, ApplicationCall>, AuthenticationProcedureChallenge, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                PipelineContext<AuthenticationProcedureChallenge, ApplicationCall> pipelineContext = function3.p$ = $receiver;
                AuthenticationProcedureChallenge authenticationProcedureChallenge = function3.p$0 = it;
                return function3;
            }

            public final Object invoke(Object object, Object object2, Object object3) {
                return (this.create((PipelineContext<AuthenticationProcedureChallenge, ApplicationCall>)((PipelineContext)object), (AuthenticationProcedureChallenge)object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final JWTVerifier getVerifierNullableIssuer(JwkProvider jwkProvider, String issuer, HttpAuthHeader token, JWTAuthSchemes schemes) {
        Object object;
        String string;
        block10: {
            block9: {
                Jwk jwk;
                String string2;
                string = JWTAuthKt.getBlob(token, schemes);
                if (string == null) break block9;
                String blob = string2 = string;
                try {
                    DecodedJWT decodedJWT = JWT.decode((String)blob);
                    Intrinsics.checkExpressionValueIsNotNull((Object)decodedJWT, (String)"JWT.decode(blob)");
                    jwk = jwkProvider.get(decodedJWT.getKeyId());
                }
                catch (JwkException ex) {
                    JWTLogger.trace("Failed to get JWK: {}", (Object)ex.getMessage());
                    jwk = null;
                }
                catch (JWTDecodeException ex) {
                    JWTLogger.trace("Illegal JWT: {}", (Object)ex.getMessage());
                    jwk = null;
                }
                Jwk jwk2 = jwk;
                string = jwk2;
                if (jwk2 != null) break block10;
            }
            return null;
        }
        String jwk = string;
        try {
            object = JWTAuthKt.makeAlgorithm((Jwk)jwk);
        }
        catch (Throwable cause) {
            String string3 = jwk.getAlgorithm();
            String string4 = cause.getMessage();
            if (string4 == null) {
                string4 = cause.getClass().getSimpleName();
            }
            JWTLogger.trace("Failed to create algorithm {}: {}", (Object)string3, (Object)string4);
            return null;
        }
        Algorithm algorithm = object;
        object = issuer;
        return object == null ? JWT.require((Algorithm)algorithm).build() : JWT.require((Algorithm)algorithm).withIssuer(issuer).build();
    }

    private static final JWTVerifier getVerifier(JwkProvider jwkProvider, String issuer, HttpAuthHeader token, JWTAuthSchemes schemes) {
        return JWTAuthKt.getVerifierNullableIssuer(jwkProvider, issuer, token, schemes);
    }

    private static final JWTVerifier getVerifier(JwkProvider jwkProvider, HttpAuthHeader token, JWTAuthSchemes schemes) {
        return JWTAuthKt.getVerifierNullableIssuer(jwkProvider, null, token, schemes);
    }

    @Nullable
    static final /* synthetic */ Object verifyAndValidate(@NotNull ApplicationCall call, @Nullable JWTVerifier jwtVerifier, @NotNull HttpAuthHeader token, @NotNull JWTAuthSchemes schemes, @NotNull Function3<? super ApplicationCall, ? super JWTCredential, ? super Continuation<? super Principal>, ? extends Object> validate, @NotNull Continuation<? super Principal> continuation) {
        String string;
        try {
            Object object;
            String string2 = JWTAuthKt.getBlob(token, schemes);
            if (string2 != null) {
                String it = string = string2;
                JWTVerifier jWTVerifier = jwtVerifier;
                object = jWTVerifier != null ? jWTVerifier.verify(it) : null;
            } else {
                object = null;
            }
            string = object;
        }
        catch (JWTVerificationException ex) {
            JWTLogger.trace("Token verification failed: {}", (Object)ex.getMessage());
            string = null;
        }
        String string3 = string;
        if (string3 == null) {
            return null;
        }
        String jwt2 = string3;
        Payload payload = JWTAuthKt.parsePayload((DecodedJWT)jwt2);
        JWTCredential credentials = new JWTCredential(payload);
        return validate.invoke((Object)call, (Object)credentials, continuation);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getBlob(@NotNull HttpAuthHeader $receiver, JWTAuthSchemes schemes) {
        if (!($receiver instanceof HttpAuthHeader.Single)) return null;
        String string = $receiver.getAuthScheme();
        JWTAuthSchemes jWTAuthSchemes = schemes;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        if (!jWTAuthSchemes.contains(string4)) return null;
        String string5 = ((HttpAuthHeader.Single)$receiver).getBlob();
        return string5;
    }

    private static final HttpAuthHeader parseAuthorizationHeaderOrNull(@NotNull ApplicationRequest $receiver) {
        HttpAuthHeader httpAuthHeader;
        try {
            httpAuthHeader = HeadersKt.parseAuthorizationHeader((ApplicationRequest)$receiver);
        }
        catch (IllegalArgumentException ex) {
            JWTLogger.trace("Illegal HTTP auth header", (Throwable)ex);
            httpAuthHeader = null;
        }
        return httpAuthHeader;
    }

    private static final HttpAuthHeader bearerAuthChallenge(@NotNull HttpAuthHeader.Companion $receiver, String realm, JWTAuthSchemes schemes) {
        return (HttpAuthHeader)new HttpAuthHeader.Parameterized(schemes.getDefaultScheme(), MapsKt.mapOf((Pair)TuplesKt.to((Object)HttpAuthHeader.Parameters.INSTANCE.getRealm(), (Object)realm)), null, 4, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Algorithm makeAlgorithm(@NotNull Jwk $receiver) {
        Algorithm algorithm;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = $receiver.getAlgorithm();
        if (string != null) {
            switch (string) {
                case "RS256": {
                    PublicKey publicKey = $receiver.getPublicKey();
                    if (publicKey == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
                    }
                    Algorithm algorithm2 = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)publicKey), null);
                    algorithm = algorithm2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)algorithm2, (String)"Algorithm.RSA256(publicKey as RSAPublicKey, null)");
                    return algorithm;
                }
                case "RS384": {
                    PublicKey publicKey = $receiver.getPublicKey();
                    if (publicKey == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
                    }
                    Algorithm algorithm3 = Algorithm.RSA384((RSAPublicKey)((RSAPublicKey)publicKey), null);
                    algorithm = algorithm3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)algorithm3, (String)"Algorithm.RSA384(publicKey as RSAPublicKey, null)");
                    return algorithm;
                }
                case "RS512": {
                    PublicKey publicKey = $receiver.getPublicKey();
                    if (publicKey == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
                    }
                    Algorithm algorithm4 = Algorithm.RSA512((RSAPublicKey)((RSAPublicKey)publicKey), null);
                    algorithm = algorithm4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)algorithm4, (String)"Algorithm.RSA512(publicKey as RSAPublicKey, null)");
                    return algorithm;
                }
                case "ES256": {
                    PublicKey publicKey = $receiver.getPublicKey();
                    if (publicKey == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
                    }
                    Algorithm algorithm5 = Algorithm.ECDSA256((ECPublicKey)((ECPublicKey)publicKey), null);
                    algorithm = algorithm5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)algorithm5, (String)"Algorithm.ECDSA256(publicKey as ECPublicKey, null)");
                    return algorithm;
                }
                case "ES384": {
                    PublicKey publicKey = $receiver.getPublicKey();
                    if (publicKey == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
                    }
                    Algorithm algorithm6 = Algorithm.ECDSA384((ECPublicKey)((ECPublicKey)publicKey), null);
                    algorithm = algorithm6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)algorithm6, (String)"Algorithm.ECDSA384(publicKey as ECPublicKey, null)");
                    return algorithm;
                }
                case "ES512": {
                    PublicKey publicKey = $receiver.getPublicKey();
                    if (publicKey == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
                    }
                    Algorithm algorithm7 = Algorithm.ECDSA512((ECPublicKey)((ECPublicKey)publicKey), null);
                    algorithm = algorithm7;
                    Intrinsics.checkExpressionValueIsNotNull((Object)algorithm7, (String)"Algorithm.ECDSA512(publicKey as ECPublicKey, null)");
                    return algorithm;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Unsupported algorithm " + $receiver.getAlgorithm());
                }
            }
        }
        PublicKey publicKey = $receiver.getPublicKey();
        if (publicKey == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
        }
        Algorithm algorithm8 = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)publicKey), null);
        algorithm = algorithm8;
        Intrinsics.checkExpressionValueIsNotNull((Object)algorithm8, (String)"Algorithm.RSA256(publicKey as RSAPublicKey, null)");
        return algorithm;
    }

    private static final Payload parsePayload(@NotNull DecodedJWT $receiver) {
        byte[] byArray = Base64.getUrlDecoder().decode($receiver.getPayload());
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.getUrlDecoder().decode(payload)");
        byte[] byArray2 = byArray;
        String payloadString = new String(byArray2, Charsets.UTF_8);
        Payload payload = new JWTParser().parsePayload(payloadString);
        Intrinsics.checkExpressionValueIsNotNull((Object)payload, (String)"JWTParser().parsePayload(payloadString)");
        return payload;
    }

    @Deprecated(message="Use DSL builder form", replaceWith=@ReplaceWith(imports={}, expression="jwt {\n        this.realm = realm\n        this.verifier(jwtVerifier)\n        this.validate(validate)\n    }\n"), level=DeprecationLevel.ERROR)
    public static final void jwtAuthentication(@NotNull Authentication.Configuration $receiver, @NotNull JWTVerifier jwtVerifier, @NotNull String realm, @NotNull Function2<? super JWTCredential, ? super Continuation<? super Principal>, ? extends Object> validate) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)jwtVerifier, (String)"jwtVerifier");
        Intrinsics.checkParameterIsNotNull((Object)realm, (String)"realm");
        Intrinsics.checkParameterIsNotNull(validate, (String)"validate");
        JWTAuthKt.jwt$default($receiver, null, (Function1)new Function1<JWTAuthenticationProvider, Unit>(realm, jwtVerifier, validate){
            final /* synthetic */ String $realm;
            final /* synthetic */ JWTVerifier $jwtVerifier;
            final /* synthetic */ Function2 $validate;

            public final void invoke(@NotNull JWTAuthenticationProvider $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                $receiver.setRealm(this.$realm);
                $receiver.verifier(this.$jwtVerifier);
                $receiver.validate((Function3<? super ApplicationCall, ? super JWTCredential, ? super Continuation<? super Principal>, ? extends Object>)((Function3)new Function3<ApplicationCall, JWTCredential, Continuation<? super Principal>, Object>(this, null){
                    private ApplicationCall p$;
                    private JWTCredential p$0;
                    int label;
                    final /* synthetic */ jwtAuthentication.1 this$0;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Object object2 = result;
                                if (object2 instanceof Result.Failure) {
                                    throw ((Result.Failure)object2).exception;
                                }
                                ApplicationCall applicationCall = this.p$;
                                JWTCredential jWTCredential = this.p$0;
                                this.label = 1;
                                Object object3 = this.this$0.$validate.invoke((Object)jWTCredential, (Object)((Object)this));
                                if (object3 != object) return object3;
                                return object;
                            }
                            case 1: {
                                Object object4 = result;
                                if (object4 instanceof Result.Failure) {
                                    throw ((Result.Failure)object4).exception;
                                }
                                Object object3 = result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        super(3, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull ApplicationCall $receiver, @NotNull JWTCredential it, @NotNull Continuation<? super Principal> continuation) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                        Function3<ApplicationCall, JWTCredential, Continuation<? super Principal>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        ApplicationCall applicationCall = function3.p$ = $receiver;
                        JWTCredential jWTCredential = function3.p$0 = it;
                        return function3;
                    }

                    public final Object invoke(Object object, Object object2, Object object3) {
                        return (this.create((ApplicationCall)object, (JWTCredential)object2, (Continuation<? super Principal>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            {
                this.$realm = string;
                this.$jwtVerifier = jWTVerifier;
                this.$validate = function2;
                super(1);
            }
        }, 1, null);
    }

    @Deprecated(message="Use DSL builder form", replaceWith=@ReplaceWith(imports={}, expression="jwt {\n        this.realm = realm\n        this.verifier(jwkProvider, issuer)\n        this.validate(validate)\n    }\n"), level=DeprecationLevel.ERROR)
    public static final void jwtAuthentication(@NotNull Authentication.Configuration $receiver, @NotNull JwkProvider jwkProvider, @NotNull String issuer, @NotNull String realm, @NotNull Function2<? super JWTCredential, ? super Continuation<? super Principal>, ? extends Object> validate) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)jwkProvider, (String)"jwkProvider");
        Intrinsics.checkParameterIsNotNull((Object)issuer, (String)"issuer");
        Intrinsics.checkParameterIsNotNull((Object)realm, (String)"realm");
        Intrinsics.checkParameterIsNotNull(validate, (String)"validate");
        JWTAuthKt.jwt$default($receiver, null, (Function1)new Function1<JWTAuthenticationProvider, Unit>(realm, jwkProvider, issuer, validate){
            final /* synthetic */ String $realm;
            final /* synthetic */ JwkProvider $jwkProvider;
            final /* synthetic */ String $issuer;
            final /* synthetic */ Function2 $validate;

            public final void invoke(@NotNull JWTAuthenticationProvider $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                $receiver.setRealm(this.$realm);
                $receiver.verifier(this.$jwkProvider, this.$issuer);
                $receiver.validate((Function3<? super ApplicationCall, ? super JWTCredential, ? super Continuation<? super Principal>, ? extends Object>)((Function3)new Function3<ApplicationCall, JWTCredential, Continuation<? super Principal>, Object>(this, null){
                    private ApplicationCall p$;
                    private JWTCredential p$0;
                    int label;
                    final /* synthetic */ jwtAuthentication.2 this$0;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Object object2 = result;
                                if (object2 instanceof Result.Failure) {
                                    throw ((Result.Failure)object2).exception;
                                }
                                ApplicationCall applicationCall = this.p$;
                                JWTCredential jWTCredential = this.p$0;
                                this.label = 1;
                                Object object3 = this.this$0.$validate.invoke((Object)jWTCredential, (Object)((Object)this));
                                if (object3 != object) return object3;
                                return object;
                            }
                            case 1: {
                                Object object4 = result;
                                if (object4 instanceof Result.Failure) {
                                    throw ((Result.Failure)object4).exception;
                                }
                                Object object3 = result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        super(3, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull ApplicationCall $receiver, @NotNull JWTCredential it, @NotNull Continuation<? super Principal> continuation) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                        Function3<ApplicationCall, JWTCredential, Continuation<? super Principal>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        ApplicationCall applicationCall = function3.p$ = $receiver;
                        JWTCredential jWTCredential = function3.p$0 = it;
                        return function3;
                    }

                    public final Object invoke(Object object, Object object2, Object object3) {
                        return (this.create((ApplicationCall)object, (JWTCredential)object2, (Continuation<? super Principal>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            {
                this.$realm = string;
                this.$jwkProvider = jwkProvider;
                this.$issuer = string2;
                this.$validate = function2;
                super(1);
            }
        }, 1, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)"io.ktor.auth.jwt");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(\"io.ktor.auth.jwt\")");
        JWTLogger = logger;
    }

    @Nullable
    public static final /* synthetic */ JWTVerifier access$getVerifier(@NotNull JwkProvider jwkProvider, @NotNull String issuer, @NotNull HttpAuthHeader token, @NotNull JWTAuthSchemes schemes) {
        return JWTAuthKt.getVerifier(jwkProvider, issuer, token, schemes);
    }

    @Nullable
    public static final /* synthetic */ JWTVerifier access$getVerifier(@NotNull JwkProvider jwkProvider, @NotNull HttpAuthHeader token, @NotNull JWTAuthSchemes schemes) {
        return JWTAuthKt.getVerifier(jwkProvider, token, schemes);
    }

    @Nullable
    public static final /* synthetic */ HttpAuthHeader access$parseAuthorizationHeaderOrNull(@NotNull ApplicationRequest $receiver) {
        return JWTAuthKt.parseAuthorizationHeaderOrNull($receiver);
    }

    public static final /* synthetic */ void access$bearerChallenge(@NotNull AuthenticationContext $receiver, @NotNull AuthenticationFailedCause cause, @NotNull String realm, @NotNull JWTAuthSchemes schemes) {
        JWTAuthKt.bearerChallenge($receiver, cause, realm, schemes);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getJWTLogger$p() {
        return JWTLogger;
    }

    @NotNull
    public static final /* synthetic */ Object access$getJWTAuthKey$p() {
        return JWTAuthKey;
    }

    @NotNull
    public static final /* synthetic */ HttpAuthHeader access$bearerAuthChallenge(@NotNull HttpAuthHeader.Companion $receiver, @NotNull String realm, @NotNull JWTAuthSchemes schemes) {
        return JWTAuthKt.bearerAuthChallenge($receiver, realm, schemes);
    }
}

