/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.signers;

import io.ethers.core.FastHex;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.Signature;
import io.ethers.crypto.Hashing;
import io.ethers.crypto.Secp256k1;
import io.ethers.signers.Signer;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0004\u0010\fJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lio/ethers/signers/PrivateKeySigner;", "Lio/ethers/signers/Signer;", "signingKey", "Lio/ethers/crypto/Secp256k1$SigningKey;", "<init>", "(Lio/ethers/crypto/Secp256k1$SigningKey;)V", "privateKey", "", "(Ljava/lang/String;)V", "Lio/ethers/core/types/Bytes;", "(Lio/ethers/core/types/Bytes;)V", "", "([B)V", "getSigningKey", "()Lio/ethers/crypto/Secp256k1$SigningKey;", "address", "Lio/ethers/core/types/Address;", "getAddress", "()Lio/ethers/core/types/Address;", "signHash", "Lio/ethers/core/types/Signature;", "hash", "toString", "equals", "", "other", "", "hashCode", "", "Companion", "ethers-signers"})
public final class PrivateKeySigner
implements Signer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Secp256k1.SigningKey signingKey;
    @NotNull
    private final Address address;

    public PrivateKeySigner(@NotNull Secp256k1.SigningKey signingKey) {
        this.signingKey = signingKey;
        this.address = new Address(Secp256k1.INSTANCE.publicKeyToAddress(this.signingKey.getPublicKey()));
    }

    @NotNull
    public final Secp256k1.SigningKey getSigningKey() {
        return this.signingKey;
    }

    @Override
    @NotNull
    public Address getAddress() {
        return this.address;
    }

    public PrivateKeySigner(@NotNull String privateKey) {
        this(PrivateKeySigner.Companion.validHexToKey(privateKey));
    }

    public PrivateKeySigner(@NotNull Bytes privateKey) {
        this(PrivateKeySigner.Companion.validByteArrayToKey(privateKey.asByteArray()));
    }

    public PrivateKeySigner(@NotNull byte[] privateKey) {
        this(PrivateKeySigner.Companion.validByteArrayToKey(privateKey));
    }

    @Override
    @NotNull
    public Signature signHash(@NotNull byte[] hash) {
        BigInteger[] sig = this.signingKey.signHash(hash);
        return new Signature(sig[0], sig[1], sig[2].longValue());
    }

    @NotNull
    public String toString() {
        return "PrivateKeySigner(address=" + this.getAddress() + ")";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.signers.PrivateKeySigner");
        PrivateKeySigner cfr_ignored_0 = (PrivateKeySigner)other;
        return Intrinsics.areEqual((Object)this.signingKey, (Object)((PrivateKeySigner)other).signingKey);
    }

    @Override
    public int hashCode() {
        return this.signingKey.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final PrivateKeySigner random() {
        return Companion.random();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lio/ethers/signers/PrivateKeySigner$Companion;", "", "<init>", "()V", "validHexToKey", "Lio/ethers/crypto/Secp256k1$SigningKey;", "hex", "", "validByteArrayToKey", "bytes", "", "random", "Lio/ethers/signers/PrivateKeySigner;", "ethers-signers"})
    public static final class Companion {
        private Companion() {
        }

        private final Secp256k1.SigningKey validHexToKey(String hex) {
            if (!FastHex.isValidHex((CharSequence)hex)) {
                throw new IllegalArgumentException("Invalid private key format. Should be hex string.");
            }
            return this.validByteArrayToKey(FastHex.decode((CharSequence)hex));
        }

        private final Secp256k1.SigningKey validByteArrayToKey(byte[] bytes) {
            if (bytes.length != 32) {
                throw new IllegalArgumentException("Invalid private key length. Should be exactly 32 bytes, got " + bytes.length);
            }
            return new Secp256k1.SigningKey(bytes);
        }

        @JvmStatic
        @NotNull
        public final PrivateKeySigner random() {
            byte[] privateKey = new byte[32];
            Hashing.secureRandom().nextBytes(privateKey);
            return new PrivateKeySigner(privateKey);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

