/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.providers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import io.ethers.core.Jackson;
import io.ethers.core.JsonParserExtensionsKt;
import io.ethers.core.Result;
import io.ethers.core.ResultKt;
import io.ethers.providers.AsyncExecutor;
import io.ethers.providers.BlockingSubscriptionStream;
import io.ethers.providers.HttpClient;
import io.ethers.providers.JsonRpcClient;
import io.ethers.providers.JsonRpcClientKt;
import io.ethers.providers.RpcClientConfig;
import io.ethers.providers.RpcError;
import io.ethers.providers.SubscriptionStream;
import io.ethers.providers.WsClient;
import io.ethers.providers.types.BatchRpcRequest;
import io.ethers.providers.types.RpcCall;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jctools.queues.MpscUnboundedXaddArrayQueue;
import org.jctools.queues.SpscUnboundedArrayQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0005YZ[\\]B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u001b\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u0017\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002\u00a2\u0006\u0004\b0\u00101J5\u00102\u001a\u00020-\"\b\b\u0000\u00103*\u0002042\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002H3062\u0006\u0010.\u001a\u00020/H\u0002\u00a2\u0006\u0004\b7\u00108J\u0010\u00109\u001a\u00020-2\u0006\u0010:\u001a\u00020\u0003H\u0002J\u0018\u0010;\u001a\u00020-2\u0006\u0010:\u001a\u00020\u00032\u0006\u0010<\u001a\u00020=H\u0002J\"\u0010>\u001a\u00020-2\u0006\u0010?\u001a\u00020\u00112\u0006\u0010@\u001a\u00020=2\b\u0010A\u001a\u0004\u0018\u00010BH\u0002J6\u0010C\u001a\u00020-\"\u0004\b\u0000\u001032\u0006\u0010?\u001a\u00020\u00112\f\u0010D\u001a\b\u0012\u0004\u0012\u0002H30\u00122\u0006\u0010@\u001a\u00020=2\b\u0010A\u001a\u0004\u0018\u00010BH\u0002J6\u0010E\u001a\u00020-\"\u0004\b\u0000\u001032\u0006\u0010?\u001a\u00020\u00112\f\u0010D\u001a\b\u0012\u0004\u0012\u0002H30\u00172\u0006\u0010@\u001a\u00020=2\b\u0010A\u001a\u0004\u0018\u00010BH\u0002J6\u0010F\u001a\u00020-\"\u0004\b\u0000\u001032\u0006\u0010?\u001a\u00020\u00112\f\u0010G\u001a\b\u0012\u0004\u0012\u0002H30\u001a2\u0006\u0010@\u001a\u00020=2\b\u0010A\u001a\u0004\u0018\u00010BH\u0002J\u0010\u0010H\u001a\u00020-2\u0006\u0010I\u001a\u00020=H\u0002J\b\u0010J\u001a\u00020-H\u0016J\u0016\u0010K\u001a\b\u0012\u0004\u0012\u00020*0L2\u0006\u0010M\u001a\u00020NH\u0016JM\u0010D\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H3\u0012\u0004\u0012\u00020B0O0L\"\u0004\b\u0000\u001032\u0006\u0010P\u001a\u00020\u00032\n\u0010Q\u001a\u0006\u0012\u0002\b\u00030R2\u0012\u0010S\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u0002H30TH\u0016\u00a2\u0006\u0002\u0010UJK\u0010V\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H30W\u0012\u0004\u0012\u00020B0O0L\"\u0004\b\u0000\u001032\n\u0010Q\u001a\u0006\u0012\u0002\b\u00030R2\u0012\u0010S\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u0002H30TH\u0016\u00a2\u0006\u0002\u0010XR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0010j\u0012\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00150\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0015`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0016\u001a&\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0010j\u0012\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n  *\u0004\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n  *\u0004\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010%\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lio/ethers/providers/WsClient;", "Lio/ethers/providers/JsonRpcClient;", "url", "", "client", "Lokhttp3/OkHttpClient;", "headers", "", "<init>", "(Ljava/lang/String;Lokhttp3/OkHttpClient;Ljava/util/Map;)V", "config", "Lio/ethers/providers/RpcClientConfig;", "(Ljava/lang/String;Lio/ethers/providers/RpcClientConfig;)V", "LOG", "Lorg/slf4j/Logger;", "inFlightRequests", "Ljava/util/HashMap;", "", "Lio/ethers/providers/WsClient$CompletableRequest;", "Lkotlin/collections/HashMap;", "inFlightBatchRequests", "Lio/ethers/providers/WsClient$CompletableBatchRequest;", "inFlightSubscriptionRequests", "Lio/ethers/providers/WsClient$CompletableSubscriptionRequest;", "requestIdToSubscription", "Ljava/util/concurrent/ConcurrentHashMap;", "Lio/ethers/providers/WsClient$Subscription;", "serverIdToSubscription", "eventLock", "Ljava/util/concurrent/locks/ReentrantLock;", "newEventCondition", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "connectionOpenedCondition", "connectionClosedCondition", "messageQueue", "Lorg/jctools/queues/SpscUnboundedArrayQueue;", "requestQueue", "Lorg/jctools/queues/MpscUnboundedXaddArrayQueue;", "batchRequestQueue", "subscriptionQueue", "reconnect", "", "stopping", "handleTimeouts", "", "timeout", "Lkotlin/time/Duration;", "handleTimeouts-LRDsOJo", "(J)V", "removeTimedOutRequests", "T", "Lio/ethers/providers/WsClient$ExpiringRequest;", "requests", "", "removeTimedOutRequests-HG0u8IE", "(Ljava/util/Map;J)V", "handleMessage", "text", "handleBatchResponse", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "handleResponse", "id", "resultParser", "error", "Lio/ethers/providers/RpcError;", "handleRequestResponse", "request", "handleSubscriptionResponse", "handleResubscriptionResponse", "subscription", "handleNotification", "paramsParser", "close", "requestBatch", "Ljava/util/concurrent/CompletableFuture;", "batch", "Lio/ethers/providers/types/BatchRpcRequest;", "Lio/ethers/core/Result;", "method", "params", "", "resultDecoder", "Ljava/util/function/Function;", "(Ljava/lang/String;[Ljava/lang/Object;Ljava/util/function/Function;)Ljava/util/concurrent/CompletableFuture;", "subscribe", "Lio/ethers/providers/SubscriptionStream;", "([Ljava/lang/Object;Ljava/util/function/Function;)Ljava/util/concurrent/CompletableFuture;", "ExpiringRequest", "CompletableRequest", "CompletableBatchRequest", "CompletableSubscriptionRequest", "Subscription", "ethers-providers"})
@SourceDebugExtension(value={"SMAP\nWsClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WsClient.kt\nio/ethers/providers/WsClient\n+ 2 LoggerExtensions.kt\nio/ethers/logger/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 JsonParserExtensions.kt\nio/ethers/core/JsonParserExtensionsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,778:1\n20#2:779\n63#2,4:783\n27#2,4:805\n27#2,4:809\n27#2,4:813\n54#2,4:823\n54#2,4:827\n27#2,4:831\n81#2,4:835\n36#2,4:839\n36#2,4:843\n36#2,4:847\n36#2,4:851\n36#2,4:855\n27#2,4:859\n27#2,4:863\n27#2,4:867\n81#2,4:871\n27#2,4:877\n1#3:780\n216#4,2:781\n33#5,6:787\n33#5,6:793\n33#5,6:799\n33#5,6:817\n1869#6,2:875\n*S KotlinDebug\n*F\n+ 1 WsClient.kt\nio/ethers/providers/WsClient\n*L\n60#1:779\n379#1:783,4\n574#1:805,4\n610#1:809,4\n631#1:813,4\n669#1:823,4\n145#1:827,4\n172#1:831,4\n177#1:835,4\n186#1:839,4\n229#1:843,4\n241#1:847,4\n253#1:851,4\n263#1:855,4\n285#1:859,4\n312#1:863,4\n327#1:867,4\n347#1:871,4\n596#1:877,4\n90#1:781,2\n398#1:787,6\n469#1:793,6\n514#1:799,6\n637#1:817,6\n356#1:875,2\n*E\n"})
public final class WsClient
implements JsonRpcClient {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final HashMap<Long, CompletableRequest<?>> inFlightRequests;
    @NotNull
    private final HashMap<Long, CompletableBatchRequest> inFlightBatchRequests;
    @NotNull
    private final HashMap<Long, CompletableSubscriptionRequest<?>> inFlightSubscriptionRequests;
    @NotNull
    private final ConcurrentHashMap<Long, Subscription<?>> requestIdToSubscription;
    @NotNull
    private final ConcurrentHashMap<String, Subscription<?>> serverIdToSubscription;
    @NotNull
    private final ReentrantLock eventLock;
    private final Condition newEventCondition;
    private final Condition connectionOpenedCondition;
    private final Condition connectionClosedCondition;
    @NotNull
    private final SpscUnboundedArrayQueue<String> messageQueue;
    @NotNull
    private final MpscUnboundedXaddArrayQueue<CompletableRequest<?>> requestQueue;
    @NotNull
    private final MpscUnboundedXaddArrayQueue<CompletableBatchRequest> batchRequestQueue;
    @NotNull
    private final MpscUnboundedXaddArrayQueue<CompletableSubscriptionRequest<?>> subscriptionQueue;
    private volatile boolean reconnect;
    private volatile boolean stopping;

    public WsClient(@NotNull String url, @NotNull OkHttpClient client, @NotNull Map<String, String> headers) {
        WsClient $this$getLogger$iv = this;
        boolean $i$f$getLogger = false;
        this.LOG = LoggerFactory.getLogger($this$getLogger$iv.getClass());
        this.inFlightRequests = new HashMap();
        this.inFlightBatchRequests = new HashMap();
        this.inFlightSubscriptionRequests = new HashMap();
        this.requestIdToSubscription = new ConcurrentHashMap();
        this.serverIdToSubscription = new ConcurrentHashMap();
        this.eventLock = new ReentrantLock();
        this.newEventCondition = this.eventLock.newCondition();
        this.connectionOpenedCondition = this.eventLock.newCondition();
        this.connectionClosedCondition = this.eventLock.newCondition();
        this.messageQueue = new SpscUnboundedArrayQueue(512);
        this.requestQueue = new MpscUnboundedXaddArrayQueue(512);
        this.batchRequestQueue = new MpscUnboundedXaddArrayQueue(256);
        this.subscriptionQueue = new MpscUnboundedXaddArrayQueue(128);
        Headers.Builder $this$_init__u24lambda_u241 = $i$f$getLogger = new Headers.Builder();
        boolean bl = false;
        Map<String, String> $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            String key = entry.getKey();
            String value = entry.getValue();
            $this$_init__u24lambda_u241.add(key, value);
        }
        Headers requestHeaders = $i$f$getLogger.build();
        Request wsRequest = new Request.Builder().url(url).headers(requestHeaders).build();
        WebSocketListener wsListener2 = new WebSocketListener(this){
            final /* synthetic */ WsClient this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onOpen(WebSocket webSocket, Response response) {
                Logger $this$inf$iv = WsClient.access$getLOG$p(this.this$0);
                boolean $i$f$inf = false;
                if ($this$inf$iv.isInfoEnabled()) {
                    Logger logger = $this$inf$iv;
                    boolean bl = false;
                    logger.info("WebSocket connection opened");
                }
                Lock lock = WsClient.access$getEventLock$p(this.this$0);
                WsClient wsClient = this.this$0;
                lock.lock();
                try {
                    boolean bl = false;
                    WsClient.access$getConnectionOpenedCondition$p(wsClient).signalAll();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(WebSocket webSocket, String text) {
                WsClient.access$getMessageQueue$p(this.this$0).add((Object)text);
                Lock lock = WsClient.access$getEventLock$p(this.this$0);
                WsClient wsClient = this.this$0;
                lock.lock();
                try {
                    boolean bl = false;
                    WsClient.access$getNewEventCondition$p(wsClient).signalAll();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                throw new IOException("Binary messages are not supported");
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                Logger $this$dbg$iv = WsClient.access$getLOG$p(this.this$0);
                boolean $i$f$dbg = false;
                if ($this$dbg$iv.isDebugEnabled()) {
                    Logger logger = $this$dbg$iv;
                    boolean bl = false;
                    logger.debug("WebSocket connection closing: " + code + " " + reason + ". Closing our side as well.");
                }
                webSocket.close(code, reason);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClosed(WebSocket webSocket, int code, String reason) {
                Logger $this$dbg$iv = WsClient.access$getLOG$p(this.this$0);
                boolean $i$f$dbg = false;
                if ($this$dbg$iv.isDebugEnabled()) {
                    Logger logger = $this$dbg$iv;
                    boolean bl = false;
                    logger.debug("WebSocket connection closed: " + code + " " + reason);
                }
                Lock lock = WsClient.access$getEventLock$p(this.this$0);
                WsClient wsClient = this.this$0;
                lock.lock();
                try {
                    boolean bl = false;
                    WsClient.access$getConnectionClosedCondition$p(wsClient).signalAll();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
                this.requestReconnect();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                Lock lock = WsClient.access$getEventLock$p(this.this$0);
                WsClient wsClient = this.this$0;
                lock.lock();
                try {
                    boolean $i$a$-withLock-WsClient$wsListener$1$onFailure$22 = false;
                    WsClient.access$getConnectionClosedCondition$p(wsClient).signalAll();
                    Unit $i$a$-withLock-WsClient$wsListener$1$onFailure$22 = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
                if (WsClient.access$getStopping$p(this.this$0)) {
                    Logger $this$dbg$iv = WsClient.access$getLOG$p(this.this$0);
                    boolean $i$f$dbg = false;
                    if ($this$dbg$iv.isDebugEnabled()) {
                        Logger logger = $this$dbg$iv;
                        boolean bl = false;
                        logger.debug("WebSocket failure ignored because we are stopping", t);
                    }
                    return;
                }
                Logger $this$err$iv = WsClient.access$getLOG$p(this.this$0);
                boolean $i$f$err = false;
                if ($this$err$iv.isErrorEnabled()) {
                    Logger logger = $this$err$iv;
                    boolean bl = false;
                    logger.error("WebSocket failure", t);
                }
                this.requestReconnect();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void requestReconnect() {
                Lock lock = WsClient.access$getEventLock$p(this.this$0);
                WsClient wsClient = this.this$0;
                lock.lock();
                try {
                    boolean bl = false;
                    WsClient.access$setReconnect$p(wsClient, true);
                    WsClient.access$getNewEventCondition$p(wsClient).signalAll();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
        };
        Thread processorThread = AsyncExecutor.INSTANCE.maybeVirtualThread(() -> WsClient._init_$lambda$27(this, client, wsRequest, wsListener2));
        processorThread.setName("WsClient-Processor-" + processorThread.getId());
        processorThread.start();
    }

    public /* synthetic */ WsClient(String string, OkHttpClient okHttpClient, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        this(string, okHttpClient, map);
    }

    @JvmOverloads
    public WsClient(@NotNull String url, @NotNull RpcClientConfig config) {
        OkHttpClient okHttpClient = config.getClient();
        Intrinsics.checkNotNull((Object)okHttpClient);
        this(url, okHttpClient, config.getRequestHeaders());
    }

    public /* synthetic */ WsClient(String string, RpcClientConfig rpcClientConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            rpcClientConfig = new RpcClientConfig();
        }
        this(string, rpcClientConfig);
    }

    private final void handleTimeouts-LRDsOJo(long timeout) {
        this.removeTimedOutRequests-HG0u8IE((Map)this.inFlightRequests, timeout);
        this.removeTimedOutRequests-HG0u8IE((Map)this.inFlightBatchRequests, timeout);
        this.removeTimedOutRequests-HG0u8IE((Map)this.inFlightSubscriptionRequests, timeout);
    }

    private final <T extends ExpiringRequest> void removeTimedOutRequests-HG0u8IE(Map<Long, T> requests, long timeout) {
        if (Duration.getInWholeMilliseconds-impl((long)timeout) < 0L || requests.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<Long, T>> iter = requests.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, T> entry = iter.next();
            if (!((ExpiringRequest)entry.getValue()).expireIfTimedOut-LRDsOJo(timeout)) continue;
            Logger $this$wrn$iv = this.LOG;
            boolean $i$f$wrn = false;
            if ($this$wrn$iv.isWarnEnabled()) {
                Logger logger = $this$wrn$iv;
                boolean bl = false;
                logger.warn("Request timed out: ID " + entry.getKey());
            }
            iter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleMessage(String text) {
        Closeable closeable = (Closeable)Jackson.INSTANCE.createAndInitParser(Jackson.MAPPER, text);
        Throwable throwable = null;
        try {
            block56: {
                Object object;
                TokenBuffer buff;
                Closeable closeable2;
                JsonParser parser = (JsonParser)closeable;
                boolean bl = false;
                if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
                    this.handleBatchResponse(text, parser);
                    return;
                }
                long id = 0L;
                id = -1L;
                String method = null;
                TokenBuffer resultBuffer = null;
                TokenBuffer paramsBuffer = null;
                Object error = null;
                JsonParser $this$forEachObjectField$iv = parser;
                boolean $i$f$forEachObjectField = false;
                while (!JsonParserExtensionsKt.isNextTokenObjectEnd((JsonParser)$this$forEachObjectField$iv)) {
                    String field$iv = $this$forEachObjectField$iv.currentName();
                    $this$forEachObjectField$iv.nextToken();
                    String field = field$iv;
                    boolean bl2 = false;
                    switch (field) {
                        case "id": {
                            id = parser.getLongValue();
                            break;
                        }
                        case "method": {
                            method = parser.getText();
                            break;
                        }
                        case "result": {
                            if (id != -1L) {
                                this.handleResponse(id, parser, (RpcError)error);
                                break block56;
                            }
                            resultBuffer = new TokenBuffer(parser);
                            resultBuffer.copyCurrentStructure(parser);
                            break;
                        }
                        case "params": {
                            if (method != null) {
                                this.handleNotification(parser);
                                break block56;
                            }
                            paramsBuffer = new TokenBuffer(parser);
                            paramsBuffer.copyCurrentStructure(parser);
                            break;
                        }
                        case "error": {
                            error = Jackson.MAPPER.readValue(parser, RpcError.class);
                            break;
                        }
                        default: {
                            throw new Exception("Invalid response: " + text);
                        }
                        case "jsonrpc": {
                            break;
                        }
                    }
                }
                if (method != null && paramsBuffer != null) {
                    closeable2 = (Closeable)paramsBuffer;
                    Throwable throwable2 = null;
                    try {
                        buff = (TokenBuffer)closeable2;
                        boolean bl3 = false;
                        Closeable closeable3 = (Closeable)buff.asParser();
                        object = null;
                        try {
                            JsonParser it = (JsonParser)closeable3;
                            boolean bl4 = false;
                            it.nextToken();
                            this.handleNotification(it);
                            it = Unit.INSTANCE;
                        }
                        catch (Throwable bl4) {
                            object = bl4;
                            throw bl4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable3, (Throwable)object);
                        }
                        buff = Unit.INSTANCE;
                    }
                    catch (Throwable bl3) {
                        throwable2 = bl3;
                        throw bl3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                }
                if (id != -1L && error != null) {
                    this.handleResponse(id, parser, (RpcError)error);
                } else {
                    if (id != -1L && resultBuffer != null) {
                        closeable2 = (Closeable)resultBuffer;
                        Throwable throwable3 = null;
                        try {
                            buff = (TokenBuffer)closeable2;
                            boolean bl5 = false;
                            Closeable closeable4 = (Closeable)buff.asParser();
                            object = null;
                            try {
                                JsonParser it = (JsonParser)closeable4;
                                boolean bl6 = false;
                                it.nextToken();
                                this.handleResponse(id, it, null);
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable4) {
                                object = throwable4;
                                throw throwable4;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable4, (Throwable)object);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable5) {
                            throwable3 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                        }
                    }
                    throw new Exception("Invalid response: " + text);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleBatchResponse(String text, JsonParser p) {
        int responseIndex = 0;
        CompletableBatchRequest batch = null;
        while (!JsonParserExtensionsKt.isNextTokenArrayEnd((JsonParser)p)) {
            boolean bl;
            Object error;
            Object result;
            block50: {
                boolean bl2;
                Object field$iv;
                if (batch != null) break block50;
                result = null;
                error = null;
                TokenBuffer buffer = null;
                JsonParser $this$forEachObjectField$iv = p;
                boolean $i$f$forEachObjectField2 = false;
                while (!JsonParserExtensionsKt.isNextTokenObjectEnd((JsonParser)$this$forEachObjectField$iv)) {
                    field$iv = $this$forEachObjectField$iv.currentName();
                    $this$forEachObjectField$iv.nextToken();
                    String field = field$iv;
                    boolean bl3 = false;
                    switch (field) {
                        case "id": {
                            batch = this.inFlightBatchRequests.remove(p.getLongValue());
                            break;
                        }
                        case "result": {
                            if (batch == null) {
                                buffer = new TokenBuffer(p);
                                buffer.copyCurrentStructure(p);
                                break;
                            }
                            result = ((CompletableBatchRequest)batch).getRequest().getRequests$ethers_providers().get(responseIndex).getResultDecoder().apply(p);
                            break;
                        }
                        case "error": {
                            error = Jackson.MAPPER.readValue(p, RpcError.class);
                            break;
                        }
                        default: {
                            throw new Exception("Invalid response: " + text);
                        }
                        case "jsonrpc": 
                    }
                }
                if (batch == null) {
                    throw new Exception("Invalid response, no matching batch found: " + text);
                }
                TokenBuffer tokenBuffer = buffer;
                if (tokenBuffer != null) {
                    Closeable $i$f$forEachObjectField2 = (Closeable)tokenBuffer;
                    field$iv = null;
                    try {
                        TokenBuffer it = (TokenBuffer)$i$f$forEachObjectField2;
                        boolean bl4 = false;
                        result = ((CompletableBatchRequest)batch).getRequest().getRequests$ethers_providers().get(responseIndex).getResultDecoder().apply(it.asParserOnFirstToken());
                        it = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        field$iv = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)$i$f$forEachObjectField2, (Throwable)field$iv);
                    }
                }
                if (result == null && error == null) {
                    bl2 = ((CompletableBatchRequest)batch).getRequest().getResponses$ethers_providers().get(responseIndex).complete(HttpClient.Companion.getERROR_INVALID_RESPONSE$ethers_providers());
                } else {
                    Result result2;
                    Object v2 = result;
                    if (v2 != null) {
                        result2 = ResultKt.success(v2);
                    } else {
                        Object object = error;
                        Intrinsics.checkNotNull(object);
                        result2 = ResultKt.failure((Result.Error)((Result.Error)object));
                    }
                    Result response = result2;
                    bl2 = ((CompletableBatchRequest)batch).getRequest().getResponses$ethers_providers().get(responseIndex).complete(response);
                }
                int response = responseIndex;
                responseIndex = response + 1;
                continue;
            }
            result = null;
            error = null;
            JsonParser $this$forEachObjectField$iv = p;
            boolean $i$f$forEachObjectField = false;
            while (!JsonParserExtensionsKt.isNextTokenObjectEnd((JsonParser)$this$forEachObjectField$iv)) {
                String field$iv = $this$forEachObjectField$iv.currentName();
                $this$forEachObjectField$iv.nextToken();
                String field = field$iv;
                boolean bl5 = false;
                switch (field) {
                    case "result": {
                        result = ((CompletableBatchRequest)batch).getRequest().getRequests$ethers_providers().get(responseIndex).getResultDecoder().apply(p);
                        break;
                    }
                    case "error": {
                        error = Jackson.MAPPER.readValue(p, RpcError.class);
                        break;
                    }
                    default: {
                        throw new Exception("Invalid response: " + text);
                    }
                    case "id": 
                    case "jsonrpc": 
                }
            }
            if (result == null && error == null) {
                bl = ((CompletableBatchRequest)batch).getRequest().getResponses$ethers_providers().get(responseIndex).complete(HttpClient.Companion.getERROR_INVALID_RESPONSE$ethers_providers());
            } else {
                Result result3;
                Object v6 = result;
                if (v6 != null) {
                    result3 = ResultKt.success(v6);
                } else {
                    Object object = error;
                    Intrinsics.checkNotNull(object);
                    result3 = ResultKt.failure((Result.Error)((Result.Error)object));
                }
                Result response = result3;
                bl = ((CompletableBatchRequest)batch).getRequest().getResponses$ethers_providers().get(responseIndex).complete(response);
            }
            int n = responseIndex;
            responseIndex = n + 1;
        }
        CompletableBatchRequest completableBatchRequest = batch;
        Intrinsics.checkNotNull(completableBatchRequest);
        ((CompletableBatchRequest)completableBatchRequest).getFuture().complete(true);
    }

    private final void handleResponse(long id, JsonParser resultParser, RpcError error) {
        CompletableRequest<?> request2 = this.inFlightRequests.remove(id);
        if (request2 != null) {
            this.handleRequestResponse(id, request2, resultParser, error);
            return;
        }
        CompletableSubscriptionRequest<?> subscriptionRequest = this.inFlightSubscriptionRequests.remove(id);
        if (subscriptionRequest != null) {
            this.handleSubscriptionResponse(id, subscriptionRequest, resultParser, error);
            return;
        }
        Subscription<?> resubscribed = this.requestIdToSubscription.get(id);
        if (resubscribed != null) {
            this.handleResubscriptionResponse(id, resubscribed, resultParser, error);
        }
    }

    private final <T> void handleRequestResponse(long id, CompletableRequest<T> request2, JsonParser resultParser, RpcError error) {
        Result result;
        Object result2;
        Object v0 = result2 = error == null ? request2.getResultDecoder().apply(resultParser) : null;
        if (result2 == null && error == null) {
            result = HttpClient.Companion.getERROR_INVALID_RESPONSE$ethers_providers();
        } else {
            Object v2 = result2;
            if (v2 != null) {
                result = ResultKt.success(v2);
            } else {
                RpcError rpcError = error;
                Intrinsics.checkNotNull((Object)rpcError);
                result = ResultKt.failure((Result.Error)rpcError);
            }
        }
        Result response = result;
        Logger $this$trc$iv = this.LOG;
        boolean $i$f$trc = false;
        if ($this$trc$iv.isTraceEnabled()) {
            Logger logger = $this$trc$iv;
            boolean bl = false;
            logger.trace("Handled response for request " + id + ": " + response);
        }
        request2.getFuture().complete(response);
    }

    private final <T> void handleSubscriptionResponse(long id, CompletableSubscriptionRequest<T> request2, JsonParser resultParser, RpcError error) {
        boolean bl;
        if (error != null) {
            bl = request2.getFuture().complete(ResultKt.failure((Result.Error)error));
        } else {
            Subscription<T> subscription = new Subscription<T>(resultParser.getText(), request2.getParams(), request2.getResultDecoder(), BlockingSubscriptionStream.Companion.singleProducer(() -> WsClient.handleSubscriptionResponse$lambda$40(this, id)));
            Long l = id;
            ((Map)this.requestIdToSubscription).put(l, subscription);
            ((Map)this.serverIdToSubscription).put(subscription.getServerId(), subscription);
            bl = request2.getFuture().complete(ResultKt.success(subscription.getStream()));
        }
        Logger $this$trc$iv = this.LOG;
        boolean $i$f$trc = false;
        if ($this$trc$iv.isTraceEnabled()) {
            Logger logger = $this$trc$iv;
            boolean bl2 = false;
            logger.trace("Handled response for subscription request " + id);
        }
    }

    private final <T> void handleResubscriptionResponse(long id, Subscription<T> subscription, JsonParser resultParser, RpcError error) {
        if (error != null) {
            throw new Exception("Error re-subscribing to stream: " + subscription.getServerId() + ", error: " + error);
        }
        this.serverIdToSubscription.remove(subscription.getServerId());
        subscription.setServerId(resultParser.getText());
        ((Map)this.serverIdToSubscription).put(subscription.getServerId(), subscription);
        Logger $this$trc$iv = this.LOG;
        boolean $i$f$trc = false;
        if ($this$trc$iv.isTraceEnabled()) {
            Logger logger = $this$trc$iv;
            boolean bl = false;
            logger.trace("Handled response for re-subscription request " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleNotification(JsonParser paramsParser) {
        Object object;
        String subscriptionId = null;
        TokenBuffer resultBuff = null;
        JsonParser $this$forEachObjectField$iv = paramsParser;
        boolean $i$f$forEachObjectField = false;
        while (!JsonParserExtensionsKt.isNextTokenObjectEnd((JsonParser)$this$forEachObjectField$iv)) {
            String field$iv = $this$forEachObjectField$iv.currentName();
            $this$forEachObjectField$iv.nextToken();
            String field = field$iv;
            boolean bl = false;
            object = field;
            if (Intrinsics.areEqual((Object)object, (Object)"subscription")) {
                subscriptionId = paramsParser.getText();
                continue;
            }
            if (Intrinsics.areEqual((Object)object, (Object)"result")) {
                if (subscriptionId != null) {
                    Subscription<?> subscription = this.serverIdToSubscription.get(subscriptionId);
                    if (subscription == null) {
                        return;
                    }
                    Subscription<?> subscription2 = subscription;
                    subscription2.handleNotification(paramsParser);
                    return;
                }
                resultBuff = new TokenBuffer(paramsParser);
                resultBuff.copyCurrentStructure(paramsParser);
                continue;
            }
            throw new Exception("Invalid notification: " + paramsParser);
        }
        Subscription subscription = (Subscription)((Map)this.serverIdToSubscription).get(subscriptionId);
        if (subscription == null) {
            return;
        }
        Subscription subscription3 = subscription;
        TokenBuffer tokenBuffer = resultBuff;
        Intrinsics.checkNotNull(tokenBuffer);
        Closeable closeable = (Closeable)tokenBuffer;
        Throwable throwable = null;
        try {
            TokenBuffer buff = (TokenBuffer)closeable;
            boolean bl = false;
            object = (Closeable)buff.asParser();
            Throwable throwable2 = null;
            try {
                JsonParser it = (JsonParser)object;
                boolean bl2 = false;
                it.nextToken();
                subscription3.handleNotification(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Logger $this$inf$iv = this.LOG;
        boolean $i$f$inf = false;
        if ($this$inf$iv.isInfoEnabled()) {
            Logger logger = $this$inf$iv;
            boolean bl = false;
            logger.info("Requesting to close WebSocket");
        }
        this.stopping = true;
        Lock lock = this.eventLock;
        lock.lock();
        try {
            boolean bl = false;
            this.newEventCondition.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletableFuture<Boolean> requestBatch(@NotNull BatchRpcRequest batch) {
        CompletableBatchRequest request2 = new CompletableBatchRequest(batch, new CompletableFuture<Boolean>());
        this.batchRequestQueue.add((Object)request2);
        Lock lock = this.eventLock;
        lock.lock();
        try {
            boolean bl = false;
            this.newEventCondition.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return request2.getFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T> CompletableFuture<Result<T, RpcError>> request(@NotNull String method, @NotNull Object[] params, @NotNull Function<JsonParser, T> resultDecoder) {
        CompletableRequest<T> request2 = new CompletableRequest<T>(method, params, resultDecoder, new CompletableFuture());
        this.requestQueue.add(request2);
        Lock lock = this.eventLock;
        lock.lock();
        try {
            boolean bl = false;
            this.newEventCondition.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return request2.getFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T> CompletableFuture<Result<SubscriptionStream<T>, RpcError>> subscribe(@NotNull Object[] params, @NotNull Function<JsonParser, T> resultDecoder) {
        CompletableSubscriptionRequest<T> request2 = new CompletableSubscriptionRequest<T>(params, resultDecoder, new CompletableFuture());
        this.subscriptionQueue.add(request2);
        Lock lock = this.eventLock;
        lock.lock();
        try {
            boolean bl = false;
            this.newEventCondition.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return request2.getFuture();
    }

    @JvmOverloads
    public WsClient(@NotNull String url) {
        this(url, null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void _init_$lambda$27(WsClient this$0, OkHttpClient $client, Request $wsRequest, wsListener.1 $wsListener) {
        Logger logger;
        Logger $this$inf$iv = this$0.LOG;
        boolean $i$f$inf = false;
        if ($this$inf$iv.isInfoEnabled()) {
            logger = $this$inf$iv;
            boolean bl = false;
            logger.info("Starting WebSocket processor thread and connecting to websocket");
        }
        WebSocket websocket = null;
        Lock lock = this$0.eventLock;
        lock.lock();
        try {
            boolean bl = false;
            websocket = $client.newWebSocket($wsRequest, (WebSocketListener)$wsListener);
            bl = this$0.connectionOpenedCondition.await($client.connectTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        finally {
            lock.unlock();
        }
        long requestId = 0L;
        String msg = null;
        Object request2 = null;
        Object batchRequest = null;
        Object subscriptionRequest = null;
        BufferRecycler bufferRecycler = new BufferRecycler();
        long lastTimeoutCheck = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        while (!this$0.stopping) {
            boolean $i$f$err;
            try {
                Object id3;
                Object it;
                while (true) {
                    Object object = this$0.messageQueue.poll();
                    it = (String)object;
                    boolean bl = false;
                    msg = it;
                    if (object == null) break;
                    Logger $this$trc$iv = this$0.LOG;
                    boolean $i$f$trc = false;
                    if ($this$trc$iv.isTraceEnabled()) {
                        logger = $this$trc$iv;
                        boolean bl2 = false;
                        String string = msg;
                        logger.trace("Processing message: " + (string != null ? StringsKt.removeSuffix((String)string, (CharSequence)System.lineSeparator()) : null));
                    }
                    try {
                        String string = msg;
                        Intrinsics.checkNotNull((Object)string);
                        this$0.handleMessage(string);
                    }
                    catch (Exception e) {
                        Logger $this$err$iv = this$0.LOG;
                        $i$f$err = false;
                        if (!$this$err$iv.isErrorEnabled()) continue;
                        logger = $this$err$iv;
                        boolean bl3 = false;
                        logger.error("Error processing message, skipping: " + msg, (Throwable)e);
                    }
                }
                if (this$0.reconnect) {
                    boolean $i$f$dbg;
                    Iterator iter;
                    boolean reconnectSuccessful = false;
                    while (!reconnectSuccessful && !this$0.stopping) {
                        boolean bl;
                        Object $this$dbg$iv = this$0.LOG;
                        boolean $i$f$dbg2 = false;
                        if ($this$dbg$iv.isDebugEnabled()) {
                            logger = $this$dbg$iv;
                            boolean bl4 = false;
                            logger.debug("Trying to reconnect WebSocket");
                        }
                        $this$dbg$iv = this$0.eventLock;
                        $this$dbg$iv.lock();
                        try {
                            boolean $i$a$-withLock-WsClient$processorThread$1$92 = false;
                            if (websocket.close(1000, "Close")) {
                                this$0.connectionClosedCondition.await();
                            }
                            Unit $i$a$-withLock-WsClient$processorThread$1$92 = Unit.INSTANCE;
                        }
                        finally {
                            $this$dbg$iv.unlock();
                        }
                        this$0.reconnect = false;
                        $this$dbg$iv = this$0.eventLock;
                        $this$dbg$iv.lock();
                        try {
                            bl = false;
                            websocket = $client.newWebSocket($wsRequest, (WebSocketListener)$wsListener);
                            bl = this$0.connectionOpenedCondition.await($client.connectTimeoutMillis(), TimeUnit.MILLISECONDS);
                        }
                        finally {
                            $this$dbg$iv.unlock();
                        }
                        reconnectSuccessful = bl;
                        if (reconnectSuccessful) continue;
                        this$0.handleTimeouts-LRDsOJo(DurationKt.toDuration((long)$client.readTimeoutMillis(), (DurationUnit)DurationUnit.MILLISECONDS));
                        Thread.sleep(2000L);
                    }
                    if (this$0.stopping) break;
                    if (!((Map)this$0.inFlightRequests).isEmpty()) {
                        iter = ((Map)this$0.inFlightRequests).entrySet().iterator();
                        while (iter.hasNext()) {
                            CompletableRequest value = (CompletableRequest)iter.next().getValue();
                            Logger $this$dbg$iv = this$0.LOG;
                            $i$f$dbg = false;
                            if ($this$dbg$iv.isDebugEnabled()) {
                                logger = $this$dbg$iv;
                                boolean bl = false;
                                logger.debug("Re-queued in-flight request: " + value);
                            }
                            this$0.requestQueue.add((Object)value);
                            iter.remove();
                        }
                    }
                    if (!((Map)this$0.inFlightBatchRequests).isEmpty()) {
                        iter = ((Map)this$0.inFlightBatchRequests).entrySet().iterator();
                        while (iter.hasNext()) {
                            CompletableBatchRequest value = (CompletableBatchRequest)iter.next().getValue();
                            Logger $this$dbg$iv = this$0.LOG;
                            $i$f$dbg = false;
                            if ($this$dbg$iv.isDebugEnabled()) {
                                logger = $this$dbg$iv;
                                boolean bl = false;
                                logger.debug("Re-queued in-flight batch request: " + value);
                            }
                            this$0.batchRequestQueue.add((Object)value);
                            iter.remove();
                        }
                    }
                    if (!((Map)this$0.inFlightSubscriptionRequests).isEmpty()) {
                        iter = ((Map)this$0.inFlightSubscriptionRequests).entrySet().iterator();
                        while (iter.hasNext()) {
                            CompletableSubscriptionRequest value = (CompletableSubscriptionRequest)iter.next().getValue();
                            Logger $this$dbg$iv = this$0.LOG;
                            $i$f$dbg = false;
                            if ($this$dbg$iv.isDebugEnabled()) {
                                logger = $this$dbg$iv;
                                boolean bl = false;
                                logger.debug("Re-queued in-flight subscription request: " + value);
                            }
                            this$0.subscriptionQueue.add((Object)value);
                            iter.remove();
                        }
                    }
                    if (!((Map)this$0.requestIdToSubscription).isEmpty()) {
                        for (Map.Entry value : ((Map)this$0.requestIdToSubscription).entrySet()) {
                            long id2 = ((Number)value.getKey()).longValue();
                            Subscription sub = (Subscription)value.getValue();
                            Logger $this$dbg$iv = this$0.LOG;
                            boolean $i$f$dbg3 = false;
                            if ($this$dbg$iv.isDebugEnabled()) {
                                logger = $this$dbg$iv;
                                boolean bl = false;
                                logger.debug("Resent stream re-subscription: " + id2);
                            }
                            SegmentedStringWriter writer = new SegmentedStringWriter(bufferRecycler);
                            Closeable closeable = (Closeable)Jackson.MAPPER.createGenerator((Writer)writer);
                            Throwable bl = null;
                            try {
                                JsonGenerator gen = (JsonGenerator)closeable;
                                boolean bl5 = false;
                                JsonRpcClientKt.writeJsonRpcRequest(gen, "eth_subscribe", id2, sub.getParams());
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable) {
                                bl = throwable;
                                throw throwable;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)bl);
                            }
                            websocket.send(writer.getAndClear());
                        }
                    }
                }
                while (true) {
                    Object reconnectSuccessful = this$0.requestQueue.poll();
                    it = (CompletableRequest)reconnectSuccessful;
                    boolean $i$a$-also-WsClient$processorThread$1$152 = false;
                    request2 = it;
                    if (reconnectSuccessful == null) break;
                    long $i$a$-also-WsClient$processorThread$1$152 = requestId;
                    requestId = $i$a$-also-WsClient$processorThread$1$152 + 1L;
                    long id3 = $i$a$-also-WsClient$processorThread$1$152;
                    SegmentedStringWriter writer = new SegmentedStringWriter(bufferRecycler);
                    Closeable id2 = (Closeable)Jackson.MAPPER.createGenerator((Writer)writer);
                    Throwable $i$f$dbg = null;
                    try {
                        JsonGenerator gen = (JsonGenerator)id2;
                        boolean bl = false;
                        Object object = request2;
                        Intrinsics.checkNotNull((Object)object);
                        JsonRpcClientKt.writeJsonRpcRequest(gen, ((CompletableRequest)object).getMethod(), id3, ((CompletableRequest)request2).getParams());
                        gen = Unit.INSTANCE;
                    }
                    catch (Throwable bl) {
                        $i$f$dbg = bl;
                        throw bl;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)id2, (Throwable)$i$f$dbg);
                    }
                    String req = writer.getAndClear();
                    Logger $this$trc$iv = this$0.LOG;
                    boolean $i$f$trc22 = false;
                    if ($this$trc$iv.isTraceEnabled()) {
                        logger = $this$trc$iv;
                        boolean bl = false;
                        logger.trace("Processing request: " + req);
                    }
                    Long $i$f$trc22 = id3;
                    ((Map)this$0.inFlightRequests).put($i$f$trc22, request2);
                    websocket.send(req);
                }
                while (true) {
                    id3 = this$0.batchRequestQueue.poll();
                    it = (CompletableBatchRequest)id3;
                    boolean $i$a$-also-WsClient$processorThread$1$182 = false;
                    batchRequest = it;
                    if (id3 == null) break;
                    long batchId = 0L;
                    batchId = -1L;
                    SegmentedStringWriter writer = new SegmentedStringWriter(bufferRecycler);
                    Closeable $i$a$-also-WsClient$processorThread$1$182 = (Closeable)Jackson.MAPPER.createGenerator((Writer)writer);
                    Throwable req = null;
                    try {
                        JsonGenerator gen = (JsonGenerator)$i$a$-also-WsClient$processorThread$1$182;
                        boolean bl = false;
                        gen.writeStartArray();
                        Object object = batchRequest;
                        Intrinsics.checkNotNull((Object)object);
                        int n = ((Collection)((CompletableBatchRequest)object).getRequest().getRequests$ethers_providers()).size();
                        for (int i = 0; i < n; ++i) {
                            RpcCall<?> req2 = ((CompletableBatchRequest)batchRequest).getRequest().getRequests$ethers_providers().get(i);
                            long l = requestId;
                            requestId = l + 1L;
                            long id4 = l;
                            if (batchId == -1L) {
                                batchId = id4;
                            }
                            JsonRpcClientKt.writeJsonRpcRequest(gen, req2.getMethod(), id4, req2.getParams());
                        }
                        gen.writeEndArray();
                        gen = Unit.INSTANCE;
                    }
                    catch (Throwable bl) {
                        req = bl;
                        throw bl;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)$i$a$-also-WsClient$processorThread$1$182, (Throwable)req);
                    }
                    String req3 = writer.getAndClear();
                    Logger $this$trc$iv = this$0.LOG;
                    boolean $i$f$trc = false;
                    if ($this$trc$iv.isTraceEnabled()) {
                        logger = $this$trc$iv;
                        boolean bl = false;
                        logger.trace("Processing batch request: " + req3);
                    }
                    ((Map)this$0.inFlightBatchRequests).put(batchId, batchRequest);
                    websocket.send(req3);
                }
                while (true) {
                    id3 = this$0.subscriptionQueue.poll();
                    it = (CompletableSubscriptionRequest)id3;
                    boolean $i$a$-also-WsClient$processorThread$1$212 = false;
                    subscriptionRequest = it;
                    if (id3 == null) break;
                    long $i$a$-also-WsClient$processorThread$1$212 = requestId;
                    requestId = $i$a$-also-WsClient$processorThread$1$212 + 1L;
                    long id2 = $i$a$-also-WsClient$processorThread$1$212;
                    SegmentedStringWriter writer = new SegmentedStringWriter(bufferRecycler);
                    Closeable $this$trc$iv = (Closeable)Jackson.MAPPER.createGenerator((Writer)writer);
                    Throwable $i$f$trc = null;
                    try {
                        JsonGenerator gen = (JsonGenerator)$this$trc$iv;
                        boolean bl = false;
                        Object object = subscriptionRequest;
                        Intrinsics.checkNotNull((Object)object);
                        JsonRpcClientKt.writeJsonRpcRequest(gen, "eth_subscribe", id2, ((CompletableSubscriptionRequest)object).getParams());
                        gen = Unit.INSTANCE;
                    }
                    catch (Throwable bl) {
                        $i$f$trc = bl;
                        throw bl;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)$this$trc$iv, (Throwable)$i$f$trc);
                    }
                    String req = writer.getAndClear();
                    Logger $this$trc$iv2 = this$0.LOG;
                    boolean $i$f$trc32 = false;
                    if ($this$trc$iv2.isTraceEnabled()) {
                        logger = $this$trc$iv2;
                        boolean bl = false;
                        logger.trace("Processing subscription request: " + req);
                    }
                    Long $i$f$trc32 = id2;
                    ((Map)this$0.inFlightSubscriptionRequests).put($i$f$trc32, subscriptionRequest);
                    websocket.send(req);
                }
                if (Duration.compareTo-LRDsOJo((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)lastTimeoutCheck), (long)DurationKt.toDuration((int)1000, (DurationUnit)DurationUnit.MILLISECONDS)) > 0) {
                    this$0.handleTimeouts-LRDsOJo(DurationKt.toDuration((long)$client.readTimeoutMillis(), (DurationUnit)DurationUnit.MILLISECONDS));
                    lastTimeoutCheck = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
                }
                id3 = this$0.eventLock;
                id3.lock();
                try {
                    boolean $i$a$-withLock-WsClient$processorThread$1$242 = false;
                    if (this$0.messageQueue.isEmpty() && this$0.requestQueue.isEmpty() && this$0.batchRequestQueue.isEmpty() && this$0.subscriptionQueue.isEmpty()) {
                        this$0.newEventCondition.await(1L, TimeUnit.SECONDS);
                    }
                    Unit $i$a$-withLock-WsClient$processorThread$1$242 = Unit.INSTANCE;
                }
                finally {
                    id3.unlock();
                }
            }
            catch (Exception e) {
                Logger $this$err$iv = this$0.LOG;
                $i$f$err = false;
                if ($this$err$iv.isErrorEnabled()) {
                    logger = $this$err$iv;
                    boolean bl = false;
                    logger.error("Exception when processing events, reconnecting WebSocket", (Throwable)e);
                }
                this$0.reconnect = true;
            }
        }
        websocket.close(1000, "Close");
        this$0.handleTimeouts-LRDsOJo(Duration.Companion.getZERO-UwyO8pc());
        Iterable $this$forEach$iv = this$0.requestIdToSubscription.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Subscription it = (Subscription)element$iv;
            boolean bl = false;
            it.getStream().unsubscribe();
        }
    }

    private static final void handleSubscriptionResponse$lambda$40(WsClient this$0, long $id) {
        Subscription<?> sub = this$0.requestIdToSubscription.remove($id);
        if (sub != null) {
            Logger $this$trc$iv = this$0.LOG;
            boolean $i$f$trc = false;
            if ($this$trc$iv.isTraceEnabled()) {
                Logger logger = $this$trc$iv;
                boolean bl = false;
                logger.trace("Unsubscribing from stream: " + sub.getServerId());
            }
            this$0.serverIdToSubscription.remove(sub.getServerId());
            Object[] objectArray = new String[]{sub.getServerId()};
            this$0.request("eth_unsubscribe", objectArray, Boolean.TYPE);
        }
    }

    public static final /* synthetic */ Logger access$getLOG$p(WsClient $this) {
        return $this.LOG;
    }

    public static final /* synthetic */ ReentrantLock access$getEventLock$p(WsClient $this) {
        return $this.eventLock;
    }

    public static final /* synthetic */ SpscUnboundedArrayQueue access$getMessageQueue$p(WsClient $this) {
        return $this.messageQueue;
    }

    public static final /* synthetic */ boolean access$getStopping$p(WsClient $this) {
        return $this.stopping;
    }

    public static final /* synthetic */ Condition access$getConnectionOpenedCondition$p(WsClient $this) {
        return $this.connectionOpenedCondition;
    }

    public static final /* synthetic */ Condition access$getNewEventCondition$p(WsClient $this) {
        return $this.newEventCondition;
    }

    public static final /* synthetic */ Condition access$getConnectionClosedCondition$p(WsClient $this) {
        return $this.connectionClosedCondition;
    }

    public static final /* synthetic */ void access$setReconnect$p(WsClient $this, boolean bl) {
        $this.reconnect = bl;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lio/ethers/providers/WsClient$CompletableBatchRequest;", "Lio/ethers/providers/WsClient$ExpiringRequest;", "request", "Lio/ethers/providers/types/BatchRpcRequest;", "future", "Ljava/util/concurrent/CompletableFuture;", "", "<init>", "(Lio/ethers/providers/types/BatchRpcRequest;Ljava/util/concurrent/CompletableFuture;)V", "getRequest", "()Lio/ethers/providers/types/BatchRpcRequest;", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "expireRequest", "", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "ethers-providers"})
    private static final class CompletableBatchRequest
    extends ExpiringRequest {
        @NotNull
        private final BatchRpcRequest request;
        @NotNull
        private final CompletableFuture<Boolean> future;

        public CompletableBatchRequest(@NotNull BatchRpcRequest request2, @NotNull CompletableFuture<Boolean> future) {
            this.request = request2;
            this.future = future;
        }

        @NotNull
        public final BatchRpcRequest getRequest() {
            return this.request;
        }

        @NotNull
        public final CompletableFuture<Boolean> getFuture() {
            return this.future;
        }

        @Override
        public void expireRequest() {
            int n = ((Collection)this.request.getResponses$ethers_providers()).size();
            for (int i = 0; i < n; ++i) {
                CompletableFuture<Result<?, RpcError>> response = this.request.getResponses$ethers_providers().get(i);
                response.complete(HttpClient.Companion.getERROR_CALL_TIMEOUT$ethers_providers());
            }
            this.future.complete(false);
        }

        @NotNull
        public final BatchRpcRequest component1() {
            return this.request;
        }

        @NotNull
        public final CompletableFuture<Boolean> component2() {
            return this.future;
        }

        @NotNull
        public final CompletableBatchRequest copy(@NotNull BatchRpcRequest request2, @NotNull CompletableFuture<Boolean> future) {
            return new CompletableBatchRequest(request2, future);
        }

        public static /* synthetic */ CompletableBatchRequest copy$default(CompletableBatchRequest completableBatchRequest, BatchRpcRequest batchRpcRequest, CompletableFuture completableFuture, int n, Object object) {
            if ((n & 1) != 0) {
                batchRpcRequest = completableBatchRequest.request;
            }
            if ((n & 2) != 0) {
                completableFuture = completableBatchRequest.future;
            }
            return completableBatchRequest.copy(batchRpcRequest, completableFuture);
        }

        @NotNull
        public String toString() {
            return "CompletableBatchRequest(request=" + this.request + ", future=" + this.future + ")";
        }

        public int hashCode() {
            int result = this.request.hashCode();
            result = result * 31 + this.future.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompletableBatchRequest)) {
                return false;
            }
            CompletableBatchRequest completableBatchRequest = (CompletableBatchRequest)other;
            if (!Intrinsics.areEqual((Object)this.request, (Object)completableBatchRequest.request)) {
                return false;
            }
            return Intrinsics.areEqual(this.future, completableBatchRequest.future);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BI\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\b\u0012\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r0\f0\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R#\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lio/ethers/providers/WsClient$CompletableRequest;", "T", "Lio/ethers/providers/WsClient$ExpiringRequest;", "method", "", "params", "", "resultDecoder", "Ljava/util/function/Function;", "Lcom/fasterxml/jackson/core/JsonParser;", "future", "Ljava/util/concurrent/CompletableFuture;", "Lio/ethers/core/Result;", "Lio/ethers/providers/RpcError;", "<init>", "(Ljava/lang/String;[Ljava/lang/Object;Ljava/util/function/Function;Ljava/util/concurrent/CompletableFuture;)V", "getMethod", "()Ljava/lang/String;", "getParams", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "getResultDecoder", "()Ljava/util/function/Function;", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "expireRequest", "", "ethers-providers"})
    private static final class CompletableRequest<T>
    extends ExpiringRequest {
        @NotNull
        private final String method;
        @NotNull
        private final Object[] params;
        @NotNull
        private final Function<JsonParser, T> resultDecoder;
        @NotNull
        private final CompletableFuture<Result<T, RpcError>> future;

        public CompletableRequest(@NotNull String method, @NotNull Object[] params, @NotNull Function<JsonParser, T> resultDecoder, @NotNull CompletableFuture<Result<T, RpcError>> future) {
            this.method = method;
            this.params = params;
            this.resultDecoder = resultDecoder;
            this.future = future;
        }

        @NotNull
        public final String getMethod() {
            return this.method;
        }

        @NotNull
        public final Object[] getParams() {
            return this.params;
        }

        @NotNull
        public final Function<JsonParser, T> getResultDecoder() {
            return this.resultDecoder;
        }

        @NotNull
        public final CompletableFuture<Result<T, RpcError>> getFuture() {
            return this.future;
        }

        @Override
        public void expireRequest() {
            this.future.complete(HttpClient.Companion.getERROR_CALL_TIMEOUT$ethers_providers());
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BG\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u001e\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0004\u0012\u00020\f0\n0\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0017\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R)\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0004\u0012\u00020\f0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lio/ethers/providers/WsClient$CompletableSubscriptionRequest;", "T", "Lio/ethers/providers/WsClient$ExpiringRequest;", "params", "", "resultDecoder", "Ljava/util/function/Function;", "Lcom/fasterxml/jackson/core/JsonParser;", "future", "Ljava/util/concurrent/CompletableFuture;", "Lio/ethers/core/Result;", "Lio/ethers/providers/SubscriptionStream;", "Lio/ethers/providers/RpcError;", "<init>", "([Ljava/lang/Object;Ljava/util/function/Function;Ljava/util/concurrent/CompletableFuture;)V", "getParams", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "getResultDecoder", "()Ljava/util/function/Function;", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "expireRequest", "", "ethers-providers"})
    private static final class CompletableSubscriptionRequest<T>
    extends ExpiringRequest {
        @NotNull
        private final Object[] params;
        @NotNull
        private final Function<JsonParser, T> resultDecoder;
        @NotNull
        private final CompletableFuture<Result<SubscriptionStream<T>, RpcError>> future;

        public CompletableSubscriptionRequest(@NotNull Object[] params, @NotNull Function<JsonParser, T> resultDecoder, @NotNull CompletableFuture<Result<SubscriptionStream<T>, RpcError>> future) {
            this.params = params;
            this.resultDecoder = resultDecoder;
            this.future = future;
        }

        @NotNull
        public final Object[] getParams() {
            return this.params;
        }

        @NotNull
        public final Function<JsonParser, T> getResultDecoder() {
            return this.resultDecoder;
        }

        @NotNull
        public final CompletableFuture<Result<SubscriptionStream<T>, RpcError>> getFuture() {
            return this.future;
        }

        @Override
        public void expireRequest() {
            this.future.complete(HttpClient.Companion.getERROR_CALL_TIMEOUT$ethers_providers());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH&R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lio/ethers/providers/WsClient$ExpiringRequest;", "", "<init>", "()V", "initiated", "Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "J", "expireIfTimedOut", "", "duration", "Lkotlin/time/Duration;", "expireIfTimedOut-LRDsOJo", "(J)Z", "expireRequest", "", "ethers-providers"})
    private static abstract class ExpiringRequest {
        private final long initiated = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();

        public final boolean expireIfTimedOut-LRDsOJo(long duration) {
            if (Duration.compareTo-LRDsOJo((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)this.initiated), (long)duration) > 0) {
                this.expireRequest();
                return true;
            }
            return false;
        }

        public abstract void expireRequest();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lio/ethers/providers/WsClient$Subscription;", "T", "", "serverId", "", "params", "", "resultDecoder", "Ljava/util/function/Function;", "Lcom/fasterxml/jackson/core/JsonParser;", "stream", "Lio/ethers/providers/BlockingSubscriptionStream;", "<init>", "(Ljava/lang/String;[Ljava/lang/Object;Ljava/util/function/Function;Lio/ethers/providers/BlockingSubscriptionStream;)V", "getServerId", "()Ljava/lang/String;", "setServerId", "(Ljava/lang/String;)V", "getParams", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "getResultDecoder", "()Ljava/util/function/Function;", "getStream", "()Lio/ethers/providers/BlockingSubscriptionStream;", "handleNotification", "", "event", "ethers-providers"})
    private static final class Subscription<T> {
        @NotNull
        private String serverId;
        @NotNull
        private final Object[] params;
        @NotNull
        private final Function<JsonParser, T> resultDecoder;
        @NotNull
        private final BlockingSubscriptionStream<T> stream;

        public Subscription(@NotNull String serverId, @NotNull Object[] params, @NotNull Function<JsonParser, T> resultDecoder, @NotNull BlockingSubscriptionStream<T> stream) {
            this.serverId = serverId;
            this.params = params;
            this.resultDecoder = resultDecoder;
            this.stream = stream;
        }

        @NotNull
        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(@NotNull String string) {
            this.serverId = string;
        }

        @NotNull
        public final Object[] getParams() {
            return this.params;
        }

        @NotNull
        public final Function<JsonParser, T> getResultDecoder() {
            return this.resultDecoder;
        }

        @NotNull
        public final BlockingSubscriptionStream<T> getStream() {
            return this.stream;
        }

        public final void handleNotification(@NotNull JsonParser event) {
            this.stream.pushEvent(this.resultDecoder.apply(event));
        }
    }
}

