/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types.transaction;

import io.ethers.core.types.AccessList;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.Hash;
import io.ethers.core.types.Signature;
import io.ethers.core.types.transaction.ChainId;
import io.ethers.core.types.transaction.TransactionUnsigned;
import io.ethers.core.types.transaction.TxType;
import io.ethers.rlp.RlpDecodable;
import io.ethers.rlp.RlpDecoder;
import io.ethers.rlp.RlpEncodable;
import io.ethers.rlp.RlpEncoder;
import java.math.BigInteger;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 E2\u00020\u0001:\u0001EBC\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\"\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u000203H\u0016J\u001a\u00104\u001a\u0002052\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u000203H\u0016J\u001a\u00106\u001a\u0002052\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u000203H\u0002J\u000b\u00107\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u00108\u001a\u00020\u0005H\u00c6\u0003J\t\u00109\u001a\u00020\u0007H\u00c6\u0003J\t\u0010:\u001a\u00020\u0007H\u00c6\u0003J\t\u0010;\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010<\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010=\u001a\u00020\u0007H\u00c6\u0003JS\u0010>\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010?\u001a\u0002032\b\u0010@\u001a\u0004\u0018\u00010AH\u00d6\u0003J\t\u0010B\u001a\u000205H\u00d6\u0001J\t\u0010C\u001a\u00020DH\u00d6\u0001R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\t\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0014\u0010\u001a\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0012R\u0014\u0010\u001c\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0012R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0016\u0010'\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0012R\u001c\u0010)\u001a\n\u0012\u0004\u0012\u00020*\u0018\u00010\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\"\u00a8\u0006F"}, d2={"Lio/ethers/core/types/transaction/TxLegacy;", "Lio/ethers/core/types/transaction/TransactionUnsigned;", "to", "Lio/ethers/core/types/Address;", "value", "Ljava/math/BigInteger;", "nonce", "", "gas", "gasPrice", "data", "Lio/ethers/core/types/Bytes;", "chainId", "<init>", "(Lio/ethers/core/types/Address;Ljava/math/BigInteger;JJLjava/math/BigInteger;Lio/ethers/core/types/Bytes;J)V", "getTo", "()Lio/ethers/core/types/Address;", "getValue", "()Ljava/math/BigInteger;", "getNonce", "()J", "getGas", "getGasPrice", "getData", "()Lio/ethers/core/types/Bytes;", "getChainId", "gasTipCap", "getGasTipCap", "gasFeeCap", "getGasFeeCap", "accessList", "", "Lio/ethers/core/types/AccessList$Item;", "getAccessList", "()Ljava/util/List;", "type", "Lio/ethers/core/types/transaction/TxType;", "getType", "()Lio/ethers/core/types/transaction/TxType;", "blobFeeCap", "getBlobFeeCap", "blobVersionedHashes", "Lio/ethers/core/types/Hash;", "getBlobVersionedHashes", "rlpEncodeEnveloped", "", "rlp", "Lio/ethers/rlp/RlpEncoder;", "signature", "Lio/ethers/core/types/Signature;", "hashEncoding", "", "rlpEnvelopedSize", "", "rlpFieldsWithSignatureSize", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "", "hashCode", "toString", "", "Companion", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nTxLegacy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TxLegacy.kt\nio/ethers/core/types/transaction/TxLegacy\n+ 2 RlpEncoder.kt\nio/ethers/rlp/RlpEncoder\n*L\n1#1,116:1\n71#2,5:117\n*S KotlinDebug\n*F\n+ 1 TxLegacy.kt\nio/ethers/core/types/transaction/TxLegacy\n*L\n41#1:117,5\n*E\n"})
public final class TxLegacy
implements TransactionUnsigned {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Address to;
    @NotNull
    private final BigInteger value;
    private final long nonce;
    private final long gas;
    @NotNull
    private final BigInteger gasPrice;
    @Nullable
    private final Bytes data;
    private final long chainId;

    public TxLegacy(@Nullable Address to, @NotNull BigInteger value, long nonce, long gas, @NotNull BigInteger gasPrice, @Nullable Bytes data, long chainId) {
        this.to = to;
        this.value = value;
        this.nonce = nonce;
        this.gas = gas;
        this.gasPrice = gasPrice;
        this.data = data;
        this.chainId = chainId;
    }

    @Override
    @Nullable
    public Address getTo() {
        return this.to;
    }

    @Override
    @NotNull
    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public long getNonce() {
        return this.nonce;
    }

    @Override
    public long getGas() {
        return this.gas;
    }

    @Override
    @NotNull
    public BigInteger getGasPrice() {
        return this.gasPrice;
    }

    @Override
    @Nullable
    public Bytes getData() {
        return this.data;
    }

    @Override
    public long getChainId() {
        return this.chainId;
    }

    @Override
    @NotNull
    public BigInteger getGasTipCap() {
        return this.getGasPrice();
    }

    @Override
    @NotNull
    public BigInteger getGasFeeCap() {
        return this.getGasPrice();
    }

    @Override
    @NotNull
    public List<AccessList.Item> getAccessList() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public TxType getType() {
        return TxType.Legacy.INSTANCE;
    }

    @Override
    @Nullable
    public BigInteger getBlobFeeCap() {
        return null;
    }

    @Override
    @Nullable
    public List<Hash> getBlobVersionedHashes() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void rlpEncodeEnveloped(@NotNull RlpEncoder rlp, @Nullable Signature signature, boolean hashEncoding) {
        void this_$iv;
        RlpEncoder rlpEncoder = rlp;
        int bodySize$iv = this.rlpFieldsWithSignatureSize(signature, hashEncoding);
        boolean $i$f$encodeList = false;
        int bufferStartPosition$iv = this_$iv.startList(bodySize$iv);
        void $this$rlpEncodeEnveloped_u24lambda_u240 = this_$iv;
        boolean bl = false;
        rlp.encode(this.getNonce());
        rlp.encode(this.getGasPrice());
        rlp.encode(this.getGas());
        rlp.encode((RlpEncodable)this.getTo());
        rlp.encode(this.getValue());
        rlp.encode((RlpEncodable)this.getData());
        if (hashEncoding && signature == null) {
            if (ChainId.isValid(this.getChainId())) {
                rlp.encode(this.getChainId());
                rlp.encode(0L);
                rlp.encode(0L);
            }
        } else if (signature != null) {
            rlp.encode((RlpEncodable)signature);
        }
        this_$iv.finishList(bufferStartPosition$iv, bodySize$iv);
    }

    @Override
    public int rlpEnvelopedSize(@Nullable Signature signature, boolean hashEncoding) {
        RlpEncoder.Companion $this$rlpEnvelopedSize_u24lambda_u241 = RlpEncoder.Companion;
        boolean bl = false;
        return $this$rlpEnvelopedSize_u24lambda_u241.sizeOfList(this.rlpFieldsWithSignatureSize(signature, hashEncoding));
    }

    private final int rlpFieldsWithSignatureSize(Signature signature, boolean hashEncoding) {
        RlpEncoder.Companion $this$rlpFieldsWithSignatureSize_u24lambda_u242 = RlpEncoder.Companion;
        boolean bl = false;
        int size = $this$rlpFieldsWithSignatureSize_u24lambda_u242.sizeOf(this.getNonce()) + $this$rlpFieldsWithSignatureSize_u24lambda_u242.sizeOf(this.getGasPrice()) + $this$rlpFieldsWithSignatureSize_u24lambda_u242.sizeOf(this.getGas()) + $this$rlpFieldsWithSignatureSize_u24lambda_u242.sizeOf((RlpEncodable)this.getTo()) + $this$rlpFieldsWithSignatureSize_u24lambda_u242.sizeOf(this.getValue()) + $this$rlpFieldsWithSignatureSize_u24lambda_u242.sizeOf((RlpEncodable)this.getData());
        if (hashEncoding && signature == null) {
            if (ChainId.isValid(this.getChainId())) {
                size += $this$rlpFieldsWithSignatureSize_u24lambda_u242.sizeOf(this.getChainId()) + 2;
            }
        } else if (signature != null) {
            size += signature.rlpSize();
        }
        return size;
    }

    @Nullable
    public final Address component1() {
        return this.to;
    }

    @NotNull
    public final BigInteger component2() {
        return this.value;
    }

    public final long component3() {
        return this.nonce;
    }

    public final long component4() {
        return this.gas;
    }

    @NotNull
    public final BigInteger component5() {
        return this.gasPrice;
    }

    @Nullable
    public final Bytes component6() {
        return this.data;
    }

    public final long component7() {
        return this.chainId;
    }

    @NotNull
    public final TxLegacy copy(@Nullable Address to, @NotNull BigInteger value, long nonce, long gas, @NotNull BigInteger gasPrice, @Nullable Bytes data, long chainId) {
        return new TxLegacy(to, value, nonce, gas, gasPrice, data, chainId);
    }

    public static /* synthetic */ TxLegacy copy$default(TxLegacy txLegacy, Address address, BigInteger bigInteger, long l, long l2, BigInteger bigInteger2, Bytes bytes, long l3, int n, Object object) {
        if ((n & 1) != 0) {
            address = txLegacy.to;
        }
        if ((n & 2) != 0) {
            bigInteger = txLegacy.value;
        }
        if ((n & 4) != 0) {
            l = txLegacy.nonce;
        }
        if ((n & 8) != 0) {
            l2 = txLegacy.gas;
        }
        if ((n & 0x10) != 0) {
            bigInteger2 = txLegacy.gasPrice;
        }
        if ((n & 0x20) != 0) {
            bytes = txLegacy.data;
        }
        if ((n & 0x40) != 0) {
            l3 = txLegacy.chainId;
        }
        return txLegacy.copy(address, bigInteger, l, l2, bigInteger2, bytes, l3);
    }

    @NotNull
    public String toString() {
        return "TxLegacy(to=" + this.to + ", value=" + this.value + ", nonce=" + this.nonce + ", gas=" + this.gas + ", gasPrice=" + this.gasPrice + ", data=" + this.data + ", chainId=" + this.chainId + ")";
    }

    public int hashCode() {
        int result = this.to == null ? 0 : this.to.hashCode();
        result = result * 31 + this.value.hashCode();
        result = result * 31 + Long.hashCode(this.nonce);
        result = result * 31 + Long.hashCode(this.gas);
        result = result * 31 + this.gasPrice.hashCode();
        result = result * 31 + (this.data == null ? 0 : this.data.hashCode());
        result = result * 31 + Long.hashCode(this.chainId);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TxLegacy)) {
            return false;
        }
        TxLegacy txLegacy = (TxLegacy)other;
        if (!Intrinsics.areEqual((Object)this.to, (Object)txLegacy.to)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.value, (Object)txLegacy.value)) {
            return false;
        }
        if (this.nonce != txLegacy.nonce) {
            return false;
        }
        if (this.gas != txLegacy.gas) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.gasPrice, (Object)txLegacy.gasPrice)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.data, (Object)txLegacy.data)) {
            return false;
        }
        return this.chainId == txLegacy.chainId;
    }

    @JvmStatic
    @NotNull
    public static TxLegacy rlpDecode(@NotNull RlpDecoder rlp) {
        return Companion.rlpDecode(rlp);
    }

    @JvmStatic
    @NotNull
    public static final TxLegacy rlpDecode(@NotNull RlpDecoder rlp, long chainId) {
        return Companion.rlpDecode(rlp, chainId);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lio/ethers/core/types/transaction/TxLegacy$Companion;", "Lio/ethers/rlp/RlpDecodable;", "Lio/ethers/core/types/transaction/TxLegacy;", "<init>", "()V", "rlpDecode", "rlp", "Lio/ethers/rlp/RlpDecoder;", "chainId", "", "ethers-core"})
    public static final class Companion
    implements RlpDecodable<TxLegacy> {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public TxLegacy rlpDecode(@NotNull RlpDecoder rlp) {
            return this.rlpDecode(rlp, -1L);
        }

        @JvmStatic
        @NotNull
        public final TxLegacy rlpDecode(@NotNull RlpDecoder rlp, long chainId) {
            long l = rlp.decodeLong();
            BigInteger bigInteger = rlp.decodeBigIntegerElse(BigInteger.ZERO);
            long l2 = rlp.decodeLong();
            Address address = (Address)rlp.decode((RlpDecodable)Address.Companion);
            BigInteger bigInteger2 = rlp.decodeBigIntegerElse(BigInteger.ZERO);
            Bytes bytes = (Bytes)rlp.decode((RlpDecodable)Bytes.Companion);
            return new TxLegacy(address, bigInteger2, l, l2, bigInteger, bytes, chainId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

