/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types.transaction;

import io.ethers.core.types.AccessList;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.CallRequest;
import io.ethers.core.types.Hash;
import io.ethers.core.types.IntoCallRequest;
import io.ethers.core.types.transaction.TxType;
import io.ethers.core.utils.GasUtils;
import java.math.BigInteger;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007H\u0016J\u0010\u0010.\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007H\u0016J\b\u0010/\u001a\u000200H\u0016R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0012\u0010\u0010\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u0012\u0010\u0012\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u0012\u0010\u0014\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\tR\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\rR\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0012\u0010!\u001a\u00020\"X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\tR\u001a\u0010'\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010 R\u0014\u0010*\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u00061\u00c0\u0006\u0001"}, d2={"Lio/ethers/core/types/transaction/Transaction;", "Lio/ethers/core/types/IntoCallRequest;", "to", "Lio/ethers/core/types/Address;", "getTo", "()Lio/ethers/core/types/Address;", "value", "Ljava/math/BigInteger;", "getValue", "()Ljava/math/BigInteger;", "nonce", "", "getNonce", "()J", "gas", "getGas", "gasPrice", "getGasPrice", "gasTipCap", "getGasTipCap", "gasFeeCap", "getGasFeeCap", "data", "Lio/ethers/core/types/Bytes;", "getData", "()Lio/ethers/core/types/Bytes;", "chainId", "getChainId", "accessList", "", "Lio/ethers/core/types/AccessList$Item;", "getAccessList", "()Ljava/util/List;", "type", "Lio/ethers/core/types/transaction/TxType;", "getType", "()Lio/ethers/core/types/transaction/TxType;", "blobFeeCap", "getBlobFeeCap", "blobVersionedHashes", "Lio/ethers/core/types/Hash;", "getBlobVersionedHashes", "blobGas", "getBlobGas", "getEffectiveGasTip", "baseFee", "getEffectiveGasPrice", "toCallRequest", "Lio/ethers/core/types/CallRequest;", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nTransaction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Transaction.kt\nio/ethers/core/types/transaction/Transaction\n+ 2 CallRequest.kt\nio/ethers/core/types/CallRequest$Companion\n*L\n1#1,161:1\n237#2:162\n*S KotlinDebug\n*F\n+ 1 Transaction.kt\nio/ethers/core/types/transaction/Transaction\n*L\n63#1:162\n*E\n"})
public interface Transaction
extends IntoCallRequest {
    @Nullable
    public Address getTo();

    @NotNull
    public BigInteger getValue();

    public long getNonce();

    public long getGas();

    @NotNull
    public BigInteger getGasPrice();

    @NotNull
    public BigInteger getGasTipCap();

    @NotNull
    public BigInteger getGasFeeCap();

    @Nullable
    public Bytes getData();

    public long getChainId();

    @NotNull
    public List<AccessList.Item> getAccessList();

    @NotNull
    public TxType getType();

    @Nullable
    public BigInteger getBlobFeeCap();

    @Nullable
    public List<Hash> getBlobVersionedHashes();

    default public long getBlobGas() {
        List<Hash> list = this.getBlobVersionedHashes();
        return list != null ? (long)list.size() * 131072L : 0L;
    }

    @NotNull
    default public BigInteger getEffectiveGasTip(@NotNull BigInteger baseFee) {
        return GasUtils.getEffectiveGasTip(baseFee, this.getGasTipCap(), this.getGasFeeCap());
    }

    @NotNull
    default public BigInteger getEffectiveGasPrice(@NotNull BigInteger baseFee) {
        return GasUtils.getEffectiveGasPrice(baseFee, this.getGasTipCap(), this.getGasFeeCap());
    }

    @Override
    @NotNull
    default public CallRequest toCallRequest() {
        CallRequest callRequest;
        CallRequest callRequest2;
        Transaction tx = this;
        CallRequest.Companion this_$iv = CallRequest.Companion;
        boolean $i$f$invoke = false;
        CallRequest $this$toCallRequest_u24lambda_u240 = callRequest2 = new CallRequest();
        boolean bl = false;
        $this$toCallRequest_u24lambda_u240.to(tx.getTo());
        $this$toCallRequest_u24lambda_u240.value(tx.getValue());
        $this$toCallRequest_u24lambda_u240.nonce(tx.getNonce());
        $this$toCallRequest_u24lambda_u240.gas(tx.getGas());
        if (Intrinsics.areEqual((Object)tx.getType(), (Object)TxType.Legacy.INSTANCE)) {
            callRequest = $this$toCallRequest_u24lambda_u240.gasPrice(tx.getGasPrice());
        } else {
            $this$toCallRequest_u24lambda_u240.gasTipCap(tx.getGasTipCap());
            callRequest = $this$toCallRequest_u24lambda_u240.gasFeeCap(tx.getGasFeeCap());
        }
        $this$toCallRequest_u24lambda_u240.data(tx.getData());
        $this$toCallRequest_u24lambda_u240.chainId(tx.getChainId());
        $this$toCallRequest_u24lambda_u240.accessList(tx.getAccessList());
        $this$toCallRequest_u24lambda_u240.blobFeeCap(tx.getBlobFeeCap());
        $this$toCallRequest_u24lambda_u240.blobVersionedHashes(tx.getBlobVersionedHashes());
        return callRequest2;
    }
}

