/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types.tracers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.ethers.core.FastHex;
import io.ethers.core.types.tracers.Tracer;
import io.ethers.core.types.tracers.TracerConfig;
import java.util.Map;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lio/ethers/core/types/tracers/TracerConfigSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lio/ethers/core/types/tracers/TracerConfig;", "<init>", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "ethers-core"})
final class TracerConfigSerializer
extends JsonSerializer<TracerConfig<?>> {
    public void serialize(@NotNull TracerConfig<?> value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
        Map map;
        gen.writeStartObject();
        if (value.getTracer() instanceof Tracer) {
            gen.writeStringField("tracer", ((Tracer)value.getTracer()).getName());
            gen.writeFieldName("tracerConfig");
            gen.writeStartObject();
            ((Tracer)value.getTracer()).encodeConfig(gen);
            gen.writeEndObject();
        } else {
            value.getTracer().encodeConfig(gen);
        }
        if (value.getTimeoutMs() >= 0L) {
            gen.writeStringField("timeout", value.getTimeoutMs() + "ms");
        }
        if (value.getReexec() >= 0L) {
            gen.writeNumberField("reexec", value.getReexec());
        }
        if (!((map = (Map)value.getStateOverrides()) == null || map.isEmpty())) {
            gen.writeObjectField("stateOverrides", (Object)value.getStateOverrides());
        }
        if (value.getBlockOverrides() != null) {
            gen.writeObjectField("blockOverrides", (Object)value.getBlockOverrides());
        }
        if (value.getTxIndex() >= 0) {
            gen.writeStringField("txIndex", FastHex.encodeWithPrefix(value.getTxIndex()));
        }
        gen.writeEndObject();
    }
}

