/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types.tracers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.ethers.core.JsonParserExtensionsKt;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.Hash;
import io.ethers.core.types.tracers.AnyTracer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004./01BY\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!H\u0016J\t\u0010\"\u001a\u00020\u0004H\u00c6\u0003J\t\u0010#\u001a\u00020\u0004H\u00c6\u0003J\t\u0010$\u001a\u00020\u0004H\u00c6\u0003J\t\u0010%\u001a\u00020\u0004H\u00c6\u0003J\t\u0010&\u001a\u00020\u0004H\u00c6\u0003J\t\u0010'\u001a\u00020\nH\u00c6\u0003J\u0015\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u00c6\u0003J[\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\n2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u00c6\u0001J\u0013\u0010*\u001a\u00020\u00042\b\u0010+\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010,\u001a\u00020\nH\u00d6\u0001J\t\u0010-\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00062"}, d2={"Lio/ethers/core/types/tracers/StructTracer;", "Lio/ethers/core/types/tracers/AnyTracer;", "Lio/ethers/core/types/tracers/StructTracer$ExecutionResult;", "enableMemory", "", "disableStack", "disableStorage", "enableReturnData", "debug", "limit", "", "overrides", "", "", "", "<init>", "(ZZZZZILjava/util/Map;)V", "getEnableMemory", "()Z", "getDisableStack", "getDisableStorage", "getEnableReturnData", "getDebug", "getLimit", "()I", "getOverrides", "()Ljava/util/Map;", "encodeConfig", "", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "decodeResult", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "ExecutionResult", "StructLog", "ExecutionResultDeserializer", "StructLogDeserializer", "ethers-core"})
public final class StructTracer
implements AnyTracer<ExecutionResult> {
    private final boolean enableMemory;
    private final boolean disableStack;
    private final boolean disableStorage;
    private final boolean enableReturnData;
    private final boolean debug;
    private final int limit;
    @NotNull
    private final Map<String, Object> overrides;

    public StructTracer(boolean enableMemory, boolean disableStack, boolean disableStorage, boolean enableReturnData, boolean debug, int limit, @NotNull Map<String, ? extends Object> overrides) {
        this.enableMemory = enableMemory;
        this.disableStack = disableStack;
        this.disableStorage = disableStorage;
        this.enableReturnData = enableReturnData;
        this.debug = debug;
        this.limit = limit;
        this.overrides = overrides;
    }

    public /* synthetic */ StructTracer(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, Map map, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        if ((n2 & 4) != 0) {
            bl3 = false;
        }
        if ((n2 & 8) != 0) {
            bl4 = false;
        }
        if ((n2 & 0x10) != 0) {
            bl5 = false;
        }
        if ((n2 & 0x20) != 0) {
            n = 0;
        }
        if ((n2 & 0x40) != 0) {
            map = MapsKt.emptyMap();
        }
        this(bl, bl2, bl3, bl4, bl5, n, map);
    }

    public final boolean getEnableMemory() {
        return this.enableMemory;
    }

    public final boolean getDisableStack() {
        return this.disableStack;
    }

    public final boolean getDisableStorage() {
        return this.disableStorage;
    }

    public final boolean getEnableReturnData() {
        return this.enableReturnData;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final int getLimit() {
        return this.limit;
    }

    @NotNull
    public final Map<String, Object> getOverrides() {
        return this.overrides;
    }

    @Override
    public void encodeConfig(@NotNull JsonGenerator gen) {
        if (this.enableMemory) {
            gen.writeBooleanField("enableMemory", true);
        }
        if (this.disableStack) {
            gen.writeBooleanField("disableStack", true);
        }
        if (this.disableStorage) {
            gen.writeBooleanField("disableStorage", true);
        }
        if (this.enableReturnData) {
            gen.writeBooleanField("enableReturnData", true);
        }
        if (this.debug) {
            gen.writeBooleanField("debug", true);
        }
        if (this.limit > 0) {
            gen.writeNumberField("limit", this.limit);
        }
        if (!this.overrides.isEmpty()) {
            gen.writeObjectField("overrides", this.overrides);
        }
    }

    @Override
    @NotNull
    public ExecutionResult decodeResult(@NotNull JsonParser parser) {
        return (ExecutionResult)parser.readValueAs(ExecutionResult.class);
    }

    public final boolean component1() {
        return this.enableMemory;
    }

    public final boolean component2() {
        return this.disableStack;
    }

    public final boolean component3() {
        return this.disableStorage;
    }

    public final boolean component4() {
        return this.enableReturnData;
    }

    public final boolean component5() {
        return this.debug;
    }

    public final int component6() {
        return this.limit;
    }

    @NotNull
    public final Map<String, Object> component7() {
        return this.overrides;
    }

    @NotNull
    public final StructTracer copy(boolean enableMemory, boolean disableStack, boolean disableStorage, boolean enableReturnData, boolean debug, int limit, @NotNull Map<String, ? extends Object> overrides) {
        return new StructTracer(enableMemory, disableStack, disableStorage, enableReturnData, debug, limit, overrides);
    }

    public static /* synthetic */ StructTracer copy$default(StructTracer structTracer, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, Map map, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = structTracer.enableMemory;
        }
        if ((n2 & 2) != 0) {
            bl2 = structTracer.disableStack;
        }
        if ((n2 & 4) != 0) {
            bl3 = structTracer.disableStorage;
        }
        if ((n2 & 8) != 0) {
            bl4 = structTracer.enableReturnData;
        }
        if ((n2 & 0x10) != 0) {
            bl5 = structTracer.debug;
        }
        if ((n2 & 0x20) != 0) {
            n = structTracer.limit;
        }
        if ((n2 & 0x40) != 0) {
            map = structTracer.overrides;
        }
        return structTracer.copy(bl, bl2, bl3, bl4, bl5, n, map);
    }

    @NotNull
    public String toString() {
        return "StructTracer(enableMemory=" + this.enableMemory + ", disableStack=" + this.disableStack + ", disableStorage=" + this.disableStorage + ", enableReturnData=" + this.enableReturnData + ", debug=" + this.debug + ", limit=" + this.limit + ", overrides=" + this.overrides + ")";
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.enableMemory);
        result = result * 31 + Boolean.hashCode(this.disableStack);
        result = result * 31 + Boolean.hashCode(this.disableStorage);
        result = result * 31 + Boolean.hashCode(this.enableReturnData);
        result = result * 31 + Boolean.hashCode(this.debug);
        result = result * 31 + Integer.hashCode(this.limit);
        result = result * 31 + ((Object)this.overrides).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StructTracer)) {
            return false;
        }
        StructTracer structTracer = (StructTracer)other;
        if (this.enableMemory != structTracer.enableMemory) {
            return false;
        }
        if (this.disableStack != structTracer.disableStack) {
            return false;
        }
        if (this.disableStorage != structTracer.disableStorage) {
            return false;
        }
        if (this.enableReturnData != structTracer.enableReturnData) {
            return false;
        }
        if (this.debug != structTracer.debug) {
            return false;
        }
        if (this.limit != structTracer.limit) {
            return false;
        }
        return Intrinsics.areEqual(this.overrides, structTracer.overrides);
    }

    public StructTracer() {
        this(false, false, false, false, false, 0, null, 127, null);
    }

    @JsonDeserialize(using=ExecutionResultDeserializer.class)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lio/ethers/core/types/tracers/StructTracer$ExecutionResult;", "", "gas", "", "failed", "", "returnValue", "Lio/ethers/core/types/Bytes;", "structLogs", "", "Lio/ethers/core/types/tracers/StructTracer$StructLog;", "<init>", "(JZLio/ethers/core/types/Bytes;Ljava/util/List;)V", "getGas", "()J", "getFailed", "()Z", "getReturnValue", "()Lio/ethers/core/types/Bytes;", "getStructLogs", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "ethers-core"})
    public static final class ExecutionResult {
        private final long gas;
        private final boolean failed;
        @NotNull
        private final Bytes returnValue;
        @NotNull
        private final List<StructLog> structLogs;

        public ExecutionResult(long gas, boolean failed, @NotNull Bytes returnValue, @NotNull List<StructLog> structLogs) {
            this.gas = gas;
            this.failed = failed;
            this.returnValue = returnValue;
            this.structLogs = structLogs;
        }

        public final long getGas() {
            return this.gas;
        }

        public final boolean getFailed() {
            return this.failed;
        }

        @NotNull
        public final Bytes getReturnValue() {
            return this.returnValue;
        }

        @NotNull
        public final List<StructLog> getStructLogs() {
            return this.structLogs;
        }

        public final long component1() {
            return this.gas;
        }

        public final boolean component2() {
            return this.failed;
        }

        @NotNull
        public final Bytes component3() {
            return this.returnValue;
        }

        @NotNull
        public final List<StructLog> component4() {
            return this.structLogs;
        }

        @NotNull
        public final ExecutionResult copy(long gas, boolean failed, @NotNull Bytes returnValue, @NotNull List<StructLog> structLogs) {
            return new ExecutionResult(gas, failed, returnValue, structLogs);
        }

        public static /* synthetic */ ExecutionResult copy$default(ExecutionResult executionResult, long l, boolean bl, Bytes bytes, List list, int n, Object object) {
            if ((n & 1) != 0) {
                l = executionResult.gas;
            }
            if ((n & 2) != 0) {
                bl = executionResult.failed;
            }
            if ((n & 4) != 0) {
                bytes = executionResult.returnValue;
            }
            if ((n & 8) != 0) {
                list = executionResult.structLogs;
            }
            return executionResult.copy(l, bl, bytes, list);
        }

        @NotNull
        public String toString() {
            return "ExecutionResult(gas=" + this.gas + ", failed=" + this.failed + ", returnValue=" + this.returnValue + ", structLogs=" + this.structLogs + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.gas);
            result = result * 31 + Boolean.hashCode(this.failed);
            result = result * 31 + this.returnValue.hashCode();
            result = result * 31 + ((Object)this.structLogs).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExecutionResult)) {
                return false;
            }
            ExecutionResult executionResult = (ExecutionResult)other;
            if (this.gas != executionResult.gas) {
                return false;
            }
            if (this.failed != executionResult.failed) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.returnValue, (Object)executionResult.returnValue)) {
                return false;
            }
            return Intrinsics.areEqual(this.structLogs, executionResult.structLogs);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/ethers/core/types/tracers/StructTracer$ExecutionResultDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lio/ethers/core/types/tracers/StructTracer$ExecutionResult;", "<init>", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "ethers-core"})
    @SourceDebugExtension(value={"SMAP\nStructTracer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StructTracer.kt\nio/ethers/core/types/tracers/StructTracer$ExecutionResultDeserializer\n+ 2 JsonParserExtensions.kt\nio/ethers/core/JsonParserExtensionsKt\n*L\n1#1,136:1\n33#2,4:137\n194#2,14:141\n38#2:155\n*S KotlinDebug\n*F\n+ 1 StructTracer.kt\nio/ethers/core/types/tracers/StructTracer$ExecutionResultDeserializer\n*L\n92#1:137,4\n97#1:141,14\n92#1:155\n*E\n"})
    private static final class ExecutionResultDeserializer
    extends JsonDeserializer<ExecutionResult> {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public ExecutionResult deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
            long gas = 0L;
            gas = -1L;
            boolean failed = false;
            Bytes returnValue = null;
            Ref.ObjectRef structLogs = new Ref.ObjectRef();
            JsonParser $this$forEachObjectField$iv = p;
            boolean $i$f$forEachObjectField = false;
            while (!JsonParserExtensionsKt.isNextTokenObjectEnd($this$forEachObjectField$iv)) {
                String field$iv = $this$forEachObjectField$iv.currentName();
                $this$forEachObjectField$iv.nextToken();
                String it = field$iv;
                boolean bl = false;
                switch (it) {
                    case "gas": {
                        gas = p.getLongValue();
                        break;
                    }
                    case "failed": {
                        failed = p.getBooleanValue();
                        break;
                    }
                    case "returnValue": {
                        returnValue = JsonParserExtensionsKt.readBytes(p);
                        break;
                    }
                    case "structLogs": {
                        List list;
                        void $this$readListOf$iv;
                        JsonParser jsonParser = p;
                        Ref.ObjectRef objectRef = structLogs;
                        boolean $i$f$readListOf = false;
                        if ($this$readListOf$iv.getCurrentToken() == JsonToken.VALUE_NULL) {
                            list = CollectionsKt.emptyList();
                        } else if ($this$readListOf$iv.nextToken() == JsonToken.END_ARRAY) {
                            list = CollectionsKt.emptyList();
                        } else {
                            ArrayList<StructLog> ret$iv = new ArrayList<StructLog>();
                            do {
                                void $this$deserialize_u24lambda_u241_u24lambda_u240;
                                void var16_17 = $this$readListOf$iv;
                                ArrayList<StructLog> arrayList = ret$iv;
                                boolean bl2 = false;
                                arrayList.add((StructLog)$this$deserialize_u24lambda_u241_u24lambda_u240.readValueAs(StructLog.class));
                            } while ($this$readListOf$iv.nextToken() != JsonToken.END_ARRAY);
                            list = ret$iv;
                        }
                        objectRef.element = list;
                    }
                }
            }
            Bytes bytes = returnValue;
            if (bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"returnValue");
                bytes = null;
            }
            Object object = structLogs.element;
            Intrinsics.checkNotNull((Object)object);
            return new ExecutionResult(gas, failed, bytes, (List)object);
        }
    }

    @JsonDeserialize(using=StructLogDeserializer.class)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001Bw\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u0012\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\u0007H\u00c6\u0003J\t\u0010'\u001a\u00020\u0007H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010*\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u00c6\u0003J\u0011\u0010+\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u00c6\u0003J\u0017\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u00c6\u0003J\t\u0010-\u001a\u00020\u0007H\u00c6\u0003J\u008d\u0001\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00052\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0016\b\u0002\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00102\u001a\u00020\u0003H\u00d6\u0001J\t\u00103\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018R\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0019\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u001f\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001a\u00a8\u00064"}, d2={"Lio/ethers/core/types/tracers/StructTracer$StructLog;", "", "pc", "", "op", "", "gas", "", "gasCost", "depth", "error", "stack", "", "Lio/ethers/core/types/Bytes;", "memory", "storage", "", "Lio/ethers/core/types/Hash;", "refundCounter", "<init>", "(ILjava/lang/String;JJILjava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/Map;J)V", "getPc", "()I", "getOp", "()Ljava/lang/String;", "getGas", "()J", "getGasCost", "getDepth", "getError", "getStack", "()Ljava/util/List;", "getMemory", "getStorage", "()Ljava/util/Map;", "getRefundCounter", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "equals", "", "other", "hashCode", "toString", "ethers-core"})
    public static final class StructLog {
        private final int pc;
        @NotNull
        private final String op;
        private final long gas;
        private final long gasCost;
        private final int depth;
        @Nullable
        private final String error;
        @Nullable
        private final List<Bytes> stack;
        @Nullable
        private final List<Bytes> memory;
        @Nullable
        private final Map<Hash, Hash> storage;
        private final long refundCounter;

        public StructLog(int pc, @NotNull String op, long gas, long gasCost, int depth, @Nullable String error, @Nullable List<Bytes> stack, @Nullable List<Bytes> memory, @Nullable Map<Hash, Hash> storage, long refundCounter) {
            this.pc = pc;
            this.op = op;
            this.gas = gas;
            this.gasCost = gasCost;
            this.depth = depth;
            this.error = error;
            this.stack = stack;
            this.memory = memory;
            this.storage = storage;
            this.refundCounter = refundCounter;
        }

        public final int getPc() {
            return this.pc;
        }

        @NotNull
        public final String getOp() {
            return this.op;
        }

        public final long getGas() {
            return this.gas;
        }

        public final long getGasCost() {
            return this.gasCost;
        }

        public final int getDepth() {
            return this.depth;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        @Nullable
        public final List<Bytes> getStack() {
            return this.stack;
        }

        @Nullable
        public final List<Bytes> getMemory() {
            return this.memory;
        }

        @Nullable
        public final Map<Hash, Hash> getStorage() {
            return this.storage;
        }

        public final long getRefundCounter() {
            return this.refundCounter;
        }

        public final int component1() {
            return this.pc;
        }

        @NotNull
        public final String component2() {
            return this.op;
        }

        public final long component3() {
            return this.gas;
        }

        public final long component4() {
            return this.gasCost;
        }

        public final int component5() {
            return this.depth;
        }

        @Nullable
        public final String component6() {
            return this.error;
        }

        @Nullable
        public final List<Bytes> component7() {
            return this.stack;
        }

        @Nullable
        public final List<Bytes> component8() {
            return this.memory;
        }

        @Nullable
        public final Map<Hash, Hash> component9() {
            return this.storage;
        }

        public final long component10() {
            return this.refundCounter;
        }

        @NotNull
        public final StructLog copy(int pc, @NotNull String op, long gas, long gasCost, int depth, @Nullable String error, @Nullable List<Bytes> stack, @Nullable List<Bytes> memory, @Nullable Map<Hash, Hash> storage, long refundCounter) {
            return new StructLog(pc, op, gas, gasCost, depth, error, stack, memory, storage, refundCounter);
        }

        public static /* synthetic */ StructLog copy$default(StructLog structLog, int n, String string, long l, long l2, int n2, String string2, List list, List list2, Map map, long l3, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = structLog.pc;
            }
            if ((n3 & 2) != 0) {
                string = structLog.op;
            }
            if ((n3 & 4) != 0) {
                l = structLog.gas;
            }
            if ((n3 & 8) != 0) {
                l2 = structLog.gasCost;
            }
            if ((n3 & 0x10) != 0) {
                n2 = structLog.depth;
            }
            if ((n3 & 0x20) != 0) {
                string2 = structLog.error;
            }
            if ((n3 & 0x40) != 0) {
                list = structLog.stack;
            }
            if ((n3 & 0x80) != 0) {
                list2 = structLog.memory;
            }
            if ((n3 & 0x100) != 0) {
                map = structLog.storage;
            }
            if ((n3 & 0x200) != 0) {
                l3 = structLog.refundCounter;
            }
            return structLog.copy(n, string, l, l2, n2, string2, list, list2, map, l3);
        }

        @NotNull
        public String toString() {
            return "StructLog(pc=" + this.pc + ", op=" + this.op + ", gas=" + this.gas + ", gasCost=" + this.gasCost + ", depth=" + this.depth + ", error=" + this.error + ", stack=" + this.stack + ", memory=" + this.memory + ", storage=" + this.storage + ", refundCounter=" + this.refundCounter + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.pc);
            result = result * 31 + this.op.hashCode();
            result = result * 31 + Long.hashCode(this.gas);
            result = result * 31 + Long.hashCode(this.gasCost);
            result = result * 31 + Integer.hashCode(this.depth);
            result = result * 31 + (this.error == null ? 0 : this.error.hashCode());
            result = result * 31 + (this.stack == null ? 0 : ((Object)this.stack).hashCode());
            result = result * 31 + (this.memory == null ? 0 : ((Object)this.memory).hashCode());
            result = result * 31 + (this.storage == null ? 0 : ((Object)this.storage).hashCode());
            result = result * 31 + Long.hashCode(this.refundCounter);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StructLog)) {
                return false;
            }
            StructLog structLog = (StructLog)other;
            if (this.pc != structLog.pc) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.op, (Object)structLog.op)) {
                return false;
            }
            if (this.gas != structLog.gas) {
                return false;
            }
            if (this.gasCost != structLog.gasCost) {
                return false;
            }
            if (this.depth != structLog.depth) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.error, (Object)structLog.error)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.stack, structLog.stack)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.memory, structLog.memory)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.storage, structLog.storage)) {
                return false;
            }
            return this.refundCounter == structLog.refundCounter;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/ethers/core/types/tracers/StructTracer$StructLogDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lio/ethers/core/types/tracers/StructTracer$StructLog;", "<init>", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "ethers-core"})
    @SourceDebugExtension(value={"SMAP\nStructTracer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StructTracer.kt\nio/ethers/core/types/tracers/StructTracer$StructLogDeserializer\n+ 2 JsonParserExtensions.kt\nio/ethers/core/JsonParserExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n33#2,4:137\n194#2,14:141\n194#2,14:155\n242#2,11:169\n253#2,3:181\n38#2:184\n1#3:180\n*S KotlinDebug\n*F\n+ 1 StructTracer.kt\nio/ethers/core/types/tracers/StructTracer$StructLogDeserializer\n*L\n117#1:137,4\n125#1:141,14\n126#1:155,14\n127#1:169,11\n127#1:181,3\n117#1:184\n127#1:180\n*E\n"})
    private static final class StructLogDeserializer
    extends JsonDeserializer<StructLog> {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public StructLog deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
            int pc = 0;
            pc = -1;
            String op = null;
            long gas = 0L;
            gas = -1L;
            long gasCost = 0L;
            gasCost = -1L;
            int depth = 0;
            depth = -1;
            String error = null;
            Ref.ObjectRef stack = new Ref.ObjectRef();
            Ref.ObjectRef memory = new Ref.ObjectRef();
            Ref.ObjectRef storage = new Ref.ObjectRef();
            long refundCounter = 0L;
            JsonParser $this$forEachObjectField$iv = p;
            boolean $i$f$forEachObjectField = false;
            while (!JsonParserExtensionsKt.isNextTokenObjectEnd($this$forEachObjectField$iv)) {
                String field$iv = $this$forEachObjectField$iv.currentName();
                $this$forEachObjectField$iv.nextToken();
                String it = field$iv;
                boolean bl = false;
                switch (it) {
                    case "pc": {
                        pc = p.getIntValue();
                        break;
                    }
                    case "op": {
                        op = p.getText();
                        break;
                    }
                    case "gas": {
                        gas = p.getLongValue();
                        break;
                    }
                    case "gasCost": {
                        gasCost = p.getLongValue();
                        break;
                    }
                    case "depth": {
                        depth = p.getIntValue();
                        break;
                    }
                    case "error": {
                        error = p.getText();
                        break;
                    }
                    case "stack": {
                        JsonParser $this$deserialize_u24lambda_u244_u24lambda_u240;
                        Cloneable cloneable;
                        Object object;
                        Cloneable ret$iv;
                        List list;
                        JsonParser $this$readListOf$iv;
                        JsonParser jsonParser = p;
                        Ref.ObjectRef objectRef = stack;
                        boolean $i$f$readListOf = false;
                        if ($this$readListOf$iv.getCurrentToken() == JsonToken.VALUE_NULL) {
                            list = CollectionsKt.emptyList();
                        } else if ($this$readListOf$iv.nextToken() == JsonToken.END_ARRAY) {
                            list = CollectionsKt.emptyList();
                        } else {
                            ret$iv = new ArrayList();
                            do {
                                object = $this$readListOf$iv;
                                cloneable = ret$iv;
                                boolean bl2 = false;
                                ((ArrayList)cloneable).add(JsonParserExtensionsKt.readBytes($this$deserialize_u24lambda_u244_u24lambda_u240));
                            } while ($this$readListOf$iv.nextToken() != JsonToken.END_ARRAY);
                            list = (List)((Object)ret$iv);
                        }
                        objectRef.element = list;
                        break;
                    }
                    case "memory": {
                        List list;
                        JsonParser $this$deserialize_u24lambda_u244_u24lambda_u240;
                        Cloneable cloneable;
                        Cloneable ret$iv;
                        JsonParser $this$readListOf$iv = p;
                        Ref.ObjectRef objectRef = memory;
                        boolean $i$f$readListOf = false;
                        if ($this$readListOf$iv.getCurrentToken() == JsonToken.VALUE_NULL) {
                            list = CollectionsKt.emptyList();
                        } else if ($this$readListOf$iv.nextToken() == JsonToken.END_ARRAY) {
                            list = CollectionsKt.emptyList();
                        } else {
                            ret$iv = new ArrayList();
                            do {
                                void $this$deserialize_u24lambda_u244_u24lambda_u241;
                                $this$deserialize_u24lambda_u244_u24lambda_u240 = $this$readListOf$iv;
                                cloneable = ret$iv;
                                boolean bl3 = false;
                                ((ArrayList)cloneable).add(JsonParserExtensionsKt.readBytes((JsonParser)$this$deserialize_u24lambda_u244_u24lambda_u241));
                            } while ($this$readListOf$iv.nextToken() != JsonToken.END_ARRAY);
                            list = (List)((Object)ret$iv);
                        }
                        objectRef.element = list;
                        break;
                    }
                    case "storage": {
                        Map map;
                        void $this$readMapOf$iv;
                        Object object;
                        Cloneable ret$iv;
                        JsonParser $this$readListOf$iv = p;
                        Ref.ObjectRef objectRef = storage;
                        boolean $i$f$readMapOf = false;
                        if ($this$readMapOf$iv.getCurrentToken() == JsonToken.VALUE_NULL) {
                            map = MapsKt.emptyMap();
                        } else if ($this$readMapOf$iv.nextToken() == JsonToken.END_OBJECT) {
                            map = MapsKt.emptyMap();
                        } else {
                            ret$iv = new HashMap();
                            do {
                                object = (Map)((Object)ret$iv);
                                String key = $this$readMapOf$iv.currentName();
                                boolean bl4 = false;
                                Hash hash = new Hash(key);
                                JsonToken $this$readMapOf_u24lambda_u243$iv = $this$readMapOf$iv.nextToken();
                                boolean bl5 = false;
                                void $this$deserialize_u24lambda_u244_u24lambda_u243 = $this$readMapOf$iv;
                                boolean bl6 = false;
                                Hash hash2 = JsonParserExtensionsKt.readHash((JsonParser)$this$deserialize_u24lambda_u244_u24lambda_u243);
                                object.put(hash, hash2);
                            } while (!JsonParserExtensionsKt.isNextTokenObjectEnd((JsonParser)$this$readMapOf$iv));
                            map = (Map)((Object)ret$iv);
                        }
                        objectRef.element = map;
                        break;
                    }
                    case "refundCounter": {
                        refundCounter = p.getLongValue();
                    }
                }
            }
            String string = op;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"op");
                string = null;
            }
            return new StructLog(pc, string, gas, gasCost, depth, error, (List)stack.element, (List)memory.element, (Map)storage.element, refundCounter);
        }
    }
}

