/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types.tracers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.ethers.core.JsonParserExtensionsKt;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.Hash;
import io.ethers.core.types.Log;
import io.ethers.core.types.tracers.Tracer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u001f !\"B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\fH\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lio/ethers/core/types/tracers/CallTracer;", "Lio/ethers/core/types/tracers/Tracer;", "Lio/ethers/core/types/tracers/CallTracer$CallFrame;", "onlyTopCall", "", "withLog", "<init>", "(ZZ)V", "getOnlyTopCall", "()Z", "getWithLog", "name", "", "getName", "()Ljava/lang/String;", "encodeConfig", "", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "decodeResult", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "CallFrame", "CallLog", "CallFrameDeserializer", "CallLogDeserializer", "ethers-core"})
public final class CallTracer
implements Tracer<CallFrame> {
    private final boolean onlyTopCall;
    private final boolean withLog;

    public CallTracer(boolean onlyTopCall, boolean withLog) {
        this.onlyTopCall = onlyTopCall;
        this.withLog = withLog;
    }

    public final boolean getOnlyTopCall() {
        return this.onlyTopCall;
    }

    public final boolean getWithLog() {
        return this.withLog;
    }

    @Override
    @NotNull
    public String getName() {
        return "callTracer";
    }

    @Override
    public void encodeConfig(@NotNull JsonGenerator gen) {
        gen.writeBooleanField("onlyTopCall", this.onlyTopCall);
        gen.writeBooleanField("withLog", this.withLog);
    }

    @Override
    @NotNull
    public CallFrame decodeResult(@NotNull JsonParser parser) {
        return (CallFrame)parser.readValueAs(CallFrame.class);
    }

    public final boolean component1() {
        return this.onlyTopCall;
    }

    public final boolean component2() {
        return this.withLog;
    }

    @NotNull
    public final CallTracer copy(boolean onlyTopCall, boolean withLog) {
        return new CallTracer(onlyTopCall, withLog);
    }

    public static /* synthetic */ CallTracer copy$default(CallTracer callTracer, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = callTracer.onlyTopCall;
        }
        if ((n & 2) != 0) {
            bl2 = callTracer.withLog;
        }
        return callTracer.copy(bl, bl2);
    }

    @NotNull
    public String toString() {
        return "CallTracer(onlyTopCall=" + this.onlyTopCall + ", withLog=" + this.withLog + ")";
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.onlyTopCall);
        result = result * 31 + Boolean.hashCode(this.withLog);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CallTracer)) {
            return false;
        }
        CallTracer callTracer = (CallTracer)other;
        if (this.onlyTopCall != callTracer.onlyTopCall) {
            return false;
        }
        return this.withLog == callTracer.withLog;
    }

    @JsonDeserialize(using=CallFrameDeserializer.class)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0014\b\u0087\b\u0018\u00002\u00020\u0001B\u00a5\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0010\u0012\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00000\u0010J\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020\u00000\u00102\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000004H\u0002J\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010J\f\u00106\u001a\b\u0012\u0004\u0012\u0002070\u0010JZ\u00108\u001a\b\u0012\u0004\u0012\u0002H90\u0010\"\u0004\b\u0000\u001092\f\u00103\u001a\b\u0012\u0004\u0012\u0002H90426\u0010:\u001a2\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b<\u0012\b\b=\u0012\u0004\b\b(>\u0012\u0013\u0012\u00110?\u00a2\u0006\f\b<\u0012\b\b=\u0012\u0004\b\b(@\u0012\u0004\u0012\u0002H90;H\u0002J\t\u0010A\u001a\u00020\u0003H\u00c6\u0003J\t\u0010B\u001a\u00020\u0005H\u00c6\u0003J\t\u0010C\u001a\u00020\u0007H\u00c6\u0003J\t\u0010D\u001a\u00020\u0007H\u00c6\u0003J\t\u0010E\u001a\u00020\nH\u00c6\u0003J\u000b\u0010F\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010G\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010H\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010I\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010J\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0010H\u00c6\u0003J\u0011\u0010K\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0010H\u00c6\u0003J\u000b\u0010L\u001a\u0004\u0018\u00010\u0014H\u00c6\u0003J\u0015\u0010M\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00170\u0016H\u00c6\u0003J\u00b1\u0001\u0010N\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u00102\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00102\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00170\u0016H\u00c6\u0001J\u0013\u0010O\u001a\u00020/2\b\u0010P\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010Q\u001a\u00020?H\u00d6\u0001J\t\u0010R\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001dR\u0013\u0010\f\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001bR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001bR\u0019\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0019\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010(R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b.\u00100\u00a8\u0006S"}, d2={"Lio/ethers/core/types/tracers/CallTracer$CallFrame;", "", "type", "", "from", "Lio/ethers/core/types/Address;", "gas", "", "gasUsed", "input", "Lio/ethers/core/types/Bytes;", "to", "output", "error", "revertReason", "calls", "", "logs", "Lio/ethers/core/types/tracers/CallTracer$CallLog;", "value", "Ljava/math/BigInteger;", "otherFields", "", "Lcom/fasterxml/jackson/databind/JsonNode;", "<init>", "(Ljava/lang/String;Lio/ethers/core/types/Address;JJLio/ethers/core/types/Bytes;Lio/ethers/core/types/Address;Lio/ethers/core/types/Bytes;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/math/BigInteger;Ljava/util/Map;)V", "getType", "()Ljava/lang/String;", "getFrom", "()Lio/ethers/core/types/Address;", "getGas", "()J", "getGasUsed", "getInput", "()Lio/ethers/core/types/Bytes;", "getTo", "getOutput", "getError", "getRevertReason", "getCalls", "()Ljava/util/List;", "getLogs", "getValue", "()Ljava/math/BigInteger;", "getOtherFields", "()Ljava/util/Map;", "isError", "", "()Z", "flatten", "addAllCallFrames", "ret", "", "getAllCallLogs", "getAllLogs", "Lio/ethers/core/types/Log;", "flattenLogs", "T", "mapper", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "log", "", "index", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "copy", "equals", "other", "hashCode", "toString", "ethers-core"})
    public static final class CallFrame {
        @NotNull
        private final String type;
        @NotNull
        private final Address from;
        private final long gas;
        private final long gasUsed;
        @NotNull
        private final Bytes input;
        @Nullable
        private final Address to;
        @Nullable
        private final Bytes output;
        @Nullable
        private final String error;
        @Nullable
        private final String revertReason;
        @Nullable
        private final List<CallFrame> calls;
        @Nullable
        private final List<CallLog> logs;
        @Nullable
        private final BigInteger value;
        @NotNull
        private final Map<String, JsonNode> otherFields;

        public CallFrame(@NotNull String type, @NotNull Address from, long gas, long gasUsed, @NotNull Bytes input, @Nullable Address to, @Nullable Bytes output, @Nullable String error, @Nullable String revertReason, @Nullable List<CallFrame> calls, @Nullable List<CallLog> logs, @Nullable BigInteger value, @NotNull Map<String, ? extends JsonNode> otherFields) {
            this.type = type;
            this.from = from;
            this.gas = gas;
            this.gasUsed = gasUsed;
            this.input = input;
            this.to = to;
            this.output = output;
            this.error = error;
            this.revertReason = revertReason;
            this.calls = calls;
            this.logs = logs;
            this.value = value;
            this.otherFields = otherFields;
        }

        public /* synthetic */ CallFrame(String string, Address address, long l, long l2, Bytes bytes, Address address2, Bytes bytes2, String string2, String string3, List list, List list2, BigInteger bigInteger, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                address2 = null;
            }
            if ((n & 0x40) != 0) {
                bytes2 = null;
            }
            if ((n & 0x80) != 0) {
                string2 = null;
            }
            if ((n & 0x100) != 0) {
                string3 = null;
            }
            if ((n & 0x200) != 0) {
                list = null;
            }
            if ((n & 0x400) != 0) {
                list2 = null;
            }
            if ((n & 0x800) != 0) {
                bigInteger = null;
            }
            if ((n & 0x1000) != 0) {
                map = MapsKt.emptyMap();
            }
            this(string, address, l, l2, bytes, address2, bytes2, string2, string3, list, list2, bigInteger, map);
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final Address getFrom() {
            return this.from;
        }

        public final long getGas() {
            return this.gas;
        }

        public final long getGasUsed() {
            return this.gasUsed;
        }

        @NotNull
        public final Bytes getInput() {
            return this.input;
        }

        @Nullable
        public final Address getTo() {
            return this.to;
        }

        @Nullable
        public final Bytes getOutput() {
            return this.output;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        @Nullable
        public final String getRevertReason() {
            return this.revertReason;
        }

        @Nullable
        public final List<CallFrame> getCalls() {
            return this.calls;
        }

        @Nullable
        public final List<CallLog> getLogs() {
            return this.logs;
        }

        @Nullable
        public final BigInteger getValue() {
            return this.value;
        }

        @NotNull
        public final Map<String, JsonNode> getOtherFields() {
            return this.otherFields;
        }

        public final boolean isError() {
            return this.error != null || this.revertReason != null;
        }

        @NotNull
        public final List<CallFrame> flatten() {
            return this.addAllCallFrames(new ArrayList());
        }

        private final List<CallFrame> addAllCallFrames(List<CallFrame> ret) {
            block1: {
                ret.add(this);
                List<CallFrame> list = this.calls;
                if (list == null) break block1;
                List<CallFrame> it = list;
                boolean bl = false;
                int n = ((Collection)it).size();
                for (int i = 0; i < n; ++i) {
                    it.get(i).addAllCallFrames(ret);
                }
            }
            return ret;
        }

        @NotNull
        public final List<CallLog> getAllCallLogs() {
            return this.flattenLogs(new ArrayList(), CallFrame::getAllCallLogs$lambda$1);
        }

        @NotNull
        public final List<Log> getAllLogs() {
            return this.flattenLogs(new ArrayList(), CallFrame::getAllLogs$lambda$2);
        }

        private final <T> List<T> flattenLogs(List<T> ret, Function2<? super CallLog, ? super Integer, ? extends T> mapper) {
            block4: {
                int i;
                int n;
                List<Object> it;
                if (this.isError()) {
                    return ret;
                }
                List<CallFrame> list = this.calls;
                if (list != null) {
                    it = list;
                    boolean bl = false;
                    n = ((Collection)it).size();
                    for (i = 0; i < n; ++i) {
                        ((CallFrame)it.get(i)).flattenLogs(ret, mapper);
                    }
                }
                List<CallLog> list2 = this.logs;
                if (list2 == null) break block4;
                it = list2;
                boolean bl = false;
                n = ((Collection)it).size();
                for (i = 0; i < n; ++i) {
                    ret.add(mapper.invoke(it.get(i), (Object)ret.size()));
                }
            }
            return ret;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @NotNull
        public final Address component2() {
            return this.from;
        }

        public final long component3() {
            return this.gas;
        }

        public final long component4() {
            return this.gasUsed;
        }

        @NotNull
        public final Bytes component5() {
            return this.input;
        }

        @Nullable
        public final Address component6() {
            return this.to;
        }

        @Nullable
        public final Bytes component7() {
            return this.output;
        }

        @Nullable
        public final String component8() {
            return this.error;
        }

        @Nullable
        public final String component9() {
            return this.revertReason;
        }

        @Nullable
        public final List<CallFrame> component10() {
            return this.calls;
        }

        @Nullable
        public final List<CallLog> component11() {
            return this.logs;
        }

        @Nullable
        public final BigInteger component12() {
            return this.value;
        }

        @NotNull
        public final Map<String, JsonNode> component13() {
            return this.otherFields;
        }

        @NotNull
        public final CallFrame copy(@NotNull String type, @NotNull Address from, long gas, long gasUsed, @NotNull Bytes input, @Nullable Address to, @Nullable Bytes output, @Nullable String error, @Nullable String revertReason, @Nullable List<CallFrame> calls, @Nullable List<CallLog> logs, @Nullable BigInteger value, @NotNull Map<String, ? extends JsonNode> otherFields) {
            return new CallFrame(type, from, gas, gasUsed, input, to, output, error, revertReason, calls, logs, value, otherFields);
        }

        public static /* synthetic */ CallFrame copy$default(CallFrame callFrame, String string, Address address, long l, long l2, Bytes bytes, Address address2, Bytes bytes2, String string2, String string3, List list, List list2, BigInteger bigInteger, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                string = callFrame.type;
            }
            if ((n & 2) != 0) {
                address = callFrame.from;
            }
            if ((n & 4) != 0) {
                l = callFrame.gas;
            }
            if ((n & 8) != 0) {
                l2 = callFrame.gasUsed;
            }
            if ((n & 0x10) != 0) {
                bytes = callFrame.input;
            }
            if ((n & 0x20) != 0) {
                address2 = callFrame.to;
            }
            if ((n & 0x40) != 0) {
                bytes2 = callFrame.output;
            }
            if ((n & 0x80) != 0) {
                string2 = callFrame.error;
            }
            if ((n & 0x100) != 0) {
                string3 = callFrame.revertReason;
            }
            if ((n & 0x200) != 0) {
                list = callFrame.calls;
            }
            if ((n & 0x400) != 0) {
                list2 = callFrame.logs;
            }
            if ((n & 0x800) != 0) {
                bigInteger = callFrame.value;
            }
            if ((n & 0x1000) != 0) {
                map = callFrame.otherFields;
            }
            return callFrame.copy(string, address, l, l2, bytes, address2, bytes2, string2, string3, list, list2, bigInteger, map);
        }

        @NotNull
        public String toString() {
            return "CallFrame(type=" + this.type + ", from=" + this.from + ", gas=" + this.gas + ", gasUsed=" + this.gasUsed + ", input=" + this.input + ", to=" + this.to + ", output=" + this.output + ", error=" + this.error + ", revertReason=" + this.revertReason + ", calls=" + this.calls + ", logs=" + this.logs + ", value=" + this.value + ", otherFields=" + this.otherFields + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.from.hashCode();
            result = result * 31 + Long.hashCode(this.gas);
            result = result * 31 + Long.hashCode(this.gasUsed);
            result = result * 31 + this.input.hashCode();
            result = result * 31 + (this.to == null ? 0 : this.to.hashCode());
            result = result * 31 + (this.output == null ? 0 : this.output.hashCode());
            result = result * 31 + (this.error == null ? 0 : this.error.hashCode());
            result = result * 31 + (this.revertReason == null ? 0 : this.revertReason.hashCode());
            result = result * 31 + (this.calls == null ? 0 : ((Object)this.calls).hashCode());
            result = result * 31 + (this.logs == null ? 0 : ((Object)this.logs).hashCode());
            result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
            result = result * 31 + ((Object)this.otherFields).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CallFrame)) {
                return false;
            }
            CallFrame callFrame = (CallFrame)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)callFrame.type)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.from, (Object)callFrame.from)) {
                return false;
            }
            if (this.gas != callFrame.gas) {
                return false;
            }
            if (this.gasUsed != callFrame.gasUsed) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.input, (Object)callFrame.input)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.to, (Object)callFrame.to)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.output, (Object)callFrame.output)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.error, (Object)callFrame.error)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.revertReason, (Object)callFrame.revertReason)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.calls, callFrame.calls)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.logs, callFrame.logs)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.value, (Object)callFrame.value)) {
                return false;
            }
            return Intrinsics.areEqual(this.otherFields, callFrame.otherFields);
        }

        private static final CallLog getAllCallLogs$lambda$1(CallLog log, int n) {
            return log;
        }

        private static final Log getAllLogs$lambda$2(CallLog log, int index) {
            return log.toLog(index);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/ethers/core/types/tracers/CallTracer$CallFrameDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lio/ethers/core/types/tracers/CallTracer$CallFrame;", "<init>", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "ethers-core"})
    @SourceDebugExtension(value={"SMAP\nCallTracer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallTracer.kt\nio/ethers/core/types/tracers/CallTracer$CallFrameDeserializer\n+ 2 JsonParserExtensions.kt\nio/ethers/core/JsonParserExtensionsKt\n*L\n1#1,240:1\n33#2,4:241\n75#2,4:245\n75#2,4:249\n194#2,14:253\n194#2,14:267\n38#2:281\n*S KotlinDebug\n*F\n+ 1 CallTracer.kt\nio/ethers/core/types/tracers/CallTracer$CallFrameDeserializer\n*L\n182#1:241,4\n188#1:245,4\n190#1:249,4\n193#1:253,14\n194#1:267,14\n182#1:281\n*E\n"})
    private static final class CallFrameDeserializer
    extends JsonDeserializer<CallFrame> {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public CallFrame deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
            Bytes bytes;
            Address address;
            String type = null;
            Address from = null;
            long gas = 0L;
            gas = -1L;
            long gasUsed = 0L;
            gasUsed = -1L;
            Ref.ObjectRef to = new Ref.ObjectRef();
            Bytes input = null;
            Ref.ObjectRef output = new Ref.ObjectRef();
            Object error = null;
            Object revertReason = null;
            Ref.ObjectRef calls = new Ref.ObjectRef();
            Ref.ObjectRef logs = new Ref.ObjectRef();
            BigInteger value = null;
            HashMap otherFields = null;
            JsonParser $this$forEachObjectField$iv = p;
            boolean $i$f$forEachObjectField = false;
            while (!JsonParserExtensionsKt.isNextTokenObjectEnd($this$forEachObjectField$iv)) {
                String field$iv = $this$forEachObjectField$iv.currentName();
                $this$forEachObjectField$iv.nextToken();
                String name = field$iv;
                boolean bl = false;
                switch (name) {
                    case "type": {
                        type = p.getText();
                        break;
                    }
                    case "from": {
                        from = JsonParserExtensionsKt.readAddress(p);
                        break;
                    }
                    case "gas": {
                        gas = JsonParserExtensionsKt.readHexLong(p);
                        break;
                    }
                    case "gasUsed": {
                        gasUsed = JsonParserExtensionsKt.readHexLong(p);
                        break;
                    }
                    case "to": {
                        JsonParser $this$deserialize_u24lambda_u244_u24lambda_u240;
                        Ref.ObjectRef objectRef;
                        Address address2;
                        Ref.ObjectRef objectRef2 = to;
                        JsonParser $this$readOrNull$iv = p;
                        boolean $i$f$readOrNull = false;
                        if ($this$readOrNull$iv.getCurrentToken() == JsonToken.VALUE_NULL) {
                            address2 = null;
                        } else {
                            JsonParser jsonParser = $this$readOrNull$iv;
                            objectRef = objectRef2;
                            boolean bl2 = false;
                            address2 = JsonParserExtensionsKt.readAddress($this$deserialize_u24lambda_u244_u24lambda_u240);
                            objectRef2 = objectRef;
                        }
                        objectRef2.element = address2;
                        break;
                    }
                    case "input": {
                        input = JsonParserExtensionsKt.readBytes(p);
                        break;
                    }
                    case "output": {
                        Bytes bytes2;
                        JsonParser $this$deserialize_u24lambda_u244_u24lambda_u240;
                        Ref.ObjectRef objectRef;
                        Ref.ObjectRef objectRef3 = output;
                        JsonParser $this$readOrNull$iv = p;
                        boolean $i$f$readOrNull = false;
                        if ($this$readOrNull$iv.getCurrentToken() == JsonToken.VALUE_NULL) {
                            bytes2 = null;
                        } else {
                            void $this$deserialize_u24lambda_u244_u24lambda_u241;
                            $this$deserialize_u24lambda_u244_u24lambda_u240 = $this$readOrNull$iv;
                            objectRef = objectRef3;
                            boolean bl3 = false;
                            bytes2 = JsonParserExtensionsKt.readBytes((JsonParser)$this$deserialize_u24lambda_u244_u24lambda_u241);
                            objectRef3 = objectRef;
                        }
                        objectRef3.element = bytes2;
                        break;
                    }
                    case "error": {
                        error = p.readValueAs(String.class);
                        break;
                    }
                    case "revertReason": {
                        revertReason = p.readValueAs(String.class);
                        break;
                    }
                    case "calls": {
                        ArrayList<Object> arrayList;
                        ArrayList<Object> ret$iv;
                        List list;
                        JsonParser $this$readListOf$iv;
                        JsonParser $this$readOrNull$iv = p;
                        Ref.ObjectRef objectRef = calls;
                        boolean $i$f$readListOf = false;
                        if ($this$readListOf$iv.getCurrentToken() == JsonToken.VALUE_NULL) {
                            list = CollectionsKt.emptyList();
                        } else if ($this$readListOf$iv.nextToken() == JsonToken.END_ARRAY) {
                            list = CollectionsKt.emptyList();
                        } else {
                            ret$iv = new ArrayList<Object>();
                            do {
                                void $this$deserialize_u24lambda_u244_u24lambda_u242;
                                JsonParser bl3 = $this$readListOf$iv;
                                arrayList = ret$iv;
                                boolean bl4 = false;
                                arrayList.add((CallFrame)$this$deserialize_u24lambda_u244_u24lambda_u242.readValueAs(CallFrame.class));
                            } while ($this$readListOf$iv.nextToken() != JsonToken.END_ARRAY);
                            list = ret$iv;
                        }
                        objectRef.element = list;
                        break;
                    }
                    case "logs": {
                        List list;
                        ArrayList<Object> arrayList;
                        ArrayList<Object> ret$iv;
                        JsonParser $this$readListOf$iv = p;
                        Ref.ObjectRef objectRef = logs;
                        boolean $i$f$readListOf = false;
                        if ($this$readListOf$iv.getCurrentToken() == JsonToken.VALUE_NULL) {
                            list = CollectionsKt.emptyList();
                        } else if ($this$readListOf$iv.nextToken() == JsonToken.END_ARRAY) {
                            list = CollectionsKt.emptyList();
                        } else {
                            ret$iv = new ArrayList();
                            do {
                                void $this$deserialize_u24lambda_u244_u24lambda_u243;
                                JsonParser $this$deserialize_u24lambda_u244_u24lambda_u242 = $this$readListOf$iv;
                                arrayList = ret$iv;
                                boolean bl5 = false;
                                arrayList.add((CallLog)$this$deserialize_u24lambda_u244_u24lambda_u243.readValueAs(CallLog.class));
                            } while ($this$readListOf$iv.nextToken() != JsonToken.END_ARRAY);
                            list = ret$iv;
                        }
                        objectRef.element = list;
                        break;
                    }
                    case "value": {
                        value = JsonParserExtensionsKt.readHexBigInteger(p);
                        break;
                    }
                    default: {
                        if (otherFields == null) {
                            otherFields = new HashMap();
                        }
                        ((Map)otherFields).put(p.currentName(), p.readValueAs(JsonNode.class));
                    }
                }
            }
            String string = type;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"type");
                string = null;
            }
            if ((address = from) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"from");
                address = null;
            }
            if ((bytes = input) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"input");
                bytes = null;
            }
            Address address3 = (Address)to.element;
            Bytes bytes3 = (Bytes)output.element;
            String string2 = (String)error;
            String string3 = (String)revertReason;
            List list = (List)calls.element;
            List list2 = (List)logs.element;
            Map map = otherFields;
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            return new CallFrame(string, address, gas, gasUsed, bytes, address3, bytes3, string2, string3, list, list2, value, map);
        }
    }

    @JsonDeserialize(using=CallLogDeserializer.class)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J-\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lio/ethers/core/types/tracers/CallTracer$CallLog;", "", "address", "Lio/ethers/core/types/Address;", "topics", "", "Lio/ethers/core/types/Hash;", "data", "Lio/ethers/core/types/Bytes;", "<init>", "(Lio/ethers/core/types/Address;Ljava/util/List;Lio/ethers/core/types/Bytes;)V", "getAddress", "()Lio/ethers/core/types/Address;", "getTopics", "()Ljava/util/List;", "getData", "()Lio/ethers/core/types/Bytes;", "toLog", "Lio/ethers/core/types/Log;", "logIndex", "", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "ethers-core"})
    public static final class CallLog {
        @NotNull
        private final Address address;
        @NotNull
        private final List<Hash> topics;
        @NotNull
        private final Bytes data;

        public CallLog(@NotNull Address address, @NotNull List<Hash> topics, @NotNull Bytes data) {
            this.address = address;
            this.topics = topics;
            this.data = data;
        }

        @NotNull
        public final Address getAddress() {
            return this.address;
        }

        @NotNull
        public final List<Hash> getTopics() {
            return this.topics;
        }

        @NotNull
        public final Bytes getData() {
            return this.data;
        }

        @JvmOverloads
        @NotNull
        public final Log toLog(int logIndex) {
            return new Log(this.address, this.topics, this.data, Hash.ZERO, -1L, -1L, Hash.ZERO, -1, logIndex, false);
        }

        public static /* synthetic */ Log toLog$default(CallLog callLog, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = -1;
            }
            return callLog.toLog(n);
        }

        @NotNull
        public final Address component1() {
            return this.address;
        }

        @NotNull
        public final List<Hash> component2() {
            return this.topics;
        }

        @NotNull
        public final Bytes component3() {
            return this.data;
        }

        @NotNull
        public final CallLog copy(@NotNull Address address, @NotNull List<Hash> topics, @NotNull Bytes data) {
            return new CallLog(address, topics, data);
        }

        public static /* synthetic */ CallLog copy$default(CallLog callLog, Address address, List list, Bytes bytes, int n, Object object) {
            if ((n & 1) != 0) {
                address = callLog.address;
            }
            if ((n & 2) != 0) {
                list = callLog.topics;
            }
            if ((n & 4) != 0) {
                bytes = callLog.data;
            }
            return callLog.copy(address, list, bytes);
        }

        @NotNull
        public String toString() {
            return "CallLog(address=" + this.address + ", topics=" + this.topics + ", data=" + this.data + ")";
        }

        public int hashCode() {
            int result = this.address.hashCode();
            result = result * 31 + ((Object)this.topics).hashCode();
            result = result * 31 + this.data.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CallLog)) {
                return false;
            }
            CallLog callLog = (CallLog)other;
            if (!Intrinsics.areEqual((Object)this.address, (Object)callLog.address)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.topics, callLog.topics)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.data, (Object)callLog.data);
        }

        @JvmOverloads
        @NotNull
        public final Log toLog() {
            return CallLog.toLog$default(this, 0, 1, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/ethers/core/types/tracers/CallTracer$CallLogDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lio/ethers/core/types/tracers/CallTracer$CallLog;", "<init>", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "ethers-core"})
    @SourceDebugExtension(value={"SMAP\nCallTracer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallTracer.kt\nio/ethers/core/types/tracers/CallTracer$CallLogDeserializer\n+ 2 JsonParserExtensions.kt\nio/ethers/core/JsonParserExtensionsKt\n*L\n1#1,240:1\n33#2,4:241\n194#2,14:245\n38#2:259\n*S KotlinDebug\n*F\n+ 1 CallTracer.kt\nio/ethers/core/types/tracers/CallTracer$CallLogDeserializer\n*L\n228#1:241,4\n231#1:245,14\n228#1:259\n*E\n"})
    private static final class CallLogDeserializer
    extends JsonDeserializer<CallLog> {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public CallLog deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
            Bytes bytes;
            List list;
            Address address = null;
            Ref.ObjectRef topics = new Ref.ObjectRef();
            Bytes data = null;
            JsonParser $this$forEachObjectField$iv = p;
            boolean $i$f$forEachObjectField = false;
            while (!JsonParserExtensionsKt.isNextTokenObjectEnd($this$forEachObjectField$iv)) {
                String field$iv = $this$forEachObjectField$iv.currentName();
                $this$forEachObjectField$iv.nextToken();
                String name = field$iv;
                boolean bl = false;
                switch (name) {
                    case "address": {
                        address = JsonParserExtensionsKt.readAddress(p);
                        break;
                    }
                    case "topics": {
                        List list2;
                        void $this$readListOf$iv;
                        JsonParser jsonParser = p;
                        Ref.ObjectRef objectRef = topics;
                        boolean $i$f$readListOf = false;
                        if ($this$readListOf$iv.getCurrentToken() == JsonToken.VALUE_NULL) {
                            list2 = CollectionsKt.emptyList();
                        } else if ($this$readListOf$iv.nextToken() == JsonToken.END_ARRAY) {
                            list2 = CollectionsKt.emptyList();
                        } else {
                            ArrayList<Hash> ret$iv = new ArrayList<Hash>();
                            do {
                                void $this$deserialize_u24lambda_u241_u24lambda_u240;
                                void var16_16 = $this$readListOf$iv;
                                ArrayList<Hash> arrayList = ret$iv;
                                boolean bl2 = false;
                                arrayList.add(JsonParserExtensionsKt.readHash((JsonParser)$this$deserialize_u24lambda_u241_u24lambda_u240));
                            } while ($this$readListOf$iv.nextToken() != JsonToken.END_ARRAY);
                            list2 = ret$iv;
                        }
                        objectRef.element = list2;
                        break;
                    }
                    case "data": {
                        data = JsonParserExtensionsKt.readBytes(p);
                    }
                }
            }
            Address address2 = address;
            if (address2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"address");
                address2 = null;
            }
            if (topics.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"topics");
                list = null;
            } else {
                list = (List)topics.element;
            }
            if ((bytes = data) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"data");
                bytes = null;
            }
            return new CallLog(address2, list, bytes);
        }
    }
}

