/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bloom;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.Hash;
import io.ethers.core.types.Log;
import io.ethers.core.types.TxReceiptDeserializer;
import io.ethers.core.types.transaction.TxType;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=TxReceiptDeserializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\u000b\n\u0002\b\u0019\b\u0087\b\u0018\u00002\u00020\u0001B\u00a1\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\n\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0005\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u0012\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c\u00a2\u0006\u0004\b\u001f\u0010 J\u000e\u0010>\u001a\u00020\u00172\u0006\u0010?\u001a\u00020\u0017J\t\u0010@\u001a\u00020\u0003H\u00c6\u0003J\t\u0010A\u001a\u00020\u0005H\u00c6\u0003J\t\u0010B\u001a\u00020\u0003H\u00c6\u0003J\t\u0010C\u001a\u00020\bH\u00c6\u0003J\t\u0010D\u001a\u00020\nH\u00c6\u0003J\u000b\u0010E\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010F\u001a\u00020\u0005H\u00c6\u0003J\t\u0010G\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010H\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u00c6\u0003J\t\u0010J\u001a\u00020\u0013H\u00c6\u0003J\t\u0010K\u001a\u00020\u0015H\u00c6\u0003J\t\u0010L\u001a\u00020\u0017H\u00c6\u0003J\t\u0010M\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010N\u001a\u0004\u0018\u00010\u001aH\u00c6\u0003J\u0015\u0010O\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cH\u00c6\u0003J\u00c1\u0001\u0010P\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u00052\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\n2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00052\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cH\u00c6\u0001J\u0013\u0010Q\u001a\u00020<2\b\u0010R\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010S\u001a\u00020\bH\u00d6\u0001J\t\u0010T\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\"R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010)R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010$R\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010$R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010)R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010$R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u001d\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0011\u0010;\u001a\u00020<8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010=\u00a8\u0006U"}, d2={"Lio/ethers/core/types/TransactionReceipt;", "", "blockHash", "Lio/ethers/core/types/Hash;", "blockNumber", "", "transactionHash", "transactionIndex", "", "from", "Lio/ethers/core/types/Address;", "to", "gasUsed", "cumulativeGasUsed", "contractAddress", "logs", "", "Lio/ethers/core/types/Log;", "logsBloom", "Lio/ethers/core/types/Bloom;", "type", "Lio/ethers/core/types/transaction/TxType;", "effectiveGasPrice", "Ljava/math/BigInteger;", "status", "root", "Lio/ethers/core/types/Bytes;", "otherFields", "", "", "Lcom/fasterxml/jackson/databind/JsonNode;", "<init>", "(Lio/ethers/core/types/Hash;JLio/ethers/core/types/Hash;ILio/ethers/core/types/Address;Lio/ethers/core/types/Address;JJLio/ethers/core/types/Address;Ljava/util/List;Lio/ethers/core/types/Bloom;Lio/ethers/core/types/transaction/TxType;Ljava/math/BigInteger;JLio/ethers/core/types/Bytes;Ljava/util/Map;)V", "getBlockHash", "()Lio/ethers/core/types/Hash;", "getBlockNumber", "()J", "getTransactionHash", "getTransactionIndex", "()I", "getFrom", "()Lio/ethers/core/types/Address;", "getTo", "getGasUsed", "getCumulativeGasUsed", "getContractAddress", "getLogs", "()Ljava/util/List;", "getLogsBloom", "()Lio/ethers/core/types/Bloom;", "getType", "()Lio/ethers/core/types/transaction/TxType;", "getEffectiveGasPrice", "()Ljava/math/BigInteger;", "getStatus", "getRoot", "()Lio/ethers/core/types/Bytes;", "getOtherFields", "()Ljava/util/Map;", "isSuccessful", "", "()Z", "getEffectiveGasTip", "baseFee", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "copy", "equals", "other", "hashCode", "toString", "ethers-core"})
public final class TransactionReceipt {
    @NotNull
    private final Hash blockHash;
    private final long blockNumber;
    @NotNull
    private final Hash transactionHash;
    private final int transactionIndex;
    @NotNull
    private final Address from;
    @Nullable
    private final Address to;
    private final long gasUsed;
    private final long cumulativeGasUsed;
    @Nullable
    private final Address contractAddress;
    @NotNull
    private final List<Log> logs;
    @NotNull
    private final Bloom logsBloom;
    @NotNull
    private final TxType type;
    @NotNull
    private final BigInteger effectiveGasPrice;
    private final long status;
    @Nullable
    private final Bytes root;
    @NotNull
    private final Map<String, JsonNode> otherFields;

    public TransactionReceipt(@NotNull Hash blockHash, long blockNumber, @NotNull Hash transactionHash, int transactionIndex, @NotNull Address from, @Nullable Address to, long gasUsed, long cumulativeGasUsed, @Nullable Address contractAddress, @NotNull List<Log> logs, @NotNull Bloom logsBloom, @NotNull TxType type, @NotNull BigInteger effectiveGasPrice, long status, @Nullable Bytes root, @NotNull Map<String, ? extends JsonNode> otherFields) {
        this.blockHash = blockHash;
        this.blockNumber = blockNumber;
        this.transactionHash = transactionHash;
        this.transactionIndex = transactionIndex;
        this.from = from;
        this.to = to;
        this.gasUsed = gasUsed;
        this.cumulativeGasUsed = cumulativeGasUsed;
        this.contractAddress = contractAddress;
        this.logs = logs;
        this.logsBloom = logsBloom;
        this.type = type;
        this.effectiveGasPrice = effectiveGasPrice;
        this.status = status;
        this.root = root;
        this.otherFields = otherFields;
    }

    public /* synthetic */ TransactionReceipt(Hash hash, long l, Hash hash2, int n, Address address, Address address2, long l2, long l3, Address address3, List list, Bloom bloom, TxType txType, BigInteger bigInteger, long l4, Bytes bytes, Map map, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x8000) != 0) {
            map = MapsKt.emptyMap();
        }
        this(hash, l, hash2, n, address, address2, l2, l3, address3, list, bloom, txType, bigInteger, l4, bytes, map);
    }

    @NotNull
    public final Hash getBlockHash() {
        return this.blockHash;
    }

    public final long getBlockNumber() {
        return this.blockNumber;
    }

    @NotNull
    public final Hash getTransactionHash() {
        return this.transactionHash;
    }

    public final int getTransactionIndex() {
        return this.transactionIndex;
    }

    @NotNull
    public final Address getFrom() {
        return this.from;
    }

    @Nullable
    public final Address getTo() {
        return this.to;
    }

    public final long getGasUsed() {
        return this.gasUsed;
    }

    public final long getCumulativeGasUsed() {
        return this.cumulativeGasUsed;
    }

    @Nullable
    public final Address getContractAddress() {
        return this.contractAddress;
    }

    @NotNull
    public final List<Log> getLogs() {
        return this.logs;
    }

    @NotNull
    public final Bloom getLogsBloom() {
        return this.logsBloom;
    }

    @NotNull
    public final TxType getType() {
        return this.type;
    }

    @NotNull
    public final BigInteger getEffectiveGasPrice() {
        return this.effectiveGasPrice;
    }

    public final long getStatus() {
        return this.status;
    }

    @Nullable
    public final Bytes getRoot() {
        return this.root;
    }

    @NotNull
    public final Map<String, JsonNode> getOtherFields() {
        return this.otherFields;
    }

    public final boolean isSuccessful() {
        return this.status == 1L;
    }

    @NotNull
    public final BigInteger getEffectiveGasTip(@NotNull BigInteger baseFee) {
        BigInteger bigInteger = this.effectiveGasPrice.subtract(baseFee);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"subtract(...)");
        return bigInteger;
    }

    @NotNull
    public final Hash component1() {
        return this.blockHash;
    }

    public final long component2() {
        return this.blockNumber;
    }

    @NotNull
    public final Hash component3() {
        return this.transactionHash;
    }

    public final int component4() {
        return this.transactionIndex;
    }

    @NotNull
    public final Address component5() {
        return this.from;
    }

    @Nullable
    public final Address component6() {
        return this.to;
    }

    public final long component7() {
        return this.gasUsed;
    }

    public final long component8() {
        return this.cumulativeGasUsed;
    }

    @Nullable
    public final Address component9() {
        return this.contractAddress;
    }

    @NotNull
    public final List<Log> component10() {
        return this.logs;
    }

    @NotNull
    public final Bloom component11() {
        return this.logsBloom;
    }

    @NotNull
    public final TxType component12() {
        return this.type;
    }

    @NotNull
    public final BigInteger component13() {
        return this.effectiveGasPrice;
    }

    public final long component14() {
        return this.status;
    }

    @Nullable
    public final Bytes component15() {
        return this.root;
    }

    @NotNull
    public final Map<String, JsonNode> component16() {
        return this.otherFields;
    }

    @NotNull
    public final TransactionReceipt copy(@NotNull Hash blockHash, long blockNumber, @NotNull Hash transactionHash, int transactionIndex, @NotNull Address from, @Nullable Address to, long gasUsed, long cumulativeGasUsed, @Nullable Address contractAddress, @NotNull List<Log> logs, @NotNull Bloom logsBloom, @NotNull TxType type, @NotNull BigInteger effectiveGasPrice, long status, @Nullable Bytes root, @NotNull Map<String, ? extends JsonNode> otherFields) {
        return new TransactionReceipt(blockHash, blockNumber, transactionHash, transactionIndex, from, to, gasUsed, cumulativeGasUsed, contractAddress, logs, logsBloom, type, effectiveGasPrice, status, root, otherFields);
    }

    public static /* synthetic */ TransactionReceipt copy$default(TransactionReceipt transactionReceipt, Hash hash, long l, Hash hash2, int n, Address address, Address address2, long l2, long l3, Address address3, List list, Bloom bloom, TxType txType, BigInteger bigInteger, long l4, Bytes bytes, Map map, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hash = transactionReceipt.blockHash;
        }
        if ((n2 & 2) != 0) {
            l = transactionReceipt.blockNumber;
        }
        if ((n2 & 4) != 0) {
            hash2 = transactionReceipt.transactionHash;
        }
        if ((n2 & 8) != 0) {
            n = transactionReceipt.transactionIndex;
        }
        if ((n2 & 0x10) != 0) {
            address = transactionReceipt.from;
        }
        if ((n2 & 0x20) != 0) {
            address2 = transactionReceipt.to;
        }
        if ((n2 & 0x40) != 0) {
            l2 = transactionReceipt.gasUsed;
        }
        if ((n2 & 0x80) != 0) {
            l3 = transactionReceipt.cumulativeGasUsed;
        }
        if ((n2 & 0x100) != 0) {
            address3 = transactionReceipt.contractAddress;
        }
        if ((n2 & 0x200) != 0) {
            list = transactionReceipt.logs;
        }
        if ((n2 & 0x400) != 0) {
            bloom = transactionReceipt.logsBloom;
        }
        if ((n2 & 0x800) != 0) {
            txType = transactionReceipt.type;
        }
        if ((n2 & 0x1000) != 0) {
            bigInteger = transactionReceipt.effectiveGasPrice;
        }
        if ((n2 & 0x2000) != 0) {
            l4 = transactionReceipt.status;
        }
        if ((n2 & 0x4000) != 0) {
            bytes = transactionReceipt.root;
        }
        if ((n2 & 0x8000) != 0) {
            map = transactionReceipt.otherFields;
        }
        return transactionReceipt.copy(hash, l, hash2, n, address, address2, l2, l3, address3, list, bloom, txType, bigInteger, l4, bytes, map);
    }

    @NotNull
    public String toString() {
        return "TransactionReceipt(blockHash=" + this.blockHash + ", blockNumber=" + this.blockNumber + ", transactionHash=" + this.transactionHash + ", transactionIndex=" + this.transactionIndex + ", from=" + this.from + ", to=" + this.to + ", gasUsed=" + this.gasUsed + ", cumulativeGasUsed=" + this.cumulativeGasUsed + ", contractAddress=" + this.contractAddress + ", logs=" + this.logs + ", logsBloom=" + this.logsBloom + ", type=" + this.type + ", effectiveGasPrice=" + this.effectiveGasPrice + ", status=" + this.status + ", root=" + this.root + ", otherFields=" + this.otherFields + ")";
    }

    public int hashCode() {
        int result = this.blockHash.hashCode();
        result = result * 31 + Long.hashCode(this.blockNumber);
        result = result * 31 + this.transactionHash.hashCode();
        result = result * 31 + Integer.hashCode(this.transactionIndex);
        result = result * 31 + this.from.hashCode();
        result = result * 31 + (this.to == null ? 0 : this.to.hashCode());
        result = result * 31 + Long.hashCode(this.gasUsed);
        result = result * 31 + Long.hashCode(this.cumulativeGasUsed);
        result = result * 31 + (this.contractAddress == null ? 0 : this.contractAddress.hashCode());
        result = result * 31 + ((Object)this.logs).hashCode();
        result = result * 31 + this.logsBloom.hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + this.effectiveGasPrice.hashCode();
        result = result * 31 + Long.hashCode(this.status);
        result = result * 31 + (this.root == null ? 0 : this.root.hashCode());
        result = result * 31 + ((Object)this.otherFields).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TransactionReceipt)) {
            return false;
        }
        TransactionReceipt transactionReceipt = (TransactionReceipt)other;
        if (!Intrinsics.areEqual((Object)this.blockHash, (Object)transactionReceipt.blockHash)) {
            return false;
        }
        if (this.blockNumber != transactionReceipt.blockNumber) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.transactionHash, (Object)transactionReceipt.transactionHash)) {
            return false;
        }
        if (this.transactionIndex != transactionReceipt.transactionIndex) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.from, (Object)transactionReceipt.from)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.to, (Object)transactionReceipt.to)) {
            return false;
        }
        if (this.gasUsed != transactionReceipt.gasUsed) {
            return false;
        }
        if (this.cumulativeGasUsed != transactionReceipt.cumulativeGasUsed) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contractAddress, (Object)transactionReceipt.contractAddress)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.logs, transactionReceipt.logs)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.logsBloom, (Object)transactionReceipt.logsBloom)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.type, (Object)transactionReceipt.type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.effectiveGasPrice, (Object)transactionReceipt.effectiveGasPrice)) {
            return false;
        }
        if (this.status != transactionReceipt.status) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.root, (Object)transactionReceipt.root)) {
            return false;
        }
        return Intrinsics.areEqual(this.otherFields, transactionReceipt.otherFields);
    }
}

