/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types;

import io.ethers.core.FastHex;
import io.ethers.core.Result;
import io.ethers.core.ResultKt;
import io.ethers.core.types.Address;
import io.ethers.core.types.InvalidSignatureError;
import io.ethers.crypto.Hashing;
import io.ethers.crypto.Secp256k1;
import io.ethers.rlp.RlpDecodable;
import io.ethers.rlp.RlpDecoder;
import io.ethers.rlp.RlpEncodable;
import io.ethers.rlp.RlpEncoder;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u0001:\u0001*B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u0015J\u0006\u0010\u001c\u001a\u00020\u0006J\b\u0010\u001d\u001a\u00020\u0006H\u0002J\u0006\u0010\u001e\u001a\u00020\u0015J\u0013\u0010\u001f\u001a\u00020\u00132\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020#H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006+"}, d2={"Lio/ethers/core/types/Signature;", "Lio/ethers/rlp/RlpEncodable;", "r", "Ljava/math/BigInteger;", "s", "v", "", "<init>", "(Ljava/math/BigInteger;Ljava/math/BigInteger;J)V", "getR", "()Ljava/math/BigInteger;", "getS", "value", "getV", "()J", "updateV", "", "updatedV", "verifyFromMessage", "", "message", "", "address", "Lio/ethers/core/types/Address;", "verifyFromHash", "hash", "recoverFromMessage", "recoverFromHash", "recoveryId", "getRecoveryId", "toByteArray", "equals", "other", "", "hashCode", "", "toString", "", "rlpEncode", "rlp", "Lio/ethers/rlp/RlpEncoder;", "rlpSize", "Companion", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nSignature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Signature.kt\nio/ethers/core/types/Signature\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n1#2:222\n*E\n"})
public final class Signature
implements RlpEncodable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigInteger r;
    @NotNull
    private final BigInteger s;
    private long v;
    public static final long V_ELECTRUM_OFFSET = 27L;
    public static final long V_EIP155_OFFSET = 35L;

    public Signature(@NotNull BigInteger r, @NotNull BigInteger s, long v) {
        this.r = r;
        this.s = s;
        this.v = v;
    }

    @NotNull
    public final BigInteger getR() {
        return this.r;
    }

    @NotNull
    public final BigInteger getS() {
        return this.s;
    }

    public final long getV() {
        return this.v;
    }

    public final void updateV(long updatedV) {
        this.v = updatedV;
    }

    public final boolean verifyFromMessage(@NotNull byte[] message, @NotNull Address address) {
        return this.verifyFromHash(Hashing.hashMessage((byte[])message), address);
    }

    public final boolean verifyFromHash(@NotNull byte[] hash, @NotNull Address address) {
        return Intrinsics.areEqual((Object)this.recoverFromHash(hash), (Object)address);
    }

    @Nullable
    public final Address recoverFromMessage(@NotNull byte[] message) {
        return this.recoverFromHash(Hashing.hashMessage((byte[])message));
    }

    @Nullable
    public final Address recoverFromHash(@NotNull byte[] hash) {
        long recoveryId = this.getRecoveryId();
        if (recoveryId == -1L) {
            return null;
        }
        byte[] byArray = Secp256k1.INSTANCE.recoverPublicKey(hash, this.r, this.s, recoveryId);
        if (byArray == null) {
            return null;
        }
        byte[] publicKey = byArray;
        return new Address(Secp256k1.INSTANCE.publicKeyToAddress(publicKey));
    }

    public final long recoveryId() {
        long recoveryId = this.getRecoveryId();
        if (recoveryId == -1L) {
            throw new IllegalStateException("Unable to recover 'recId' from 'v': " + this.v);
        }
        return recoveryId;
    }

    private final long getRecoveryId() {
        long l;
        long l2 = this.v;
        if (l2 == 0L) {
            l = 0L;
        } else if (l2 == 1L) {
            l = 1L;
        } else if (l2 == 27L) {
            l = 0L;
        } else if (l2 == 28L) {
            l = 1L;
        } else {
            if (this.v < 35L) {
                return -1L;
            }
            l = (this.v - 1L) % (long)2;
        }
        return l;
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] rBytes;
        byte[] ret = new byte[65];
        System.arraycopy(rBytes, (rBytes = this.r.toByteArray()).length > 32 ? 1 : 0, ret, rBytes.length > 32 ? 0 : 32 - rBytes.length, rBytes.length > 32 ? 32 : rBytes.length);
        byte[] sBytes = this.s.toByteArray();
        System.arraycopy(sBytes, sBytes.length > 32 ? 1 : 0, ret, sBytes.length > 32 ? 32 : 64 - sBytes.length, sBytes.length > 32 ? 32 : sBytes.length);
        ret[64] = (byte)(this.recoveryId() + 27L);
        return ret;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.core.types.Signature");
        Signature cfr_ignored_0 = (Signature)other;
        if (!Intrinsics.areEqual((Object)this.r, (Object)((Signature)other).r)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.s, (Object)((Signature)other).s)) {
            return false;
        }
        return this.v == ((Signature)other).v;
    }

    public int hashCode() {
        int result = this.r.hashCode();
        result = 31 * result + this.s.hashCode();
        result = 31 * result + Long.hashCode(this.v);
        return result;
    }

    @NotNull
    public String toString() {
        return "Signature(r=" + this.r + ", s=" + this.s + ", v=" + this.v + ")";
    }

    public void rlpEncode(@NotNull RlpEncoder rlp) {
        rlp.encode(this.v);
        rlp.encode(this.r);
        rlp.encode(this.s);
    }

    public int rlpSize() {
        RlpEncoder.Companion $this$rlpSize_u24lambda_u240 = RlpEncoder.Companion;
        boolean bl = false;
        return $this$rlpSize_u24lambda_u240.sizeOf(this.v) + $this$rlpSize_u24lambda_u240.sizeOf(this.r) + $this$rlpSize_u24lambda_u240.sizeOf(this.s);
    }

    @JvmStatic
    @Nullable
    public static Signature rlpDecode(@NotNull RlpDecoder rlp) {
        return Companion.rlpDecode(rlp);
    }

    @JvmStatic
    @NotNull
    public static final Result<Signature, InvalidSignatureError> fromByteArray(@NotNull byte[] byteArray) {
        return Companion.fromByteArray(byteArray);
    }

    @JvmStatic
    @NotNull
    public static final Result<Signature, InvalidSignatureError> fromHex(@NotNull String hexString) {
        return Companion.fromHex(hexString);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0017J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/ethers/core/types/Signature$Companion;", "Lio/ethers/rlp/RlpDecodable;", "Lio/ethers/core/types/Signature;", "<init>", "()V", "V_ELECTRUM_OFFSET", "", "V_EIP155_OFFSET", "rlpDecode", "rlp", "Lio/ethers/rlp/RlpDecoder;", "fromByteArray", "Lio/ethers/core/Result;", "Lio/ethers/core/types/InvalidSignatureError;", "byteArray", "", "fromHex", "hexString", "", "ethers-core"})
    public static final class Companion
    implements RlpDecodable<Signature> {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public Signature rlpDecode(@NotNull RlpDecoder rlp) {
            long v = rlp.decodeLong();
            BigInteger bigInteger = rlp.decodeBigInteger();
            if (bigInteger == null) {
                return null;
            }
            BigInteger r = bigInteger;
            BigInteger bigInteger2 = rlp.decodeBigInteger();
            if (bigInteger2 == null) {
                return null;
            }
            BigInteger s = bigInteger2;
            return new Signature(r, s, v);
        }

        @JvmStatic
        @NotNull
        public final Result<Signature, InvalidSignatureError> fromByteArray(@NotNull byte[] byteArray) {
            if (byteArray.length != 65) {
                return ResultKt.failure(new InvalidSignatureError("Invalid signature length: " + byteArray.length));
            }
            BigInteger r = new BigInteger(1, byteArray, 0, 32);
            BigInteger s = new BigInteger(1, byteArray, 32, 32);
            long v = byteArray[64];
            return ResultKt.success(new Signature(r, s, v));
        }

        @JvmStatic
        @NotNull
        public final Result<Signature, InvalidSignatureError> fromHex(@NotNull String hexString) {
            if (!FastHex.isValidHex(hexString)) {
                return ResultKt.failure(new InvalidSignatureError("Invalid hex format: " + hexString));
            }
            byte[] byteArray = FastHex.decode(hexString);
            return this.fromByteArray(byteArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

