/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.ethers.core.types.Address;
import io.ethers.core.types.BlockId;
import io.ethers.core.types.BlockSelector;
import io.ethers.core.types.Hash;
import io.ethers.core.types.LogFilterSerializer;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=LogFilterSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u0000 82\u00020\u0001:\u00018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0005J\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u001cJ\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001cJ\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0011J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0019J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\fJ\u001f\u0010\"\u001a\u00020\u00002\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0002\u0010#J\u0014\u0010\"\u001a\u00020\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0011J\u001f\u0010%\u001a\u00020\u00002\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u000b\"\u00020\u0011\u00a2\u0006\u0002\u0010)J\u0014\u0010%\u001a\u00020\u00002\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110$J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0011J\u001f\u0010*\u001a\u00020\u00002\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u000b\"\u00020\u0011\u00a2\u0006\u0002\u0010)J\u0014\u0010*\u001a\u00020\u00002\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110$J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0011J\u001f\u0010,\u001a\u00020\u00002\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u000b\"\u00020\u0011\u00a2\u0006\u0002\u0010)J\u0014\u0010,\u001a\u00020\u00002\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110$J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0011J\u001f\u0010.\u001a\u00020\u00002\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u000b\"\u00020\u0011\u00a2\u0006\u0002\u0010)J\u0014\u0010.\u001a\u00020\u00002\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110$J#\u00100\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020\u0011\u0018\u00010\u000bj\u0004\u0018\u0001`\u00120\u000bH\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u00101\u001a\u000202H\u0016J\u0013\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00106\u001a\u000207H\u0016R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR4\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000b2\u0010\u0010\u0006\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fRP\u0010\u0013\u001a\u001a\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020\u0011\u0018\u00010\u000bj\u0004\u0018\u0001`\u0012\u0018\u00010\u000b2\u001e\u0010\u0006\u001a\u001a\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020\u0011\u0018\u00010\u000bj\u0004\u0018\u0001`\u0012\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R!\u0010%\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0011\u0018\u00010\u000bj\u0004\u0018\u0001`\u00128F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R!\u0010*\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0011\u0018\u00010\u000bj\u0004\u0018\u0001`\u00128F\u00a2\u0006\u0006\u001a\u0004\b+\u0010'R!\u0010,\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0011\u0018\u00010\u000bj\u0004\u0018\u0001`\u00128F\u00a2\u0006\u0006\u001a\u0004\b-\u0010'R!\u0010.\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0011\u0018\u00010\u000bj\u0004\u0018\u0001`\u00128F\u00a2\u0006\u0006\u001a\u0004\b/\u0010'\u00a8\u00069"}, d2={"Lio/ethers/core/types/LogFilter;", "", "<init>", "()V", "filter", "(Lio/ethers/core/types/LogFilter;)V", "value", "Lio/ethers/core/types/BlockSelector;", "blocks", "getBlocks", "()Lio/ethers/core/types/BlockSelector;", "", "Lio/ethers/core/types/Address;", "addresses", "getAddresses", "()[Lio/ethers/core/types/Address;", "[Lio/ethers/core/types/Address;", "Lio/ethers/core/types/Hash;", "Lio/ethers/core/types/TopicHashes;", "topics", "getTopics", "()[[Lio/ethers/core/types/Hash;", "[[Lio/ethers/core/types/Hash;", "blockRange", "from", "", "to", "Lio/ethers/core/types/BlockId$Number;", "Lio/ethers/core/types/BlockId$Name;", "atBlock", "hash", "number", "blockId", "Lio/ethers/core/types/BlockId;", "address", "([Lio/ethers/core/types/Address;)Lio/ethers/core/types/LogFilter;", "", "topic0", "getTopic0", "()[Lio/ethers/core/types/Hash;", "hashes", "([Lio/ethers/core/types/Hash;)Lio/ethers/core/types/LogFilter;", "topic1", "getTopic1", "topic2", "getTopic2", "topic3", "getTopic3", "getOrCreateTopics", "toString", "", "equals", "", "other", "hashCode", "", "Companion", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nLogFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogFilter.kt\nio/ethers/core/types/LogFilter\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,411:1\n37#2:412\n36#2,3:413\n37#2:416\n36#2,3:417\n37#2:420\n36#2,3:421\n37#2:424\n36#2,3:425\n37#2:428\n36#2,3:429\n1#3:432\n*S KotlinDebug\n*F\n+ 1 LogFilter.kt\nio/ethers/core/types/LogFilter\n*L\n135#1:412\n135#1:413,3\n165#1:416\n165#1:417,3\n195#1:420\n195#1:421,3\n225#1:424\n225#1:425,3\n255#1:428\n255#1:429,3\n*E\n"})
public final class LogFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private BlockSelector blocks = BlockSelector.Companion.getLATEST_BLOCK();
    @Nullable
    private Address[] addresses;
    @Nullable
    private Hash[][] topics;

    public LogFilter() {
    }

    public LogFilter(@NotNull LogFilter filter) {
        this();
        Hash[][] hashArray;
        Address[] addressArray;
        this.blocks = filter.blocks;
        if (filter.addresses != null) {
            Address[] addressArray2 = Arrays.copyOf(filter.addresses, filter.addresses.length);
            Intrinsics.checkNotNullExpressionValue((Object)addressArray2, (String)"copyOf(...)");
            addressArray = addressArray2;
        } else {
            Address[] cfr_ignored_0 = filter.addresses;
            addressArray = this.addresses = null;
        }
        if (filter.topics != null) {
            Object[] objectArray = (Object[])filter.topics;
            Object[] objectArray2 = Arrays.copyOf(objectArray, objectArray.length);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
            hashArray = (Hash[][])objectArray2;
        } else {
            Hash[][] cfr_ignored_1 = filter.topics;
            hashArray = null;
        }
        this.topics = hashArray;
    }

    @NotNull
    public final BlockSelector getBlocks() {
        return this.blocks;
    }

    @Nullable
    public final Address[] getAddresses() {
        return this.addresses;
    }

    @Nullable
    public final Hash[][] getTopics() {
        return this.topics;
    }

    @NotNull
    public final LogFilter blockRange(long from, long to) {
        return this.blockRange(new BlockId.Number(from), new BlockId.Number(to));
    }

    @NotNull
    public final LogFilter blockRange(@NotNull BlockId.Number from, @NotNull BlockId.Number to) {
        this.blocks = new BlockSelector.Range(from, to);
        return this;
    }

    @NotNull
    public final LogFilter blockRange(@NotNull BlockId.Name from, @NotNull BlockId.Name to) {
        this.blocks = new BlockSelector.Range(from, to);
        return this;
    }

    @NotNull
    public final LogFilter blockRange(@NotNull BlockId.Number from, @NotNull BlockId.Name to) {
        this.blocks = new BlockSelector.Range(from, to);
        return this;
    }

    @NotNull
    public final LogFilter blockRange(@NotNull BlockId.Name from, @NotNull BlockId.Number to) {
        this.blocks = new BlockSelector.Range(from, to);
        return this;
    }

    @NotNull
    public final LogFilter atBlock(@NotNull Hash hash) {
        this.blocks = new BlockSelector.Hash(hash);
        return this;
    }

    @NotNull
    public final LogFilter atBlock(long number) {
        return this.blockRange(number, number);
    }

    @NotNull
    public final LogFilter atBlock(@NotNull BlockId blockId) {
        LogFilter logFilter;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            logFilter = this.atBlock(((BlockId.Hash)blockId).getHash());
        } else if (blockId2 instanceof BlockId.Number) {
            logFilter = this.blockRange((BlockId.Number)blockId, (BlockId.Number)blockId);
        } else if (blockId2 instanceof BlockId.Name) {
            logFilter = this.blockRange((BlockId.Name)blockId, (BlockId.Name)blockId);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return logFilter;
    }

    @NotNull
    public final LogFilter address(@NotNull Address address) {
        Address[] addressArray = new Address[]{address};
        this.addresses = addressArray;
        return this;
    }

    @NotNull
    public final LogFilter address(Address ... addresses) {
        this.addresses = Arrays.copyOf(addresses, addresses.length);
        return this;
    }

    @NotNull
    public final LogFilter address(@NotNull Collection<Address> addresses) {
        Collection<Address> $this$toTypedArray$iv = addresses;
        boolean $i$f$toTypedArray = false;
        Collection<Address> thisCollection$iv = $this$toTypedArray$iv;
        this.addresses = thisCollection$iv.toArray(new Address[0]);
        return this;
    }

    @Nullable
    public final Hash[] getTopic0() {
        return this.topics != null ? this.topics[0] : null;
    }

    @NotNull
    public final LogFilter topic0(@NotNull Hash hash) {
        Hash[] hashArray = new Hash[]{hash};
        this.getOrCreateTopics()[0] = hashArray;
        return this;
    }

    @NotNull
    public final LogFilter topic0(Hash ... hashes) {
        this.getOrCreateTopics()[0] = hashes;
        return this;
    }

    @NotNull
    public final LogFilter topic0(@NotNull Collection<Hash> hashes) {
        Collection<Hash> $this$toTypedArray$iv = hashes;
        boolean $i$f$toTypedArray = false;
        Collection<Hash> thisCollection$iv = $this$toTypedArray$iv;
        this.getOrCreateTopics()[0] = thisCollection$iv.toArray(new Hash[0]);
        return this;
    }

    @Nullable
    public final Hash[] getTopic1() {
        return this.topics != null ? this.topics[1] : null;
    }

    @NotNull
    public final LogFilter topic1(@NotNull Hash hash) {
        Hash[] hashArray = new Hash[]{hash};
        this.getOrCreateTopics()[1] = hashArray;
        return this;
    }

    @NotNull
    public final LogFilter topic1(Hash ... hashes) {
        this.getOrCreateTopics()[1] = hashes;
        return this;
    }

    @NotNull
    public final LogFilter topic1(@NotNull Collection<Hash> hashes) {
        Collection<Hash> $this$toTypedArray$iv = hashes;
        boolean $i$f$toTypedArray = false;
        Collection<Hash> thisCollection$iv = $this$toTypedArray$iv;
        this.getOrCreateTopics()[1] = thisCollection$iv.toArray(new Hash[0]);
        return this;
    }

    @Nullable
    public final Hash[] getTopic2() {
        return this.topics != null ? this.topics[2] : null;
    }

    @NotNull
    public final LogFilter topic2(@NotNull Hash hash) {
        Hash[] hashArray = new Hash[]{hash};
        this.getOrCreateTopics()[2] = hashArray;
        return this;
    }

    @NotNull
    public final LogFilter topic2(Hash ... hashes) {
        this.getOrCreateTopics()[2] = hashes;
        return this;
    }

    @NotNull
    public final LogFilter topic2(@NotNull Collection<Hash> hashes) {
        Collection<Hash> $this$toTypedArray$iv = hashes;
        boolean $i$f$toTypedArray = false;
        Collection<Hash> thisCollection$iv = $this$toTypedArray$iv;
        this.getOrCreateTopics()[2] = thisCollection$iv.toArray(new Hash[0]);
        return this;
    }

    @Nullable
    public final Hash[] getTopic3() {
        return this.topics != null ? this.topics[3] : null;
    }

    @NotNull
    public final LogFilter topic3(@NotNull Hash hash) {
        Hash[] hashArray = new Hash[]{hash};
        this.getOrCreateTopics()[3] = hashArray;
        return this;
    }

    @NotNull
    public final LogFilter topic3(Hash ... hashes) {
        this.getOrCreateTopics()[3] = hashes;
        return this;
    }

    @NotNull
    public final LogFilter topic3(@NotNull Collection<Hash> hashes) {
        Collection<Hash> $this$toTypedArray$iv = hashes;
        boolean $i$f$toTypedArray = false;
        Collection<Hash> thisCollection$iv = $this$toTypedArray$iv;
        this.getOrCreateTopics()[3] = thisCollection$iv.toArray(new Hash[0]);
        return this;
    }

    private final Hash[][] getOrCreateTopics() {
        Hash[][] topics = this.topics;
        if (topics != null) {
            return topics;
        }
        Hash[][] hashArrayArray = new Hash[4][];
        Hash[][] it = hashArrayArray;
        boolean bl = false;
        this.topics = it;
        return hashArrayArray;
    }

    @NotNull
    public String toString() {
        String string;
        if (this.addresses != null) {
            String string2 = Arrays.toString(this.addresses);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        } else {
            string = null;
        }
        return "LogFilter(blockSelector=" + this.blocks + ", address=" + string + ", topics=" + (this.topics != null ? ArraysKt.contentDeepToString((Object[])((Object[])this.topics)) : null) + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.core.types.LogFilter");
        LogFilter cfr_ignored_0 = (LogFilter)other;
        if (!Intrinsics.areEqual((Object)this.blocks, (Object)((LogFilter)other).blocks)) {
            return false;
        }
        if (this.addresses != null) {
            if (((LogFilter)other).addresses == null) {
                return false;
            }
            if (!Arrays.equals(this.addresses, ((LogFilter)other).addresses)) {
                return false;
            }
        } else if (((LogFilter)other).addresses != null) {
            return false;
        }
        if (this.topics != null) {
            if (((LogFilter)other).topics == null) {
                return false;
            }
            if (!ArraysKt.contentDeepEquals((Object[])((Object[])this.topics), (Object[])((Object[])((LogFilter)other).topics))) {
                return false;
            }
        } else if (((LogFilter)other).topics != null) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.blocks.hashCode();
        result = 31 * result + (this.addresses != null ? Arrays.hashCode(this.addresses) : 0);
        result = 31 * result + (this.topics != null ? ArraysKt.contentDeepHashCode((Object[])((Object[])this.topics)) : 0);
        return result;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\tH\u0086\n\u00a8\u0006\n"}, d2={"Lio/ethers/core/types/LogFilter$Companion;", "", "<init>", "()V", "invoke", "Lio/ethers/core/types/LogFilter;", "builder", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "ethers-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LogFilter invoke(@NotNull Function1<? super LogFilter, Unit> builder) {
            boolean $i$f$invoke = false;
            LogFilter logFilter = new LogFilter();
            builder.invoke((Object)logFilter);
            return logFilter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

