/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.ethers.core.JsonParserExtensionsKt;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.Hash;
import io.ethers.core.types.Log;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/ethers/core/types/LogDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lio/ethers/core/types/Log;", "<init>", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Log.kt\nio/ethers/core/types/LogDeserializer\n+ 2 JsonParserExtensions.kt\nio/ethers/core/JsonParserExtensionsKt\n*L\n1#1,81:1\n33#2,6:82\n*S KotlinDebug\n*F\n+ 1 Log.kt\nio/ethers/core/types/LogDeserializer\n*L\n51#1:82,6\n*E\n"})
final class LogDeserializer
extends JsonDeserializer<Log> {
    @NotNull
    public Log deserialize(@NotNull JsonParser p, @NotNull DeserializationContext context) {
        if (p.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new IllegalStateException("Expected start object, got: " + p.getCurrentToken());
        }
        Address address = null;
        List<Hash> topics = null;
        Bytes data = null;
        Hash blockHash = null;
        long blockNumber = 0L;
        blockNumber = -1L;
        long blockTimestamp = 0L;
        blockTimestamp = -1L;
        Hash transactionHash = null;
        Integer transactionIndex = null;
        int logIndex = 0;
        logIndex = -1;
        Boolean removed = null;
        JsonParser $this$forEachObjectField$iv = p;
        boolean $i$f$forEachObjectField = false;
        while (!JsonParserExtensionsKt.isNextTokenObjectEnd($this$forEachObjectField$iv)) {
            String field$iv = $this$forEachObjectField$iv.currentName();
            $this$forEachObjectField$iv.nextToken();
            String field = field$iv;
            boolean bl = false;
            switch (field) {
                case "address": {
                    address = JsonParserExtensionsKt.readAddress(p);
                    break;
                }
                case "topics": {
                    topics = JsonParserExtensionsKt.readListOfHashes(p);
                    break;
                }
                case "data": {
                    data = JsonParserExtensionsKt.readBytes(p);
                    break;
                }
                case "blockHash": {
                    blockHash = JsonParserExtensionsKt.readHash(p);
                    break;
                }
                case "blockNumber": {
                    blockNumber = JsonParserExtensionsKt.readHexLong(p);
                    break;
                }
                case "blockTimestamp": {
                    blockTimestamp = JsonParserExtensionsKt.readHexLong(p);
                    break;
                }
                case "transactionHash": {
                    transactionHash = JsonParserExtensionsKt.readHash(p);
                    break;
                }
                case "transactionIndex": {
                    transactionIndex = JsonParserExtensionsKt.readHexInt(p);
                    break;
                }
                case "logIndex": {
                    logIndex = JsonParserExtensionsKt.readHexInt(p);
                    break;
                }
                case "removed": {
                    removed = p.currentToken() == JsonToken.VALUE_TRUE;
                    break;
                }
                default: {
                    JsonParserExtensionsKt.handleUnknownField(p);
                }
            }
        }
        Address address2 = address;
        if (address2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"address");
            address2 = null;
        }
        List<Hash> list = topics;
        Intrinsics.checkNotNull(list);
        Bytes bytes = data;
        Intrinsics.checkNotNull(bytes);
        Hash hash = blockHash;
        Intrinsics.checkNotNull(hash);
        Hash hash2 = transactionHash;
        Intrinsics.checkNotNull(hash2);
        Integer n = transactionIndex;
        Intrinsics.checkNotNull((Object)n);
        int n2 = ((Number)n).intValue();
        Boolean bl = removed;
        Intrinsics.checkNotNull((Object)bl);
        return new Log(address2, list, bytes, hash, blockNumber, blockTimestamp, hash2, n2, logIndex, bl);
    }
}

