/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.ethers.core.FastHex;
import io.ethers.core.types.Address;
import io.ethers.core.types.HashDeserializer;
import io.ethers.core.types.HashSerializer;
import io.ethers.rlp.RlpDecodable;
import io.ethers.rlp.RlpDecoder;
import io.ethers.rlp.RlpEncodable;
import io.ethers.rlp.RlpEncoder;
import java.math.BigInteger;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=HashDeserializer.class)
@JsonSerialize(using=HashSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\b\u00a2\u0006\u0004\b\u0004\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0086\u0004J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0086\u0004J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\b\u0010\u001b\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/ethers/core/types/Hash;", "Lio/ethers/rlp/RlpEncodable;", "value", "", "<init>", "([B)V", "", "(Ljava/lang/CharSequence;)V", "Lio/ethers/core/types/Address;", "(Lio/ethers/core/types/Address;)V", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;)V", "stringCache", "", "asByteArray", "toByteArray", "rlpEncode", "", "rlp", "Lio/ethers/rlp/RlpEncoder;", "rlpSize", "", "equals", "", "other", "", "hashCode", "toString", "Companion", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nHash.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Hash.kt\nio/ethers/core/types/Hash\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class Hash
implements RlpEncodable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] value;
    @Nullable
    private String stringCache;
    @JvmField
    @NotNull
    public static final Hash ZERO = new Hash(new byte[32]);

    public Hash(@NotNull byte[] value) {
        this.value = value;
        if (!(this.value.length == 32)) {
            boolean bl = false;
            String string = "Hash must be 32 bytes long";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public Hash(@NotNull CharSequence value) {
        this(FastHex.decode(value));
    }

    public Hash(@NotNull Address value) {
        this(ArraysKt.copyInto$default((byte[])value.asByteArray(), (byte[])new byte[32], (int)12, (int)0, (int)0, (int)12, null));
    }

    public Hash(@NotNull BigInteger value) {
        this(Hash.Companion.bigIntegerToBytes(value));
    }

    @NotNull
    public final byte[] asByteArray() {
        return this.value;
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] byArray = Arrays.copyOf(this.value, this.value.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return byArray;
    }

    public void rlpEncode(@NotNull RlpEncoder rlp) {
        rlp.encode(this.value);
    }

    public int rlpSize() {
        return RlpEncoder.Companion.sizeOf(this.value);
    }

    public final boolean equals(@NotNull CharSequence other) {
        return Arrays.equals(this.value, FastHex.decode(other));
    }

    public final boolean equals(@NotNull byte[] other) {
        return Arrays.equals(this.value, other);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.core.types.Hash");
        Hash cfr_ignored_0 = (Hash)other;
        return Arrays.equals(this.value, ((Hash)other).value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @NotNull
    public String toString() {
        String string = this.stringCache;
        if (string == null) {
            String string2;
            String it = string2 = FastHex.encodeWithPrefix(this.value);
            boolean bl = false;
            this.stringCache = it;
            string = string2;
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static Hash rlpDecode(@NotNull RlpDecoder rlp) {
        return Companion.rlpDecode(rlp);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0010\u0010\u0005\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/ethers/core/types/Hash$Companion;", "Lio/ethers/rlp/RlpDecodable;", "Lio/ethers/core/types/Hash;", "<init>", "()V", "ZERO", "rlpDecode", "rlp", "Lio/ethers/rlp/RlpDecoder;", "bigIntegerToBytes", "", "value", "Ljava/math/BigInteger;", "ethers-core"})
    @SourceDebugExtension(value={"SMAP\nHash.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Hash.kt\nio/ethers/core/types/Hash$Companion\n+ 2 RlpDecoder.kt\nio/ethers/rlp/RlpDecoder\n*L\n1#1,130:1\n248#2:131\n*S KotlinDebug\n*F\n+ 1 Hash.kt\nio/ethers/core/types/Hash$Companion\n*L\n92#1:131\n*E\n"})
    public static final class Companion
    implements RlpDecodable<Hash> {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public Hash rlpDecode(@NotNull RlpDecoder rlp) {
            Hash hash;
            RlpDecoder this_$iv = rlp;
            boolean $i$f$decodeByteArray = false;
            byte[] byArray = this_$iv.decodeByteArray();
            if (byArray != null) {
                byte[] p0 = byArray;
                boolean bl = false;
                hash = new Hash(p0);
            } else {
                hash = null;
            }
            return hash;
        }

        private final byte[] bigIntegerToBytes(BigInteger value) {
            byte[] bytes = value.toByteArray();
            if (bytes.length > 33 || bytes.length == 33 && bytes[0] != 0) {
                throw new IllegalArgumentException("Provided value has more than 256 bits: " + value);
            }
            byte[] ret = new byte[32];
            ArraysKt.copyInto((byte[])bytes, (byte[])ret, (int)(bytes.length > 32 ? 0 : 32 - bytes.length), (int)(bytes.length > 32 ? 1 : 0), (int)bytes.length);
            return ret;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

