/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.ethers.core.types.FeeHistoryDeserializer;
import java.math.BigInteger;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=FeeHistoryDeserializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0014\u0010\t\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0018\u00010\u0005\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J\u0017\u0010\u001e\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010 \u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005H\u00c6\u0003Jo\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0016\b\u0002\u0010\t\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0018\u00010\u00052\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u001f\u0010\t\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006)"}, d2={"Lio/ethers/core/types/FeeHistory;", "", "oldestBlock", "", "baseFeePerGas", "", "Ljava/math/BigInteger;", "gasUsedRatio", "", "rewards", "baseFeePerBlobGas", "blobGasUsedRatio", "<init>", "(JLjava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getOldestBlock", "()J", "getBaseFeePerGas", "()Ljava/util/List;", "getGasUsedRatio", "getRewards", "getBaseFeePerBlobGas", "getBlobGasUsedRatio", "nextBaseFeePerGas", "getNextBaseFeePerGas", "()Ljava/math/BigInteger;", "nextBaseFeePerBlobGas", "getNextBaseFeePerBlobGas", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ethers-core"})
public final class FeeHistory {
    private final long oldestBlock;
    @NotNull
    private final List<BigInteger> baseFeePerGas;
    @NotNull
    private final List<Double> gasUsedRatio;
    @Nullable
    private final List<List<BigInteger>> rewards;
    @Nullable
    private final List<BigInteger> baseFeePerBlobGas;
    @Nullable
    private final List<Double> blobGasUsedRatio;

    public FeeHistory(long oldestBlock, @NotNull List<? extends BigInteger> baseFeePerGas, @NotNull List<Double> gasUsedRatio, @Nullable List<? extends List<? extends BigInteger>> rewards, @Nullable List<? extends BigInteger> baseFeePerBlobGas, @Nullable List<Double> blobGasUsedRatio) {
        this.oldestBlock = oldestBlock;
        this.baseFeePerGas = baseFeePerGas;
        this.gasUsedRatio = gasUsedRatio;
        this.rewards = rewards;
        this.baseFeePerBlobGas = baseFeePerBlobGas;
        this.blobGasUsedRatio = blobGasUsedRatio;
    }

    public final long getOldestBlock() {
        return this.oldestBlock;
    }

    @NotNull
    public final List<BigInteger> getBaseFeePerGas() {
        return this.baseFeePerGas;
    }

    @NotNull
    public final List<Double> getGasUsedRatio() {
        return this.gasUsedRatio;
    }

    @Nullable
    public final List<List<BigInteger>> getRewards() {
        return this.rewards;
    }

    @Nullable
    public final List<BigInteger> getBaseFeePerBlobGas() {
        return this.baseFeePerBlobGas;
    }

    @Nullable
    public final List<Double> getBlobGasUsedRatio() {
        return this.blobGasUsedRatio;
    }

    @NotNull
    public final BigInteger getNextBaseFeePerGas() {
        BigInteger bigInteger = (BigInteger)CollectionsKt.lastOrNull(this.baseFeePerGas);
        if (bigInteger == null) {
            bigInteger = BigInteger.ZERO;
        }
        return bigInteger;
    }

    @NotNull
    public final BigInteger getNextBaseFeePerBlobGas() {
        List<BigInteger> list = this.baseFeePerBlobGas;
        if (list == null || (list = (BigInteger)CollectionsKt.lastOrNull(list)) == null) {
            list = BigInteger.ZERO;
        }
        return list;
    }

    public final long component1() {
        return this.oldestBlock;
    }

    @NotNull
    public final List<BigInteger> component2() {
        return this.baseFeePerGas;
    }

    @NotNull
    public final List<Double> component3() {
        return this.gasUsedRatio;
    }

    @Nullable
    public final List<List<BigInteger>> component4() {
        return this.rewards;
    }

    @Nullable
    public final List<BigInteger> component5() {
        return this.baseFeePerBlobGas;
    }

    @Nullable
    public final List<Double> component6() {
        return this.blobGasUsedRatio;
    }

    @NotNull
    public final FeeHistory copy(long oldestBlock, @NotNull List<? extends BigInteger> baseFeePerGas, @NotNull List<Double> gasUsedRatio, @Nullable List<? extends List<? extends BigInteger>> rewards, @Nullable List<? extends BigInteger> baseFeePerBlobGas, @Nullable List<Double> blobGasUsedRatio) {
        return new FeeHistory(oldestBlock, baseFeePerGas, gasUsedRatio, rewards, baseFeePerBlobGas, blobGasUsedRatio);
    }

    public static /* synthetic */ FeeHistory copy$default(FeeHistory feeHistory, long l, List list, List list2, List list3, List list4, List list5, int n, Object object) {
        if ((n & 1) != 0) {
            l = feeHistory.oldestBlock;
        }
        if ((n & 2) != 0) {
            list = feeHistory.baseFeePerGas;
        }
        if ((n & 4) != 0) {
            list2 = feeHistory.gasUsedRatio;
        }
        if ((n & 8) != 0) {
            list3 = feeHistory.rewards;
        }
        if ((n & 0x10) != 0) {
            list4 = feeHistory.baseFeePerBlobGas;
        }
        if ((n & 0x20) != 0) {
            list5 = feeHistory.blobGasUsedRatio;
        }
        return feeHistory.copy(l, list, list2, list3, list4, list5);
    }

    @NotNull
    public String toString() {
        return "FeeHistory(oldestBlock=" + this.oldestBlock + ", baseFeePerGas=" + this.baseFeePerGas + ", gasUsedRatio=" + this.gasUsedRatio + ", rewards=" + this.rewards + ", baseFeePerBlobGas=" + this.baseFeePerBlobGas + ", blobGasUsedRatio=" + this.blobGasUsedRatio + ")";
    }

    public int hashCode() {
        int result = Long.hashCode(this.oldestBlock);
        result = result * 31 + ((Object)this.baseFeePerGas).hashCode();
        result = result * 31 + ((Object)this.gasUsedRatio).hashCode();
        result = result * 31 + (this.rewards == null ? 0 : ((Object)this.rewards).hashCode());
        result = result * 31 + (this.baseFeePerBlobGas == null ? 0 : ((Object)this.baseFeePerBlobGas).hashCode());
        result = result * 31 + (this.blobGasUsedRatio == null ? 0 : ((Object)this.blobGasUsedRatio).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FeeHistory)) {
            return false;
        }
        FeeHistory feeHistory = (FeeHistory)other;
        if (this.oldestBlock != feeHistory.oldestBlock) {
            return false;
        }
        if (!Intrinsics.areEqual(this.baseFeePerGas, feeHistory.baseFeePerGas)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.gasUsedRatio, feeHistory.gasUsedRatio)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.rewards, feeHistory.rewards)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.baseFeePerBlobGas, feeHistory.baseFeePerBlobGas)) {
            return false;
        }
        return Intrinsics.areEqual(this.blobGasUsedRatio, feeHistory.blobGasUsedRatio);
    }
}

