/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.ethers.core.FastHex;
import io.ethers.core.types.CallRequest;
import io.ethers.core.types.Hash;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lio/ethers/core/types/CallRequestSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lio/ethers/core/types/CallRequest;", "<init>", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "ethers-core"})
final class CallRequestSerializer
extends JsonSerializer<CallRequest> {
    public void serialize(@NotNull CallRequest value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
        List<Hash> blobVersionedHashes;
        BigInteger blobFeeCap;
        gen.writeStartObject();
        if (value.getFrom() != null) {
            gen.writeStringField("from", String.valueOf(value.getFrom()));
        }
        if (value.getTo() != null) {
            gen.writeStringField("to", String.valueOf(value.getTo()));
        }
        if (value.getGas() != -1L) {
            gen.writeStringField("gas", FastHex.encodeWithPrefix(value.getGas()));
        }
        if (value.getGasPrice() != null) {
            BigInteger bigInteger = value.getGasPrice();
            Intrinsics.checkNotNull((Object)bigInteger);
            gen.writeStringField("gasPrice", FastHex.encodeWithPrefix(bigInteger));
        }
        if (value.getGasFeeCap() != null) {
            BigInteger bigInteger = value.getGasFeeCap();
            Intrinsics.checkNotNull((Object)bigInteger);
            gen.writeStringField("maxFeePerGas", FastHex.encodeWithPrefix(bigInteger));
        }
        if (value.getGasTipCap() != null) {
            BigInteger bigInteger = value.getGasTipCap();
            Intrinsics.checkNotNull((Object)bigInteger);
            gen.writeStringField("maxPriorityFeePerGas", FastHex.encodeWithPrefix(bigInteger));
        }
        if (value.getValue() != null) {
            BigInteger bigInteger = value.getValue();
            Intrinsics.checkNotNull((Object)bigInteger);
            gen.writeStringField("value", FastHex.encodeWithPrefix(bigInteger));
        }
        if (value.getNonce() != -1L) {
            gen.writeStringField("nonce", FastHex.encodeWithPrefix(value.getNonce()));
        }
        if (value.getData() != null) {
            gen.writeStringField("data", String.valueOf(value.getData()));
        }
        if (!((Collection)value.getAccessList()).isEmpty()) {
            gen.writeArrayFieldStart("accessList");
            int n = ((Collection)value.getAccessList()).size();
            for (int i = 0; i < n; ++i) {
                gen.writeObject((Object)value.getAccessList().get(i));
            }
            gen.writeEndArray();
        }
        if (value.getChainId() != -1L) {
            gen.writeStringField("chainId", FastHex.encodeWithPrefix(value.getChainId()));
        }
        if ((blobFeeCap = value.getBlobFeeCap()) != null) {
            gen.writeStringField("maxFeePerBlobGas", FastHex.encodeWithPrefix(blobFeeCap));
        }
        if ((blobVersionedHashes = value.getBlobVersionedHashes()) != null) {
            gen.writeArrayFieldStart("blobVersionedHashes");
            int n = ((Collection)blobVersionedHashes).size();
            for (int i = 0; i < n; ++i) {
                gen.writeString(blobVersionedHashes.get(i).toString());
            }
            gen.writeEndArray();
        }
        gen.writeEndObject();
    }
}

