/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.ethers.core.types.AccessList;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.CallRequestSerializer;
import io.ethers.core.types.Hash;
import io.ethers.core.types.IntoCallRequest;
import io.ethers.core.types.transaction.ChainId;
import io.ethers.core.types.transaction.TransactionUnsigned;
import io.ethers.core.types.transaction.TxAccessList;
import io.ethers.core.types.transaction.TxBlob;
import io.ethers.core.types.transaction.TxDynamicFee;
import io.ethers.core.types.transaction.TxLegacy;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=CallRequestSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u0000 H2\u00020\u0001:\u0001HB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0000H\u0016J\u0010\u0010\u0007\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0010\u0010\r\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0018\u001a\u00020\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017J\u0010\u0010\u001d\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017J\u0010\u0010 \u001a\u00020\u00002\b\u0010 \u001a\u0004\u0018\u00010\u0017J\u0010\u0010\u0016\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0011J\u0010\u0010(\u001a\u00020\u00002\b\u0010(\u001a\u0004\u0018\u00010)J\u0014\u0010.\u001a\u00020\u00002\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/J\u000e\u00105\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0011J\u0010\u00108\u001a\u00020\u00002\b\u00108\u001a\u0004\u0018\u00010\u0017J\u0016\u0010;\u001a\u00020\u00002\u000e\u0010;\u001a\n\u0012\u0004\u0012\u00020<\u0018\u00010/J\b\u0010?\u001a\u0004\u0018\u00010@J\b\u0010A\u001a\u00020BH\u0016J\u0013\u0010C\u001a\u00020D2\b\u0010\u0004\u001a\u0004\u0018\u00010EH\u0096\u0002J\b\u0010F\u001a\u00020GH\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R(\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR(\u0010\u001d\u001a\u0004\u0018\u00010\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR(\u0010 \u001a\u0004\u0018\u00010\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001cR(\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001a\"\u0004\b$\u0010\u001cR\u001a\u0010%\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0013\"\u0004\b'\u0010\u0015R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R \u0010.\u001a\b\u0012\u0004\u0012\u0002000/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0013\"\u0004\b7\u0010\u0015R(\u00108\u001a\u0004\u0018\u00010\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u001a\"\u0004\b:\u0010\u001cR\"\u0010;\u001a\n\u0012\u0004\u0012\u00020<\u0018\u00010/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u00102\"\u0004\b>\u00104\u00a8\u0006I"}, d2={"Lio/ethers/core/types/CallRequest;", "Lio/ethers/core/types/IntoCallRequest;", "<init>", "()V", "other", "(Lio/ethers/core/types/CallRequest;)V", "toCallRequest", "from", "Lio/ethers/core/types/Address;", "getFrom", "()Lio/ethers/core/types/Address;", "setFrom", "(Lio/ethers/core/types/Address;)V", "to", "getTo", "setTo", "gas", "", "getGas", "()J", "setGas", "(J)V", "value", "Ljava/math/BigInteger;", "gasPrice", "getGasPrice", "()Ljava/math/BigInteger;", "setGasPrice", "(Ljava/math/BigInteger;)V", "gasFeeCap", "getGasFeeCap", "setGasFeeCap", "gasTipCap", "getGasTipCap", "setGasTipCap", "getValue", "setValue", "nonce", "getNonce", "setNonce", "data", "Lio/ethers/core/types/Bytes;", "getData", "()Lio/ethers/core/types/Bytes;", "setData", "(Lio/ethers/core/types/Bytes;)V", "accessList", "", "Lio/ethers/core/types/AccessList$Item;", "getAccessList", "()Ljava/util/List;", "setAccessList", "(Ljava/util/List;)V", "chainId", "getChainId", "setChainId", "blobFeeCap", "getBlobFeeCap", "setBlobFeeCap", "blobVersionedHashes", "Lio/ethers/core/types/Hash;", "getBlobVersionedHashes", "setBlobVersionedHashes", "toUnsignedTransactionOrNull", "Lio/ethers/core/types/transaction/TransactionUnsigned;", "toString", "", "equals", "", "", "hashCode", "", "Companion", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nCallRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallRequest.kt\nio/ethers/core/types/CallRequest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,298:1\n1#2:299\n*E\n"})
public final class CallRequest
implements IntoCallRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Address from;
    @Nullable
    private Address to;
    private long gas = -1L;
    @Nullable
    private BigInteger gasPrice;
    @Nullable
    private BigInteger gasFeeCap;
    @Nullable
    private BigInteger gasTipCap;
    @Nullable
    private BigInteger value;
    private long nonce = -1L;
    @Nullable
    private Bytes data;
    @NotNull
    private List<AccessList.Item> accessList = CollectionsKt.emptyList();
    private long chainId = -1L;
    @Nullable
    private BigInteger blobFeeCap;
    @Nullable
    private List<Hash> blobVersionedHashes;

    public CallRequest() {
    }

    public CallRequest(@NotNull CallRequest other) {
        this();
        this.from = other.from;
        this.to = other.to;
        this.gas = other.gas;
        this.setGasPrice(other.gasPrice);
        this.setGasFeeCap(other.gasFeeCap);
        this.setGasTipCap(other.gasTipCap);
        this.setValue(other.value);
        this.nonce = other.nonce;
        this.data = other.data;
        this.accessList = other.accessList;
        this.chainId = other.chainId;
        this.setBlobFeeCap(other.blobFeeCap);
        this.blobVersionedHashes = other.blobVersionedHashes;
    }

    @Override
    @NotNull
    public CallRequest toCallRequest() {
        return this;
    }

    @Nullable
    public final Address getFrom() {
        return this.from;
    }

    public final /* synthetic */ void setFrom(Address address) {
        this.from = address;
    }

    @Nullable
    public final Address getTo() {
        return this.to;
    }

    public final /* synthetic */ void setTo(Address address) {
        this.to = address;
    }

    public final long getGas() {
        return this.gas;
    }

    public final /* synthetic */ void setGas(long l) {
        this.gas = l;
    }

    @Nullable
    public final BigInteger getGasPrice() {
        return this.gasPrice;
    }

    public final /* synthetic */ void setGasPrice(BigInteger value) {
        if (!(value == null || value.compareTo(BigInteger.ZERO) >= 0)) {
            boolean bl = false;
            String string = "GasPrice must be non-negative";
            throw new IllegalArgumentException(string.toString());
        }
        this.gasPrice = value;
    }

    @Nullable
    public final BigInteger getGasFeeCap() {
        return this.gasFeeCap;
    }

    public final /* synthetic */ void setGasFeeCap(BigInteger value) {
        if (!(value == null || value.compareTo(BigInteger.ZERO) >= 0)) {
            boolean bl = false;
            String string = "GasFeeCap must be non-negative";
            throw new IllegalArgumentException(string.toString());
        }
        this.gasFeeCap = value;
    }

    @Nullable
    public final BigInteger getGasTipCap() {
        return this.gasTipCap;
    }

    public final /* synthetic */ void setGasTipCap(BigInteger value) {
        if (!(value == null || value.compareTo(BigInteger.ZERO) >= 0)) {
            boolean bl = false;
            String string = "GasTipCap must be non-negative";
            throw new IllegalArgumentException(string.toString());
        }
        this.gasTipCap = value;
    }

    @Nullable
    public final BigInteger getValue() {
        return this.value;
    }

    public final /* synthetic */ void setValue(BigInteger value) {
        if (!(value == null || value.compareTo(BigInteger.ZERO) >= 0)) {
            boolean bl = false;
            String string = "Value must be non-negative";
            throw new IllegalArgumentException(string.toString());
        }
        this.value = value;
    }

    public final long getNonce() {
        return this.nonce;
    }

    public final /* synthetic */ void setNonce(long l) {
        this.nonce = l;
    }

    @Nullable
    public final Bytes getData() {
        return this.data;
    }

    public final /* synthetic */ void setData(Bytes bytes) {
        this.data = bytes;
    }

    @NotNull
    public final List<AccessList.Item> getAccessList() {
        return this.accessList;
    }

    public final /* synthetic */ void setAccessList(List list) {
        this.accessList = list;
    }

    public final long getChainId() {
        return this.chainId;
    }

    public final /* synthetic */ void setChainId(long l) {
        this.chainId = l;
    }

    @Nullable
    public final BigInteger getBlobFeeCap() {
        return this.blobFeeCap;
    }

    public final /* synthetic */ void setBlobFeeCap(BigInteger value) {
        if (!(value == null || value.compareTo(BigInteger.ZERO) >= 0)) {
            boolean bl = false;
            String string = "BlobFeeCap must be non-negative";
            throw new IllegalArgumentException(string.toString());
        }
        this.blobFeeCap = value;
    }

    @Nullable
    public final List<Hash> getBlobVersionedHashes() {
        return this.blobVersionedHashes;
    }

    public final /* synthetic */ void setBlobVersionedHashes(List list) {
        this.blobVersionedHashes = list;
    }

    @NotNull
    public final CallRequest from(@Nullable Address from) {
        CallRequest callRequest;
        CallRequest $this$from_u24lambda_u245 = callRequest = this;
        boolean bl = false;
        $this$from_u24lambda_u245.from = from;
        return callRequest;
    }

    @NotNull
    public final CallRequest to(@Nullable Address to) {
        CallRequest callRequest;
        CallRequest $this$to_u24lambda_u246 = callRequest = this;
        boolean bl = false;
        $this$to_u24lambda_u246.to = to;
        return callRequest;
    }

    @NotNull
    public final CallRequest gas(long gas) {
        CallRequest callRequest;
        CallRequest $this$gas_u24lambda_u247 = callRequest = this;
        boolean bl = false;
        $this$gas_u24lambda_u247.gas = gas;
        return callRequest;
    }

    @NotNull
    public final CallRequest gasPrice(@Nullable BigInteger gasPrice) {
        CallRequest callRequest;
        CallRequest $this$gasPrice_u24lambda_u248 = callRequest = this;
        boolean bl = false;
        $this$gasPrice_u24lambda_u248.setGasPrice(gasPrice);
        return callRequest;
    }

    @NotNull
    public final CallRequest gasFeeCap(@Nullable BigInteger gasFeeCap) {
        CallRequest callRequest;
        CallRequest $this$gasFeeCap_u24lambda_u249 = callRequest = this;
        boolean bl = false;
        $this$gasFeeCap_u24lambda_u249.setGasFeeCap(gasFeeCap);
        return callRequest;
    }

    @NotNull
    public final CallRequest gasTipCap(@Nullable BigInteger gasTipCap) {
        CallRequest callRequest;
        CallRequest $this$gasTipCap_u24lambda_u2410 = callRequest = this;
        boolean bl = false;
        $this$gasTipCap_u24lambda_u2410.setGasTipCap(gasTipCap);
        return callRequest;
    }

    @NotNull
    public final CallRequest value(@Nullable BigInteger value) {
        CallRequest callRequest;
        CallRequest $this$value_u24lambda_u2411 = callRequest = this;
        boolean bl = false;
        $this$value_u24lambda_u2411.setValue(value);
        return callRequest;
    }

    @NotNull
    public final CallRequest nonce(long nonce) {
        CallRequest callRequest;
        CallRequest $this$nonce_u24lambda_u2412 = callRequest = this;
        boolean bl = false;
        $this$nonce_u24lambda_u2412.nonce = nonce;
        return callRequest;
    }

    @NotNull
    public final CallRequest data(@Nullable Bytes data) {
        CallRequest callRequest;
        CallRequest $this$data_u24lambda_u2413 = callRequest = this;
        boolean bl = false;
        $this$data_u24lambda_u2413.data = data;
        return callRequest;
    }

    @NotNull
    public final CallRequest accessList(@NotNull List<AccessList.Item> accessList) {
        CallRequest callRequest;
        CallRequest $this$accessList_u24lambda_u2414 = callRequest = this;
        boolean bl = false;
        $this$accessList_u24lambda_u2414.accessList = accessList;
        return callRequest;
    }

    @NotNull
    public final CallRequest chainId(long chainId) {
        CallRequest callRequest;
        CallRequest $this$chainId_u24lambda_u2415 = callRequest = this;
        boolean bl = false;
        $this$chainId_u24lambda_u2415.chainId = chainId;
        return callRequest;
    }

    @NotNull
    public final CallRequest blobFeeCap(@Nullable BigInteger blobFeeCap) {
        CallRequest callRequest;
        CallRequest $this$blobFeeCap_u24lambda_u2416 = callRequest = this;
        boolean bl = false;
        $this$blobFeeCap_u24lambda_u2416.setBlobFeeCap(blobFeeCap);
        return callRequest;
    }

    @NotNull
    public final CallRequest blobVersionedHashes(@Nullable List<Hash> blobVersionedHashes) {
        CallRequest callRequest;
        CallRequest $this$blobVersionedHashes_u24lambda_u2417 = callRequest = this;
        boolean bl = false;
        $this$blobVersionedHashes_u24lambda_u2417.blobVersionedHashes = blobVersionedHashes;
        return callRequest;
    }

    @Nullable
    public final TransactionUnsigned toUnsignedTransactionOrNull() {
        if (this.nonce < 0L) {
            return null;
        }
        if (this.gas < 21000L) {
            return null;
        }
        if (this.gasFeeCap != null && this.gasTipCap != null && this.blobVersionedHashes != null) {
            if (this.to == null || this.blobFeeCap == null || !ChainId.isValid(this.chainId)) {
                return null;
            }
            Address address = this.to;
            Intrinsics.checkNotNull((Object)address);
            BigInteger bigInteger = this.value;
            if (bigInteger == null) {
                bigInteger = BigInteger.ZERO;
            }
            BigInteger bigInteger2 = this.gasFeeCap;
            Intrinsics.checkNotNull((Object)bigInteger2);
            BigInteger bigInteger3 = this.gasTipCap;
            Intrinsics.checkNotNull((Object)bigInteger3);
            BigInteger bigInteger4 = this.blobFeeCap;
            Intrinsics.checkNotNull((Object)bigInteger4);
            List<Hash> list = this.blobVersionedHashes;
            Intrinsics.checkNotNull(list);
            return new TxBlob(address, bigInteger, this.nonce, this.gas, bigInteger2, bigInteger3, this.data, this.chainId, this.accessList, bigInteger4, list, null, 2048, null);
        }
        if (this.gasFeeCap != null && this.gasTipCap != null && this.blobVersionedHashes == null) {
            if (!ChainId.isValid(this.chainId)) {
                return null;
            }
            BigInteger bigInteger = this.value;
            if (bigInteger == null) {
                bigInteger = BigInteger.ZERO;
            }
            BigInteger bigInteger5 = this.gasFeeCap;
            Intrinsics.checkNotNull((Object)bigInteger5);
            BigInteger bigInteger6 = this.gasTipCap;
            Intrinsics.checkNotNull((Object)bigInteger6);
            return new TxDynamicFee(this.to, bigInteger, this.nonce, this.gas, bigInteger5, bigInteger6, this.data, this.chainId, this.accessList);
        }
        if (this.gasPrice != null && !((Collection)this.accessList).isEmpty()) {
            if (!ChainId.isValid(this.chainId)) {
                return null;
            }
            BigInteger bigInteger = this.value;
            if (bigInteger == null) {
                bigInteger = BigInteger.ZERO;
            }
            BigInteger bigInteger7 = this.gasPrice;
            Intrinsics.checkNotNull((Object)bigInteger7);
            return new TxAccessList(this.to, bigInteger, this.nonce, this.gas, bigInteger7, this.data, this.chainId, this.accessList);
        }
        if (this.gasPrice != null && this.accessList.isEmpty()) {
            BigInteger bigInteger = this.value;
            if (bigInteger == null) {
                bigInteger = BigInteger.ZERO;
            }
            BigInteger bigInteger8 = this.gasPrice;
            Intrinsics.checkNotNull((Object)bigInteger8);
            return new TxLegacy(this.to, bigInteger, this.nonce, this.gas, bigInteger8, this.data, this.chainId);
        }
        return null;
    }

    @NotNull
    public String toString() {
        return "CallRequest(from=" + this.from + ", to=" + this.to + ", gas=" + this.gas + ", gasPrice=" + this.gasPrice + ", gasFeeCap=" + this.gasFeeCap + ", gasTipCap=" + this.gasTipCap + ", value=" + this.value + ", nonce=" + this.nonce + ", data=" + this.data + ", accessList=" + this.accessList + ", chainId=" + this.chainId + ", blobFeeCap=" + this.blobFeeCap + ", blobVersionedHashes=" + this.blobVersionedHashes + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.core.types.CallRequest");
        CallRequest cfr_ignored_0 = (CallRequest)other;
        if (!Intrinsics.areEqual((Object)this.from, (Object)((CallRequest)other).from)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.to, (Object)((CallRequest)other).to)) {
            return false;
        }
        if (this.gas != ((CallRequest)other).gas) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.gasPrice, (Object)((CallRequest)other).gasPrice)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.gasFeeCap, (Object)((CallRequest)other).gasFeeCap)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.gasTipCap, (Object)((CallRequest)other).gasTipCap)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.value, (Object)((CallRequest)other).value)) {
            return false;
        }
        if (this.nonce != ((CallRequest)other).nonce) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.data, (Object)((CallRequest)other).data)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.accessList, ((CallRequest)other).accessList)) {
            return false;
        }
        if (this.chainId != ((CallRequest)other).chainId) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.blobFeeCap, (Object)((CallRequest)other).blobFeeCap)) {
            return false;
        }
        return Intrinsics.areEqual(this.blobVersionedHashes, ((CallRequest)other).blobVersionedHashes);
    }

    public int hashCode() {
        Address address = this.from;
        int result = address != null ? address.hashCode() : 0;
        Address address2 = this.to;
        result = 31 * result + (address2 != null ? address2.hashCode() : 0);
        result = 31 * result + Long.hashCode(this.gas);
        BigInteger bigInteger = this.gasPrice;
        result = 31 * result + (bigInteger != null ? bigInteger.hashCode() : 0);
        BigInteger bigInteger2 = this.gasFeeCap;
        result = 31 * result + (bigInteger2 != null ? bigInteger2.hashCode() : 0);
        BigInteger bigInteger3 = this.gasTipCap;
        result = 31 * result + (bigInteger3 != null ? bigInteger3.hashCode() : 0);
        BigInteger bigInteger4 = this.value;
        result = 31 * result + (bigInteger4 != null ? bigInteger4.hashCode() : 0);
        result = 31 * result + Long.hashCode(this.nonce);
        Bytes bytes = this.data;
        result = 31 * result + (bytes != null ? bytes.hashCode() : 0);
        result = 31 * result + ((Object)this.accessList).hashCode();
        result = 31 * result + Long.hashCode(this.chainId);
        BigInteger bigInteger5 = this.blobFeeCap;
        result = 31 * result + (bigInteger5 != null ? bigInteger5.hashCode() : 0);
        List<Hash> list = this.blobVersionedHashes;
        result = 31 * result + (list != null ? ((Object)list).hashCode() : 0);
        return result;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\tH\u0086\n\u00a8\u0006\n"}, d2={"Lio/ethers/core/types/CallRequest$Companion;", "", "<init>", "()V", "invoke", "Lio/ethers/core/types/CallRequest;", "builder", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "ethers-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CallRequest invoke(@NotNull Function1<? super CallRequest, Unit> builder) {
            boolean $i$f$invoke = false;
            CallRequest callRequest = new CallRequest();
            builder.invoke((Object)callRequest);
            return callRequest;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

