/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.ethers.core.FastHex;
import io.ethers.core.types.BytesDeserializer;
import io.ethers.core.types.BytesSerializer;
import io.ethers.rlp.RlpDecodable;
import io.ethers.rlp.RlpDecoder;
import io.ethers.rlp.RlpEncodable;
import io.ethers.rlp.RlpEncoder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=BytesDeserializer.class)
@JsonSerialize(using=BytesSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007J\u0006\u0010\n\u001a\u00020\u0003J\u0006\u0010\u000b\u001a\u00020\u0003J\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rJ\u0011\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0006H\u0086\u0002J\u0011\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0000J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0003J\u0011\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0006H\u0086\u0004J\u0011\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0003H\u0086\u0004J\u0013\u0010\u0019\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\rH\u0016J\b\u0010\u001c\u001a\u00020\tH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012\u00a8\u0006#"}, d2={"Lio/ethers/core/types/Bytes;", "Lio/ethers/rlp/RlpEncodable;", "value", "", "<init>", "([B)V", "", "(Ljava/lang/CharSequence;)V", "stringCache", "", "asByteArray", "toByteArray", "size", "", "getSize", "()I", "isEmpty", "", "()Z", "copyOfRange", "startIndex", "endIndex", "contains", "other", "startsWith", "equals", "", "hashCode", "toString", "rlpEncode", "", "rlp", "Lio/ethers/rlp/RlpEncoder;", "rlpSize", "Companion", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nBytes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bytes.kt\nio/ethers/core/types/Bytes\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,230:1\n1#2:231\n*E\n"})
public final class Bytes
implements RlpEncodable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] value;
    @Nullable
    private String stringCache;
    @JvmField
    @NotNull
    public static final Bytes EMPTY = new Bytes(new byte[0]);

    public Bytes(@NotNull byte[] value) {
        this.value = value;
    }

    public Bytes(@NotNull CharSequence value) {
        this(FastHex.decode(value));
    }

    @NotNull
    public final byte[] asByteArray() {
        return this.value;
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] byArray = Arrays.copyOf(this.value, this.value.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return byArray;
    }

    public final int getSize() {
        return this.value.length;
    }

    public final boolean isEmpty() {
        return this.value.length == 0;
    }

    @NotNull
    public final Bytes copyOfRange(int startIndex, int endIndex) {
        return new Bytes(ArraysKt.copyOfRange((byte[])this.value, (int)startIndex, (int)endIndex));
    }

    public final boolean contains(@NotNull Bytes other) {
        return this.contains(other.value);
    }

    public final boolean contains(@NotNull CharSequence other) {
        boolean bl;
        int otherSize = StringsKt.startsWith$default((CharSequence)other, (CharSequence)"0x", (boolean)false, (int)2, null) ? other.length() - 2 : other.length();
        if (otherSize == 0) {
            bl = true;
        } else {
            if (otherSize % 2 == 1) {
                throw new IllegalArgumentException("CharSequence need to be even length (2 hex char =  1 byte).");
            }
            bl = otherSize / 2 > this.value.length ? false : this.contains(FastHex.decode(other));
        }
        return bl;
    }

    public final boolean contains(@NotNull byte[] other) {
        if (other.length == 0) {
            return true;
        }
        if (other.length > this.value.length) {
            return false;
        }
        byte otherFirst = other[0];
        int n = this.value.length;
        block0: for (int i = 0; i < n; ++i) {
            if (i + other.length > this.value.length) {
                return false;
            }
            if (this.value[i] != otherFirst) continue;
            int k = 1;
            int n2 = i + other.length;
            for (int j = i + 1; j < n2; ++j) {
                if (this.value[j] != other[k++]) continue block0;
            }
            return true;
        }
        return false;
    }

    public final boolean startsWith(@NotNull Bytes other) {
        return this.startsWith(other.value);
    }

    public final boolean startsWith(@NotNull CharSequence other) {
        boolean bl;
        int otherSize = StringsKt.startsWith$default((CharSequence)other, (CharSequence)"0x", (boolean)false, (int)2, null) ? other.length() - 2 : other.length();
        if (otherSize == 0) {
            bl = true;
        } else {
            if (otherSize % 2 == 1) {
                throw new IllegalArgumentException("CharSequence need to be even length (2 hex char =  1 byte).");
            }
            bl = otherSize / 2 > this.value.length ? false : this.startsWith(FastHex.decode(other));
        }
        return bl;
    }

    public final boolean startsWith(@NotNull byte[] other) {
        if (other.length == 0) {
            return true;
        }
        if (other.length > this.value.length) {
            return false;
        }
        int n = other.length;
        for (int i = 0; i < n; ++i) {
            if (other[i] == this.value[i]) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(@NotNull CharSequence other) {
        boolean bl;
        int otherSize = StringsKt.startsWith$default((CharSequence)other, (CharSequence)"0x", (boolean)false, (int)2, null) ? other.length() - 2 : other.length();
        if (otherSize == 0) {
            bl = this.value.length == 0;
        } else {
            if (otherSize % 2 == 1) {
                throw new IllegalArgumentException("CharSequence need to be even length (2 hex char =  1 byte).");
            }
            bl = this.equals(FastHex.decode(other));
        }
        return bl;
    }

    public final boolean equals(@NotNull byte[] other) {
        return Arrays.equals(this.value, other);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
        Bytes cfr_ignored_0 = (Bytes)other;
        return Arrays.equals(this.value, ((Bytes)other).value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @NotNull
    public String toString() {
        String string = this.stringCache;
        if (string == null) {
            String string2;
            String it = string2 = FastHex.encodeWithPrefix(this.value);
            boolean bl = false;
            this.stringCache = it;
            string = string2;
        }
        return string;
    }

    public void rlpEncode(@NotNull RlpEncoder rlp) {
        rlp.encode(this.value);
    }

    public int rlpSize() {
        return RlpEncoder.Companion.sizeOf(this.value);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0005\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/ethers/core/types/Bytes$Companion;", "Lio/ethers/rlp/RlpDecodable;", "Lio/ethers/core/types/Bytes;", "<init>", "()V", "EMPTY", "rlpDecode", "rlp", "Lio/ethers/rlp/RlpDecoder;", "ethers-core"})
    @SourceDebugExtension(value={"SMAP\nBytes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bytes.kt\nio/ethers/core/types/Bytes$Companion\n+ 2 RlpDecoder.kt\nio/ethers/rlp/RlpDecoder\n*L\n1#1,230:1\n248#2:231\n*S KotlinDebug\n*F\n+ 1 Bytes.kt\nio/ethers/core/types/Bytes$Companion\n*L\n214#1:231\n*E\n"})
    public static final class Companion
    implements RlpDecodable<Bytes> {
        private Companion() {
        }

        @Nullable
        public Bytes rlpDecode(@NotNull RlpDecoder rlp) {
            Bytes bytes;
            RlpDecoder this_$iv = rlp;
            boolean $i$f$decodeByteArray = false;
            byte[] byArray = this_$iv.decodeByteArray();
            if (byArray != null) {
                byte[] p0 = byArray;
                boolean bl = false;
                bytes = new Bytes(p0);
            } else {
                bytes = null;
            }
            return bytes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

