/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.ethers.core.FastHex;
import io.ethers.core.types.Address;
import io.ethers.core.types.BloomDeserializer;
import io.ethers.core.types.BloomSerializer;
import io.ethers.core.types.Hash;
import io.ethers.crypto.Hashing;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=BloomDeserializer.class)
@JsonSerialize(using=BloomSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0006\u0010\t\u001a\u00020\u0003J\u0006\u0010\n\u001a\u00020\u0003J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0003JN\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u000320\u0010\u0017\u001a,\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\u00150\u0018H\u0082\b\u00a2\u0006\u0002\u0010\u001bJ\u0014\u0010\u001c\u001a\u00020\u001a*\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0013\u0010 \u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\"\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/ethers/core/types/Bloom;", "", "value", "", "<init>", "([B)V", "()V", "", "(Ljava/lang/CharSequence;)V", "asByteArray", "toByteArray", "contains", "", "hash", "Lio/ethers/core/types/Hash;", "address", "Lio/ethers/core/types/Address;", "input", "add", "", "withBloomValues", "R", "item", "consumer", "Lkotlin/Function6;", "", "", "([BLkotlin/jvm/functions/Function6;)Ljava/lang/Object;", "getUShort", "index", "toString", "", "equals", "other", "hashCode", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nBloom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bloom.kt\nio/ethers/core/types/Bloom\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n87#1,10:134\n87#1,10:144\n1#2:133\n*S KotlinDebug\n*F\n+ 1 Bloom.kt\nio/ethers/core/types/Bloom\n*L\n58#1:134,10\n79#1:144,10\n*E\n"})
public final class Bloom {
    @NotNull
    private final byte[] value;

    public Bloom(@NotNull byte[] value) {
        this.value = value;
        if (!(this.value.length == 256)) {
            boolean bl = false;
            String string = "Bloom must be exactly 256 bytes long";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public Bloom() {
        this(new byte[256]);
    }

    public Bloom(@NotNull CharSequence value) {
        this(FastHex.decode(value));
    }

    @NotNull
    public final byte[] asByteArray() {
        return this.value;
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] byArray = Arrays.copyOf(this.value, this.value.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return byArray;
    }

    public final boolean contains(@NotNull Hash hash) {
        return this.contains(hash.asByteArray());
    }

    public final boolean contains(@NotNull Address address) {
        return this.contains(address.asByteArray());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(@NotNull byte[] input) {
        void b3;
        void i3;
        void b2;
        void i2;
        void i1;
        int i3$iv;
        Bloom this_$iv = this;
        boolean $i$f$withBloomValues = false;
        byte[] hash$iv = Hashing.keccak256((byte[])input);
        byte b1$iv = (byte)(1 << (hash$iv[1] & 7));
        byte b2$iv = (byte)(1 << (hash$iv[3] & 7));
        byte b3$iv = (byte)(1 << (hash$iv[5] & 7));
        int i1$iv = 256 - ((this_$iv.getUShort(hash$iv, 0) & 0x7FF) >> 3) - 1;
        int i2$iv = 256 - ((this_$iv.getUShort(hash$iv, 2) & 0x7FF) >> 3) - 1;
        int n = i3$iv = 256 - ((this_$iv.getUShort(hash$iv, 4) & 0x7FF) >> 3) - 1;
        int n2 = i2$iv;
        int n3 = i1$iv;
        byte by = b3$iv;
        byte by2 = b2$iv;
        byte b1 = b1$iv;
        boolean bl = false;
        if ((byte)(this.value[i1] & b1) != b1) {
            return false;
        }
        if ((byte)(this.value[i2] & b2) != b2) {
            return false;
        }
        return (byte)(this.value[i3] & b3) == b3;
    }

    public final void add(@NotNull Hash hash) {
        this.add(hash.asByteArray());
    }

    public final void add(@NotNull Address address) {
        this.add(address.asByteArray());
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull byte[] input) {
        void b3;
        void i3;
        void b2;
        void i2;
        void i1;
        int i3$iv;
        Bloom this_$iv = this;
        boolean $i$f$withBloomValues = false;
        byte[] hash$iv = Hashing.keccak256((byte[])input);
        byte b1$iv = (byte)(1 << (hash$iv[1] & 7));
        byte b2$iv = (byte)(1 << (hash$iv[3] & 7));
        byte b3$iv = (byte)(1 << (hash$iv[5] & 7));
        int i1$iv = 256 - ((this_$iv.getUShort(hash$iv, 0) & 0x7FF) >> 3) - 1;
        int i2$iv = 256 - ((this_$iv.getUShort(hash$iv, 2) & 0x7FF) >> 3) - 1;
        int n = i3$iv = 256 - ((this_$iv.getUShort(hash$iv, 4) & 0x7FF) >> 3) - 1;
        int n2 = i2$iv;
        int n3 = i1$iv;
        byte by = b3$iv;
        byte by2 = b2$iv;
        byte b1 = b1$iv;
        boolean bl = false;
        this.value[i1] = (byte)(this.value[i1] | b1);
        this.value[i2] = (byte)(this.value[i2] | b2);
        this.value[i3] = (byte)(this.value[i3] | b3);
    }

    private final <R> R withBloomValues(byte[] item, Function6<? super Byte, ? super Byte, ? super Byte, ? super Integer, ? super Integer, ? super Integer, ? extends R> consumer) {
        boolean $i$f$withBloomValues = false;
        byte[] hash = Hashing.keccak256((byte[])item);
        byte b1 = (byte)(1 << (hash[1] & 7));
        byte b2 = (byte)(1 << (hash[3] & 7));
        byte b3 = (byte)(1 << (hash[5] & 7));
        int i1 = 256 - ((this.getUShort(hash, 0) & 0x7FF) >> 3) - 1;
        int i2 = 256 - ((this.getUShort(hash, 2) & 0x7FF) >> 3) - 1;
        int i3 = 256 - ((this.getUShort(hash, 4) & 0x7FF) >> 3) - 1;
        return (R)consumer.invoke((Object)b1, (Object)b2, (Object)b3, (Object)i1, (Object)i2, (Object)i3);
    }

    private final int getUShort(byte[] $this$getUShort, int index) {
        return ($this$getUShort[index] & 0xFF) << 8 | $this$getUShort[index + 1] & 0xFF;
    }

    @NotNull
    public String toString() {
        return FastHex.encodeWithPrefix(this.value);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.core.types.Bloom");
        Bloom cfr_ignored_0 = (Bloom)other;
        return Arrays.equals(this.value, ((Bloom)other).value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

