/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.ethers.core.FastHex;
import io.ethers.core.types.Address;
import io.ethers.core.types.BlockOverride;
import io.ethers.core.types.Hash;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lio/ethers/core/types/BlockOverrideSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lio/ethers/core/types/BlockOverride;", "<init>", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "ethers-core"})
final class BlockOverrideSerializer
extends JsonSerializer<BlockOverride> {
    public void serialize(@NotNull BlockOverride value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
        gen.writeStartObject();
        if (value.getNumber() != -1L) {
            gen.writeStringField("number", FastHex.encodeWithPrefix(value.getNumber()));
        }
        if (value.getDifficulty() != null) {
            BigInteger bigInteger = value.getDifficulty();
            Intrinsics.checkNotNull((Object)bigInteger);
            gen.writeStringField("difficulty", FastHex.encodeWithPrefix(bigInteger));
        }
        if (value.getTime() != -1L) {
            gen.writeStringField("time", FastHex.encodeWithPrefix(value.getTime()));
        }
        if (value.getGasLimit() != -1L) {
            gen.writeStringField("gasLimit", FastHex.encodeWithPrefix(value.getGasLimit()));
        }
        if (value.getCoinbase() != null) {
            Address address = value.getCoinbase();
            Intrinsics.checkNotNull((Object)address);
            gen.writeStringField("coinbase", address.toString());
        }
        if (value.getRandom() != null) {
            Hash hash = value.getRandom();
            Intrinsics.checkNotNull((Object)hash);
            gen.writeStringField("random", hash.toString());
        }
        if (value.getBaseFee() != null) {
            BigInteger bigInteger = value.getBaseFee();
            Intrinsics.checkNotNull((Object)bigInteger);
            gen.writeStringField("baseFee", FastHex.encodeWithPrefix(bigInteger));
        }
        gen.writeEndObject();
    }
}

