/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.ethers.core.FastHex;
import io.ethers.core.types.AddressDeserializer;
import io.ethers.core.types.AddressSerializer;
import io.ethers.core.types.transaction.ChainId;
import io.ethers.crypto.Hashing;
import io.ethers.rlp.RlpDecodable;
import io.ethers.rlp.RlpDecoder;
import io.ethers.rlp.RlpEncodable;
import io.ethers.rlp.RlpEncoder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=AddressDeserializer.class)
@JsonSerialize(using=AddressSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007J\u0006\u0010\n\u001a\u00020\u0003J\u0006\u0010\u000b\u001a\u00020\u0003J\u0012\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0086\u0004J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0086\u0004J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/ethers/core/types/Address;", "Lio/ethers/rlp/RlpEncodable;", "value", "", "<init>", "([B)V", "", "(Ljava/lang/CharSequence;)V", "stringCache", "", "asByteArray", "toByteArray", "toChecksumString", "chainId", "", "rlpEncode", "", "rlp", "Lio/ethers/rlp/RlpEncoder;", "rlpSize", "", "equals", "", "other", "", "hashCode", "toString", "Companion", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nAddress.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Address.kt\nio/ethers/core/types/Address\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1#2:180\n*E\n"})
public final class Address
implements RlpEncodable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] value;
    @Nullable
    private String stringCache;
    @JvmField
    @NotNull
    public static final Address ZERO = new Address(new byte[20]);

    public Address(@NotNull byte[] value) {
        this.value = value;
        if (!(this.value.length == 20)) {
            boolean bl = false;
            String string = "Address must be 20 bytes long";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public Address(@NotNull CharSequence value) {
        this(FastHex.decode(value));
    }

    @NotNull
    public final byte[] asByteArray() {
        return this.value;
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] byArray = Arrays.copyOf(this.value, this.value.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return byArray;
    }

    @JvmOverloads
    @NotNull
    public final String toChecksumString(long chainId) {
        byte[] byArray;
        boolean validChainId = ChainId.isValid(chainId);
        int encodedOffset = validChainId ? 2 : 0;
        byte[] encodedHex = FastHex.encodeAsBytes(this.value, validChainId);
        boolean bl = validChainId;
        if (bl) {
            String string = String.valueOf(chainId);
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            byArray = Hashing.keccak256((byte[])ArraysKt.plus((byte[])byArray2, (byte[])encodedHex));
        } else if (!bl) {
            byArray = Hashing.keccak256((byte[])encodedHex);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        byte[] hash = byArray;
        byte[] hashHex = FastHex.encodeAsBytes(hash, false);
        byte[] ret = new byte[42];
        ret[0] = 48;
        ret[1] = 120;
        for (int i = 0; i < 40; ++i) {
            byte nibble = encodedHex[i + encodedOffset];
            char c = (char)nibble;
            ret[i + 2] = ('a' <= c ? c < 'g' : false) && hashHex[i] >= 56 ? (byte)(nibble - 32) : nibble;
        }
        return new String(ret, Charsets.UTF_8);
    }

    public static /* synthetic */ String toChecksumString$default(Address address, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = -1L;
        }
        return address.toChecksumString(l);
    }

    public void rlpEncode(@NotNull RlpEncoder rlp) {
        rlp.encode(this.value);
    }

    public int rlpSize() {
        return RlpEncoder.Companion.sizeOf(this.value);
    }

    public final boolean equals(@NotNull CharSequence other) {
        return Arrays.equals(this.value, FastHex.decode(other));
    }

    public final boolean equals(@NotNull byte[] other) {
        return Arrays.equals(this.value, other);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.core.types.Address");
        Address cfr_ignored_0 = (Address)other;
        return Arrays.equals(this.value, ((Address)other).value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @NotNull
    public String toString() {
        String string = this.stringCache;
        if (string == null) {
            String string2;
            String it = string2 = FastHex.encodeWithPrefix(this.value);
            boolean bl = false;
            this.stringCache = it;
            string = string2;
        }
        return string;
    }

    @JvmOverloads
    @NotNull
    public final String toChecksumString() {
        return Address.toChecksumString$default(this, 0L, 1, null);
    }

    @JvmStatic
    @Nullable
    public static Address rlpDecode(@NotNull RlpDecoder rlp) {
        return Companion.rlpDecode(rlp);
    }

    @JvmStatic
    @NotNull
    public static final Address computeCreate(@NotNull Address sender, long nonce) {
        return Companion.computeCreate(sender, nonce);
    }

    @JvmStatic
    @NotNull
    public static final Address computeCreate2(@NotNull Address sender, @NotNull byte[] salt, @NotNull byte[] codeHash) {
        return Companion.computeCreate2(sender, salt, codeHash);
    }

    @JvmStatic
    @NotNull
    public static final Address random() {
        return Companion.random();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0007J \u0010\r\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0007J\b\u0010\u0011\u001a\u00020\u0002H\u0007R\u0010\u0010\u0005\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/ethers/core/types/Address$Companion;", "Lio/ethers/rlp/RlpDecodable;", "Lio/ethers/core/types/Address;", "<init>", "()V", "ZERO", "rlpDecode", "rlp", "Lio/ethers/rlp/RlpDecoder;", "computeCreate", "sender", "nonce", "", "computeCreate2", "salt", "", "codeHash", "random", "ethers-core"})
    @SourceDebugExtension(value={"SMAP\nAddress.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Address.kt\nio/ethers/core/types/Address$Companion\n+ 2 RlpDecoder.kt\nio/ethers/rlp/RlpDecoder\n+ 3 RlpEncoder.kt\nio/ethers/rlp/RlpEncoder\n*L\n1#1,179:1\n248#2:180\n71#3,5:181\n*S KotlinDebug\n*F\n+ 1 Address.kt\nio/ethers/core/types/Address$Companion\n*L\n123#1:180\n134#1:181,5\n*E\n"})
    public static final class Companion
    implements RlpDecodable<Address> {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public Address rlpDecode(@NotNull RlpDecoder rlp) {
            Address address;
            RlpDecoder this_$iv = rlp;
            boolean $i$f$decodeByteArray = false;
            byte[] byArray = this_$iv.decodeByteArray();
            if (byArray != null) {
                byte[] p0 = byArray;
                boolean bl = false;
                address = new Address(p0);
            } else {
                address = null;
            }
            return address;
        }

        @JvmStatic
        @NotNull
        public final Address computeCreate(@NotNull Address sender, long nonce) {
            RlpEncoder rlp;
            RlpEncoder.Companion $this$computeCreate_u24lambda_u241 = RlpEncoder.Companion;
            boolean bl = false;
            int fieldsSize = $this$computeCreate_u24lambda_u241.sizeOf((RlpEncodable)sender) + $this$computeCreate_u24lambda_u241.sizeOf(nonce);
            RlpEncoder this_$iv = rlp = new RlpEncoder($this$computeCreate_u24lambda_u241.sizeOfList(fieldsSize), true);
            boolean $i$f$encodeList = false;
            int bufferStartPosition$iv = this_$iv.startList(fieldsSize);
            RlpEncoder $this$computeCreate_u24lambda_u241_u24lambda_u240 = this_$iv;
            boolean bl2 = false;
            $this$computeCreate_u24lambda_u241_u24lambda_u240.encode((RlpEncodable)sender);
            $this$computeCreate_u24lambda_u241_u24lambda_u240.encode(nonce);
            this_$iv.finishList(bufferStartPosition$iv, fieldsSize);
            byte[] hash = Hashing.keccak256((byte[])rlp.toByteArray());
            return new Address(ArraysKt.copyOfRange((byte[])hash, (int)12, (int)hash.length));
        }

        @JvmStatic
        @NotNull
        public final Address computeCreate2(@NotNull Address sender, @NotNull byte[] salt, @NotNull byte[] codeHash) {
            byte[] data = new byte[85];
            data[0] = -1;
            System.arraycopy(sender.value, 0, data, 1, 20);
            System.arraycopy(salt, 0, data, 21, 32);
            System.arraycopy(codeHash, 0, data, 53, 32);
            byte[] hash = Hashing.keccak256((byte[])data);
            return new Address(ArraysKt.copyOfRange((byte[])hash, (int)12, (int)hash.length));
        }

        @JvmStatic
        @NotNull
        public final Address random() {
            return new Address(Random.Default.nextBytes(new byte[20]));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

