/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.ethers.core.JsonParserExtensionsKt;
import io.ethers.core.types.AccessList;
import io.ethers.core.types.Address;
import io.ethers.core.types.Hash;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/ethers/core/types/AccessListItemDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lio/ethers/core/types/AccessList$Item;", "<init>", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nAccessList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessList.kt\nio/ethers/core/types/AccessListItemDeserializer\n+ 2 JsonParserExtensions.kt\nio/ethers/core/JsonParserExtensionsKt\n*L\n1#1,122:1\n33#2,6:123\n*S KotlinDebug\n*F\n+ 1 AccessList.kt\nio/ethers/core/types/AccessListItemDeserializer\n*L\n89#1:123,6\n*E\n"})
final class AccessListItemDeserializer
extends JsonDeserializer<AccessList.Item> {
    @NotNull
    public AccessList.Item deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        List<Hash> list;
        if (p.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new IllegalArgumentException("Expected start object");
        }
        Address address = null;
        List<Hash> storageKeys = null;
        JsonParser $this$forEachObjectField$iv = p;
        boolean $i$f$forEachObjectField = false;
        while (!JsonParserExtensionsKt.isNextTokenObjectEnd($this$forEachObjectField$iv)) {
            String field$iv = $this$forEachObjectField$iv.currentName();
            $this$forEachObjectField$iv.nextToken();
            String field = field$iv;
            boolean bl = false;
            String string = field;
            if (Intrinsics.areEqual((Object)string, (Object)"address")) {
                address = JsonParserExtensionsKt.readAddress(p);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"storageKeys")) {
                storageKeys = JsonParserExtensionsKt.readListOfHashes(p);
                continue;
            }
            JsonParserExtensionsKt.handleUnknownField(p);
        }
        Address address2 = address;
        if (address2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"address");
            address2 = null;
        }
        if ((list = storageKeys) == null) {
            list = CollectionsKt.emptyList();
        }
        return new AccessList.Item(address2, list);
    }
}

