/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi.call;

import com.fasterxml.jackson.databind.JsonNode;
import io.ethers.abi.error.ContractError;
import io.ethers.abi.error.ContractRpcError;
import io.ethers.abi.error.ExecutionRevertedError;
import io.ethers.abi.error.RevertError;
import io.ethers.core.FastHex;
import io.ethers.core.types.AccessList;
import io.ethers.core.types.Address;
import io.ethers.core.types.BlockId;
import io.ethers.core.types.BlockOverride;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.CallRequest;
import io.ethers.core.types.Hash;
import io.ethers.core.types.IntoCallRequest;
import io.ethers.core.types.StateOverride;
import io.ethers.core.types.tracers.TracerConfig;
import io.ethers.providers.RpcError;
import io.ethers.providers.middleware.Middleware;
import io.ethers.providers.types.RpcRequest;
import java.math.BigInteger;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0014\b\u0001\u0010\u0002*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00002\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000bH\u0016J4\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J4\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J4\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J0\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H$J.\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020\u001e0\u000f\"\u0004\b\u0002\u0010\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 J.\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020\u001e0\u000f\"\u0004\b\u0002\u0010\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 J.\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020\u001e0\u000f\"\u0004\b\u0002\u0010\u001d2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u001eH\u0004J\u0015\u0010(\u001a\u00028\u00012\b\u0010&\u001a\u0004\u0018\u00010'\u00a2\u0006\u0002\u0010OJ\u0013\u00102\u001a\u00028\u00012\u0006\u0010&\u001a\u00020\u0018\u00a2\u0006\u0002\u0010PJ\u0015\u00107\u001a\u00028\u00012\b\u0010&\u001a\u0004\u0018\u00010/\u00a2\u0006\u0002\u0010QJ\u0015\u0010;\u001a\u00028\u00012\b\u0010&\u001a\u0004\u0018\u00010/\u00a2\u0006\u0002\u0010QJ\u0015\u0010>\u001a\u00028\u00012\b\u0010&\u001a\u0004\u0018\u00010/\u00a2\u0006\u0002\u0010QJ\u0013\u0010A\u001a\u00028\u00012\u0006\u0010&\u001a\u00020\u0018\u00a2\u0006\u0002\u0010PJ\u0019\u0010J\u001a\u00028\u00012\f\u0010&\u001a\b\u0012\u0004\u0012\u00020I0H\u00a2\u0006\u0002\u0010RR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010#\u001a\u00028\u0001X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R(\u0010(\u001a\u0004\u0018\u00010'2\b\u0010&\u001a\u0004\u0018\u00010'8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0013\u0010-\u001a\u0004\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010*R\u0016\u0010&\u001a\u0004\u0018\u00010/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R$\u00102\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b3\u00104\"\u0004\b5\u00106R(\u00107\u001a\u0004\u0018\u00010/2\b\u0010&\u001a\u0004\u0018\u00010/8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u00101\"\u0004\b9\u0010:R(\u0010;\u001a\u0004\u0018\u00010/2\b\u0010&\u001a\u0004\u0018\u00010/8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b<\u00101\"\u0004\b=\u0010:R(\u0010>\u001a\u0004\u0018\u00010/2\b\u0010&\u001a\u0004\u0018\u00010/8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b?\u00101\"\u0004\b@\u0010:R$\u0010A\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bB\u00104\"\u0004\bC\u00106R\u0013\u0010D\u001a\u0004\u0018\u00010E8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR0\u0010J\u001a\b\u0012\u0004\u0012\u00020I0H2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020I0H8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bK\u0010L\"\u0004\bM\u0010N\u00a8\u0006S"}, d2={"Lio/ethers/abi/call/ReadContractCall;", "C", "B", "Lio/ethers/core/types/IntoCallRequest;", "provider", "Lio/ethers/providers/middleware/Middleware;", "<init>", "(Lio/ethers/providers/middleware/Middleware;)V", "getProvider", "()Lio/ethers/providers/middleware/Middleware;", "call", "Lio/ethers/core/types/CallRequest;", "getCall", "()Lio/ethers/core/types/CallRequest;", "toCallRequest", "Lio/ethers/providers/types/RpcRequest;", "Lio/ethers/abi/error/ContractError;", "blockHash", "Lio/ethers/core/types/Hash;", "stateOverride", "Lio/ethers/core/types/StateOverride;", "blockOverride", "Lio/ethers/core/types/BlockOverride;", "blockNumber", "", "blockId", "Lio/ethers/core/types/BlockId;", "doCall", "traceCall", "T", "Lio/ethers/providers/RpcError;", "config", "Lio/ethers/core/types/tracers/TracerConfig;", "tryDecodingContractRevert", "err", "self", "getSelf", "()Lio/ethers/abi/call/ReadContractCall;", "value", "Lio/ethers/core/types/Address;", "from", "getFrom", "()Lio/ethers/core/types/Address;", "setFrom", "(Lio/ethers/core/types/Address;)V", "to", "getTo", "Ljava/math/BigInteger;", "getValue", "()Ljava/math/BigInteger;", "gas", "getGas", "()J", "setGas", "(J)V", "gasPrice", "getGasPrice", "setGasPrice", "(Ljava/math/BigInteger;)V", "gasFeeCap", "getGasFeeCap", "setGasFeeCap", "gasTipCap", "getGasTipCap", "setGasTipCap", "nonce", "getNonce", "setNonce", "data", "Lio/ethers/core/types/Bytes;", "getData", "()Lio/ethers/core/types/Bytes;", "", "Lio/ethers/core/types/AccessList$Item;", "accessList", "getAccessList", "()Ljava/util/List;", "setAccessList", "(Ljava/util/List;)V", "(Lio/ethers/core/types/Address;)Lio/ethers/abi/call/ReadContractCall;", "(J)Lio/ethers/abi/call/ReadContractCall;", "(Ljava/math/BigInteger;)Lio/ethers/abi/call/ReadContractCall;", "(Ljava/util/List;)Lio/ethers/abi/call/ReadContractCall;", "ethers-abi"})
@SourceDebugExtension(value={"SMAP\nContractCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContractCall.kt\nio/ethers/abi/call/ReadContractCall\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,294:1\n1#2:295\n*E\n"})
public abstract class ReadContractCall<C, B extends ReadContractCall<C, B>>
implements IntoCallRequest {
    @NotNull
    private final Middleware provider;
    @NotNull
    private final CallRequest call;

    /*
     * WARNING - void declaration
     */
    public ReadContractCall(@NotNull Middleware provider) {
        void $this$call_u24lambda_u240;
        CallRequest callRequest;
        this.provider = provider;
        CallRequest callRequest2 = callRequest = new CallRequest();
        ReadContractCall readContractCall = this;
        boolean bl = false;
        $this$call_u24lambda_u240.setChainId(this.provider.getChainId());
        readContractCall.call = callRequest;
    }

    @NotNull
    public final Middleware getProvider() {
        return this.provider;
    }

    @NotNull
    protected final CallRequest getCall() {
        return this.call;
    }

    @NotNull
    public CallRequest toCallRequest() {
        return new CallRequest(this.call);
    }

    @JvmOverloads
    @NotNull
    public final RpcRequest<C, ContractError> call(@NotNull Hash blockHash, @Nullable StateOverride stateOverride, @Nullable BlockOverride blockOverride) {
        return this.call((BlockId)new BlockId.Hash(blockHash), stateOverride, blockOverride);
    }

    public static /* synthetic */ RpcRequest call$default(ReadContractCall readContractCall, Hash hash, StateOverride stateOverride, BlockOverride blockOverride, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: call");
        }
        if ((n & 2) != 0) {
            stateOverride = null;
        }
        if ((n & 4) != 0) {
            blockOverride = null;
        }
        return readContractCall.call(hash, stateOverride, blockOverride);
    }

    @JvmOverloads
    @NotNull
    public final RpcRequest<C, ContractError> call(long blockNumber, @Nullable StateOverride stateOverride, @Nullable BlockOverride blockOverride) {
        return this.call((BlockId)new BlockId.Number(blockNumber), stateOverride, blockOverride);
    }

    public static /* synthetic */ RpcRequest call$default(ReadContractCall readContractCall, long l, StateOverride stateOverride, BlockOverride blockOverride, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: call");
        }
        if ((n & 2) != 0) {
            stateOverride = null;
        }
        if ((n & 4) != 0) {
            blockOverride = null;
        }
        return readContractCall.call(l, stateOverride, blockOverride);
    }

    @JvmOverloads
    @NotNull
    public final RpcRequest<C, ContractError> call(@NotNull BlockId blockId, @Nullable StateOverride stateOverride, @Nullable BlockOverride blockOverride) {
        return this.doCall(blockId, stateOverride, blockOverride);
    }

    public static /* synthetic */ RpcRequest call$default(ReadContractCall readContractCall, BlockId blockId, StateOverride stateOverride, BlockOverride blockOverride, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: call");
        }
        if ((n & 2) != 0) {
            stateOverride = null;
        }
        if ((n & 4) != 0) {
            blockOverride = null;
        }
        return readContractCall.call(blockId, stateOverride, blockOverride);
    }

    @NotNull
    protected abstract RpcRequest<C, ContractError> doCall(@NotNull BlockId var1, @Nullable StateOverride var2, @Nullable BlockOverride var3);

    @NotNull
    public final <T> RpcRequest<T, RpcError> traceCall(@NotNull Hash blockHash, @NotNull TracerConfig<T> config) {
        return this.traceCall((BlockId)new BlockId.Hash(blockHash), config);
    }

    @NotNull
    public final <T> RpcRequest<T, RpcError> traceCall(long blockNumber, @NotNull TracerConfig<T> config) {
        return this.traceCall((BlockId)new BlockId.Number(blockNumber), config);
    }

    @NotNull
    public final <T> RpcRequest<T, RpcError> traceCall(@NotNull BlockId blockId, @NotNull TracerConfig<T> config) {
        return this.provider.traceCall((IntoCallRequest)this.call, blockId, config);
    }

    @NotNull
    protected final ContractError tryDecodingContractRevert(@NotNull RpcError err) {
        block9: {
            boolean isRevertMessage;
            block8: {
                isRevertMessage = StringsKt.contains((CharSequence)err.getMessage(), (CharSequence)"execution revert", (boolean)true);
                if (err.isExecutionError()) break block8;
                if (!isRevertMessage) break block9;
            }
            if (err.getData() == null && isRevertMessage) {
                return ExecutionRevertedError.INSTANCE;
            }
            if (err.getData() != null) {
                JsonNode jsonNode = err.getData();
                Intrinsics.checkNotNull((Object)jsonNode);
                if (jsonNode.isTextual()) {
                    JsonNode jsonNode2 = err.getData();
                    Intrinsics.checkNotNull((Object)jsonNode2);
                    String data = jsonNode2.textValue();
                    if (!FastHex.isValidHex((CharSequence)data)) {
                        return new RevertError(data);
                    }
                    ContractError contractError = ContractError.Companion.getOrNull(new Bytes((CharSequence)data));
                    if (contractError != null) {
                        return contractError;
                    }
                }
            }
        }
        return new ContractRpcError(err);
    }

    @NotNull
    protected abstract B getSelf();

    @Nullable
    public final Address getFrom() {
        return this.call.getFrom();
    }

    public final /* synthetic */ void setFrom(Address value) {
        this.call.setFrom(value);
    }

    @Nullable
    public final Address getTo() {
        return this.call.getTo();
    }

    @Nullable
    public BigInteger getValue() {
        return this.call.getValue();
    }

    public final long getGas() {
        return this.call.getGas();
    }

    public final /* synthetic */ void setGas(long value) {
        this.call.setGas(value);
    }

    @Nullable
    public final BigInteger getGasPrice() {
        return this.call.getGasPrice();
    }

    public final /* synthetic */ void setGasPrice(BigInteger value) {
        this.call.setGasPrice(value);
    }

    @Nullable
    public final BigInteger getGasFeeCap() {
        return this.call.getGasFeeCap();
    }

    public final /* synthetic */ void setGasFeeCap(BigInteger value) {
        this.call.setGasFeeCap(value);
    }

    @Nullable
    public final BigInteger getGasTipCap() {
        return this.call.getGasTipCap();
    }

    public final /* synthetic */ void setGasTipCap(BigInteger value) {
        this.call.setGasTipCap(value);
    }

    public final long getNonce() {
        return this.call.getNonce();
    }

    public final /* synthetic */ void setNonce(long value) {
        this.call.setNonce(value);
    }

    @Nullable
    public final Bytes getData() {
        return this.call.getData();
    }

    @NotNull
    public final List<AccessList.Item> getAccessList() {
        return this.call.getAccessList();
    }

    public final /* synthetic */ void setAccessList(List value) {
        this.call.setAccessList(value);
    }

    @NotNull
    public final B from(@Nullable Address value) {
        this.call.setFrom(value);
        return this.getSelf();
    }

    @NotNull
    public final B gas(long value) {
        this.call.setGas(value);
        return this.getSelf();
    }

    @NotNull
    public final B gasPrice(@Nullable BigInteger value) {
        this.call.setGasPrice(value);
        return this.getSelf();
    }

    @NotNull
    public final B gasFeeCap(@Nullable BigInteger value) {
        this.call.setGasFeeCap(value);
        return this.getSelf();
    }

    @NotNull
    public final B gasTipCap(@Nullable BigInteger value) {
        this.call.setGasTipCap(value);
        return this.getSelf();
    }

    @NotNull
    public final B nonce(long value) {
        this.call.setNonce(value);
        return this.getSelf();
    }

    @NotNull
    public final B accessList(@NotNull List<AccessList.Item> value) {
        this.call.setAccessList(value);
        return this.getSelf();
    }

    @JvmOverloads
    @NotNull
    public final RpcRequest<C, ContractError> call(@NotNull Hash blockHash, @Nullable StateOverride stateOverride) {
        return ReadContractCall.call$default(this, blockHash, stateOverride, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final RpcRequest<C, ContractError> call(@NotNull Hash blockHash) {
        return ReadContractCall.call$default(this, blockHash, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final RpcRequest<C, ContractError> call(long blockNumber, @Nullable StateOverride stateOverride) {
        return ReadContractCall.call$default(this, blockNumber, stateOverride, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final RpcRequest<C, ContractError> call(long blockNumber) {
        return ReadContractCall.call$default(this, blockNumber, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final RpcRequest<C, ContractError> call(@NotNull BlockId blockId, @Nullable StateOverride stateOverride) {
        return ReadContractCall.call$default(this, blockId, stateOverride, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final RpcRequest<C, ContractError> call(@NotNull BlockId blockId) {
        return ReadContractCall.call$default(this, blockId, null, null, 6, null);
    }
}

