/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.engine.stable;

import io.kotest.common.Platform;
import io.kotest.common.reflection.AnnotationSearchParameter;
import io.kotest.common.reflection.IncludingAnnotations;
import io.kotest.common.reflection.Property;
import io.kotest.common.reflection.ReflectionKt;
import io.kotest.common.reflection.reflectionjvm;
import io.kotest.engine.names.WithDataTestName;
import io.kotest.engine.stable.IsStableType;
import io.kotest.engine.stable.PlatformKt;
import io.kotest.engine.stable.Platform_jvmKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J%\u0010\u0007\u001a\u00020\b2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0000\u00a2\u0006\u0002\b\rJ \u0010\u000e\u001a\u00020\b2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0002\u00a8\u0006\u000f"}, d2={"Lio/kotest/engine/stable/StableIdents;", "", "<init>", "()V", "getStableIdentifier", "", "t", "isStable", "", "type", "Lkotlin/reflect/KType;", "kclass", "Lkotlin/reflect/KClass;", "isStable$kotest_framework_engine", "hasStableMembers", "kotest-framework-engine"})
@SourceDebugExtension(value={"SMAP\nStableIdents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StableIdents.kt\nio/kotest/engine/stable/StableIdents\n+ 2 reflection.kt\nio/kotest/common/reflection/ReflectionKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n81#2,4:129\n73#2:133\n808#3,11:134\n1740#3,3:145\n*S KotlinDebug\n*F\n+ 1 StableIdents.kt\nio/kotest/engine/stable/StableIdents\n*L\n59#1:129,4\n59#1:133\n59#1:134,11\n114#1:145,3\n*E\n"})
public final class StableIdents {
    @NotNull
    public static final StableIdents INSTANCE = new StableIdents();

    private StableIdents() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getStableIdentifier(@Nullable Object t) {
        String string;
        if (t == null) {
            string = "<null>";
        } else {
            void $this$filterIsInstanceTo$iv$iv$iv$iv;
            void $this$annotation$iv$iv;
            KClass $this$hasAnnotation_u24default$iv = Reflection.getOrCreateKotlinClass(t.getClass());
            IncludingAnnotations[] includingAnnotationsArray = new IncludingAnnotations[]{IncludingAnnotations.INSTANCE};
            AnnotationSearchParameter[] parameters$iv = (AnnotationSearchParameter[])includingAnnotationsArray;
            boolean $i$f$hasAnnotation = false;
            KClass kClass = $this$hasAnnotation_u24default$iv;
            Object[] parameters$iv$iv = Arrays.copyOf(parameters$iv, parameters$iv.length);
            boolean $i$f$annotation = false;
            Iterable $this$filterIsInstance$iv$iv$iv = reflectionjvm.getReflection().annotations((KClass)$this$annotation$iv$iv, ArraysKt.toSet((Object[])parameters$iv$iv));
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv$iv$iv;
            Collection destination$iv$iv$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv$iv) {
                if (!(element$iv$iv$iv$iv instanceof IsStableType)) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            if (CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv$iv)) != null || io.kotest.common.Platform_jvmKt.getPlatform() != Platform.JVM) {
                string = t.toString();
            } else if (t instanceof WithDataTestName) {
                string = ((WithDataTestName)t).dataTestName();
            } else {
                String psv = PlatformKt.platformStableValue(t);
                string = psv;
                if (string == null) {
                    string = this.isStable$kotest_framework_engine(Reflection.getOrCreateKotlinClass(t.getClass()), t) ? t.toString() : ReflectionKt.bestName((KClass)Reflection.getOrCreateKotlinClass(t.getClass()));
                }
            }
        }
        return string;
    }

    private final boolean isStable(KType type) {
        KClassifier classifier = type.getClassifier();
        return classifier instanceof KClass ? this.isStable$kotest_framework_engine((KClass)classifier, null) : false;
    }

    public final boolean isStable$kotest_framework_engine(@NotNull KClass<?> kclass, @Nullable Object t) {
        boolean bl;
        Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
        if (PlatformKt.isAllPlatformStable(kclass)) {
            bl = true;
        } else if (reflectionjvm.getReflection().isEnumClass(kclass)) {
            bl = true;
        } else if (reflectionjvm.getReflection().isDataClass(kclass) && this.hasStableMembers(kclass, t)) {
            bl = true;
        } else if (Platform_jvmKt.isPlatformStable(kclass)) {
            bl = true;
        } else {
            System.out.println((Object)("Warning, type " + kclass + " used in data testing does not have a stable toString()"));
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean isStable$kotest_framework_engine$default(StableIdents stableIdents, KClass kClass, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return stableIdents.isStable$kotest_framework_engine(kClass, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasStableMembers(KClass<?> kclass, Object t) {
        boolean bl;
        List members = reflectionjvm.getReflection().primaryConstructorMembers(kclass);
        boolean bl2 = false;
        if (((Collection)members).isEmpty()) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        Iterable $this$all$iv = members;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            boolean valueIsStable;
            boolean bl4;
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            Property getter = (Property)element$iv;
            boolean bl5 = false;
            boolean typeIsStable = INSTANCE.isStable(getter.getType());
            if (t == null) {
                bl = typeIsStable;
                continue;
            }
            if (getter.getCall().invoke(t) != null) {
                Object memberValue;
                boolean bl6 = false;
                bl4 = INSTANCE.isStable$kotest_framework_engine(Reflection.getOrCreateKotlinClass(memberValue.getClass()), memberValue);
            } else {
                bl4 = valueIsStable = false;
            }
            if (!typeIsStable) {
                if (!valueIsStable) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    static /* synthetic */ boolean hasStableMembers$default(StableIdents stableIdents, KClass kClass, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return stableIdents.hasStableMembers(kClass, object);
    }
}

