/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.engine.test.interceptors;

import io.kotest.core.Logger;
import io.kotest.core.test.TestCase;
import io.kotest.core.test.TestScope;
import io.kotest.core.test.TestType;
import io.kotest.engine.config.TestConfigResolver;
import io.kotest.engine.test.TestResult;
import io.kotest.engine.test.TestResultBuilder;
import io.kotest.engine.test.interceptors.NextTestExecutionInterceptor;
import io.kotest.engine.test.interceptors.TestExecutionInterceptor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/kotest/engine/test/interceptors/InvocationCountCheckInterceptor;", "Lio/kotest/engine/test/interceptors/TestExecutionInterceptor;", "testConfigResolver", "Lio/kotest/engine/config/TestConfigResolver;", "<init>", "(Lio/kotest/engine/config/TestConfigResolver;)V", "logger", "Lio/kotest/core/Logger;", "intercept", "Lio/kotest/engine/test/TestResult;", "testCase", "Lio/kotest/core/test/TestCase;", "scope", "Lio/kotest/core/test/TestScope;", "test", "Lio/kotest/engine/test/interceptors/NextTestExecutionInterceptor;", "(Lio/kotest/core/test/TestCase;Lio/kotest/core/test/TestScope;Lio/kotest/engine/test/interceptors/NextTestExecutionInterceptor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "kotest-framework-engine"})
public final class InvocationCountCheckInterceptor
implements TestExecutionInterceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TestConfigResolver testConfigResolver;
    @NotNull
    private final Logger logger;
    @NotNull
    private static final String ERROR_MESSAGE = "Cannot execute multiple invocations in container tests";

    public InvocationCountCheckInterceptor(@NotNull TestConfigResolver testConfigResolver) {
        Intrinsics.checkNotNullParameter((Object)testConfigResolver, (String)"testConfigResolver");
        this.testConfigResolver = testConfigResolver;
        this.logger = new Logger(Reflection.getOrCreateKotlinClass(this.getClass()));
    }

    @Override
    @Nullable
    public Object intercept(@NotNull TestCase testCase, @NotNull TestScope scope, @NotNull NextTestExecutionInterceptor test2, @NotNull Continuation<? super TestResult> $completion) {
        this.logger.log((Function0<Pair<String, String>>)((Function0)() -> InvocationCountCheckInterceptor.intercept$lambda$0(testCase)));
        if (testCase.getType() != TestType.Container || this.testConfigResolver.invocations(testCase) <= 1) {
            return test2.invoke(testCase, scope, $completion);
        }
        return TestResultBuilder.Companion.builder().withFailure(ERROR_MESSAGE).build();
    }

    private static final Pair intercept$lambda$0(TestCase $testCase) {
        return new Pair((Object)$testCase.getName().getName(), (Object)"Checking that invocation count is 1 for containers");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/kotest/engine/test/interceptors/InvocationCountCheckInterceptor$Companion;", "", "<init>", "()V", "ERROR_MESSAGE", "", "kotest-framework-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

