/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.extensions.testcontainers;

import com.zaxxer.hikari.HikariDataSource;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.logging.Logger;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\n\u001a\u00020\u0001H\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003J\u0012\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J#\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u0002H\u001c\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u001dR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/kotest/extensions/testcontainers/SettableDataSource;", "Ljavax/sql/DataSource;", "ds", "Lcom/zaxxer/hikari/HikariDataSource;", "(Lcom/zaxxer/hikari/HikariDataSource;)V", "getConnection", "Ljava/sql/Connection;", "username", "", "password", "getDs", "getLogWriter", "Ljava/io/PrintWriter;", "getLoginTimeout", "", "getParentLogger", "Ljava/util/logging/Logger;", "isWrapperFor", "", "iface", "Ljava/lang/Class;", "setDataSource", "", "setLogWriter", "out", "setLoginTimeout", "seconds", "unwrap", "T", "(Ljava/lang/Class;)Ljava/lang/Object;", "kotest-extensions-testcontainers"})
public final class SettableDataSource
implements DataSource {
    @Nullable
    private HikariDataSource ds;

    public SettableDataSource(@Nullable HikariDataSource ds) {
        this.ds = ds;
    }

    private final DataSource getDs() {
        HikariDataSource hikariDataSource = this.ds;
        if (hikariDataSource == null) {
            throw new IllegalStateException("DataSource is not ready".toString());
        }
        return (DataSource)hikariDataSource;
    }

    public final void setDataSource(@Nullable HikariDataSource ds) {
        HikariDataSource hikariDataSource = this.ds;
        if (hikariDataSource != null) {
            hikariDataSource.close();
        }
        this.ds = ds;
    }

    @Override
    @NotNull
    public PrintWriter getLogWriter() {
        PrintWriter printWriter = this.getDs().getLogWriter();
        Intrinsics.checkNotNullExpressionValue((Object)printWriter, (String)"getDs().logWriter");
        return printWriter;
    }

    @Override
    public void setLogWriter(@Nullable PrintWriter out) {
        this.getDs().setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.getDs().setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() {
        return this.getDs().getLoginTimeout();
    }

    @Override
    @NotNull
    public Logger getParentLogger() {
        Logger logger = this.getDs().getParentLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getDs().parentLogger");
        return logger;
    }

    @Override
    public <T> T unwrap(@Nullable Class<T> iface) {
        return this.getDs().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(@Nullable Class<?> iface) {
        return this.getDs().isWrapperFor(iface);
    }

    @Override
    @NotNull
    public Connection getConnection() {
        Connection connection = this.getDs().getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getDs().connection");
        return connection;
    }

    @Override
    @NotNull
    public Connection getConnection(@Nullable String username, @Nullable String password) {
        Connection connection = this.getDs().getConnection(username, password);
        Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getDs().getConnection(username, password)");
        return connection;
    }
}

