/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.extensions.testcontainers;

import io.kotest.extensions.testcontainers.Resource;
import java.io.Closeable;
import java.net.URI;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Deprecated(message="use Flyway or another db migration tool")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004*\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lio/kotest/extensions/testcontainers/ResourceLoader;", "", "()V", "getClasspathResourcesFromJar", "", "Lio/kotest/extensions/testcontainers/Resource;", "resource", "", "getFileResourcesFromPath", "Lio/kotest/extensions/testcontainers/Resource$File;", "path", "Ljava/nio/file/Path;", "resolveResource", "getDirContentsOrItself", "kotest-extensions-testcontainers"})
public final class ResourceLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<Path> getDirContentsOrItself(Path $this$getDirContentsOrItself) {
        List list;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory($this$getDirContentsOrItself, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            void $this$filterTo$iv$iv;
            Iterable stream2;
            Closeable closeable = Files.newDirectoryStream($this$getDirContentsOrItself);
            Throwable throwable = null;
            try {
                stream2 = (DirectoryStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)stream2, (String)"stream");
                stream2 = CollectionsKt.toList((Iterable)stream2);
            }
            catch (Throwable stream2) {
                throwable = stream2;
                throw stream2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Iterable $this$filter$iv = stream2;
            boolean $i$f$filter = false;
            stream2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path it = (Path)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.isRegularFile(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.listOf((Object)$this$getDirContentsOrItself);
        }
        return list;
    }

    private final List<Resource.File> getFileResourcesFromPath(Path path) {
        List list;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IllegalStateException(("Resource " + path + " does not exist on the classpath or on the local filesystem").toString());
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.isRegularFile(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            list = CollectionsKt.listOf((Object)new Resource.File(path));
        } else {
            List list2 = Files.walk(path, new FileVisitOption[0]).filter(ResourceLoader::getFileResourcesFromPath$lambda-2).sorted().map(ResourceLoader::getFileResourcesFromPath$lambda-3).collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(list2, (String)"walk(path)\n            .\u2026lect(Collectors.toList())");
            list = list2;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<Resource> getClasspathResourcesFromJar(String resource) {
        URL uRL = this.getClass().getResource(resource);
        Intrinsics.checkNotNull((Object)uRL);
        URI uri = uRL.toURI();
        Closeable closeable = FileSystems.newFileSystem(uri, (Map)new LinkedHashMap());
        Throwable throwable = null;
        try {
            void $this$sortedBy$iv;
            void $this$mapTo$iv$iv;
            FileSystem fs = (FileSystem)closeable;
            boolean bl = false;
            Path path = fs.getPath(resource, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"fs.getPath(resource)");
            List<Path> pathList = this.getDirContentsOrItself(path);
            Iterable $this$map$iv = pathList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path2 = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new Resource.Classpath(it.toString()));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            List list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Resource.Classpath it = (Resource.Classpath)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.toString());
                    it = (Resource.Classpath)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.toString())));
                }
            });
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final List<Resource> resolveResource(@NotNull String resource) {
        List<Resource> list;
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        URL url = this.getClass().getResource(resource);
        if (url == null) {
            Path path = Paths.get(resource, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            list = this.getFileResourcesFromPath(path);
        } else {
            String string = url.getProtocol();
            if (Intrinsics.areEqual((Object)string, (Object)"jar")) {
                list = this.getClasspathResourcesFromJar(resource);
            } else if (Intrinsics.areEqual((Object)string, (Object)"file")) {
                Path path = Paths.get(url.toURI());
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(url.toURI())");
                list = this.getFileResourcesFromPath(path);
            } else {
                throw new IllegalStateException(("Unhandled protocol: " + url.getProtocol()).toString());
            }
        }
        return list;
    }

    private static final boolean getFileResourcesFromPath$lambda-2(Path it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final Resource.File getFileResourcesFromPath$lambda-3(Path it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return new Resource.File(it);
    }
}

