/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.resource;

import io.kjson.resource.Resource;
import io.kjson.resource.ResourceDescriptor;
import io.kjson.resource.ResourceLoader;
import io.kjson.resource.ResourceLoaderException;
import io.kjson.resource.ResourceNotFoundException;
import io.kjson.util.Cache;
import io.kjson.util.HTTPHeader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001e*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001b\u0010\u0010\u001a\u00028\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0015H&\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0016J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u001a\u001a\u00020\u001bJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u001c\u001a\u00020\u001dR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lio/kjson/resource/ResourceLoader;", "T", "", "()V", "defaultExtension", "", "getDefaultExtension", "()Ljava/lang/String;", "defaultMIMEType", "getDefaultMIMEType", "addExtension", "s", "checkHTTP", "", "conn", "Ljava/net/HttpURLConnection;", "load", "resource", "Lio/kjson/resource/Resource;", "(Lio/kjson/resource/Resource;)Ljava/lang/Object;", "rd", "Lio/kjson/resource/ResourceDescriptor;", "(Lio/kjson/resource/ResourceDescriptor;)Ljava/lang/Object;", "openResource", "resourceFile", "Ljava/io/File;", "resourceURL", "Ljava/net/URL;", "resourcePath", "Ljava/nio/file/Path;", "Companion", "resource-loader"})
@SourceDebugExtension(value={"SMAP\nResourceLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceLoader.kt\nio/kjson/resource/ResourceLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1#2:184\n*E\n"})
public abstract class ResourceLoader<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String defaultExtension;
    @Nullable
    private final String defaultMIMEType;
    private static final FileSystem defaultFileSystem = FileSystems.getDefault();
    @NotNull
    private static final Cache<String, FileSystem> fileSystemCache = new Cache(Companion.fileSystemCache.1.INSTANCE);

    @Nullable
    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    @Nullable
    public String getDefaultMIMEType() {
        return this.defaultMIMEType;
    }

    public abstract T load(@NotNull ResourceDescriptor var1);

    public boolean checkHTTP(@NotNull HttpURLConnection conn) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        return true;
    }

    @NotNull
    public final Resource<T> resource(@NotNull File resourceFile) {
        Intrinsics.checkNotNullParameter((Object)resourceFile, (String)"resourceFile");
        Path path = resourceFile.toPath();
        URL uRL = resourceFile.toURI().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return new Resource(path, uRL, this);
    }

    @NotNull
    public final Resource<T> resource(@NotNull Path resourcePath) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        URL uRL = resourcePath.toUri().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return new Resource(resourcePath, uRL, this);
    }

    @NotNull
    public final Resource<T> resource(@NotNull URL resourceURL) {
        Intrinsics.checkNotNullParameter((Object)resourceURL, (String)"resourceURL");
        return new Resource(Companion.derivePath(resourceURL), resourceURL, this);
    }

    public T load(@NotNull Resource<T> resource) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        return this.load(this.openResource(resource));
    }

    @NotNull
    public ResourceDescriptor openResource(@NotNull Resource<T> resource) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        try {
            Instant instant;
            Path path = resource.getResourcePath$resource_loader();
            if (path != null) {
                Path path2 = path;
                boolean bl = false;
                if (!Files.exists(path2, new LinkOption[0]) || Files.isDirectory(path2, new LinkOption[0])) {
                    throw new ResourceNotFoundException(resource.getResourceURL());
                }
                InputStream inputStream = Files.newInputStream(path2, new OpenOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                return new ResourceDescriptor(inputStream, resource.getResourceURL(), null, Files.size(path2), Files.getLastModifiedTime(path2, new LinkOption[0]).toInstant(), null, null, 100, null);
            }
            URLConnection uRLConnection = resource.getResourceURL().openConnection();
            Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"openConnection(...)");
            URLConnection conn = uRLConnection;
            Long path2 = conn.getContentLengthLong();
            long it = ((Number)path2).longValue();
            boolean bl = false;
            Long contentLength = it >= 0L ? path2 : null;
            Long l = conn.getLastModified();
            long it2 = ((Number)l).longValue();
            boolean bl2 = false;
            Long l2 = it2 != 0L ? l : null;
            if (l2 != null) {
                it2 = ((Number)l2).longValue();
                boolean bl3 = false;
                instant = Instant.ofEpochMilli(it2);
            } else {
                instant = null;
            }
            Instant lastModified = instant;
            String charsetName = null;
            String mimeType = null;
            String eTag = null;
            if (conn instanceof HttpURLConnection) {
                HTTPHeader contentTypeHeader;
                Object object;
                HTTPHeader hTTPHeader;
                if (!this.checkHTTP((HttpURLConnection)conn)) {
                    throw new ResourceLoaderException("Connection vetoed - " + resource.getResourceURL(), null, 2, null);
                }
                if (((HttpURLConnection)conn).getResponseCode() == 404) {
                    throw new ResourceNotFoundException(resource.getResourceURL());
                }
                if (((HttpURLConnection)conn).getResponseCode() != 200) {
                    throw new IOException("Error status - " + ((HttpURLConnection)conn).getResponseCode() + " - " + resource.getResourceURL());
                }
                String string = ((HttpURLConnection)conn).getContentType();
                if (string != null) {
                    String it3 = string;
                    boolean bl4 = false;
                    hTTPHeader = HTTPHeader.Companion.create(it3);
                } else {
                    hTTPHeader = null;
                }
                charsetName = (object = (contentTypeHeader = hTTPHeader)) != null && (object = HTTPHeader.element$default((HTTPHeader)object, 0, 1, null)) != null ? HTTPHeader.Element.parameter$default((HTTPHeader.Element)object, "charset", 0, 2, null) : null;
                HTTPHeader hTTPHeader2 = contentTypeHeader;
                mimeType = hTTPHeader2 != null ? hTTPHeader2.firstElementText() : null;
                eTag = conn.getHeaderField("etag");
            } else {
                charsetName = null;
                mimeType = conn.getContentType();
                eTag = null;
            }
            InputStream inputStream = conn.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            return new ResourceDescriptor(inputStream, resource.getResourceURL(), charsetName, contentLength, lastModified, mimeType, eTag);
        }
        catch (ResourceLoaderException rle) {
            throw rle;
        }
        catch (Exception e) {
            throw new ResourceLoaderException("Error opening resource " + resource.getResourceURL(), e);
        }
    }

    @NotNull
    public final String addExtension(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return this.getDefaultExtension() != null && StringsKt.indexOf$default((CharSequence)s, (char)'.', (int)(StringsKt.lastIndexOf$default((CharSequence)s, (char)File.separatorChar, (int)0, (boolean)false, (int)6, null) + 1), (boolean)false, (int)4, null) < 0 ? s + '.' + this.getDefaultExtension() : s;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/kjson/resource/ResourceLoader$Companion;", "", "()V", "defaultFileSystem", "Ljava/nio/file/FileSystem;", "kotlin.jvm.PlatformType", "fileSystemCache", "Lio/kjson/util/Cache;", "", "derivePath", "Ljava/nio/file/Path;", "url", "Ljava/net/URL;", "resource-loader"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Path derivePath(@NotNull URL url) {
            Path path;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            URI uri = url.toURI();
            String string = uri.getScheme();
            if (Intrinsics.areEqual((Object)string, (Object)"jar")) {
                String schemeSpecific = uri.getSchemeSpecificPart();
                Intrinsics.checkNotNull((Object)schemeSpecific);
                int start = StringsKt.indexOf$default((CharSequence)schemeSpecific, (char)':', (int)0, (boolean)false, (int)6, null);
                int bang = StringsKt.lastIndexOf$default((CharSequence)schemeSpecific, (char)'!', (int)0, (boolean)false, (int)6, null);
                if (start < 0 || bang < 0 || start > bang) {
                    return null;
                }
                ++start;
                while (start + 2 < bang && schemeSpecific.charAt(start) == '/' && schemeSpecific.charAt(start + 1) == '/') {
                    ++start;
                }
                Cache cache = fileSystemCache;
                String string2 = schemeSpecific.substring(start, bang);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                FileSystem fs = (FileSystem)cache.get(string2);
                String string3 = schemeSpecific.substring(bang + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                path = fs.getPath(string3, new String[0]);
            } else {
                path = Intrinsics.areEqual((Object)string, (Object)"file") ? defaultFileSystem.getPath(uri.getPath(), new String[0]) : null;
            }
            return path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

