/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.parser;

import io.kjson.JSONArray;
import io.kjson.JSONBoolean;
import io.kjson.JSONDecimal;
import io.kjson.JSONInt;
import io.kjson.JSONLong;
import io.kjson.JSONObject;
import io.kjson.JSONString;
import io.kjson.JSONValue;
import io.kjson.parser.ParseException;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.JSONFunctions;
import net.pwall.text.TextMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0004J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/kjson/parser/Parser;", "", "()V", "DUPLICATE_KEY", "", "EXCESS_CHARS", "ILLEGAL_KEY", "ILLEGAL_NUMBER", "ILLEGAL_SYNTAX", "MAX_INTEGER_DIGITS_LENGTH", "", "MISSING_CLOSING_BRACE", "MISSING_CLOSING_BRACKET", "MISSING_COLON", "rootPointer", "parse", "Lio/kjson/JSONValue;", "json", "tm", "Lnet/pwall/text/TextMatcher;", "pointer", "parseString", "kjson-core"})
public final class Parser {
    @NotNull
    public static final Parser INSTANCE = new Parser();
    @NotNull
    public static final String rootPointer = "";
    private static final int MAX_INTEGER_DIGITS_LENGTH = 10;
    @NotNull
    public static final String EXCESS_CHARS = "Excess characters following JSON";
    @NotNull
    public static final String ILLEGAL_NUMBER = "Illegal JSON number";
    @NotNull
    public static final String ILLEGAL_SYNTAX = "Illegal JSON syntax";
    @NotNull
    public static final String ILLEGAL_KEY = "Illegal key in JSON object";
    @NotNull
    public static final String DUPLICATE_KEY = "Duplicate key in JSON object";
    @NotNull
    public static final String MISSING_COLON = "Missing colon in JSON object";
    @NotNull
    public static final String MISSING_CLOSING_BRACE = "Missing closing brace in JSON object";
    @NotNull
    public static final String MISSING_CLOSING_BRACKET = "Missing closing bracket in JSON array";

    private Parser() {
    }

    @Nullable
    public final JSONValue parse(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        TextMatcher tm = new TextMatcher(json);
        JSONValue result = this.parse(tm, rootPointer);
        tm.skip(JSONFunctions::isSpaceCharacter);
        if (!tm.isAtEnd()) {
            throw new ParseException(EXCESS_CHARS, null, 2, null);
        }
        return result;
    }

    private final JSONValue parse(TextMatcher tm, String pointer) {
        tm.skip(JSONFunctions::isSpaceCharacter);
        if (tm.match('{')) {
            JSONObject.Builder builder = new JSONObject.Builder(0, null, 3, null);
            tm.skip(JSONFunctions::isSpaceCharacter);
            if (!tm.match('}')) {
                while (true) {
                    if (!tm.match('\"')) {
                        throw new ParseException(ILLEGAL_KEY, pointer);
                    }
                    String key = this.parseString(tm, pointer);
                    if (builder.containsKey(key)) {
                        throw new ParseException(DUPLICATE_KEY, pointer);
                    }
                    tm.skip(JSONFunctions::isSpaceCharacter);
                    if (!tm.match(':')) {
                        throw new ParseException(MISSING_COLON, pointer);
                    }
                    builder.add(key, this.parse(tm, pointer + '/' + key));
                    tm.skip(JSONFunctions::isSpaceCharacter);
                    if (!tm.match(',')) break;
                    tm.skip(JSONFunctions::isSpaceCharacter);
                }
                if (!tm.match('}')) {
                    throw new ParseException(MISSING_CLOSING_BRACE, pointer);
                }
            }
            return builder.build();
        }
        if (tm.match('[')) {
            JSONArray.Builder builder = new JSONArray.Builder(0, null, 3, null);
            tm.skip(JSONFunctions::isSpaceCharacter);
            if (!tm.match(']')) {
                do {
                    builder.add(this.parse(tm, pointer + '/' + builder.getSize()));
                    tm.skip(JSONFunctions::isSpaceCharacter);
                } while (tm.match(','));
                if (!tm.match(']')) {
                    throw new ParseException(MISSING_CLOSING_BRACKET, pointer);
                }
            }
            return builder.build();
        }
        if (tm.match('\"')) {
            return new JSONString(this.parseString(tm, pointer));
        }
        if (tm.match((CharSequence)"true")) {
            return JSONBoolean.TRUE;
        }
        if (tm.match((CharSequence)"false")) {
            return JSONBoolean.FALSE;
        }
        if (tm.match((CharSequence)"null")) {
            return null;
        }
        int numberStart = tm.getIndex();
        boolean negative = tm.match('-');
        if (tm.matchDec(0, 1)) {
            int integerLength = tm.getResultLength();
            if (integerLength > 1 && tm.getResultChar() == '0') {
                throw new ParseException(ILLEGAL_NUMBER, pointer);
            }
            boolean floating = false;
            if (tm.match('.')) {
                floating = true;
                if (!tm.matchDec(0, 1)) {
                    throw new ParseException(ILLEGAL_NUMBER, pointer);
                }
            }
            if (tm.match('e') || tm.match('E')) {
                floating = true;
                tm.matchAny("-+");
                if (!tm.matchDec(0, 1)) {
                    throw new ParseException(ILLEGAL_NUMBER, pointer);
                }
            }
            if (!floating) {
                if (integerLength < 10) {
                    return JSONInt.Companion.of(tm.getResultInt(negative));
                }
                try {
                    long result = tm.getResultLong(negative);
                    if (result >= Integer.MIN_VALUE && result <= Integer.MAX_VALUE) {
                        return new JSONInt((int)result);
                    }
                    return new JSONLong(result);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return new JSONDecimal(new BigDecimal(tm.getString(numberStart, tm.getIndex())));
        }
        throw new ParseException(ILLEGAL_SYNTAX, pointer);
    }

    private final String parseString(TextMatcher tm, String pointer) {
        String string;
        try {
            string = JSONFunctions.parseString((TextMatcher)tm);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            JSONFunctions.parseString(tm)\n        }");
        }
        catch (IllegalArgumentException iae) {
            String string2 = iae.getMessage();
            throw new ParseException(string2 == null ? "Error parsing JSON string" : string2, pointer);
        }
        return string;
    }
}

