/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.template;

import com.intuit.karate.graal.JsEngine;
import com.intuit.karate.graal.JsValue;
import com.intuit.karate.template.KarateTemplateResource;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.IdentifierSequences;
import org.thymeleaf.engine.TemplateData;
import org.thymeleaf.expression.IExpressionObjects;
import org.thymeleaf.inline.IInliner;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresource.ITemplateResource;

public class KarateEngineContext
implements IEngineContext {
    private static final Logger logger = LoggerFactory.getLogger(KarateEngineContext.class);
    private static final ThreadLocal<KarateEngineContext> THREAD_LOCAL = new ThreadLocal();
    private final IEngineContext wrapped;
    private final JsEngine jsEngine;
    private final Map<String, Object> context = new HashMap<String, Object>();
    private boolean redirect;

    public static KarateEngineContext initThreadLocal(IEngineContext wrapped, JsEngine engine) {
        KarateEngineContext tec = new KarateEngineContext(wrapped, engine);
        THREAD_LOCAL.set(tec);
        return tec;
    }

    private KarateEngineContext(IEngineContext wrapped, JsEngine jsEngine) {
        this.wrapped = wrapped;
        this.jsEngine = jsEngine;
        jsEngine.put("_", this.context);
    }

    public static KarateEngineContext get() {
        return THREAD_LOCAL.get();
    }

    public static void set(KarateEngineContext kec) {
        THREAD_LOCAL.set(kec);
    }

    public JsEngine getJsEngine() {
        return this.jsEngine;
    }

    public String getCallerTemplateName() {
        TemplateData td = this.wrapped.getTemplateData();
        ITemplateResource tr = td.getTemplateResource();
        if (tr instanceof KarateTemplateResource) {
            KarateTemplateResource ktr = (KarateTemplateResource)tr;
            return ktr.getCaller();
        }
        return null;
    }

    public String getTemplateName() {
        String name = this.wrapped.getTemplateData().getTemplate();
        return name.startsWith("/") ? name.substring(1) : name;
    }

    public void setRedirect(boolean redirect) {
        this.redirect = redirect;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public JsValue evalGlobal(String src) {
        this.getVariableNames().forEach(name -> this.jsEngine.put((String)name, this.getVariable((String)name)));
        try {
            return this.jsEngine.eval(src);
        }
        catch (Exception e) {
            throw JsEngine.fromJsEvalException(src, e, null);
        }
    }

    public JsValue evalLocalAsObject(String src) {
        String temp = src.startsWith("${") ? "`" + src + "`" : "({" + src + "})";
        return this.evalLocal(temp, true);
    }

    public JsValue evalLocal(String src, boolean returnValue) {
        try {
            Value value = this.jsEngine.evalWith(this.getVariableNames(), this::getVariable, src, returnValue);
            return new JsValue(value);
        }
        catch (Exception e) {
            throw JsEngine.fromJsEvalException(src, e, null);
        }
    }

    public void setLocal(String name, Object value) {
        this.context.put(name, value);
    }

    public void increaseLevel() {
        if (!this.context.isEmpty()) {
            this.setVariables(this.context);
            this.context.clear();
        }
        this.wrapped.increaseLevel();
    }

    public void setVariable(String name, Object value) {
        this.wrapped.setVariable(name, value);
    }

    public void setVariables(Map<String, Object> variables) {
        this.wrapped.setVariables(variables);
    }

    public void removeVariable(String name) {
        this.wrapped.removeVariable(name);
    }

    public void setTemplateData(TemplateData template) {
        this.wrapped.setTemplateData(template);
    }

    public void decreaseLevel() {
        this.wrapped.decreaseLevel();
    }

    public boolean containsVariable(String name) {
        return this.wrapped.containsVariable(name);
    }

    public Set<String> getVariableNames() {
        return this.wrapped.getVariableNames();
    }

    public Object getVariable(String name) {
        return this.wrapped.getVariable(name);
    }

    public boolean isVariableLocal(String name) {
        return this.wrapped.isVariableLocal(name);
    }

    public void setSelectionTarget(Object selectionTarget) {
        this.wrapped.setSelectionTarget(selectionTarget);
    }

    public void setInliner(IInliner inliner) {
        this.wrapped.setInliner(inliner);
    }

    public void setElementTag(IProcessableElementTag elementTag) {
        this.wrapped.setElementTag(elementTag);
    }

    public List<IProcessableElementTag> getElementStackAbove(int contextLevel) {
        return this.wrapped.getElementStackAbove(contextLevel);
    }

    public int level() {
        return this.wrapped.level();
    }

    public TemplateData getTemplateData() {
        return this.wrapped.getTemplateData();
    }

    public TemplateMode getTemplateMode() {
        return this.wrapped.getTemplateMode();
    }

    public List<TemplateData> getTemplateStack() {
        return this.wrapped.getTemplateStack();
    }

    public List<IProcessableElementTag> getElementStack() {
        return this.wrapped.getElementStack();
    }

    public Map<String, Object> getTemplateResolutionAttributes() {
        return this.wrapped.getTemplateResolutionAttributes();
    }

    public IModelFactory getModelFactory() {
        return this.wrapped.getModelFactory();
    }

    public boolean hasSelectionTarget() {
        return this.wrapped.hasSelectionTarget();
    }

    public Object getSelectionTarget() {
        return this.wrapped.getSelectionTarget();
    }

    public IInliner getInliner() {
        return this.wrapped.getInliner();
    }

    public String getMessage(Class<?> origin, String key, Object[] messageParameters, boolean useAbsent) {
        return this.wrapped.getMessage(origin, key, messageParameters, useAbsent);
    }

    public String buildLink(String base, Map<String, Object> parameters) {
        return this.wrapped.buildLink(base, parameters);
    }

    public IdentifierSequences getIdentifierSequences() {
        return this.wrapped.getIdentifierSequences();
    }

    public IEngineConfiguration getConfiguration() {
        return this.wrapped.getConfiguration();
    }

    public IExpressionObjects getExpressionObjects() {
        return this.wrapped.getExpressionObjects();
    }

    public Locale getLocale() {
        return this.wrapped.getLocale();
    }
}

