/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.template;

import com.intuit.karate.http.ServerConfig;
import com.intuit.karate.resource.Resource;
import com.intuit.karate.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

public class KaLinkAttrProcessor
extends AbstractAttributeTagProcessor {
    private static final Logger logger = LoggerFactory.getLogger(KaLinkAttrProcessor.class);
    private static final String HREF = "href";
    private final ResourceResolver resourceResolver;
    private final String hostContextPath;

    public KaLinkAttrProcessor(String dialectPrefix, ServerConfig config) {
        super(TemplateMode.HTML, dialectPrefix, "link", false, HREF, false, 1000, false);
        this.hostContextPath = config.getHostContextPath();
        this.resourceResolver = config.getResourceResolver();
    }

    protected void doProcess(ITemplateContext ctx, IProcessableElementTag tag, AttributeName an, String av, IElementTagStructureHandler sh) {
        Object href = this.hostContextPath == null ? av : this.hostContextPath + av;
        String noCache = tag.getAttributeValue(this.getDialectPrefix(), "nocache");
        if (noCache != null) {
            try {
                Resource resource = this.resourceResolver.resolve((String)href);
                href = (String)href + "?ts=" + resource.getLastModified();
            }
            catch (Exception e) {
                logger.warn("nocache failed: {}", (Object)e.getMessage());
            }
            sh.removeAttribute(this.getDialectPrefix(), "nocache");
        }
        sh.setAttribute(HREF, (String)href);
    }
}

