/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.FileUtils;
import com.intuit.karate.StringUtils;
import com.intuit.karate.http.Request;
import com.intuit.karate.http.RequestCycle;
import com.intuit.karate.http.ResourceType;
import com.intuit.karate.http.Response;
import com.intuit.karate.http.ServerConfig;
import com.intuit.karate.http.ServerContext;
import com.intuit.karate.http.Session;
import com.intuit.karate.resource.ResourceResolver;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ResponseBuilder.class);
    private byte[] body;
    private Set<Cookie> cookies;
    private Map<String, List<String>> headers;
    private ResourceType resourceType;
    private final ServerConfig config;
    private final ResourceResolver resourceResolver;
    private final RequestCycle requestCycle;

    public ResponseBuilder(ServerConfig config, RequestCycle requestCycle) {
        this.config = config;
        this.resourceResolver = config.getResourceResolver();
        this.requestCycle = requestCycle;
        if (requestCycle != null) {
            this.headers = requestCycle.getResponse().getHeaders();
        }
    }

    public ResponseBuilder body(String body) {
        this.body = FileUtils.toBytes(body);
        return this;
    }

    public ResponseBuilder html(String body) {
        this.body(body);
        this.contentTypeHtml();
        return this;
    }

    public ResponseBuilder body(InputStream body) {
        this.body = FileUtils.toBytes(body);
        return this;
    }

    public ResponseBuilder locationHeader(String url) {
        return this.header("Location", url);
    }

    public ResponseBuilder contentTypeHtml() {
        this.resourceType = ResourceType.HTML;
        this.contentType(this.resourceType.contentType);
        return this;
    }

    public ResponseBuilder contentType(String contentType) {
        if (contentType != null) {
            this.header("Content-Type", contentType);
        }
        return this;
    }

    public ResponseBuilder cookie(String name, String value) {
        return this.cookie(name, value, false);
    }

    public ResponseBuilder sessionCookie(String value) {
        return this.cookie(this.config.getSessionCookieName(), value);
    }

    public ResponseBuilder deleteSessionCookie(String value) {
        return this.cookie(this.config.getSessionCookieName(), value, true);
    }

    private ResponseBuilder cookie(String name, String value, boolean delete) {
        DefaultCookie cookie = new DefaultCookie(name, value);
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        if (delete) {
            cookie.setMaxAge(0L);
        }
        if (this.cookies == null) {
            this.cookies = new HashSet<Cookie>();
        }
        this.cookies.add((Cookie)cookie);
        return this;
    }

    public ResponseBuilder header(String name, String value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, List<String>>();
        }
        this.headers.put(name, Collections.singletonList(value));
        return this;
    }

    public ResponseBuilder ajaxRedirect(String url) {
        this.header("HX-Redirect", url);
        return this;
    }

    public ResponseBuilder session(Session session, boolean newSession) {
        if (session != null && newSession) {
            this.sessionCookie(session.getId());
        }
        return this;
    }

    public Response build() {
        Session session;
        Response response = this.requestCycle.getResponse();
        ServerContext context = this.requestCycle.getContext();
        if (context.isClosed() && (session = this.requestCycle.getSession()) != null && !session.isTemporary()) {
            this.deleteSessionCookie(session.getId());
        }
        if (this.cookies != null) {
            this.cookies.forEach(c -> this.header("Set-Cookie", ServerCookieEncoder.LAX.encode(c)));
        }
        if (this.resourceType != null && this.resourceType.isHtml() && context.getBodyAppends() != null) {
            String appends = StringUtils.join(context.getBodyAppends(), "\n");
            this.body = ResponseBuilder.merge(this.body, FileUtils.toBytes(appends));
        }
        if (context.getRedirectPath() != null) {
            this.locationHeader(context.getRedirectPath());
            response.setStatus(302);
        }
        if (context.isApi()) {
            this.body = response.getBody();
            if (this.resourceType != null) {
                this.contentType(this.resourceType.contentType);
            } else if (this.body != null) {
                this.contentType(ResourceType.JSON.contentType);
            }
            Map<String, List<String>> apiHeaders = response.getHeaders();
            if (apiHeaders != null) {
                if (this.headers == null) {
                    this.headers = apiHeaders;
                } else {
                    this.headers.putAll(apiHeaders);
                }
            }
        }
        return this.buildWithStatus(response.getStatus());
    }

    private static byte[] merge(byte[] body, byte[] extra) {
        if (body == null) {
            body = new byte[]{};
        }
        byte[] merged = new byte[body.length + extra.length];
        System.arraycopy(body, 0, merged, 0, body.length);
        System.arraycopy(extra, 0, merged, body.length, extra.length);
        return merged;
    }

    public Response buildStatic(Request request) {
        this.resourceType = request.getResourceType();
        if (this.resourceType == null) {
            this.resourceType = ResourceType.BINARY;
        }
        this.contentType(this.resourceType.contentType);
        try {
            InputStream is = this.resourceResolver.resolve(request.getResourcePath()).getStream();
            this.body(is);
            if (this.config.isNoCache()) {
                this.header("Cache-Control", "max-age=0");
            } else {
                this.header("Cache-Control", "max-age=31536000");
            }
        }
        catch (Exception e) {
            logger.error("local resource failed: {} - {}", (Object)request, (Object)e.toString());
        }
        return this.buildWithStatus(200);
    }

    public Response buildWithStatus(int status) {
        return new Response(status, this.headers, status == 204 ? null : this.body, this.resourceType);
    }
}

